/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management.commands;

import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.SimpleCommandProvider;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.ws.wim.management.AttrHelpers.GenericAttrHolder;
import com.ibm.ws.wim.management.AttrHelpers.GroupAttrHolder;
import com.ibm.ws.wim.management.AttrHelpers.PersonAccountAttrHolder;
import com.ibm.ws.wim.management.helpers.GenericHelper;
import com.ibm.ws.wim.management.helpers.entityHelpers.EntityHelper;
import com.ibm.ws.wim.management.helpers.entityHelpers.EntityHelperFactory;
import com.ibm.ws.wim.management.repositoryhelpers.UMAssistant;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UpdateCommandProvider
extends SimpleCommandProvider {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = UpdateCommandProvider.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String duplicateMembershipOfUser(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "duplicateMembershipOfUser(AbstractAdminCommand cmd)";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        if (!GenericHelper.isWASUserRegistry("PersonAccount")) {
            throw new WIMApplicationException("WAS_USER_REGISTRY_NOT_SUPPORTED", Level.SEVERE, CLASSNAME, string);
        }
        String string2 = (String)abstractAdminCommand.getParameter("copyFromUniqueName");
        String string3 = (String)abstractAdminCommand.getParameter("copyToUniqueName");
        PersonAccountAttrHolder personAccountAttrHolder = new PersonAccountAttrHolder(string3);
        EntityHelper entityHelper = EntityHelperFactory.create(personAccountAttrHolder.getAttrHolderType());
        entityHelper.verifyType(personAccountAttrHolder);
        PersonAccountAttrHolder personAccountAttrHolder2 = new PersonAccountAttrHolder(string2);
        EntityHelper entityHelper2 = EntityHelperFactory.create(personAccountAttrHolder2.getAttrHolderType());
        entityHelper2.verifyType(personAccountAttrHolder2);
        new UMAssistant().duplicateMembership(personAccountAttrHolder2, personAccountAttrHolder);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return string3;
    }

    public String duplicateMembershipOfGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "duplicateMembershipOfGroup(AbstractAdminCommand cmd)";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        if (!GenericHelper.isWASUserRegistry("Group")) {
            throw new WIMApplicationException("WAS_USER_REGISTRY_NOT_SUPPORTED", Level.SEVERE, CLASSNAME, string);
        }
        String string2 = (String)abstractAdminCommand.getParameter("copyFromUniqueName");
        String string3 = (String)abstractAdminCommand.getParameter("copyToUniqueName");
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string3);
        EntityHelper entityHelper = EntityHelperFactory.create(groupAttrHolder.getAttrHolderType());
        entityHelper.verifyType(groupAttrHolder);
        GroupAttrHolder groupAttrHolder2 = new GroupAttrHolder(string2);
        EntityHelper entityHelper2 = EntityHelperFactory.create(groupAttrHolder2.getAttrHolderType());
        entityHelper2.verifyType(groupAttrHolder2);
        new UMAssistant().duplicateMembership(groupAttrHolder2, groupAttrHolder);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return string3;
    }

    public String updateGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "updateGroup(AbstractAdminCommand cmd)";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        if (!GenericHelper.isWASUserRegistry("Group")) {
            throw new WIMApplicationException("WAS_USER_REGISTRY_NOT_SUPPORTED", Level.SEVERE, CLASSNAME, string);
        }
        String string2 = (String)abstractAdminCommand.getParameter("cn");
        String string3 = (String)abstractAdminCommand.getParameter("description");
        String string4 = (String)abstractAdminCommand.getParameter("uniqueName");
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string4, string2, string3, null, null, null);
        EntityHelper entityHelper = EntityHelperFactory.create(groupAttrHolder.getAttrHolderType());
        entityHelper.verifyType(groupAttrHolder);
        string4 = new UMAssistant().update(groupAttrHolder);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return string4;
    }

    public String updateUser(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "updateUser(AbstractAdminCommand cmd)";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        if (!GenericHelper.isWASUserRegistry("PersonAccount")) {
            throw new WIMApplicationException("WAS_USER_REGISTRY_NOT_SUPPORTED", Level.SEVERE, CLASSNAME, string);
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string2 = (String)abstractAdminCommand.getParameter("cn");
        String string3 = (String)abstractAdminCommand.getParameter("uid");
        String string4 = (String)abstractAdminCommand.getParameter("sn");
        String string5 = (String)abstractAdminCommand.getParameter("mail");
        String string6 = (String)abstractAdminCommand.getParameter("password");
        String string7 = (String)abstractAdminCommand.getParameter("confirmPassword");
        if (string6 != null) {
            byArray = PasswordUtil.getByteArrayPassword(string6);
        }
        if (string7 != null) {
            byArray2 = PasswordUtil.getByteArrayPassword(string7);
        }
        String string8 = (String)abstractAdminCommand.getParameter("uniqueName");
        GenericHelper.checkPassword(byArray, byArray2);
        PersonAccountAttrHolder personAccountAttrHolder = new PersonAccountAttrHolder(string8, string2, string3, string4, string5, byArray, byArray2, null, null);
        EntityHelper entityHelper = EntityHelperFactory.create(personAccountAttrHolder.getAttrHolderType());
        entityHelper.verifyType(personAccountAttrHolder);
        string8 = new UMAssistant().update(personAccountAttrHolder);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return string8;
    }

    public String addMemberToGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "addMemberToGroup(AbstractAdminCommand cmd)";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        if (!GenericHelper.isWASUserRegistry("Group")) {
            throw new WIMApplicationException("WAS_USER_REGISTRY_NOT_SUPPORTED", Level.SEVERE, CLASSNAME, string);
        }
        String string2 = (String)abstractAdminCommand.getParameter("memberUniqueName");
        String string3 = (String)abstractAdminCommand.getParameter("groupUniqueName");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Group");
        arrayList.add("PersonAccount");
        GenericAttrHolder genericAttrHolder = new GenericAttrHolder(string2);
        EntityHelper entityHelper = EntityHelperFactory.create(genericAttrHolder.getAttrHolderType());
        entityHelper.verifyType(genericAttrHolder);
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string3);
        EntityHelper entityHelper2 = EntityHelperFactory.create(groupAttrHolder.getAttrHolderType());
        entityHelper2.verifyType(groupAttrHolder);
        new UMAssistant().addMemberToGroup(genericAttrHolder, groupAttrHolder);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return string2;
    }

    public String removeMemberFromGroup(AbstractAdminCommand abstractAdminCommand) throws Exception {
        String string = "removeMemberFromGroup(AbstractAdminCommand cmd)";
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
        if (!GenericHelper.isWASUserRegistry("Group")) {
            throw new WIMApplicationException("WAS_USER_REGISTRY_NOT_SUPPORTED", Level.SEVERE, CLASSNAME, string);
        }
        String string2 = (String)abstractAdminCommand.getParameter("memberUniqueName");
        String string3 = (String)abstractAdminCommand.getParameter("groupUniqueName");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Group");
        arrayList.add("PersonAccount");
        GenericAttrHolder genericAttrHolder = new GenericAttrHolder(string2);
        EntityHelper entityHelper = EntityHelperFactory.create(genericAttrHolder.getAttrHolderType());
        entityHelper.verifyType(genericAttrHolder);
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string3);
        EntityHelper entityHelper2 = EntityHelperFactory.create(groupAttrHolder.getAttrHolderType());
        entityHelper2.verifyType(groupAttrHolder);
        new UMAssistant().removeMemberFromGroup(genericAttrHolder, groupAttrHolder);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
        return string2;
    }
}

