/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management.helpers;

import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.config.WASURHelper;
import com.ibm.ws.wim.management.AttrHelpers.AttrHolder;
import com.ibm.ws.wim.management.helpers.CommandConstants;
import commonj.sdo.DataObject;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class GenericHelper
implements CommandConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    static final String CLASSNAME = GenericHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public static String getRepoIdOfEntity(DataObject dataObject) throws WIMException {
        DataObject dataObject2 = dataObject.getDataObject("identifier");
        return dataObject2.getString("repositoryId");
    }

    public static String getUniqueNameOfEntity(DataObject dataObject) throws WIMException {
        DataObject dataObject2 = dataObject.getDataObject("identifier");
        return dataObject2.getString("uniqueName");
    }

    public static Map getEntitiesInMap(List list, List list2) throws WIMException {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject = (DataObject)list.get(i);
            String string = GenericHelper.getUniqueNameOfEntity(dataObject);
            String string2 = GenericHelper.getRepoIdOfEntity(dataObject);
            Map map = GenericHelper.getProperties(dataObject, list2);
            map.put("repositoryId", string2);
            hashMap.put(string, map);
        }
        return hashMap;
    }

    public static Map getProperties(DataObject dataObject, List list) throws WIMException {
        if (list == null) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            Object object = null;
            if (string != "description") {
                object = dataObject.get(string);
            } else {
                List list2 = (List)dataObject.get(string);
                if (list2 != null && list2.size() > 0) {
                    object = (String)list2.get(0);
                }
            }
            hashMap.put(string, object);
        }
        return hashMap;
    }

    public static List extractUniqueNames(Map map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = map.keySet();
        for (String string : set) {
            arrayList.add(string);
        }
        return arrayList;
    }

    public static List extractTypeAndUniqueNames(Map map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = map.keySet();
        for (String string : set) {
            Map map2 = (Map)map.get(string);
            String string2 = (String)map2.get("type");
            arrayList.add(string2 + ", " + string);
        }
        return arrayList;
    }

    public static void checkPassword(byte[] byArray, byte[] byArray2) throws Exception {
        if (byArray == null && byArray2 != null) {
            throw new WIMApplicationException("PARAMS_DO_NOT_MATCH", WIMMessageHelper.generateMsgParms("password", "confirmPassword"), Level.SEVERE, CLASSNAME, "checkPassword(password, confirmPassword)");
        }
        if (byArray != null && byArray2 != null) {
            int n = byArray2.length;
            int n2 = byArray.length;
            if (n != n2) {
                throw new WIMApplicationException("PARAMS_DO_NOT_MATCH", WIMMessageHelper.generateMsgParms("password", "confirmPassword"), Level.SEVERE, CLASSNAME, "checkPassword(password, confirmPassword)");
            }
            for (int i = 0; i < n; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                throw new WIMApplicationException("PARAMS_DO_NOT_MATCH", WIMMessageHelper.generateMsgParms("password", "confirmPassword"), Level.SEVERE, CLASSNAME, "checkPassword(password, confirmPassword)");
            }
        }
    }

    public static String verifySearchParams(List list, AbstractAdminCommand abstractAdminCommand) throws Exception {
        boolean bl = false;
        String string = null;
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (abstractAdminCommand.getParameter(string2) == null) continue;
            if (bl) {
                throw new WIMApplicationException("SEARCH_PARAMETERS_OVER_SPECIFIED", Level.SEVERE, CLASSNAME, "verifySearchParams(inAttrs, cmd)");
            }
            bl = true;
            string = string2;
        }
        if (string == null) {
            throw new WIMApplicationException("SEARCH_ATTR_NOT_SPECIFIED", Level.SEVERE, CLASSNAME, "verifySearchParams(inAttrs, cmd)");
        }
        return string;
    }

    public static void setRealm(DataObject dataObject, String string) {
        if (string != null) {
            DataObject dataObject2 = dataObject.getDataGraph().getRootObject().getDataObject("Root").createDataObject("contexts");
            dataObject2.set("key", (Object)"realm");
            dataObject2.set("value", (Object)string);
        }
    }

    public static void setUniqueName(DataObject dataObject, String string) {
        DataObject dataObject2 = dataObject.getDataObject("identifier");
        if (dataObject2 == null) {
            dataObject2 = dataObject.createDataObject("identifier");
        }
        dataObject2.setString("uniqueName", string);
    }

    public static String escapeSearchExpression(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        while (c != '\uffff') {
            if (c == '\'') {
                stringBuffer.append("''");
            } else if (c == '\"') {
                stringBuffer.append("\"\"");
            } else {
                stringBuffer.append(c);
            }
            c = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public static Map getMembersAndProps(DataObject dataObject, AttrHolder attrHolder) throws WIMException {
        List list = dataObject.getList("members");
        List list2 = (List)attrHolder.getAttribute("memberAttrs");
        Map map = GenericHelper.retrieveMemberOrGroupInfo(dataObject, list2, list);
        return map;
    }

    public static Map getGroupsAndProps(DataObject dataObject, AttrHolder attrHolder) throws WIMException {
        List list = dataObject.getList("groups");
        List list2 = (List)attrHolder.getAttribute("groupAttrs");
        Map map = GenericHelper.retrieveMemberOrGroupInfo(dataObject, list2, list);
        return map;
    }

    private static Map retrieveMemberOrGroupInfo(DataObject dataObject, List list, List list2) throws WIMException {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list2.size(); ++i) {
            DataObject dataObject2 = (DataObject)list2.get(i);
            String string = dataObject2.getDataObject("identifier").getString("uniqueName");
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            String string2 = dataObject2.getType().getName();
            hashMap2.put("type", string2);
            if (list != null) {
                for (int j = 0; j < list.size(); ++j) {
                    String string3 = (String)list.get(j);
                    try {
                        List list3;
                        if (dataObject2.isSet(string3) && string3 != "description") {
                            hashMap2.put(string3, dataObject2.get(string3));
                            continue;
                        }
                        if (!dataObject2.isSet(string3) || (list3 = (List)dataObject2.get(string3)) == null || list3.size() <= 0) continue;
                        hashMap2.put(string3, (String)list3.get(0));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            hashMap.put(string, hashMap2);
        }
        return hashMap;
    }

    public static boolean isReferenceToLoggedInUser(String string) throws WIMException {
        String string2 = GenericHelper.getCallerUniqueName();
        return string != null && string.equals(string2);
    }

    public static String getCallerUniqueName() throws WIMException {
        String string = "UNAUTHENTICATED";
        Subject subject = null;
        WSCredential wSCredential = null;
        try {
            Iterator<WSCredential> iterator;
            subject = WSSubject.getRunAsSubject();
            if (subject == null) {
                subject = WSSubject.getCallerSubject();
            }
            if (subject != null && (iterator = subject.getPublicCredentials(WSCredential.class).iterator()).hasNext()) {
                wSCredential = iterator.next();
            }
            if (wSCredential != null) {
                string = wSCredential.getUniqueSecurityName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static boolean isWASUserRegistry(String string) throws Exception {
        return new WASURHelper().isWASUserRegistry(string);
    }
}

