/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management.helpers;

import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.util.UniqueNameHelper;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RootHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = RootHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public static DataObject getFirstEntity(DataObject dataObject) throws WIMException {
        List list = dataObject.getList("entities");
        if (list == null || list.size() == 0) {
            throw new WIMException("Error: Could not find first entity");
        }
        return (DataObject)list.get(0);
    }

    public static DataObject getEntity(DataObject dataObject, String string) throws WIMException {
        String string2 = "getEntity(DataObject root, String uniqueName)";
        ArrayList arrayList = dataObject.getList("entities");
        DataObject dataObject2 = null;
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            DataObject dataObject3 = (DataObject)arrayList.get(i);
            DataObject dataObject4 = dataObject3.getDataObject("identifier");
            if (dataObject4 == null) continue;
            if (string != null) {
                string = UniqueNameHelper.formatUniqueName(string);
            }
            if (!string.equalsIgnoreCase(dataObject4.getString("uniqueName"))) continue;
            dataObject2 = dataObject3;
            break;
        }
        if (dataObject2 == null) {
            throw new WIMApplicationException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, string2);
        }
        return dataObject2;
    }

    public static void setGroupAttrControls(DataObject dataObject) throws WIMException {
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
        dataObject2.getList("properties").add("cn");
        dataObject2.getList("properties").add("description");
    }

    public static void setGroupMembershipControl(DataObject dataObject, List list) throws WIMException {
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMembershipControl");
        if (list == null) {
            dataObject2.getList("properties").add("cn");
        } else {
            dataObject2.setList("properties", list);
        }
    }

    public static void setGroupMemberControl(DataObject dataObject, boolean bl) throws WIMException {
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMemberControl");
        DataObject dataObject3 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
        dataObject3.getList("properties").add("cn");
        if (bl) {
            dataObject2.setInt("modifyMode", 3);
        }
    }

    public static void setGroupMemberControl(DataObject dataObject, List list) throws WIMException {
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMemberControl");
        if (list != null) {
            dataObject2.setList("properties", list);
        } else {
            DataObject dataObject3 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
            dataObject3.getList("properties").add("cn");
        }
    }

    public static void setDeleteControl(DataObject dataObject) throws WIMException {
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "DeleteControl");
        dataObject2.setBoolean("returnDeleted", true);
    }

    public static List getEntities(DataObject dataObject) throws WIMException {
        List list = dataObject.getList("entities");
        return list;
    }

    public static DataObject createEntity(DataObject dataObject, String string) {
        DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", string);
        return dataObject2;
    }
}

