/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management.helpers.entityHelpers;

import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.management.AttrHelpers.AttrHolder;
import com.ibm.ws.wim.management.helpers.CommandConstants;
import com.ibm.ws.wim.management.helpers.GenericHelper;
import com.ibm.ws.wim.management.helpers.RootHelper;
import com.ibm.ws.wim.management.helpers.entityHelpers.EntityHelper;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GroupHelper
implements EntityHelper,
CommandConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = GroupHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public void setAttributes(DataObject dataObject, AttrHolder attrHolder) throws WIMException {
        if (attrHolder.getAttribute("uniqueName") != null) {
            GenericHelper.setUniqueName(dataObject, (String)attrHolder.getAttribute("uniqueName"));
        }
        if (attrHolder.getAttribute("cn") != null) {
            dataObject.setString("cn", (String)attrHolder.getAttribute("cn"));
        }
        if (attrHolder.getAttribute("description") != null) {
            this.setDescription(dataObject, (String)attrHolder.getAttribute("description"));
        }
        if (attrHolder.getAttribute("parent") != null) {
            this.setParent(dataObject, (String)attrHolder.getAttribute("parent"));
        }
        if (attrHolder.getAttribute("memberUniqueName") != null) {
            this.setMember(dataObject, (String)attrHolder.getAttribute("memberUniqueName"));
        }
        if (attrHolder.getAttribute("realm") != null) {
            GenericHelper.setRealm(dataObject, (String)attrHolder.getAttribute("realm"));
        }
    }

    private void setDescription(DataObject dataObject, String string) {
        List list = dataObject.getList("description");
        list.clear();
        list.add(string);
    }

    public Map getAttributes(DataObject dataObject) throws WIMException {
        Object object;
        List list;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (dataObject.isSet("cn")) {
            hashMap.put("cn", dataObject.getString("cn"));
        }
        if ((list = dataObject.getList("description")) != null && list.size() > 0) {
            object = (String)list.get(0);
            hashMap.put("description", object);
        }
        if ((object = dataObject.getDataObject("identifier")) != null) {
            hashMap.put("uniqueName", object.get("uniqueName"));
            hashMap.put("repositoryId", object.get("repositoryId"));
        }
        return hashMap;
    }

    public void setMember(DataObject dataObject, String string) {
        DataObject dataObject2 = dataObject.createDataObject("members");
        DataObject dataObject3 = dataObject2.createDataObject("identifier");
        dataObject3.setString("uniqueName", string);
    }

    private void setParent(DataObject dataObject, String string) {
        DataObject dataObject2 = dataObject.createDataObject("parent");
        DataObject dataObject3 = dataObject2.createDataObject("identifier");
        dataObject3.setString("uniqueName", string);
    }

    public List getGroups(DataObject dataObject) throws WIMException {
        ArrayList arrayList = dataObject.getList("groups");
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public List getMembers(DataObject dataObject) throws WIMException {
        ArrayList arrayList = dataObject.getList("members");
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    public void verifyType(AttrHolder attrHolder) throws Exception {
        String string = "verifyType(String unqiueName)";
        String string2 = (String)attrHolder.getAttribute("uniqueName");
        String string3 = (String)attrHolder.getAttribute("realm");
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        DataObject dataObject = serviceProvider.createRootDataObject();
        DataObject dataObject2 = RootHelper.createEntity(dataObject, "Entity");
        GenericHelper.setUniqueName(dataObject2, string2);
        GenericHelper.setRealm(dataObject2, string3);
        dataObject = serviceProvider.get(dataObject);
        DataObject dataObject3 = RootHelper.getEntity(dataObject, string2);
        if (!"Group".equals(dataObject3.getType().getName())) {
            throw new WIMApplicationException("INCORRECT_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string2, "Group"), Level.SEVERE, CLASSNAME, string);
        }
    }

    public void setAttrControls(DataObject dataObject) throws WIMException {
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
        dataObject2.getList("properties").add("cn");
        dataObject2.getList("properties").add("description");
    }

    public String getType() {
        return "Group";
    }
}

