/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management.helpers.entityHelpers;

import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.WIMApplicationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.management.AttrHelpers.AttrHolder;
import com.ibm.ws.wim.management.helpers.CommandConstants;
import com.ibm.ws.wim.management.helpers.GenericHelper;
import com.ibm.ws.wim.management.helpers.RootHelper;
import com.ibm.ws.wim.management.helpers.entityHelpers.EntityHelper;
import commonj.sdo.DataObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PersonAccountHelper
implements EntityHelper,
CommandConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = PersonAccountHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public void setAttributes(DataObject dataObject, AttrHolder attrHolder) throws WIMException {
        if (attrHolder.getAttribute("uniqueName") != null) {
            GenericHelper.setUniqueName(dataObject, (String)attrHolder.getAttribute("uniqueName"));
        }
        if (attrHolder.getAttribute("cn") != null) {
            dataObject.setString("cn", (String)attrHolder.getAttribute("cn"));
        }
        if (attrHolder.getAttribute("uid") != null) {
            dataObject.setString("uid", (String)attrHolder.getAttribute("uid"));
        }
        if (attrHolder.getAttribute("sn") != null) {
            dataObject.setString("sn", (String)attrHolder.getAttribute("sn"));
        }
        if (attrHolder.getAttribute("mail") != null) {
            dataObject.setString("mail", (String)attrHolder.getAttribute("mail"));
        }
        if (attrHolder.getAttribute("password") != null) {
            dataObject.set("password", attrHolder.getAttribute("password"));
        }
        if (attrHolder.getAttribute("parent") != null) {
            PersonAccountHelper.setParent(dataObject, (String)attrHolder.getAttribute("parent"));
        }
        if (attrHolder.getAttribute("realm") != null) {
            GenericHelper.setRealm(dataObject, (String)attrHolder.getAttribute("realm"));
        }
    }

    public Map getAttributes(DataObject dataObject) throws WIMException {
        DataObject dataObject2;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (dataObject.isSet("cn")) {
            hashMap.put("cn", dataObject.getString("cn"));
        }
        if (dataObject.isSet("uid")) {
            hashMap.put("uid", dataObject.getString("uid"));
        }
        if (dataObject.isSet("sn")) {
            hashMap.put("sn", dataObject.getString("sn"));
        }
        if (dataObject.isSet("mail")) {
            hashMap.put("mail", dataObject.getString("mail"));
        }
        if (dataObject.isSet("principalName")) {
            hashMap.put("principalName", dataObject.getString("principalName"));
        }
        if ((dataObject2 = dataObject.getDataObject("identifier")) != null) {
            hashMap.put("uniqueName", dataObject2.get("uniqueName"));
            hashMap.put("repositoryId", dataObject2.get("repositoryId"));
        }
        return hashMap;
    }

    public String getType() {
        return "PersonAccount";
    }

    private static void setParent(DataObject dataObject, String string) {
        DataObject dataObject2 = dataObject.createDataObject("parent");
        DataObject dataObject3 = dataObject2.createDataObject("identifier");
        dataObject3.setString("uniqueName", string);
    }

    public void verifyType(AttrHolder attrHolder) throws Exception {
        String string = "verifyType(String uniqueName)";
        String string2 = (String)attrHolder.getAttribute("uniqueName");
        String string3 = (String)attrHolder.getAttribute("realm");
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        DataObject dataObject = serviceProvider.createRootDataObject();
        DataObject dataObject2 = RootHelper.createEntity(dataObject, "Entity");
        GenericHelper.setUniqueName(dataObject2, string2);
        GenericHelper.setRealm(dataObject2, string3);
        dataObject = serviceProvider.get(dataObject);
        DataObject dataObject3 = RootHelper.getEntity(dataObject, string2);
        if (!"PersonAccount".equals(dataObject3.getType().getName())) {
            throw new WIMApplicationException("INCORRECT_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string2, "PersonAccount"), Level.SEVERE, CLASSNAME, string);
        }
    }

    public void setAttrControls(DataObject dataObject) throws WIMException {
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
        dataObject2.getList("properties").add("cn");
        dataObject2.getList("properties").add("sn");
        dataObject2.getList("properties").add("uid");
        dataObject2.getList("properties").add("mail");
        dataObject2.getList("properties").add("principalName");
    }
}

