/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management.repositoryhelpers;

import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.management.AttrHelpers.AttrHolder;
import com.ibm.ws.wim.management.AttrHelpers.GroupAttrHolder;
import com.ibm.ws.wim.management.helpers.CommandConstants;
import com.ibm.ws.wim.management.helpers.GenericHelper;
import com.ibm.ws.wim.management.helpers.RootHelper;
import com.ibm.ws.wim.management.helpers.entityHelpers.EntityHelper;
import com.ibm.ws.wim.management.helpers.entityHelpers.EntityHelperFactory;
import com.ibm.ws.wim.management.helpers.entityHelpers.GroupHelper;
import com.ibm.ws.wim.management.helpers.searchHelpers.SearchHelper;
import com.ibm.ws.wim.management.helpers.searchHelpers.SearchHelperFactory;
import com.ibm.ws.wim.management.repositoryhelpers.UMAssistantInterface;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UMAssistant
implements UMAssistantInterface,
CommandConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = UMAssistant.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public String create(AttrHolder attrHolder) throws Exception {
        String string = "create(AttrHolder holder)";
        UMAssistant.logEnter(string);
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        DataObject dataObject = serviceProvider.createRootDataObject();
        EntityHelper entityHelper = EntityHelperFactory.create(attrHolder.getAttrHolderType());
        DataObject dataObject2 = RootHelper.createEntity(dataObject, entityHelper.getType());
        entityHelper.setAttributes(dataObject2, attrHolder);
        dataObject = serviceProvider.create(dataObject);
        dataObject2 = RootHelper.getFirstEntity(dataObject);
        String string2 = GenericHelper.getUniqueNameOfEntity(dataObject2);
        UMAssistant.logExit(string);
        return string2;
    }

    public String delete(AttrHolder attrHolder) throws Exception {
        String string = "delete(AttrHolder holder)";
        UMAssistant.logEnter(string);
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        EntityHelper entityHelper = EntityHelperFactory.create(attrHolder.getAttrHolderType());
        DataObject dataObject = serviceProvider.createRootDataObject();
        DataObject dataObject2 = RootHelper.createEntity(dataObject, entityHelper.getType());
        entityHelper.setAttributes(dataObject2, attrHolder);
        RootHelper.setDeleteControl(dataObject);
        serviceProvider.delete(dataObject);
        UMAssistant.logExit(string);
        return (String)attrHolder.getAttribute("uniqueName");
    }

    public Map get(AttrHolder attrHolder) throws Exception {
        String string = "get(AttrHolder holder)";
        UMAssistant.logEnter(string);
        Map map = null;
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        DataObject dataObject = serviceProvider.createRootDataObject();
        EntityHelper entityHelper = EntityHelperFactory.create(attrHolder.getAttrHolderType());
        DataObject dataObject2 = RootHelper.createEntity(dataObject, entityHelper.getType());
        entityHelper.setAttributes(dataObject2, attrHolder);
        entityHelper.setAttrControls(dataObject);
        dataObject = serviceProvider.get(dataObject);
        dataObject2 = RootHelper.getEntity(dataObject, (String)attrHolder.getAttribute("uniqueName"));
        map = entityHelper.getAttributes(dataObject2);
        UMAssistant.logExit(string);
        return map;
    }

    public Map getMembership(AttrHolder attrHolder) throws Exception {
        String string = "getMembership(AttrHolder holder)";
        UMAssistant.logEnter(string);
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        EntityHelper entityHelper = EntityHelperFactory.create(attrHolder.getAttrHolderType());
        DataObject dataObject = serviceProvider.createRootDataObject();
        DataObject dataObject2 = RootHelper.createEntity(dataObject, entityHelper.getType());
        entityHelper.setAttributes(dataObject2, attrHolder);
        RootHelper.setGroupMembershipControl(dataObject, (List)attrHolder.getAttribute("groupAttrs"));
        dataObject = serviceProvider.get(dataObject);
        dataObject2 = RootHelper.getEntity(dataObject, (String)attrHolder.getAttribute("uniqueName"));
        Map map = GenericHelper.getGroupsAndProps(dataObject2, attrHolder);
        UMAssistant.logExit(string);
        return map;
    }

    public Map getMembersOfGroup(AttrHolder attrHolder) throws Exception {
        String string = "getMembersOfGroup(AttrHolder holder)";
        UMAssistant.logEnter(string);
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        EntityHelper entityHelper = EntityHelperFactory.create(attrHolder.getAttrHolderType());
        DataObject dataObject = serviceProvider.createRootDataObject();
        DataObject dataObject2 = RootHelper.createEntity(dataObject, entityHelper.getType());
        entityHelper.setAttributes(dataObject2, attrHolder);
        RootHelper.setGroupMemberControl(dataObject, (List)attrHolder.getAttribute("memberAttrs"));
        dataObject = serviceProvider.get(dataObject);
        dataObject2 = RootHelper.getEntity(dataObject, (String)attrHolder.getAttribute("uniqueName"));
        Map map = GenericHelper.getMembersAndProps(dataObject2, attrHolder);
        UMAssistant.logExit(string);
        return map;
    }

    public List searchUsers(AttrHolder attrHolder) throws Exception {
        Map map = this.search(attrHolder);
        ArrayList arrayList = new ArrayList(map.keySet());
        return arrayList;
    }

    public List searchGroups(AttrHolder attrHolder) throws Exception {
        Map map = this.search(attrHolder);
        ArrayList arrayList = new ArrayList(map.keySet());
        return arrayList;
    }

    public Map search(AttrHolder attrHolder) throws Exception {
        String string = "search(AttrHolder holder)";
        UMAssistant.logEnter(string);
        Map map = null;
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        DataObject dataObject = serviceProvider.createRootDataObject();
        String string2 = attrHolder.getAttrHolderType();
        SearchHelper searchHelper = SearchHelperFactory.create(string2);
        searchHelper.setAttributes(dataObject, attrHolder);
        dataObject = serviceProvider.search(dataObject);
        List list = RootHelper.getEntities(dataObject);
        map = GenericHelper.getEntitiesInMap(list, (List)attrHolder.getAttribute("searchProps"));
        UMAssistant.logExit(string);
        return map;
    }

    public String addMemberToGroup(AttrHolder attrHolder, AttrHolder attrHolder2) throws Exception {
        String string = "addMemberToGroup(AttrHolder memberAttrHolder, AttrHolder groupAttrHolder)";
        UMAssistant.logEnter(string);
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        EntityHelper entityHelper = EntityHelperFactory.create(attrHolder2.getAttrHolderType());
        DataObject dataObject = serviceProvider.createRootDataObject();
        DataObject dataObject2 = RootHelper.createEntity(dataObject, entityHelper.getType());
        entityHelper.setAttributes(dataObject2, attrHolder2);
        new GroupHelper().setMember(dataObject2, (String)attrHolder.getAttribute("uniqueName"));
        serviceProvider.update(dataObject);
        UMAssistant.logExit(string);
        return (String)attrHolder.getAttribute("uniqueName");
    }

    public String removeMemberFromGroup(AttrHolder attrHolder, AttrHolder attrHolder2) throws Exception {
        String string = "removeMemberFromGroup(AttrHolder memberAttrHolder, AttrHolder groupAttrHolder)";
        UMAssistant.logEnter(string);
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        DataObject dataObject = serviceProvider.createRootDataObject();
        EntityHelper entityHelper = EntityHelperFactory.create(attrHolder2.getAttrHolderType());
        DataObject dataObject2 = RootHelper.createEntity(dataObject, entityHelper.getType());
        entityHelper.setAttributes(dataObject2, attrHolder2);
        RootHelper.setGroupMemberControl(dataObject, true);
        new GroupHelper().setMember(dataObject2, (String)attrHolder.getAttribute("uniqueName"));
        serviceProvider.update(dataObject);
        UMAssistant.logExit(string);
        return (String)attrHolder.getAttribute("uniqueName");
    }

    public String duplicateMembership(AttrHolder attrHolder, AttrHolder attrHolder2) throws Exception {
        String string = "duplicateMembership(AttrHolder copyFromHolder, AttrHolder copyToHolder)";
        UMAssistant.logEnter(string);
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        EntityHelper entityHelper = EntityHelperFactory.create(attrHolder.getAttrHolderType());
        DataObject dataObject = serviceProvider.createRootDataObject();
        DataObject dataObject2 = RootHelper.createEntity(dataObject, entityHelper.getType());
        entityHelper.setAttributes(dataObject2, attrHolder);
        RootHelper.setGroupMembershipControl(dataObject, null);
        DataObject dataObject3 = serviceProvider.get(dataObject);
        dataObject2 = RootHelper.getEntity(dataObject3, (String)attrHolder.getAttribute("uniqueName"));
        List list = new GroupHelper().getGroups(dataObject2);
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject4 = serviceProvider.createRootDataObject();
            DataObject dataObject5 = (DataObject)list.get(i);
            String string2 = dataObject5.getDataObject("identifier").getString("uniqueName");
            DataObject dataObject6 = RootHelper.createEntity(dataObject4, "Group");
            GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string2);
            EntityHelper entityHelper2 = EntityHelperFactory.create("Group");
            entityHelper2.setAttributes(dataObject6, groupAttrHolder);
            new GroupHelper().setMember(dataObject6, (String)attrHolder2.getAttribute("uniqueName"));
            serviceProvider.update(dataObject4);
        }
        UMAssistant.logExit(string);
        return (String)attrHolder2.getAttribute("uniqueName");
    }

    public String update(AttrHolder attrHolder) throws Exception {
        String string = "update(AttrHolder holder)";
        UMAssistant.logEnter(string);
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        GenericHelper.checkPassword((byte[])attrHolder.getAttribute("password"), (byte[])attrHolder.getAttribute("confirmPassword"));
        EntityHelper entityHelper = EntityHelperFactory.create(attrHolder.getAttrHolderType());
        DataObject dataObject = serviceProvider.createRootDataObject();
        DataObject dataObject2 = RootHelper.createEntity(dataObject, entityHelper.getType());
        entityHelper.setAttributes(dataObject2, attrHolder);
        dataObject = serviceProvider.update(dataObject);
        dataObject2 = RootHelper.getFirstEntity(dataObject);
        String string2 = GenericHelper.getUniqueNameOfEntity(dataObject2);
        UMAssistant.logExit(string);
        return string2;
    }

    public static void logEnter(String string) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
    }

    public static void logExit(String string) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }
}

