/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.management.repositoryhelpers;

import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.config.GenericRepositoryConfigHelper;
import com.ibm.ws.wim.config.RealmConfigHelper;
import com.ibm.ws.wim.management.AttrHelpers.GenericAttrHolder;
import com.ibm.ws.wim.management.AttrHelpers.GroupAttrHolder;
import com.ibm.ws.wim.management.AttrHelpers.PersonAccountAttrHolder;
import com.ibm.ws.wim.management.AttrHelpers.SearchAttrHolder;
import com.ibm.ws.wim.management.repositoryhelpers.RepositoryAssistant;
import com.ibm.ws.wim.management.repositoryhelpers.UMAssistant;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WIMRepositoryAssistant
implements RepositoryAssistant {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = WIMRepositoryAssistant.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public boolean isReadOnly() throws Exception {
        String string = "WIMManagementSession";
        boolean bl = true;
        String string2 = new RealmConfigHelper().getIdMgrDefaultRealm(string);
        List list = new RealmConfigHelper().getIdMgrRepositoriesForRealm(string, string2);
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            String string3 = (String)map.get("id");
            Map map2 = new GenericRepositoryConfigHelper().getIdMgrRepository(string, string3);
            Boolean bl2 = (Boolean)map2.get("readOnly");
            if (bl2 != null && bl2.booleanValue()) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static void logEnter(String string) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, string);
        }
    }

    private static void logExit(String string) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.exiting(CLASSNAME, string);
        }
    }

    public boolean isPersonAccountSupported() {
        String string = "isPersonAccountSupported";
        WIMRepositoryAssistant.logEnter(string);
        return false;
    }

    public boolean isPersonSupported() {
        String string = "isPersonSupported";
        WIMRepositoryAssistant.logEnter(string);
        return false;
    }

    public String createUser(String string, String string2, String string3, String string4, byte[] byArray, byte[] byArray2, String string5) throws Exception {
        PersonAccountAttrHolder personAccountAttrHolder = new PersonAccountAttrHolder(null, string, string2, string3, string4, byArray, byArray2, string5, null);
        String string6 = new UMAssistant().create(personAccountAttrHolder);
        return string6;
    }

    public String createGroup(String string, String string2, String string3, String string4) throws Exception {
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(null, string2, string, string3, string4, null);
        String string5 = new UMAssistant().create(groupAttrHolder);
        return string5;
    }

    public String deleteUser(String string) throws Exception {
        PersonAccountAttrHolder personAccountAttrHolder = new PersonAccountAttrHolder(string);
        new UMAssistant().delete(personAccountAttrHolder);
        return string;
    }

    public String deleteGroup(String string) throws Exception {
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string);
        new UMAssistant().delete(groupAttrHolder);
        return string;
    }

    public Map getUser(String string) throws Exception {
        PersonAccountAttrHolder personAccountAttrHolder = new PersonAccountAttrHolder(string);
        Map map = new UMAssistant().get(personAccountAttrHolder);
        return map;
    }

    public Map getGroup(String string) throws Exception {
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string);
        Map map = new UMAssistant().get(groupAttrHolder);
        return map;
    }

    public Map getMembershipOfUser(String string) throws Exception {
        PersonAccountAttrHolder personAccountAttrHolder = new PersonAccountAttrHolder(string);
        Map map = new UMAssistant().getMembership(personAccountAttrHolder);
        return map;
    }

    public Map getMembershipOfGroup(String string) throws Exception {
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string);
        Map map = new UMAssistant().getMembership(groupAttrHolder);
        return map;
    }

    public Map getMembersOfGroup(String string) throws Exception {
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string);
        Map map = new UMAssistant().getMembersOfGroup(groupAttrHolder);
        return map;
    }

    public List searchUsers(Integer n, Integer n2, String string, String string2) throws Exception {
        SearchAttrHolder searchAttrHolder = new SearchAttrHolder(n, n2, string, string2, null, "PersonAccount", null);
        List list = new UMAssistant().searchUsers(searchAttrHolder);
        return list;
    }

    public Map searchUsers(Integer n, Integer n2, String string, String string2, List list) throws Exception {
        SearchAttrHolder searchAttrHolder = new SearchAttrHolder(n, n2, string, string2, list, "PersonAccount", null);
        Map map = new UMAssistant().search(searchAttrHolder);
        return map;
    }

    public List searchGroups(Integer n, Integer n2, String string, String string2) throws Exception {
        SearchAttrHolder searchAttrHolder = new SearchAttrHolder(n, n2, string, string2, null, "Group", null);
        List list = new UMAssistant().searchGroups(searchAttrHolder);
        return list;
    }

    public Map searchGroups(Integer n, Integer n2, String string, String string2, List list) throws Exception {
        SearchAttrHolder searchAttrHolder = new SearchAttrHolder(n, n2, string, string2, list, "Group", null);
        Map map = new UMAssistant().search(searchAttrHolder);
        return map;
    }

    public String addMemberToGroup(String string, String string2) throws Exception {
        GenericAttrHolder genericAttrHolder = new GenericAttrHolder(string);
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string2);
        new UMAssistant().addMemberToGroup(genericAttrHolder, groupAttrHolder);
        return string;
    }

    public String removeMemberFromGroup(String string, String string2) throws Exception {
        GenericAttrHolder genericAttrHolder = new GenericAttrHolder(string);
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string2);
        new UMAssistant().removeMemberFromGroup(genericAttrHolder, groupAttrHolder);
        return string;
    }

    public String duplicateMembershipOfUser(String string, String string2) throws Exception {
        PersonAccountAttrHolder personAccountAttrHolder = new PersonAccountAttrHolder(string2);
        PersonAccountAttrHolder personAccountAttrHolder2 = new PersonAccountAttrHolder(string);
        new UMAssistant().duplicateMembership(personAccountAttrHolder2, personAccountAttrHolder);
        return string2;
    }

    public String duplicateMembershipOfGroup(String string, String string2) throws Exception {
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string2);
        GroupAttrHolder groupAttrHolder2 = new GroupAttrHolder(string);
        new UMAssistant().duplicateMembership(groupAttrHolder2, groupAttrHolder);
        return string2;
    }

    public String updateGroup(String string, String string2, String string3) throws Exception {
        GroupAttrHolder groupAttrHolder = new GroupAttrHolder(string3, string, string2, null, null, null);
        string3 = new UMAssistant().update(groupAttrHolder);
        return string3;
    }

    public String updateUser(String string, String string2, String string3, String string4, byte[] byArray, byte[] byArray2, String string5) throws Exception {
        PersonAccountAttrHolder personAccountAttrHolder = new PersonAccountAttrHolder(string5, string, string2, string3, string4, byArray, byArray2, null, null);
        string5 = new UMAssistant().update(personAccountAttrHolder);
        return string5;
    }
}

