/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration;

import com.ibm.websphere.wim.exception.MigrationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.migration.MigrationConstants;
import com.ibm.ws.wim.migration.config.ConfigMigration;
import com.ibm.ws.wim.migration.db.DBMigration;
import com.ibm.ws.wim.migration.db.ReferenceUpdate;
import com.ibm.ws.wim.migration.ur.WMMURMigration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WMMToVMMMigration
implements MigrationConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = WMMToVMMMigration.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public void migrateWMMConfigToVMM(String string, String string2, String string3) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, " > ENTRY: migrateWMMConfigToVMM", WIMTraceHelper.printObjectArray(new Object[]{string, string2, string3}));
        }
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            throw new MigrationException("MIGRATION_CONFIG_PATH_MISSING", Level.SEVERE, CLASSNAME, "migrateWMMConfigToVMM");
        }
        ConfigMigration configMigration = new ConfigMigration(string, string2, string3);
        configMigration.migrate();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, " < EXIT: migrateWMMConfigToVMM");
        }
    }

    public void migrateWMMURToWIMRealm(String string, String string2, Map map) throws WIMException {
        WMMURMigration wMMURMigration = new WMMURMigration(string, string2, map);
        wMMURMigration.migrateWMMURToVMM();
    }

    public short migrateWMMDBToVMMDB(String string, String string2, Map map) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, " > ENTRY: migrateWMMDBToVMMDB");
        }
        if (string == null || string.length() == 0 || string2 == null || string2.length() == 0 || map == null || map.size() == 0) {
            throw new MigrationException("MIGRATION_CONFIG_PATH_MISSING", Level.SEVERE, CLASSNAME, "migrateWMMDBToVMMDB");
        }
        DBMigration dBMigration = new DBMigration();
        dBMigration.initialize(string, string2, map);
        short s = dBMigration.migrate();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.logp(Level.FINER, CLASSNAME, "migrateWMMDBToVMMDB", "referece to update is " + s);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, " < EXIT: migrateWMMDBToVMMDB");
        }
        return s;
    }

    public void ReferenceUpdate(short s, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, " > ENTRY: ReferenceUpdate");
        }
        if (s > 2 || s < 0) {
            return;
        }
        if (string == null || string.length() == 0) {
            throw new MigrationException("MIGRATION_CONFIG_PATH_MISSING", Level.SEVERE, CLASSNAME, "ReferenceUpdate");
        }
        ReferenceUpdate referenceUpdate = new ReferenceUpdate();
        referenceUpdate.initialize(s, string);
        referenceUpdate.updateReference();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, " < EXIT: ReferenceUpdate");
        }
    }
}

