/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration.config;

import com.ibm.websphere.wim.exception.MigrationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.ws.security.util.WSEncoderDecoder;
import com.ibm.ws.wim.migration.MigrationConstants;
import com.ibm.ws.wim.migration.wmm.DataTypeHelper;
import com.ibm.ws.wim.migration.wmm.MemberTypeHelper;
import com.ibm.ws.wim.migration.wmm.config.MemberManager;
import com.ibm.ws.wim.migration.wmm.config.MemberRepository;
import com.ibm.ws.wim.migration.wmm.config.MemberType;
import com.ibm.ws.wim.migration.wmm.config.NodeMap;
import com.ibm.ws.wim.migration.wmm.config.ProfileEntryType;
import com.ibm.ws.wim.migration.wmm.config.ProfileRepository;
import com.ibm.ws.wim.migration.wmm.datatype.AttributeDefinition;
import com.ibm.ws.wim.migration.wmm.datatype.AttributeDefinitionSet;
import com.ibm.ws.wim.migration.wmm.datatype.StringSet;
import com.ibm.ws.wim.migration.wmm.plugin.PluginAttribute;
import com.ibm.ws.wim.migration.wmm.plugin.PluginConfigManager;
import com.ibm.ws.wim.migration.wmm.plugin.PluginConfigManagerImpl;
import com.ibm.ws.wim.migration.wmm.xml.config.XML2WMMConfiguration;
import com.ibm.ws.wim.migration.wmm.xml.config.XML2WMMConfigurationConstants;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.ws.wim.util.PasswordEncryptionUtil;
import com.ibm.ws.xml.ParserFactory;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.impl.DynamicEDataObjectImpl;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.xsd.ecore.XSDEcoreBuilder;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigMigration
implements MigrationConstants,
XML2WMMConfigurationConstants {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = ConfigMigration.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final String ALL = new String("all");
    private static final String ALL_TEMP_FILE = "wimconfig_fed_la_db.xml";
    private static final String IDS_TEMP_FILE = "wimconfig_ldap_ids.xml";
    private static final String SUNONE_TEMP_FILE = "wimconfig_ldap_so.xml";
    private static final String NDS_TEMP_FILE = "wimconfig_ldap_nds.xml";
    private static final String AD_TEMP_FILE = "wimconfig_ldap_ad.xml";
    private static final String DM_TEMP_FILE = "wimconfig_ldap_dm.xml";
    private static final String vmmConfigXSDFile = "wimconfig.xsd";
    private String vmmSchemaXSDFile = "wimschema.xsd";
    private static final String vmmConfigXMLFile = "wimconfig.xml";
    private static final String vmmPropFileName = "wimPropertyNames.properties";
    private String vmmMigrationExtXMLFile = "wimxmlextension_migration.xml";
    private String vmmExtXMLFile = "wimxmlextension.xml";
    private boolean hasDBAdapter = false;
    private static Set attrsInWMMOnly = new HashSet();
    private DataObject vmmCfgProviderDO = null;
    private DataGraph vmmConfigDG = null;
    private DataGraph vmmExtDG = null;
    private String wmmConfigPath = null;
    private String wasHomePath = null;
    private String wimHomePath = null;
    private EPackage configSchema = null;
    private MemberManager wmmConfig = null;
    private HashMap attrDefMap = null;
    private AttributeDefinitionSet[] memberTypeAttrDef = null;
    private StringSet supportedDataTypes = null;
    private Properties vmmPropNames = null;
    private PluginConfigManager ldapConfig = null;
    private String entityTypeXPath = "configurationProvider/supportedEntityTypes[name=\"{0}\"]";
    private String schar = File.separator;

    public ConfigMigration(String string, String string2, String string3) {
        if (!string.endsWith(this.schar)) {
            string = string + this.schar;
        }
        if (!string2.endsWith(this.schar)) {
            string2 = string2 + this.schar;
        }
        if (!string3.endsWith(this.schar)) {
            string3 = string3 + this.schar;
        }
        this.wmmConfigPath = string;
        this.wasHomePath = string2;
        this.wimHomePath = string3;
    }

    public void migrate() throws WIMException {
        Object object;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "migrate");
        }
        this.wmmConfig = XML2WMMConfiguration.getWmmConfiguration(this.wmmConfigPath, "wmm.xml");
        List list = this.wmmConfig.getMemberRepositories();
        String string = this.wimHomePath + "config" + this.schar + vmmConfigXSDFile;
        this.loadConfigSchemaFromPackage("com.ibm.ws.wim.configmodel.ConfigmodelPackage");
        this.vmmConfigDG = this.loadConfigFromXML(this.getVMMConfigTemplateFile(ALL));
        this.vmmCfgProviderDO = this.vmmConfigDG.getRootObject().getDataObject("configurationProvider");
        string = this.wimHomePath + "model" + this.schar + this.vmmSchemaXSDFile;
        this.loadSchemaFromXSD(string);
        this.vmmExtDG = this.loadExtXML();
        this.initializeSupportMemberTypes();
        this.memberTypeAttrDef = new AttributeDefinitionSet[this.wmmConfig.getSupportedMemberTypes().size()];
        this.initializeAttrDefCaches(this.wmmConfig.getConfigurationFile());
        this.migrateProviderLevel(this.wmmConfig);
        this.migrateSupportedEntities(this.wmmConfig.getSupportedMemberTypes());
        this.vmmPropNames = this.loadVMMPropertyNames();
        for (int i = 0; i < list.size(); ++i) {
            object = (MemberRepository)list.get(i);
            this.migrateRepository((MemberRepository)object, this.wmmConfig);
        }
        String string2 = this.wmmConfig.getUserSecurityNameAttribute();
        if (string2 != null) {
            this.migrateLoginProperties(string2);
        }
        if (!this.hasDBAdapter) {
            object = this.vmmCfgProviderDO.getList("repositories");
            boolean bl = false;
            for (int i = 0; i < object.size() && !bl; ++i) {
                DataObject dataObject = (DataObject)object.get(i);
                String string3 = dataObject.getType().getName();
                if (!string3.equals("DatabaseRepositoryType")) continue;
                object.remove(i);
                bl = true;
            }
        }
        this.checkWMMAttribute(list.size());
        if (!this.wmmConfig.isHorizontalPartitioning()) {
            this.vmmCfgProviderDO.unset("entryMappingRepository");
        }
        if (!this.wmmConfig.isLookAside()) {
            this.vmmCfgProviderDO.unset("propertyExtensionRepository");
        }
        object = this.wimHomePath + "config" + this.schar + vmmConfigXMLFile;
        DataGraphHelper.saveDataGraph(this.vmmConfigDG, (String)object);
        String string4 = this.wimHomePath + "model" + this.schar + this.vmmExtXMLFile;
        DataGraphHelper.saveDataGraph(this.vmmExtDG, string4);
        if (trcLogger.isLoggable(Level.FINER)) {
            // empty if block
        }
        trcLogger.exiting(CLASSNAME, "migrate");
    }

    public DataGraph loadConfigFromXML(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "loadConfigFromXML", WIMTraceHelper.printObjectArray(new Object[]{string}));
        }
        EDataGraph eDataGraph = null;
        String string2 = this.wasHomePath + "etc/wim/migration" + this.schar + string;
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            HashMap hashMap = new HashMap();
            eDataGraph = SDOUtil.loadDataGraph((InputStream)fileInputStream, hashMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MigrationException("WIM_CONFIG_XML_FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "loadConfigFromXML", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new MigrationException("INVALID_WIM_CONFIG_XML_FILE", WIMMessageHelper.generateMsgParms(string2, iOException.getMessage()), CLASSNAME, "loadConfigFromXML", (Throwable)iOException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "loadConfigFromXML");
        }
        return eDataGraph;
    }

    private EPackage loadSchemaFromXSD(String string) throws WIMException {
        long l = System.currentTimeMillis();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        XSDEcoreBuilder xSDEcoreBuilder = new XSDEcoreBuilder();
        Collection collection = xSDEcoreBuilder.generate(URI.createFileURI((String)string));
        if (trcLogger.isLoggable(Level.CONFIG)) {
            long l2 = System.currentTimeMillis();
            trcLogger.logp(Level.CONFIG, CLASSNAME, "loadSchemaFromXSD", "Loaded successful from " + string + " (" + (l2 - l) + " milliseconds)");
        }
        Iterator iterator = collection.iterator();
        EPackage ePackage = null;
        if (iterator.hasNext()) {
            ePackage = (EPackage)iterator.next();
            String string2 = ePackage.getNsURI();
            ePackage.setEFactoryInstance((EFactory)new DynamicEDataObjectImpl.FactoryImpl());
            EPackage.Registry.INSTANCE.put((Object)string2, (Object)ePackage);
        }
        return ePackage;
    }

    private String getVMMConfigTemplateFile(String string) {
        String string2 = null;
        if (string.equals(ALL)) {
            string2 = ALL_TEMP_FILE;
        }
        return string2;
    }

    private String getDbTypeFromClassName(String string) {
        int n;
        String string2 = "com.ibm.ws.wmm.db.dao.";
        String string3 = string.substring(string2.length());
        String string4 = string3.substring(0, n = string3.indexOf("."));
        if (string4.equals("cloudscape")) {
            string4 = "derby";
        }
        return string4;
    }

    private void migrateProviderLevel(MemberManager memberManager) {
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        Integer n5 = memberManager.getMaximumSearchResults();
        if (n5 != null) {
            this.vmmCfgProviderDO.setInt("maxSearchResults", n5.intValue());
        }
        if ((n4 = memberManager.getMaximumSearchResultsForSortingAndPaging()) != null) {
            this.vmmCfgProviderDO.setInt("maxPagingResults", n4.intValue());
        }
        if ((n3 = memberManager.getMaximumTotalSearchResultsForSortingAndPaging()) != null) {
            this.vmmCfgProviderDO.setInt("maxTotalPagingResults", n3.intValue());
        }
        if ((n2 = memberManager.getSearchTimeout()) != null) {
            this.vmmCfgProviderDO.setInt("searchTimeOut", n2.intValue());
        }
        if ((n = memberManager.getTimeToRemovePagedCacheEntry()) != null) {
            this.vmmCfgProviderDO.setInt("pagedCacheTimeOut", n.intValue());
        }
        boolean bl = memberManager.isPagingMemberObject();
        this.vmmCfgProviderDO.setBoolean("pagingEntityObject", bl);
    }

    private void migrateRepository(MemberRepository memberRepository, MemberManager memberManager) throws WIMException {
        String string = memberRepository.getRepositoryType();
        if (string.equals("DB")) {
            this.migrateDBRepository((ProfileRepository)memberRepository);
            this.hasDBAdapter = true;
        } else if (string.equals("LDAP")) {
            this.migrateLDAPRepository((ProfileRepository)memberRepository, memberManager.getSupportedMemberTypes());
        } else if (string.equals("LA")) {
            this.migrateLaOrFedRepository(memberRepository, true);
        } else if (string.equals("FED")) {
            this.migrateLaOrFedRepository(memberRepository, false);
        }
    }

    private void migrateDBRepository(ProfileRepository profileRepository) throws WIMException {
        String string = (String)profileRepository.getProperty("dataAccessManagerClassName");
        String string2 = this.getDbTypeFromClassName(string);
        String string3 = profileRepository.getRepositoryUUID();
        int n = (Integer)profileRepository.getProperty("saltLength");
        String string4 = (String)profileRepository.getProperty("dbEncryptionKey");
        DataObject dataObject = (DataObject)this.vmmCfgProviderDO.getList("repositories").get(0);
        dataObject.setString("databaseType", string2);
        dataObject.setString("id", string3);
        dataObject.setInt("saltLength", n);
        dataObject.setString("encryptionKey", string4);
        this.migrateNodesToBaseEntries(dataObject, profileRepository);
        this.migrateRepositoriesForGroups(dataObject, profileRepository);
    }

    private void migrateNodesToBaseEntries(DataObject dataObject, ProfileRepository profileRepository) throws WIMException {
        List list = dataObject.getList("baseEntries");
        list.clear();
        DataObject dataObject2 = this.vmmCfgProviderDO.getDataObject("realmConfiguration");
        if (dataObject2 != null) {
            dataObject2.delete();
        }
        List list2 = profileRepository.getNodeMap();
        for (int i = 0; i < list2.size(); ++i) {
            NodeMap nodeMap = (NodeMap)list2.get(i);
            String string = nodeMap.getNode();
            String string2 = nodeMap.getPluginNode();
            if (string == null) continue;
            DataObject dataObject3 = SDOHelper.createConfigDataObject(dataObject, "http://www.ibm.com/websphere/wim/config", "baseEntries");
            dataObject3.set("name", (Object)string);
            if (string2 == null || string2.equalsIgnoreCase(string)) continue;
            dataObject3.set("nameInRepository", (Object)string2);
        }
    }

    private void migrateLoginProperties(String string) {
        List list = this.vmmCfgProviderDO.getList("repositories");
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject = (DataObject)list.get(i);
            List list2 = dataObject.getList("loginProperties");
            list2.add(string);
        }
    }

    private void migrateRepositoriesForGroups(DataObject dataObject, ProfileRepository profileRepository) {
        List list = profileRepository.getProfileRepositoryForGroups();
        List list2 = dataObject.getList("repositoriesForGroups");
        for (int i = 0; i < list.size(); ++i) {
            list2.add(list.get(i));
        }
    }

    private void migrateSupportedEntities(List list) throws WIMException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        List list2 = null;
        if (list == null) {
            throw new MigrationException("MIGRATION_WMM_FILE_INVALID", WIMMessageHelper.generateMsgParms("wmm.xml"), CLASSNAME, "migrateSupportedEntities");
        }
        for (int i = 0; i < list.size(); ++i) {
            MemberType memberType = (MemberType)list.get(i);
            String string2 = memberType.getStringName();
            String string3 = null;
            DataObject dataObject = null;
            string3 = memberType.getDefaultParentMember();
            if (string2.equals("Person")) {
                dataObject = this.vmmConfigDG.getRootObject().getDataObject(this.getEntityTypeXPath("PersonAccount"));
                list2 = dataObject.getList("rdnProperties");
                list2.clear();
                bl = true;
            } else if (string2.equals("Group")) {
                dataObject = this.vmmConfigDG.getRootObject().getDataObject(this.getEntityTypeXPath("Group"));
                list2 = dataObject.getList("rdnProperties");
                list2.clear();
                bl2 = true;
            } else if (string2.equals("Organization")) {
                dataObject = this.vmmConfigDG.getRootObject().getDataObject(this.getEntityTypeXPath("OrgContainer"));
                if (string != null) {
                    string3 = string;
                }
                bl3 = true;
            } else if (string2.equals("OrganizationalUnit")) {
                dataObject = this.vmmConfigDG.getRootObject().getDataObject(this.getEntityTypeXPath("OrgContainer"));
                string = string3;
                bl3 = true;
            } else {
                throw new MigrationException("MIGRATION_WMM_FILE_INVALID", WIMMessageHelper.generateMsgParms("wmm.xml"), CLASSNAME, "migrateSupportedEntities");
            }
            dataObject.setString("defaultParent", string3);
            if (string2.equals("Organization") || string2.equals("OrganizationalUnit")) continue;
            String[] stringArray = memberType.getRDNAttrTypes();
            String string4 = this.generateCombineStr(stringArray, ";");
            list2.add(string4);
        }
        if (!bl3) {
            List list3 = this.vmmCfgProviderDO.getList("supportedEntityTypes");
            list3.remove(this.vmmConfigDG.getRootObject().getDataObject(this.getEntityTypeXPath("OrgContainer")));
        }
    }

    private String generateCombineStr(String[] stringArray, String string) {
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = string2 == null ? stringArray[i] : string2 + string + stringArray[i];
        }
        return string2;
    }

    private String getEntityTypeXPath(String string) {
        Object[] objectArray = new Object[]{string};
        String string2 = new MessageFormat(this.entityTypeXPath).format(objectArray);
        return string2;
    }

    private void migrateLDAPRepository(ProfileRepository profileRepository, List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "migrateLDAPRepository", WIMTraceHelper.printObjectArray(new Object[]{profileRepository, list}));
        }
        this.ldapConfig = new PluginConfigManagerImpl();
        this.ldapConfig.initialize(profileRepository, list);
        String string = profileRepository.getRepositoryUUID();
        DataGraph dataGraph = null;
        String string2 = this.getLdapType(profileRepository, this.ldapConfig);
        if (string2.startsWith("IDS")) {
            dataGraph = this.loadConfigFromXML(IDS_TEMP_FILE);
        } else if (string2.startsWith("DM")) {
            dataGraph = this.loadConfigFromXML(DM_TEMP_FILE);
        } else if (string2.startsWith("AD")) {
            dataGraph = this.loadConfigFromXML(AD_TEMP_FILE);
        } else if (string2.equals("SUNONE")) {
            dataGraph = this.loadConfigFromXML(SUNONE_TEMP_FILE);
        } else if (string2.equals("NDS")) {
            dataGraph = this.loadConfigFromXML(NDS_TEMP_FILE);
        }
        DataObject dataObject = dataGraph.getRootObject().getDataObject("configurationProvider");
        DataObject dataObject2 = (DataObject)dataObject.getList("repositories").get(0);
        dataObject2.setString("ldapServerType", string2);
        dataObject2.setString("id", string);
        List list2 = profileRepository.getCreateMemberType();
        if (list2 == null || list2.size() == 0) {
            dataObject2.setBoolean("readOnly", true);
        }
        this.migrateNodesToBaseEntries(dataObject2, profileRepository);
        this.migrateRepositoriesForGroups(dataObject2, profileRepository);
        this.migrateLDAPServerConfiguration(dataObject2, profileRepository);
        this.migrateLDAPEntityTypes(dataObject2, profileRepository);
        this.migrateGroupConfiguration(dataObject2, profileRepository, this.ldapConfig);
        this.migrateAttributeConfiguration(dataObject2, profileRepository, this.ldapConfig);
        this.migrateContextPool(dataObject2, profileRepository);
        this.migrateCacheConfiguration(dataObject2, profileRepository);
        this.vmmPropNames = this.loadVMMPropertyNames();
        this.vmmCfgProviderDO.getList("repositories").add(dataObject2);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "migrateLDAPRepository");
        }
    }

    private void migrateContextPool(DataObject dataObject, ProfileRepository profileRepository) {
        DataObject dataObject2 = dataObject.getDataObject("contextPool");
        if (dataObject2 == null) {
            dataObject2 = dataObject.createDataObject("contextPool");
        }
        Map map = profileRepository.getProperties();
        boolean bl = false;
        Integer n = (Integer)map.get("dirContextsMaxSize");
        Integer n2 = (Integer)map.get("dirContextTimeToLive");
        Integer n3 = (Integer)map.get("dirContextsMinSize");
        Integer n4 = (Integer)map.get("dirContextTimeout");
        if (n == null || n < 1) {
            dataObject2.delete();
        } else {
            int n5;
            if (n2 != null && n2 == 0) {
                dataObject2.setBoolean("enabled", false);
            } else {
                dataObject2.setBoolean("enabled", true);
            }
            int n6 = n;
            dataObject2.setInt("maxPoolSize", n6);
            dataObject2.setInt("prefPoolSize", n6);
            if (n2 != null) {
                n5 = n2;
                if (n5 == -1) {
                    n5 = 0;
                }
                dataObject2.setInt("poolTimeOut", n5);
            }
            if (n3 != null) {
                n5 = n3;
                if (n5 < 1) {
                    n5 = 1;
                }
                dataObject2.setInt("initPoolSize", n5);
            }
            if (n4 != null) {
                n5 = n4;
                dataObject2.setInt("poolWaitTime", n5);
            }
        }
    }

    private void migrateCacheConfiguration(DataObject dataObject, ProfileRepository profileRepository) {
        Integer n;
        Integer n2;
        DataObject dataObject2;
        int n3;
        Integer n4;
        Integer n5;
        DataObject dataObject3;
        DataObject dataObject4 = dataObject.getDataObject("cacheConfiguration");
        Map map = profileRepository.getProperties();
        String string = (String)map.get("cacheAttributes");
        Boolean bl = null;
        if (string != null) {
            bl = new Boolean(string);
        }
        string = (String)map.get("cacheNames");
        Boolean bl2 = null;
        if (string != null) {
            bl2 = new Boolean(string);
        }
        string = (String)map.get("cacheGroups");
        Boolean bl3 = null;
        if (string != null) {
            bl3 = new Boolean(string);
        }
        boolean bl4 = true;
        if (!(bl == null || bl.booleanValue() || bl3 != null && bl3.booleanValue())) {
            bl4 = false;
        }
        if ((dataObject3 = dataObject4.getDataObject("attributesCache")) == null) {
            dataObject3 = dataObject4.createDataObject("attributesCache");
        }
        dataObject3.setBoolean("enabled", bl4);
        Integer n6 = (Integer)map.get("attributesCacheTimeOut");
        if (n6 != null) {
            int n7 = n6;
            if (n7 == 0) {
                dataObject3.setBoolean("enabled", false);
            } else {
                if (n7 == -1) {
                    n7 = 0;
                }
                dataObject3.setInt("cacheTimeOut", n7);
            }
        }
        if ((n5 = (Integer)map.get("attributesCacheSize")) != null) {
            int n8 = n5;
            if (n8 < 1) {
                dataObject3.setBoolean("enabled", false);
            } else {
                if (n8 < 100) {
                    n8 = 100;
                }
                dataObject3.setInt("cacheSize", n8);
            }
        }
        if ((n4 = (Integer)map.get("attribtueSizeCacheLimit")) != null) {
            n3 = n4;
            if (!n3) {
                dataObject3.setBoolean("enabled", false);
            } else {
                if (n3 < 1) {
                    n3 = 0;
                }
                dataObject3.setInt("attributeSizeLimit", n3);
            }
        }
        n3 = 1;
        if (!(bl2 == null || bl2.booleanValue() || bl3 != null && bl3.booleanValue())) {
            n3 = 0;
        }
        if ((dataObject2 = dataObject4.getDataObject("searchResultsCache")) == null) {
            dataObject2 = dataObject4.createDataObject("searchResultsCache");
        }
        dataObject2.setBoolean("enabled", n3 != 0);
        Integer n9 = (Integer)map.get("namesCacheTimeOut");
        if (n9 != null) {
            int n10 = n9;
            if (n10 == 0) {
                dataObject2.setBoolean("enabled", false);
            } else {
                if (n10 == -1) {
                    n10 = 0;
                }
                dataObject2.setInt("cacheTimeOut", n10);
            }
        }
        if ((n2 = (Integer)map.get("namesCacheSize")) != null) {
            int n11 = n2;
            if (n11 < 1) {
                dataObject2.setBoolean("enabled", false);
            } else {
                if (n11 < 100) {
                    n11 = 100;
                }
                dataObject2.setInt("cacheSize", n11);
            }
        }
        if ((n = (Integer)map.get("searchResultCacheLimit")) != null) {
            int n12 = n;
            if (n12 == 0) {
                dataObject2.setBoolean("enabled", false);
            } else {
                if (n12 < 1) {
                    n12 = 0;
                }
                dataObject2.setInt("searchResultSizeLimit", n12);
            }
        }
    }

    private String getLdapType(ProfileRepository profileRepository, PluginConfigManager pluginConfigManager) {
        String string = "IDS5";
        String string2 = profileRepository.getAdapterClassName();
        String string3 = "DistinguishedName";
        List list = pluginConfigManager.getExtIdNames();
        if (list.size() > 0) {
            string3 = (String)list.get(0);
        }
        if (string2.endsWith("com.ibm.ws.wmm.ldap.ibmdir.IBMDirectory5AdapterImpl")) {
            string = "IDS5";
        } else if (string2.endsWith("com.ibm.ws.wmm.ldap.ibmdir.IBMDirectoryAdapterImpl")) {
            string = string3.equalsIgnoreCase("ibm-entryUUID") ? "IDS5" : "IDS4";
        } else if (string2.endsWith("com.ibm.ws.wmm.ldap.activedir.ActiveDirectoryAdapterImpl")) {
            string = "AD2000";
        } else if (string2.endsWith("com.ibm.ws.wmm.ldap.activedir.ActiveDirectory2003AdapterImpl")) {
            string = "AD2003";
        } else if (string2.endsWith("com.ibm.ws.wmm.ldap.domino.DominoLdapAdapterImpl")) {
            string = "DM5";
        } else if (string2.endsWith("com.ibm.ws.wmm.ldap.domino.Domino6LdapAdapterImpl")) {
            string = "DM6";
        } else if (string2.endsWith("com.ibm.ws.wmm.ldap.sunone.SunOneDirectoryAdapterImpl")) {
            string = "SUNONE";
        } else if (string2.endsWith("com.ibm.ws.wmm.ldap.novell.NovelleDirectoryAdapterImpl")) {
            string = "NDS";
        }
        return string;
    }

    private void migrateGroupConfiguration(DataObject dataObject, ProfileRepository profileRepository, PluginConfigManager pluginConfigManager) {
        DataObject dataObject2;
        String string;
        String string2;
        Object object;
        Object object2;
        Object object3;
        DataObject dataObject3 = dataObject.getDataObject("groupConfiguration");
        List list = dataObject3.getList("memberAttributes");
        list.clear();
        String string3 = (String)profileRepository.getProperty("groupMemberAttributeMap");
        if (string3 != null && string3.trim().length() > 0) {
            object3 = new StringTokenizer(string3, ";");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken().trim();
                object = new StringTokenizer((String)object2, ":");
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                string2 = ((StringTokenizer)object).nextToken().trim();
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                string = ((StringTokenizer)object).nextToken().trim();
                dataObject2 = dataObject3.createDataObject("memberAttributes");
                dataObject2.setString("name", string);
                dataObject2.setString("objectClass", string2);
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                String string4 = ((StringTokenizer)object).nextToken();
                dataObject2.setString("scope", string4);
            }
        } else {
            object3 = pluginConfigManager.getPluginAttribute("groupMember");
            if (object3 != null && (object2 = ((PluginAttribute)object3).getPluginAttributeName()) != null && ((String)object2).length() > 0) {
                object = dataObject3.createDataObject("memberAttributes");
                object.setString("name", (String)object2);
                string2 = ((PluginAttribute)object3).getDefaultValue();
                if (string2 != null) {
                    object.setString("dummyMember", string2);
                }
            }
        }
        list = dataObject3.getList("dynamicMemberAttributes");
        list.clear();
        string3 = (String)profileRepository.getProperty("groupDynamicMemberAttributeMap");
        if (string3 != null && string3.trim().length() > 0) {
            object3 = new StringTokenizer(string3, ";");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken().trim();
                object = new StringTokenizer((String)object2, ":");
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                string2 = ((StringTokenizer)object).nextToken().trim();
                if (!((StringTokenizer)object).hasMoreTokens()) continue;
                string = ((StringTokenizer)object).nextToken().trim();
                dataObject2 = dataObject3.createDataObject("dynamicMemberAttributes");
                dataObject2.setString("name", string);
                dataObject2.setString("objectClass", string2);
            }
        } else {
            object3 = pluginConfigManager.getPluginAttributeName("groupMemberURL");
            if (object3 != null && ((String)object3).length() > 0) {
                object2 = dataObject3.createDataObject("dynamicMemberAttributes");
                object2.setString("name", (String)object3);
            }
        }
        if ((string3 = (String)profileRepository.getProperty("groupMembershipAttributeMap")) == null || string3.trim().length() == 0) {
            string3 = (String)profileRepository.getProperty("memberOfAttributeName");
        }
        if (string3 != null && string3.trim().length() > 0) {
            object3 = dataObject3.createDataObject("membershipAttribute");
            object2 = new StringTokenizer(string3, ":");
            if (((StringTokenizer)object2).hasMoreTokens()) {
                object3.setString("name", ((StringTokenizer)object2).nextToken().trim());
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    object3.setString("scope", ((StringTokenizer)object2).nextToken().trim());
                }
            }
        }
    }

    private void migrateAttributeConfiguration(DataObject dataObject, ProfileRepository profileRepository, PluginConfigManager pluginConfigManager) throws WIMException {
        DataObject dataObject2 = dataObject.getDataObject("attributeConfiguration");
        this.migrateExtIdAttribute(dataObject2, profileRepository, pluginConfigManager);
        this.migrateAttributes(dataObject2, profileRepository, pluginConfigManager);
        this.migratePropertiesNotSupported(dataObject2, profileRepository, pluginConfigManager);
    }

    private void migrateExtIdAttribute(DataObject dataObject, ProfileRepository profileRepository, PluginConfigManager pluginConfigManager) {
        List list = pluginConfigManager.getExtIdAttributes();
        if (list.size() == 1) {
            PluginAttribute pluginAttribute = (PluginAttribute)list.get(0);
            DataObject dataObject2 = dataObject.createDataObject("externalIdAttributes");
            dataObject2.setString("name", pluginAttribute.getPluginAttributeName());
            if (pluginAttribute.getPluginDataType() != null) {
                dataObject2.setString("syntax", pluginAttribute.getPluginDataType());
            }
            if (pluginAttribute.isWMMGenerate() || profileRepository.isGenerateExtId()) {
                dataObject2.setBoolean("wimGenerate", true);
            }
        } else if (list.size() > 1) {
            for (int i = 0; i < list.size(); ++i) {
                PluginAttribute pluginAttribute = (PluginAttribute)list.get(i);
                DataObject dataObject3 = dataObject.createDataObject("externalIdAttributes");
                dataObject3.setString("name", pluginAttribute.getPluginAttributeName());
                if (pluginAttribute.getPluginDataType() != null) {
                    dataObject3.setString("syntax", pluginAttribute.getPluginDataType());
                }
                if (pluginAttribute.isWMMGenerate()) {
                    dataObject3.setBoolean("wimGenerate", true);
                }
                this.addEntityTypes(pluginAttribute.getApplicableMemberTypes(), dataObject3);
            }
        }
    }

    private boolean isEntityTypesSame(short[] sArray, DataObject dataObject) {
        List list = dataObject.getList("entityTypes");
        if (sArray.length != list.size()) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == 0) {
                if (list.contains("PersonAccount")) continue;
                return false;
            }
            if (sArray[i] == 1) {
                if (list.contains("Group")) continue;
                return false;
            }
            if (sArray[i] == 2 || sArray[i] == 3) {
                if (list.contains("OrgContainer")) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private void addEntityTypes(short[] sArray, DataObject dataObject) {
        if (sArray.length > 0 && sArray.length < 4) {
            List list = dataObject.getList("entityTypes");
            for (int i = 0; i < sArray.length; ++i) {
                if (sArray[i] == 0) {
                    if (list.contains("PersonAccount")) continue;
                    list.add("PersonAccount");
                    continue;
                }
                if (sArray[i] == 1) {
                    if (list.contains("Group")) continue;
                    list.add("Group");
                    continue;
                }
                if (sArray[i] != 2 && sArray[i] != 3 || list.contains("OrgContainer")) continue;
                list.add("OrgContainer");
            }
        }
    }

    private void migrateAttributes(DataObject dataObject, ProfileRepository profileRepository, PluginConfigManager pluginConfigManager) {
        Set set = pluginConfigManager.getAllWmmAttributeNames();
        for (String string : set) {
            if (string.equalsIgnoreCase("extId") || string.equalsIgnoreCase("groupMember") || string.equalsIgnoreCase("groupMemberURL") || string.equalsIgnoreCase("userPassword")) continue;
            String string2 = pluginConfigManager.getPluginAttributeName(string);
            PluginAttribute pluginAttribute = pluginConfigManager.getPluginAttribute(string);
            String string3 = pluginAttribute.getDefaultValue();
            String string4 = pluginAttribute.getDefaultAttribute();
            DataObject dataObject2 = null;
            if (string.equalsIgnoreCase(string2) && string3 == null && string4 == null) continue;
            List list = dataObject.getList("attributes");
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    DataObject dataObject3 = (DataObject)list.get(i);
                    String string5 = dataObject3.getString("name");
                    if (string5 == null || !string5.equals(string2) || !this.isEntityTypesSame(pluginAttribute.getApplicableMemberTypes(), dataObject3)) continue;
                    dataObject3.delete();
                    --i;
                }
            }
            dataObject2 = dataObject.createDataObject("attributes");
            dataObject2.setString("name", string2);
            if (!string.equalsIgnoreCase(string2)) {
                dataObject2.setString("propertyName", string);
            }
            if (string3 != null) {
                if (string2.equalsIgnoreCase("userAccountControl") && string3.equals("66048")) {
                    string3 = "544";
                }
                dataObject2.setString("defaultValue", string3);
            }
            if (string4 != null) {
                dataObject2.setString("defaultAttribute", string4);
            }
            this.addEntityTypes(pluginAttribute.getApplicableMemberTypes(), dataObject2);
        }
    }

    private void migratePropertiesNotSupported(DataObject dataObject, ProfileRepository profileRepository, PluginConfigManager pluginConfigManager) throws WIMException {
        Set set = this.getWMMAttributesNotInLDAP();
        if (set != null) {
            for (String string : set) {
                if (string.indexOf(":") > -1) {
                    throw new MigrationException("MIGRATION_ERROR", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "migratePropertiesNotSupported");
                }
                DataObject dataObject2 = dataObject.getDataObject("propertiesNotSupported[name=" + string + "]");
                if (dataObject2 != null) continue;
                DataObject dataObject3 = dataObject.createDataObject("propertiesNotSupported");
                dataObject3.setString("name", string);
            }
        }
    }

    private void migrateLDAPEntityTypes(DataObject dataObject, ProfileRepository profileRepository) {
        List list = profileRepository.getSupportedProfileEntryType();
        String[][] stringArrayArray = new String[list.size()][];
        for (ProfileEntryType profileEntryType : list) {
            Object object;
            Object object2;
            List list2;
            Object object3;
            Object object4;
            short s = profileEntryType.getName();
            if (s == 4 && trcLogger.isLoggable(Level.FINE)) {
                trcLogger.logp(Level.FINE, CLASSNAME, "migrateLDAPEntityTypes", "memberType " + s + " is not supported.");
            }
            DataObject dataObject2 = null;
            if (s == 0) {
                dataObject2 = dataObject.getDataObject("ldapEntityTypes[name=\"PersonAccount\"]");
            } else if (s == 1) {
                dataObject2 = dataObject.getDataObject("ldapEntityTypes[name=\"Group\"]");
            } else if (s == 2 || s == 3) {
                dataObject2 = dataObject.getDataObject("ldapEntityTypes[name=\"OrgContainer\"]");
            }
            String[] stringArray = profileEntryType.getRDNAttrTypes();
            String string = null;
            if (stringArray.length == 1) {
                string = stringArray[0];
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    string = string + stringArray[i];
                    if (i >= stringArray.length - 1) continue;
                    string = string + "+";
                }
            }
            List list3 = profileEntryType.getObjectClasses();
            List list4 = profileEntryType.getAuxiliaryObjectClasses();
            if (list4 != null) {
                for (int i = 0; i < list4.size(); ++i) {
                    object4 = (String)list4.get(i);
                    if (list3.contains(object4)) continue;
                    list3.add(object4);
                }
            }
            String string2 = profileEntryType.getDefiningObjectClass();
            object4 = new ArrayList();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (stringTokenizer.hasMoreTokens()) {
                object3 = stringTokenizer.nextToken();
                if (object3 == null || ((String)(object3 = ((String)object3).trim())).length() <= 0) continue;
                object4.add(object3);
            }
            object3 = dataObject2.getList("rdnAttributes");
            if (s != 2 && s != 3) {
                object3.clear();
                list2 = dataObject2.createDataObject("rdnAttributes");
                list2.setString("name", string);
                object2 = dataObject2.getList("objectClasses");
                object2.clear();
                object2.addAll(object4);
                object = dataObject2.getList("objectClassesForCreate");
                object.clear();
                object.addAll(list3);
            }
            list2 = dataObject2.getList("searchBases");
            list2.clear();
            object2 = profileEntryType.getSearchBases();
            if (object2 != null && ((String[])object2).length > 0) {
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    list2.add(object2[i]);
                }
            }
            if ((object = profileEntryType.getSearchFilter()) == null || ((String)object).length() <= 0) continue;
            dataObject2.setString("searchFilter", (String)object);
        }
    }

    private void migrateLDAPServerConfiguration(DataObject dataObject, ProfileRepository profileRepository) throws WIMException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        DataObject dataObject2 = dataObject.getDataObject("ldapServerConfiguration");
        Map map = profileRepository.getProperties();
        WSEncoderDecoder wSEncoderDecoder = new WSEncoderDecoder();
        String string10 = map.get("ldapTimeOut").toString();
        if (string10 != null && string10.trim().length() > 0) {
            int n = Integer.parseInt(string10);
            dataObject2.setInt("searchTimeLimit", n);
        }
        if ((string9 = (String)map.get("sslLocalScope")) == null || !string9.equalsIgnoreCase("true")) {
            string8 = (String)map.remove("sslTrustStore");
            if (string8 != null && string8.trim().length() > 0) {
                dataObject2.setString("sslTrustStore", string8);
                string7 = (String)map.remove("sslTrustStorePassword");
                if (string7 != null) {
                    block25: {
                        try {
                            string7 = PasswordEncryptionUtil.decrypt(string7.trim(), null).trim();
                        }
                        catch (NullPointerException nullPointerException) {
                            if (!trcLogger.isLoggable(Level.FINE)) break block25;
                            trcLogger.logp(Level.FINE, CLASSNAME, "migrateLDAPServerConfiguration", "sslTrustStorePwd is not encrypted.");
                        }
                    }
                    string7 = wSEncoderDecoder.encode(string7);
                    dataObject2.setString("sslTrustStorePassword", string7);
                }
            }
            if ((string7 = (String)map.remove("sslKeyStore")) != null && string7.trim().length() > 0) {
                dataObject2.setString("sslKeyStore", string7);
                string6 = (String)map.remove("sslKeyStorePassword");
                if (string6 != null) {
                    block26: {
                        try {
                            string6 = PasswordEncryptionUtil.decrypt(string6.trim(), null).trim();
                        }
                        catch (NullPointerException nullPointerException) {
                            if (!trcLogger.isLoggable(Level.FINE)) break block26;
                            trcLogger.logp(Level.FINE, CLASSNAME, "migrateLDAPServerConfiguration", "sslKeyStorePwd is not encrypted.");
                        }
                    }
                    string6 = wSEncoderDecoder.encode(string6);
                    dataObject2.setString("sslKeyStorePassword", string6);
                }
            }
        } else if (trcLogger.isLoggable(Level.FINE)) {
            trcLogger.logp(Level.FINE, CLASSNAME, "migrateLDAPServerConfiguration", "sslLocalScope is true, need to configure sslAlias in WAS and use the sslAlias in wimconfig.xml.");
        }
        string8 = (DataObject)dataObject2.getList("ldapServers").get(0);
        string7 = (String)map.remove("adminId");
        string6 = (String)map.remove("adminPassword");
        string6 = wSEncoderDecoder.encode(string6);
        string8.setString("bindDN", string7);
        string8.setString("bindPassword", string6);
        String string11 = (String)map.remove("java.naming.provider.url");
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (string11 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string11, " ");
            while (stringTokenizer.hasMoreTokens()) {
                string5 = stringTokenizer.nextToken();
                string4 = string5.substring(string5.lastIndexOf(":") + 1);
                string3 = string5.substring(string5.indexOf("//") + 2, string5.lastIndexOf(":"));
                arrayList.add(string3);
                arrayList2.add(string4);
            }
        } else {
            arrayList.add((String)map.remove("ldapHost"));
            arrayList2.add(map.remove("ldapPort").toString());
        }
        string8.getList("connections").clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            string5 = string8.createDataObject("connections");
            string5.set("host", arrayList.get(i));
            string5.setInt("port", new Integer((String)arrayList2.get(i)).intValue());
        }
        String string12 = (String)map.remove("sslEnabled");
        if ("true".equalsIgnoreCase(string12)) {
            string8.setBoolean("sslEnabled", true);
        } else if ("ssl".equalsIgnoreCase((String)map.remove("java.naming.security.protocol"))) {
            string8.setBoolean("sslEnabled", true);
        }
        string5 = (String)map.remove("ldapAuthen");
        if (string5 != null && !"simple".equalsIgnoreCase(string5)) {
            string8.setString("authentication", string5);
        }
        if ((string4 = (String)map.remove("java.naming.referral")) != null && string4.trim().length() > 0) {
            string8.setString("referal", string4);
        }
        if ((string3 = (String)map.remove("java.naming.ldap.derefAliases")) != null && string3.trim().length() > 0) {
            string8.setString("derefAliases", string3);
        }
        if ("true".equalsIgnoreCase(string2 = (String)map.remove("com.sun.jndi.ldap.connect.pool"))) {
            string8.setBoolean("connectionPool", true);
        }
        if ((string = (String)map.remove("com.sun.jndi.ldap.connect.timeout")) != null && string.trim().length() > 0) {
            int n = Integer.parseInt(string);
            string8.setInt("connectTimeout", n / 1000);
        }
        for (String string13 : map.keySet()) {
            if (!string13.startsWith("java.naming")) continue;
            DataObject dataObject3 = string8.createDataObject("environmentProperties");
            dataObject3.setString("name", string13);
            dataObject3.setString("value", (String)map.get(string13));
        }
    }

    private void migrateLaOrFedRepository(MemberRepository memberRepository, boolean bl) {
        String string = (String)memberRepository.getProperty("dataAccessManagerClassName");
        String string2 = this.getDbTypeFromClassName(string);
        String string3 = memberRepository.getRepositoryUUID();
        DataObject dataObject = null;
        dataObject = bl ? this.vmmCfgProviderDO.getDataObject("propertyExtensionRepository") : this.vmmCfgProviderDO.getDataObject("entryMappingRepository");
        dataObject.setString("databaseType", string2);
        dataObject.setString("id", string3);
    }

    private void initializeAttrDefCaches(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initializeAttrDefCaches(String wmmAttrsXMLFile)", WIMTraceHelper.printObjectArray(new Object[]{string}));
        }
        if (string == null || string.trim().length() == 0) {
            throw new MigrationException("FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "initializeAttrDefCaches(String wmmAttrsXMLFile)");
        }
        this.attrDefMap = new HashMap();
        this.supportedDataTypes = StringSet.Factory.getInstance();
        try {
            DocumentBuilderFactory documentBuilderFactory = ParserFactory.newDocumentBuilderFactory();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("attribute");
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Object object;
                int n2;
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute("wmmAttributeName");
                if (string2 == null) continue;
                AttributeDefinition attributeDefinition = AttributeDefinition.Factory.getInstance(string2, null);
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                short[] sArray = null;
                NamedNodeMap namedNodeMap = element2.getAttributes();
                int n3 = namedNodeMap.getLength();
                for (n2 = 0; n2 < n3; ++n2) {
                    object = namedNodeMap.item(n2);
                    String string3 = object.getNodeName();
                    String string4 = object.getNodeValue();
                    if ("wmmAttributeName".equalsIgnoreCase(string3)) continue;
                    if ("applicableMemberTypes".equalsIgnoreCase(string3)) {
                        sArray = MemberTypeHelper.getMemberTypes(string4);
                        hashMap.put("applicableMemberTypes", sArray);
                        continue;
                    }
                    if ("requiredMemberTypes".equalsIgnoreCase(string3)) {
                        hashMap.put("requiredForMemberTypes", MemberTypeHelper.getMemberTypes(string4));
                        continue;
                    }
                    if ("dataType".equalsIgnoreCase(string3)) {
                        String string5 = DataTypeHelper.getDataTypeName(DataTypeHelper.getDataType(string4));
                        hashMap.put("datatype", string5);
                        continue;
                    }
                    if ("valueLength".equalsIgnoreCase(string3)) {
                        hashMap.put("valueLength", string4);
                        continue;
                    }
                    if ("multiValued".equalsIgnoreCase(string3)) {
                        hashMap.put("multiValued", DataTypeHelper.getBooleanValue(string4));
                        continue;
                    }
                    if ("readOnly".equalsIgnoreCase(string3)) {
                        hashMap.put("readOnly", DataTypeHelper.getBooleanValue(string4));
                        continue;
                    }
                    if ("caseExactlyMactch".equalsIgnoreCase(string3)) {
                        hashMap.put("caseExactMatch", DataTypeHelper.getBooleanValue(string4));
                        continue;
                    }
                    if ("description".equalsIgnoreCase(string3)) {
                        hashMap.put("description", string4);
                        continue;
                    }
                    if (!"classname".equalsIgnoreCase(string3)) continue;
                    hashMap.put("className", string4);
                }
                attributeDefinition.setMetaData(hashMap);
                this.attrDefMap.put(string2, attributeDefinition);
                for (n2 = 0; n2 < sArray.length; ++n2) {
                    n3 = sArray[n2];
                    object = this.memberTypeAttrDef[n3];
                    if (object == null) {
                        object = AttributeDefinitionSet.Factory.getInstance();
                    }
                    object.add(attributeDefinition);
                    this.memberTypeAttrDef[n3] = object;
                }
            }
        }
        catch (IOException iOException) {
            throw new MigrationException("MIGRATION_WMM_FILE_INVALID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "initializeAttrDefCaches(String wmmAttrsXMLFile)", (Throwable)iOException);
        }
        catch (SAXException sAXException) {
            throw new MigrationException("MIGRATION_WMM_FILE_INVALID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "initializeAttrDefCaches(String wmmAttrsXMLFile)", (Throwable)sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new MigrationException("MIGRATION_WMM_FILE_INVALID", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "initializeAttrDefCaches(String wmmAttrsXMLFile)", (Throwable)parserConfigurationException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initializeAttrDefCaches(String wmmAttrsXMLFile)");
        }
    }

    private void initializeSupportMemberTypes() throws WIMException {
        List list = this.wmmConfig.getSupportedMemberTypes();
        boolean bl = true;
        if (list == null || list.isEmpty()) {
            throw new MigrationException("MIGRATION_WMM_FILE_INVALID", WIMMessageHelper.generateMsgParms("wmm.xml"), CLASSNAME, "initializeSupportMemberTypes");
        }
        short[] sArray = new short[list.size()];
        String[] stringArray = new String[list.size()];
        String[][] stringArray2 = new String[list.size()][];
        for (MemberType memberType : list) {
            Short s = memberType.getName();
            int n = s.shortValue();
            stringArray2[n] = memberType.getRDNAttrTypes();
            if (bl) {
                for (int i = 0; i < n; ++i) {
                    if (stringArray2[i] == null) continue;
                    if (stringArray2[n].length == stringArray2[i].length) {
                        for (int j = 0; j < stringArray2[n].length; ++j) {
                            if (!stringArray2[n][j].equalsIgnoreCase(stringArray2[i][j])) continue;
                            bl = false;
                            break;
                        }
                    }
                    if (!bl) break;
                }
            }
            sArray[n] = n;
            stringArray[n] = memberType.getStringName();
        }
        MemberTypeHelper.setMemberTypes(sArray);
        MemberTypeHelper.setMemberTypeNames(stringArray);
        MemberTypeHelper.setMemberRDNAttrTypes(stringArray2);
    }

    private Properties loadVMMPropertyNames() throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "loadVMMPropertyNames");
        }
        String string = this.wasHomePath + "etc/wim/migration" + this.schar + vmmPropFileName;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MigrationException("WIM_CONFIG_XML_FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "loadVMMPropertyNames", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new MigrationException("INVALID_WIM_CONFIG_XML_FILE", WIMMessageHelper.generateMsgParms(string, iOException.getMessage()), CLASSNAME, "loadVMMPropertyNames", (Throwable)iOException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "loadVMMPropertyNames");
        }
        return properties;
    }

    private DataGraph loadExtXML() throws WIMException {
        String string = this.wasHomePath + "etc/wim/migration" + this.schar + this.vmmMigrationExtXMLFile;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            HashMap hashMap = new HashMap();
            EDataGraph eDataGraph = SDOUtil.loadDataGraph((InputStream)fileInputStream, hashMap);
            return eDataGraph;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MigrationException("FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "loadExtXML", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new MigrationException("MIGRATION_ERROR", WIMMessageHelper.generateMsgParms(iOException.getMessage()), CLASSNAME, "loadExtXML", (Throwable)iOException);
        }
    }

    private void checkWMMAttribute(int n) {
        block6: {
            block5: {
                Object object;
                Object object2;
                Object object3;
                if (n != 1 && (n != 2 || !this.wmmConfig.isLookAside()) || this.ldapConfig == null) break block5;
                Set set = this.getWMMAttributesNotInLDAP();
                if (set != null) {
                    object3 = set.iterator();
                    while (object3.hasNext()) {
                        object2 = (String)object3.next();
                        if (this.vmmPropNames.containsKey(object2)) continue;
                        object = (AttributeDefinition)this.attrDefMap.get(object2);
                        this.processWMMAttribute((AttributeDefinition)object, (String)object2);
                    }
                }
                if ((object3 = this.ldapConfig.getAllWmmAttributeNames()) == null) break block6;
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    if (((String)object).equalsIgnoreCase("extId") || ((String)object).equalsIgnoreCase("groupMember") || ((String)object).equalsIgnoreCase("groupMemberURL") || ((String)object).equalsIgnoreCase("userPassword") || this.vmmPropNames.containsKey(object)) continue;
                    PluginAttribute pluginAttribute = this.ldapConfig.getPluginAttribute((String)object);
                    this.processLdapAttribute(pluginAttribute, (String)object);
                }
                break block6;
            }
            if (this.attrDefMap != null && this.vmmPropNames != null) {
                for (String string : this.attrDefMap.keySet()) {
                    if (this.vmmPropNames.containsKey(string) || string.equalsIgnoreCase("userPassword")) continue;
                    AttributeDefinition attributeDefinition = (AttributeDefinition)this.attrDefMap.get(string);
                    this.processWMMAttribute(attributeDefinition, string);
                }
            }
        }
    }

    private void processLdapAttribute(PluginAttribute pluginAttribute, String string) {
        if (pluginAttribute == null || pluginAttribute == null) {
            return;
        }
        short[] sArray = pluginAttribute.getApplicableMemberTypes();
        short[] sArray2 = pluginAttribute.getRequiredMemberTypes();
        String string2 = DataTypeHelper.getDataTypeName(pluginAttribute.getDataType());
        boolean bl = pluginAttribute.isMultiValued();
        this.addAttributeToVmmSchema(string, sArray, sArray2, string2, bl);
    }

    private void processWMMAttribute(AttributeDefinition attributeDefinition, String string) {
        if (attributeDefinition == null || string == null) {
            return;
        }
        Map map = attributeDefinition.getMetaData();
        short[] sArray = (short[])map.get("applicableMemberTypes");
        short[] sArray2 = (short[])map.get("requiredMemberTypes");
        String string2 = (String)map.get("datatype");
        String string3 = (String)map.get("multiValued");
        boolean bl = DataTypeHelper.getBoolean(string3);
        this.addAttributeToVmmSchema(string, sArray, sArray2, string2, bl);
    }

    private Set getWMMAttributesNotInLDAP() {
        HashSet<String> hashSet = null;
        if (this.ldapConfig != null && this.attrDefMap != null) {
            hashSet = new HashSet<String>();
            Set set = this.ldapConfig.getAllWmmAttributeNames();
            Set set2 = this.attrDefMap.keySet();
            for (String string : set2) {
                if (set.contains(string)) continue;
                hashSet.add(string);
            }
        }
        return hashSet;
    }

    private void addAttributeToVmmSchema(String string, short[] sArray, short[] sArray2, String string2, boolean bl) {
        DataObject dataObject = this.vmmExtDG.getRootObject().getDataObject("schema");
        if (!this.vmmPropNames.containsKey(string) && !attrsInWMMOnly.contains(string)) {
            Iterator iterator;
            List list;
            DataObject dataObject2 = dataObject.createDataObject("propertySchema");
            dataObject2.setString("nsURI", "http://www.ibm.com/websphere/wim");
            dataObject2.setString("propertyName", string);
            dataObject2.setBoolean("multiValued", bl);
            Set set = this.getVmmEntityTypesFromWMMMbrTypes(sArray);
            if (set != null) {
                list = dataObject2.getList("applicableEntityTypeNames");
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
            if ((set = this.getVmmEntityTypesFromWMMMbrTypes(sArray2)) != null) {
                list = dataObject2.getList("requiredEntityTypeNames");
                iterator = set.iterator();
                while (iterator.hasNext()) {
                    list.add(iterator.next());
                }
            }
            if ("OBJECT".equalsIgnoreCase(string2)) {
                dataObject2.setString("dataType", "Base64Binary");
            } else if ("STRING".equalsIgnoreCase(string2)) {
                dataObject2.setString("dataType", "String");
            } else if ("LONG".equalsIgnoreCase(string2)) {
                dataObject2.setString("dataType", "Long");
            } else if ("INTEGER".equalsIgnoreCase(string2)) {
                dataObject2.setString("dataType", "Int");
            } else if ("DOUBLE".equalsIgnoreCase(string2)) {
                dataObject2.setString("dataType", "Double");
            } else if ("TIMESTAMP".equalsIgnoreCase(string2)) {
                dataObject2.setString("dataType", "DateTime");
            } else if ("MEMBERIDENTIFIER".equalsIgnoreCase(string2)) {
                dataObject2.setString("dataType", "IdentifierType");
            } else if ("BYTEARRAY".equalsIgnoreCase(string2)) {
                dataObject2.setString("dataType", "Base64Binary");
            } else {
                dataObject2.setString("dataType", "Base64Binary");
            }
        }
    }

    private Set getVmmEntityTypesFromWMMMbrTypes(short[] sArray) {
        HashSet<String> hashSet = null;
        if (sArray != null) {
            hashSet = new HashSet<String>();
            for (int i = 0; i < sArray.length; ++i) {
                short s = sArray[i];
                if (1 == s) {
                    hashSet.add("Group");
                    continue;
                }
                if (0 == s) {
                    hashSet.add("PersonAccount");
                    continue;
                }
                if (2 == s) {
                    hashSet.add("OrgContainer");
                    continue;
                }
                if (3 != s) continue;
                hashSet.add("OrgContainer");
            }
        }
        return hashSet;
    }

    private EPackage loadConfigSchemaFromPackage(String string) throws WIMException {
        try {
            Class<?> clazz = Class.forName(string);
            EPackage ePackage = (EPackage)clazz.getField("eINSTANCE").get(clazz);
            String string2 = ePackage.getNsURI();
            EPackage.Registry.INSTANCE.put((Object)string2, (Object)ePackage);
            return ePackage;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MigrationException("CLASS_OR_INTERFACE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new MigrationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MigrationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)illegalAccessException);
        }
    }

    static {
        attrsInWMMOnly.add("ibm-otherEmail");
        attrsInWMMOnly.add("ibm-personalTitle");
        attrsInWMMOnly.add("ibm-middleName");
        attrsInWMMOnly.add("ibm-regionalLocale");
        attrsInWMMOnly.add("ibm-generationQualifier");
        attrsInWMMOnly.add("ibm-timeZone");
        attrsInWMMOnly.add("ibm-preferredCalendar");
        attrsInWMMOnly.add("ibm-alternativeCalendar");
        attrsInWMMOnly.add("ibm-firstDayOfWeek");
        attrsInWMMOnly.add("ibm-firstWorkDayOfWeek");
        attrsInWMMOnly.add("ibm-gender");
        attrsInWMMOnly.add("ibm-hobby");
    }
}

