/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration.db;

import com.ibm.websphere.wim.exception.MigrationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.security.util.WSEncoderDecoder;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.schema.DBLoadManager;
import com.ibm.ws.wim.dao.schema.JDBCSqlImport;
import com.ibm.ws.wim.migration.MigrationConstants;
import com.ibm.ws.wim.migration.db.DataTransfer;
import com.ibm.ws.wim.migration.db.DerbyDataTransfer;
import com.ibm.ws.wim.migration.db.SqlServerDataTransfer;
import com.ibm.ws.wim.util.DataGraphHelper;
import commonj.sdo.DataObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;

public class DBMigration
implements MigrationConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DBMigration.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private String dbType = null;
    private Connection wmmconn = null;
    private Connection vmmconn = null;
    private String jdbcClass = null;
    private String cloudscapeJDBCClass = "com.ibm.db2j.jdbc.DB2jDriver";
    private String wmmDBURL = null;
    private String wmmDBAdminId = null;
    private String wmmDBAdminPassword = null;
    private String vmmDBURL = null;
    private String vmmDBAdminId = null;
    private String vmmDBAdminPassword = null;
    private short dbToMigrate = (short)-1;
    private String wasInstallRoot = null;
    private String DATABASE = "database";
    private String LOOKASIDE = "lookaside";
    private String FEDERATION = "federation";
    private DataTransfer dataTrans = null;
    private JDBCSqlImport sqlimport = null;
    private DBLoadManager propLoader = null;
    private String schar = File.separator;
    static final String vmmConfigXMLFile = "wimconfig.xml";
    private static final String DB_PROP_MIGRATION_TEMPLATE = "wimdbproperties_migration.xml";
    private static final String SCHEMA_SQL = "schema.sql";
    private static final String PRIMARYKEYS_SQL = "primarykeys.sql";
    private static final String REFERENCES_SQL = "references.sql";
    private static final String INDEXES_SQL = "indexes.sql";
    private static final short DB_ONLY = 1;
    private static final short LA_ONLY = 2;
    private static final short FED_ONLY = 3;
    private static final short DB_LA = 4;
    private static final short DB_FED = 5;
    private static final short LA_FED = 6;
    private static final short ALL = 7;

    public void initialize(String string, String string2, Map map) throws WIMException {
        String string3;
        Object object;
        String string4;
        Object object2;
        Object object3;
        DataObject dataObject;
        DataObject dataObject2;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize", WIMMessageHelper.generateMsgParms("wasHome=" + string, "wimHome=" + string2, "WMM Database properties are: " + WIMTraceHelper.printMapWithoutPassword(map)));
        }
        this.wasInstallRoot = string.endsWith("/") || string.endsWith("\\") ? string.substring(0, string.length() - 1) : string;
        String string5 = string2;
        if (string2.endsWith("/") || string2.endsWith("\\")) {
            string5 = string2.substring(0, string2.length() - 1);
        }
        if ((dataObject2 = (dataObject = this.loadWIMConfig(string5)).getDataObject("entryMappingRepository")) != null) {
            this.dbToMigrate = (short)3;
            this.dbType = dataObject2.getString("databaseType");
            object3 = dataObject2.getString("dbURL");
            if (object3 != null && ((String)object3).length() != 0) {
                this.vmmDBURL = object3;
            }
            object2 = dataObject2.getString("dbAdminId");
            string4 = dataObject2.getString("dbAdminPassword");
            if (object2 != null && ((String)object2).length() != 0 && string4 != null && string4.length() != 0) {
                this.vmmDBAdminId = object2;
                this.vmmDBAdminPassword = string4;
            }
            if ((object = dataObject2.getString("JDBCDriverClass")) != null && ((String)object).length() != 0) {
                this.jdbcClass = object;
            }
        }
        if ((object3 = dataObject.getDataObject("propertyExtensionRepository")) != null) {
            this.dbToMigrate = this.dbToMigrate == 3 ? (short)6 : (short)2;
            this.dbType = object3.getString("databaseType");
            object2 = object3.getString("dbURL");
            if (object2 != null && ((String)object2).length() != 0) {
                this.vmmDBURL = object2;
            }
            string4 = object3.getString("dbAdminId");
            object = object3.getString("dbAdminPassword");
            if (string4 != null && string4.length() != 0 && object != null && ((String)object).length() != 0) {
                this.vmmDBAdminId = string4;
                this.vmmDBAdminPassword = object;
            }
            if ((string3 = object3.getString("JDBCDriverClass")) != null && string3.length() != 0) {
                this.jdbcClass = string3;
            }
        }
        object2 = dataObject.getList("repositories");
        for (int i = 0; i < object2.size(); ++i) {
            String string6;
            object = (DataObject)object2.get(i);
            if (!object.getType().getName().equals("DatabaseRepositoryType")) continue;
            this.dbToMigrate = this.dbToMigrate == 3 ? (short)5 : (this.dbToMigrate == 2 ? (short)4 : (this.dbToMigrate == 6 ? (short)7 : (short)1));
            this.dbType = object.getString("databaseType");
            string3 = object.getString("dbURL");
            if (string3 != null && string3.length() != 0) {
                this.vmmDBURL = string3;
            }
            String string7 = object.getString("dbAdminId");
            String string8 = object.getString("dbAdminPassword");
            if (string7 != null && string7.length() != 0 && string8 != null && string8.length() != 0) {
                this.vmmDBAdminId = string7;
                this.vmmDBAdminPassword = string8;
            }
            if ((string6 = object.getString("JDBCDriverClass")) == null || string6.length() == 0) continue;
            this.jdbcClass = string6;
        }
        if (this.jdbcClass == null) {
            this.jdbcClass = DAOHelper.getDefaultDBDriver(this.dbType);
        }
        this.wmmDBURL = (String)map.get("wmmDBURL");
        this.wmmDBAdminId = (String)map.get("wmmDBAdminId");
        this.wmmDBAdminPassword = (String)map.get("wmmDBAdminPassword");
        WSEncoderDecoder wSEncoderDecoder = new WSEncoderDecoder();
        if (this.vmmDBAdminPassword != null) {
            this.vmmDBAdminPassword = wSEncoderDecoder.decode(this.vmmDBAdminPassword);
        }
        try {
            if (this.dbType.equalsIgnoreCase("derby") && this.wmmDBAdminId == null) {
                this.sqlimport = new JDBCSqlImport(this.vmmDBURL, this.jdbcClass);
                this.propLoader = new DBLoadManager(this.dbType, this.vmmDBURL, this.jdbcClass, true);
            } else {
                this.sqlimport = new JDBCSqlImport(this.vmmDBURL, this.jdbcClass, this.vmmDBAdminId, this.vmmDBAdminPassword);
                this.propLoader = new DBLoadManager(this.dbType, this.vmmDBURL, this.jdbcClass, this.vmmDBAdminId, this.vmmDBAdminPassword, true);
            }
        }
        catch (WIMSystemException wIMSystemException) {
            throw new MigrationException("DATABASE_CONNECTION", WIMMessageHelper.generateMsgParms(this.vmmDBURL), CLASSNAME, "initialize", (Throwable)wIMSystemException);
        }
        this.dataTrans = this.getDataTransfer();
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    private DataTransfer getDataTransfer() {
        DataTransfer dataTransfer = null;
        dataTransfer = this.dbType.equalsIgnoreCase("derby") ? new DerbyDataTransfer() : (this.dbType.equalsIgnoreCase("sqlserver") ? new SqlServerDataTransfer() : new DataTransfer());
        return dataTransfer;
    }

    private DataObject loadWIMConfig(String string) throws WIMException {
        FileInputStream fileInputStream;
        this.loadConfigSchemaFromPackage("com.ibm.ws.wim.configmodel.ConfigmodelPackage");
        String string2 = string + this.schar + "config" + this.schar + vmmConfigXMLFile;
        EDataGraph eDataGraph = null;
        try {
            fileInputStream = new FileInputStream(string2);
            HashMap hashMap = new HashMap();
            eDataGraph = SDOUtil.loadDataGraph((InputStream)fileInputStream, hashMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MigrationException("WIM_CONFIG_XML_FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "loadWIMConfig", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new MigrationException("INVALID_WIM_CONFIG_XML_FILE", WIMMessageHelper.generateMsgParms(string2, iOException.getMessage()), CLASSNAME, "loadWIMConfig", (Throwable)iOException);
        }
        fileInputStream = DataGraphHelper.cloneDataObject(eDataGraph.getRootObject().getDataObject("configurationProvider"));
        return fileInputStream;
    }

    public short migrate() throws MigrationException {
        this.importSchemaSQL();
        this.importPrimaryKeysSQL();
        this.importIndexesSQL();
        this.importReferencesSQL();
        short s = this.dataTransfer();
        if (this.dbToMigrate == 1 || this.dbToMigrate == 4 || this.dbToMigrate == 5 || this.dbToMigrate == 7) {
            this.uploadWIMExtraProperties();
        }
        return s;
    }

    private short dataTransfer() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "dataTransfer");
        }
        short s = -1;
        boolean bl = false;
        boolean bl2 = false;
        switch (this.dbToMigrate) {
            case 1: {
                bl = this.transferDB();
                if (!trcLogger.isLoggable(Level.INFO)) break;
                trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM database data have been transfered.");
                break;
            }
            case 2: {
                bl2 = this.transferLA();
                if (!trcLogger.isLoggable(Level.INFO)) break;
                trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM lookaside data have been transfered.");
                break;
            }
            case 3: {
                this.transferFED();
                if (!trcLogger.isLoggable(Level.INFO)) break;
                trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM federation data have been transfered.");
                break;
            }
            case 4: {
                bl = this.transferDB();
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM database data have been transfered.");
                }
                bl2 = this.transferLA();
                if (!trcLogger.isLoggable(Level.INFO)) break;
                trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM lookaside data have been transfered.");
                break;
            }
            case 5: {
                bl = this.transferDB();
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM database data have been transfered.");
                }
                this.transferFED();
                if (!trcLogger.isLoggable(Level.INFO)) break;
                trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM federation data have been transfered.");
                break;
            }
            case 6: {
                bl2 = this.transferLA();
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM lookaside data have been transfered.");
                }
                this.transferFED();
                if (!trcLogger.isLoggable(Level.INFO)) break;
                trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM federation data have been transfered.");
                break;
            }
            case 7: {
                bl = this.transferDB();
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM database data have been transfered.");
                }
                bl2 = this.transferLA();
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM lookaside data have been transfered.");
                }
                this.transferFED();
                if (!trcLogger.isLoggable(Level.INFO)) break;
                trcLogger.logp(Level.INFO, CLASSNAME, "dataTransfer", "WMM federation data have been transfered.");
            }
        }
        if (bl) {
            s = bl2 ? (short)2 : 0;
        } else if (bl2) {
            s = 1;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "dataTransfer");
        }
        return s;
    }

    private void importSchemaSQL() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "importSchemaSQL");
        }
        String string = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.DATABASE + this.schar + this.dbType + this.schar + SCHEMA_SQL;
        String string2 = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.LOOKASIDE + this.schar + this.dbType + this.schar + SCHEMA_SQL;
        String string3 = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.FEDERATION + this.schar + this.dbType + this.schar + SCHEMA_SQL;
        this.importFile(string, string2, string3);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "importSchemaSQL");
        }
    }

    private void importPrimaryKeysSQL() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "importPrimaryKeysSQL");
        }
        String string = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.DATABASE + this.schar + this.dbType + this.schar + PRIMARYKEYS_SQL;
        String string2 = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.LOOKASIDE + this.schar + this.dbType + this.schar + PRIMARYKEYS_SQL;
        String string3 = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.FEDERATION + this.schar + this.dbType + this.schar + PRIMARYKEYS_SQL;
        this.importFile(string, string2, string3);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "importPrimaryKeysSQL");
        }
    }

    private void importIndexesSQL() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "importIndexesSQL");
        }
        String string = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.DATABASE + this.schar + this.dbType + this.schar + INDEXES_SQL;
        String string2 = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.LOOKASIDE + this.schar + this.dbType + this.schar + INDEXES_SQL;
        String string3 = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.FEDERATION + this.schar + this.dbType + this.schar + INDEXES_SQL;
        this.importFile(string, string2, string3);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "importIndexesSQL");
        }
    }

    private void importReferencesSQL() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "importReferencesSQL");
        }
        String string = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.DATABASE + this.schar + this.dbType + this.schar + REFERENCES_SQL;
        String string2 = this.wasInstallRoot + "/etc/wim/setup" + this.schar + this.LOOKASIDE + this.schar + this.dbType + this.schar + REFERENCES_SQL;
        this.importFile(string, string2, null);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "importReferencesSQL");
        }
    }

    private void importFile(String string, String string2, String string3) throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "importFile");
        }
        try {
            switch (this.dbToMigrate) {
                case 1: {
                    this.sqlimport.importFile(string);
                    if (!trcLogger.isLoggable(Level.INFO)) break;
                    trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string + " has been loaded.");
                    break;
                }
                case 2: {
                    this.sqlimport.importFile(string2);
                    if (!trcLogger.isLoggable(Level.INFO)) break;
                    trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string2 + " has been loaded.");
                    break;
                }
                case 3: {
                    if (string3 == null) break;
                    this.sqlimport.importFile(string3);
                    if (!trcLogger.isLoggable(Level.INFO)) break;
                    trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string3 + " has been loaded.");
                    break;
                }
                case 4: {
                    this.sqlimport.importFile(string);
                    if (trcLogger.isLoggable(Level.INFO)) {
                        trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string + " has been loaded.");
                    }
                    this.sqlimport.importFile(string2);
                    if (!trcLogger.isLoggable(Level.INFO)) break;
                    trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string2 + " has been loaded.");
                    break;
                }
                case 5: {
                    this.sqlimport.importFile(string);
                    if (trcLogger.isLoggable(Level.INFO)) {
                        trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string + " has been loaded.");
                    }
                    if (string3 == null) break;
                    this.sqlimport.importFile(string3);
                    if (!trcLogger.isLoggable(Level.INFO)) break;
                    trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string3 + " has been loaded.");
                    break;
                }
                case 6: {
                    this.sqlimport.importFile(string2);
                    if (trcLogger.isLoggable(Level.INFO)) {
                        trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string2 + " has been loaded.");
                    }
                    if (string3 == null) break;
                    this.sqlimport.importFile(string3);
                    if (!trcLogger.isLoggable(Level.INFO)) break;
                    trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string3 + " has been loaded.");
                    break;
                }
                case 7: {
                    this.sqlimport.importFile(string);
                    if (trcLogger.isLoggable(Level.INFO)) {
                        trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string + " has been loaded.");
                    }
                    this.sqlimport.importFile(string2);
                    if (trcLogger.isLoggable(Level.INFO)) {
                        trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string2 + " has been loaded.");
                    }
                    if (string3 == null) break;
                    this.sqlimport.importFile(string3);
                    if (!trcLogger.isLoggable(Level.INFO)) break;
                    trcLogger.logp(Level.INFO, CLASSNAME, "importFile", string3 + " has been loaded.");
                }
            }
        }
        catch (WIMSystemException wIMSystemException) {
            throw new MigrationException("MIGRATION_DATABASE_LOADING", WIMMessageHelper.generateMsgParms("schema"), CLASSNAME, "importFile", (Throwable)wIMSystemException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "importFile");
        }
    }

    private Connection makeWMMConnection() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "makeWMMConnection");
        }
        Connection connection = null;
        Properties properties = new Properties();
        if (this.wmmDBAdminId != null && this.wmmDBAdminPassword != null) {
            properties.put("user", this.wmmDBAdminId);
            properties.put("password", this.wmmDBAdminPassword);
        }
        try {
            Class clazz = this.loadJDBCClass("wmm");
            Object t = clazz.newInstance();
            Method method2 = clazz.getMethod("connect", String.class, Properties.class);
            connection = (Connection)method2.invoke(t, this.wmmDBURL, properties);
        }
        catch (Exception exception) {
            try {
                if (this.jdbcClass != null) {
                    Class.forName(this.jdbcClass);
                }
                connection = DriverManager.getConnection(this.wmmDBURL, properties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationException("GENERIC", WIMMessageHelper.generateMsgParms(classNotFoundException.getMessage()), CLASSNAME, "makeWMMConnection", (Throwable)classNotFoundException);
            }
            catch (SQLException sQLException) {
                throw new MigrationException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "makeWMMConnection", (Throwable)sQLException);
            }
        }
        return connection;
    }

    private Connection getWMMConnection() throws MigrationException {
        if (this.wmmconn == null) {
            this.wmmconn = this.makeWMMConnection();
        }
        return this.wmmconn;
    }

    private Connection getVMMConnection() throws MigrationException {
        if (this.vmmconn == null) {
            this.vmmconn = this.makeVMMConnection();
        }
        return this.vmmconn;
    }

    private Connection makeVMMConnection() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "makeVMMConnection");
        }
        Connection connection = null;
        Properties properties = new Properties();
        if (this.vmmDBAdminId != null && this.vmmDBAdminPassword != null) {
            properties.put("user", this.vmmDBAdminId);
            properties.put("password", this.vmmDBAdminPassword);
        }
        try {
            Class clazz = this.loadJDBCClass("vmm");
            Object t = clazz.newInstance();
            Method method2 = clazz.getMethod("connect", String.class, Properties.class);
            connection = (Connection)method2.invoke(t, this.vmmDBURL, properties);
        }
        catch (Exception exception) {
            try {
                if (this.jdbcClass != null) {
                    Class.forName(this.jdbcClass);
                }
                connection = DriverManager.getConnection(this.vmmDBURL, properties);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationException("GENERIC", WIMMessageHelper.generateMsgParms(classNotFoundException.getMessage()), CLASSNAME, "makeVMMConnection", (Throwable)classNotFoundException);
            }
            catch (SQLException sQLException) {
                throw new MigrationException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "makeVMMConnection", (Throwable)sQLException);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "makeVMMConnection");
        }
        return connection;
    }

    private Class loadJDBCClass(String string) throws WIMSystemException {
        String string2 = this.jdbcClass;
        if (string.equals("wmm") && this.dbType.equalsIgnoreCase("derby")) {
            string2 = this.cloudscapeJDBCClass;
        }
        return DAOHelper.loadJDBCClass(string2);
    }

    private boolean transferDB() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "transferDB");
        }
        this.dataTrans.transferDBENTITY(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBPROPTYPE(this.getVMMConnection());
        this.dataTrans.transferDBPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBPROPENT(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBLONGPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBBLOBPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBDBLPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBINTPROP(this.getWMMConnection(), this.getVMMConnection());
        boolean bl = this.dataTrans.transferDBREFPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBSTRPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBTSPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBENTREL(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBKEYS(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBGRPREL(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferDBACCT(this.getWMMConnection(), this.getVMMConnection());
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "transferDB");
        }
        return bl;
    }

    private boolean transferLA() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "transferLA");
        }
        this.dataTrans.transferLAENTITY(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferLAKEYS(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferLAPROPTYPE(this.getVMMConnection());
        this.dataTrans.transferLAPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferLAPROPENT(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferLALONGPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferLABLOBPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferLADBLPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferLAINTPROP(this.getWMMConnection(), this.getVMMConnection());
        boolean bl = this.dataTrans.transferLAREFPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferLASTRPROP(this.getWMMConnection(), this.getVMMConnection());
        this.dataTrans.transferLATSPROP(this.getWMMConnection(), this.getVMMConnection());
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "transferLA");
        }
        return bl;
    }

    private void transferFED() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "transferFED");
        }
        this.dataTrans.transferFEDENTITY(this.getWMMConnection(), this.getVMMConnection());
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "transferFED");
        }
    }

    private void uploadWIMExtraProperties() throws MigrationException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "uploadWIMExtraProperties");
        }
        String string = this.wasInstallRoot + this.schar + "etc/wim/migration" + this.schar + DB_PROP_MIGRATION_TEMPLATE;
        try {
            this.propLoader.initialize(string);
        }
        catch (WIMSystemException wIMSystemException) {
            throw new MigrationException(wIMSystemException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "uploadWIMExtraProperties");
        }
    }

    private EPackage loadConfigSchemaFromPackage(String string) throws WIMException {
        try {
            Class<?> clazz = Class.forName(string);
            EPackage ePackage = (EPackage)clazz.getField("eINSTANCE").get(clazz);
            String string2 = ePackage.getNsURI();
            EPackage.Registry.INSTANCE.put((Object)string2, (Object)ePackage);
            return ePackage;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MigrationException("CLASS_OR_INTERFACE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new MigrationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MigrationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)illegalAccessException);
        }
    }
}

