/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration.db;

import com.ibm.websphere.wim.Service;
import com.ibm.websphere.wim.exception.MigrationException;
import com.ibm.websphere.wim.exception.MissingInitPropertyException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.ws.wim.dao.DAOHelper;
import com.ibm.ws.wim.dao.DataAccessObject;
import com.ibm.ws.wim.migration.MigrationConstants;
import com.ibm.ws.wim.migration.db.ReferenceType;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.wsspi.wim.Repository;
import commonj.sdo.DataObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;

public class ReferenceUpdate
implements MigrationConstants {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = ReferenceUpdate.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final short DB_ONLY = 0;
    private static final short LA_ONLY = 1;
    private static final short DB_LA = 2;
    private Service service = null;
    short reposToUpdate = (short)-1;
    private String schar = File.separator;
    static final String vmmConfigXSDFile = "wimconfig.xsd";
    static final String vmmConfigXMLFile = "wimconfig.xml";
    private DataAccessObject dao = null;
    private DataObject wimConfig = null;
    private static final String DB_ADAPTER_CLASS = "com.ibm.ws.wim.adapter.db.DBAdapter";
    private static final String FILE_ADAPTER_CLASS = "com.ibm.ws.wim.adapter.file.was.FileAdapter";
    private static final String LDAP_ADAPTER_CLASS = "com.ibm.ws.wim.adapter.ldap.LdapAdapter";
    private Map reposMap = new HashMap();
    private String wimRoot = null;

    public void initialize(short s, String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize");
        }
        this.reposToUpdate = s;
        String string2 = "db2";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        this.wimRoot = string;
        if (string.endsWith("/") || string.endsWith("\\")) {
            this.wimRoot = string.substring(0, string.length() - 1);
        }
        this.wimConfig = this.loadWIMConfig(this.wimRoot);
        switch (s) {
            case 0: {
                List list = this.wimConfig.getList("repositories");
                for (int i = 0; i < list.size(); ++i) {
                    String string8;
                    DataObject dataObject = (DataObject)list.get(i);
                    if (!dataObject.getType().getName().equals("DatabaseRepositoryType")) continue;
                    string2 = dataObject.getString("databaseType");
                    String string9 = dataObject.getString("dbURL");
                    if (string9 != null && string9.length() != 0) {
                        string3 = string9;
                    }
                    string7 = dataObject.getString("dataSourceName");
                    String string10 = dataObject.getString("dbAdminId");
                    String string11 = dataObject.getString("dbAdminPassword");
                    if (string10 != null && string10.length() != 0 && string11 != null && string11.length() != 0) {
                        string4 = string10;
                        string5 = string11;
                    }
                    if ((string8 = dataObject.getString("JDBCDriverClass")) == null || string8.length() == 0) continue;
                    string6 = string8;
                }
                break;
            }
            case 1: 
            case 2: {
                String string12;
                DataObject dataObject = this.wimConfig.getDataObject("propertyExtensionRepository");
                if (dataObject == null) break;
                string2 = dataObject.getString("databaseType");
                String string13 = dataObject.getString("dbURL");
                if (string13 != null && string13.length() != 0) {
                    string3 = string13;
                }
                string7 = dataObject.getString("dataSourceName");
                String string14 = dataObject.getString("dbAdminId");
                String string15 = dataObject.getString("dbAdminPassword");
                if (string14 != null && string14.length() != 0 && string15 != null && string15.length() != 0) {
                    string4 = string14;
                    string5 = string15;
                }
                if ((string12 = dataObject.getString("JDBCDriverClass")) == null || string12.length() == 0) break;
                string6 = string12;
                break;
            }
        }
        if (string6 == null) {
            string6 = DAOHelper.getDefaultDBDriver(string2);
        }
        this.dao = DAOHelper.getNewDAOClass(string2, string7, string3, string4, string5, string6);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    private DataObject loadWIMConfig(String string) throws WIMException {
        FileInputStream fileInputStream;
        this.loadConfigSchemaFromPackage("com.ibm.ws.wim.configmodel.ConfigmodelPackage");
        String string2 = string + this.schar + "config" + this.schar + vmmConfigXMLFile;
        EDataGraph eDataGraph = null;
        try {
            fileInputStream = new FileInputStream(string2);
            HashMap hashMap = new HashMap();
            eDataGraph = SDOUtil.loadDataGraph((InputStream)fileInputStream, hashMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MigrationException("WIM_CONFIG_XML_FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string2), CLASSNAME, "loadWIMConfig", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new MigrationException("INVALID_WIM_CONFIG_XML_FILE", WIMMessageHelper.generateMsgParms(string2, iOException.getMessage()), CLASSNAME, "loadWIMConfig", (Throwable)iOException);
        }
        fileInputStream = DataGraphHelper.cloneDataObject(eDataGraph.getRootObject().getDataObject("configurationProvider"));
        return fileInputStream;
    }

    private EPackage loadConfigSchemaFromPackage(String string) throws WIMException {
        try {
            Class<?> clazz = Class.forName(string);
            EPackage ePackage = (EPackage)clazz.getField("eINSTANCE").get(clazz);
            String string2 = ePackage.getNsURI();
            EPackage.Registry.INSTANCE.put((Object)string2, (Object)ePackage);
            return ePackage;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MigrationException("CLASS_OR_INTERFACE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)classNotFoundException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new MigrationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)noSuchFieldException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new MigrationException("INVALID_PACKAGE_NAME", WIMMessageHelper.generateMsgParms(string, "packageName"), CLASSNAME, "loadConfigSchemaFromPackage", (Throwable)illegalAccessException);
        }
    }

    private Connection getVMMConnection() throws WIMException {
        Connection connection = this.dao.getConnection();
        return connection;
    }

    public void updateReference() throws WIMException {
        if (this.reposToUpdate == 2) {
            Set set = this.getDBToDoReference();
            Set set2 = this.getReferenceUniqueNames(set);
            this.updateDBToDoReference(set2);
            Set set3 = this.getLAToDoReference();
            Set set4 = this.getReferenceUniqueNames(set3);
            this.updateLAToDoReference(set4);
        } else if (this.reposToUpdate == 0) {
            Set set = this.getDBToDoReference();
            Set set5 = this.getReferenceUniqueNames(set);
            this.updateDBToDoReference(set5);
        } else if (this.reposToUpdate == 1) {
            Set set = this.getLAToDoReference();
            Set set6 = this.getReferenceUniqueNames(set);
            this.updateLAToDoReference(set6);
        }
    }

    /*
     * Loose catch block
     */
    private Set getDBToDoReference() throws WIMException {
        HashSet<ReferenceType> hashSet;
        block17: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "getDBToDoReference");
            }
            hashSet = new HashSet<ReferenceType>();
            ReferenceType referenceType = null;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            String string = null;
            ResultSet resultSet = null;
            string = "SELECT ENTITY_ID, REF_FULL_EXT_ID, REF_REPOS_ID FROM DBREFPROP WHERE REF_UNAME_KEY='TODO'";
            connection = this.getVMMConnection();
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                referenceType = new ReferenceType();
                referenceType.setEntityId(resultSet.getLong(1));
                referenceType.setExtId(resultSet.getString(2));
                referenceType.setReposId(resultSet.getString(3).trim());
                hashSet.add(referenceType);
            }
            Object var10_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.dao.closeConnection(connection);
                }
                break block17;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "getDBToDoReference", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
                break block17;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getDBToDoReference", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var10_8 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.dao.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block18;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "getDBToDoReference", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getDBToDoReference");
        }
        return hashSet;
    }

    /*
     * Loose catch block
     */
    private Set getLAToDoReference() throws WIMException {
        HashSet<ReferenceType> hashSet;
        block17: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "getLAToDoReference");
            }
            hashSet = new HashSet<ReferenceType>();
            ReferenceType referenceType = null;
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            String string = null;
            ResultSet resultSet = null;
            string = "SELECT ENTITY_ID, REF_FULL_EXT_ID, REF_REPOS_ID FROM LAREFPROP WHERE REF_UNAME_KEY='TODO'";
            connection = this.getVMMConnection();
            preparedStatement = connection.prepareStatement(string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                referenceType = new ReferenceType();
                referenceType.setEntityId(resultSet.getLong(1));
                referenceType.setExtId(resultSet.getString(2));
                referenceType.setReposId(resultSet.getString(3).trim());
                hashSet.add(referenceType);
            }
            Object var10_7 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.dao.closeConnection(connection);
                }
                break block17;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "getLAToDoReference", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
                break block17;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "getLAToDoReference", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var10_8 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.dao.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block18;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "getLAToDoReference", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getLAToDoReference");
        }
        return hashSet;
    }

    private void initRepos(Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initRepos");
        }
        List list = this.wimConfig.getList("repositories");
        System.setProperty("wim.home", this.wimRoot);
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject = (DataObject)list.get(i);
            String string = dataObject.getString("id");
            if (!set.contains(string)) continue;
            String string2 = dataObject.getType().getName();
            String string3 = dataObject.getString("adapterClassName");
            if (string3 == null) {
                if (string2.equals("DatabaseRepositoryType")) {
                    string3 = DB_ADAPTER_CLASS;
                } else if (string2.equals("FileRepositoryType")) {
                    string3 = FILE_ADAPTER_CLASS;
                } else if (string2.equals("LdapRepositoryType")) {
                    string3 = LDAP_ADAPTER_CLASS;
                } else {
                    throw new MissingInitPropertyException("MISSING_INI_PROPERTY", WIMMessageHelper.generateMsgParms("adapterClassName"), CLASSNAME, "initRepos");
                }
            }
            try {
                Class<?> clazz = Class.forName(string3);
                Repository repository2 = (Repository)clazz.newInstance();
                repository2.initialize(dataObject);
                this.reposMap.put(string, repository2);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(string3, classNotFoundException.getMessage()), CLASSNAME, "initRepos", (Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(string3, instantiationException.getMessage()), CLASSNAME, "initRepos", (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new WIMSystemException("REPOSITORY_INITIALIZATION_FAILED", WIMMessageHelper.generateMsgParms(string3, illegalAccessException.getMessage()), CLASSNAME, "initRepos", (Throwable)illegalAccessException);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initRepos");
        }
    }

    private Set getReferenceUniqueNames(Set set) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getReferenceUniqueNames");
        }
        HashSet<ReferenceType> hashSet = new HashSet<ReferenceType>();
        Map map = this.sortByReposId(set);
        Set set2 = map.keySet();
        this.initRepos(set2);
        for (String string : set2) {
            Object object2;
            Repository repository2 = (Repository)this.reposMap.get(string.trim());
            DataObject dataObject = SDOHelper.createRootDataObject();
            Map map2 = (Map)map.get(string);
            Set set3 = map2.keySet();
            for (Object object2 : set3) {
                DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "Entity");
                dataObject2.createDataObject("identifier").setString("externalId", (String)object2);
            }
            dataObject = repository2.get(dataObject);
            object2 = dataObject.getList("entities");
            for (int i = 0; i < object2.size(); ++i) {
                DataObject dataObject3 = (DataObject)object2.get(i);
                String string2 = dataObject3.getDataObject("identifier").getString("externalId");
                String string3 = dataObject3.getDataObject("identifier").getString("uniqueName");
                ReferenceType referenceType = (ReferenceType)map2.get(string2);
                referenceType.setUniqueName(string3);
                hashSet.add(referenceType);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getReferenceUniqueNames");
        }
        return hashSet;
    }

    private Map sortByReposId(Set set) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "sortByReposId");
        }
        HashMap<String, HashMap<String, ReferenceType>> hashMap = new HashMap<String, HashMap<String, ReferenceType>>();
        for (ReferenceType referenceType : set) {
            String string = referenceType.getReposId();
            HashMap<String, ReferenceType> hashMap2 = (HashMap<String, ReferenceType>)hashMap.get(string);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<String, ReferenceType>();
            }
            hashMap2.put(referenceType.getExtId(), referenceType);
            hashMap.put(string, hashMap2);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "sortByReposId");
        }
        return hashMap;
    }

    /*
     * Loose catch block
     */
    private void updateDBToDoReference(Set set) throws WIMException {
        block17: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "updateDBToDoReference");
            }
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            String string = null;
            ResultSet resultSet = null;
            Iterator iterator = set.iterator();
            string = "UPDATE DBREFPROP SET REF_UNAME = ?, REF_UNAME_KEY = ? WHERE ENTITY_ID = ?";
            connection = this.getVMMConnection();
            preparedStatement = connection.prepareStatement(string);
            while (iterator.hasNext()) {
                ReferenceType referenceType = (ReferenceType)iterator.next();
                preparedStatement.setString(1, referenceType.getUniqueName());
                preparedStatement.setString(2, DAOHelper.getTruncatedUniqueName(referenceType.getUniqueName()));
                preparedStatement.setLong(3, referenceType.getEntityId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            Object var10_9 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.dao.closeConnection(connection);
                }
                break block17;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "updateDBToDoReference", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
                break block17;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "updateDBToDoReference", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var10_10 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.dao.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block18;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "updateDBToDoReference", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateDBToDoReference");
        }
    }

    /*
     * Loose catch block
     */
    private void updateLAToDoReference(Set set) throws WIMException {
        block17: {
            if (trcLogger.isLoggable(Level.FINER)) {
                trcLogger.entering(CLASSNAME, "updateLAToDoReference");
            }
            Connection connection = null;
            PreparedStatement preparedStatement = null;
            String string = null;
            ResultSet resultSet = null;
            Iterator iterator = set.iterator();
            string = "UPDATE LAREFPROP SET REF_UNAME = ?, REF_UNAME_KEY = ? WHERE ENTITY_ID = ?";
            connection = this.getVMMConnection();
            preparedStatement = connection.prepareStatement(string);
            while (iterator.hasNext()) {
                ReferenceType referenceType = (ReferenceType)iterator.next();
                preparedStatement.setString(1, referenceType.getUniqueName());
                preparedStatement.setString(2, DAOHelper.getTruncatedUniqueName(referenceType.getUniqueName()));
                preparedStatement.setLong(3, referenceType.getEntityId());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
            Object var10_9 = null;
            try {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
                if (connection != null) {
                    this.dao.closeConnection(connection);
                }
                break block17;
            }
            catch (SQLException sQLException) {
                if (trcLogger.isLoggable(Level.FINE)) {
                    StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                    stringBuffer.append(sQLException.toString());
                    trcLogger.logp(Level.FINE, CLASSNAME, "updateLAToDoReference", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                }
                break block17;
            }
            {
                catch (SQLException sQLException) {
                    throw new WIMSystemException("SQL_EXCEPTION", WIMMessageHelper.generateMsgParms(sQLException.getMessage()), CLASSNAME, "updateLAToDoReference", (Throwable)sQLException);
                }
            }
            catch (Throwable throwable) {
                block18: {
                    Object var10_10 = null;
                    try {
                        if (preparedStatement != null) {
                            preparedStatement.close();
                        }
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (connection != null) {
                            this.dao.closeConnection(connection);
                        }
                    }
                    catch (SQLException sQLException) {
                        if (!trcLogger.isLoggable(Level.FINE)) break block18;
                        StringBuffer stringBuffer = new StringBuffer("Unexpected error when closing the prepared statement or the connection : ");
                        stringBuffer.append(sQLException.toString());
                        trcLogger.logp(Level.FINE, CLASSNAME, "updateLAToDoReference", stringBuffer.toString(), WIMMessageHelper.generateMsgParms(sQLException));
                    }
                }
                throw throwable;
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "updateLAToDoReference");
        }
    }
}

