/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration.ur;

import com.ibm.websphere.wim.exception.MigrationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.migration.ur.WMMRealm;
import com.ibm.ws.wim.util.DataGraphHelper;
import com.ibm.ws.xml.ParserFactory;
import commonj.sdo.DataObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.util.SDOUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WMMURMigration {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String LOGGER = "com.ibm.ws.wim.migration.ur";
    private static final String CLASSNAME = WMMURMigration.class.getName();
    private static final Logger msgLogger = WIMLogger.getMessageLogger("com.ibm.ws.wim.migration.ur");
    private static final Logger trcLogger = WIMLogger.getTraceLogger("com.ibm.ws.wim.migration.ur");
    private static final String WMMUR_REALMS = "realms";
    private static final String WMMUR_REALM = "realm";
    private static final String WMMUR_REALM_ID = "id";
    private static final String WMMUR_REALM_DELIMITER = "delimiter";
    private static final String WMMUR_REALM_DEFAULT = "default";
    private static final String WMMUR_WMMNODE = "wmmnode";
    private static final String WMMUR_NODE = "node";
    private static final String WMMUR_DEFAULTPARENT = "defaultParent";
    private String wmmConfigFile;
    private String wimHome;
    private Map userGroupIdMappings;
    private String defaultRealm;
    private List wmmRealmList = new Vector();

    public WMMURMigration(String string, String string2, Map map) {
        trcLogger.entering(CLASSNAME, "WMMURMigration()");
        this.wmmConfigFile = string;
        this.wimHome = string2;
        this.userGroupIdMappings = map;
        trcLogger.exiting(CLASSNAME, "WMMURMigration()");
    }

    public void migrateWMMURToVMM() throws WIMException {
        trcLogger.entering(CLASSNAME, "migrateWMMURToVMM()");
        this.loadWMMConfigFile();
        this.migrateWMMConfiguration();
        trcLogger.exiting(CLASSNAME, "migrateWMMURToVMM()");
    }

    private void loadWMMConfigFile() throws WIMException {
        trcLogger.entering(CLASSNAME, "loadWMMConfigFile");
        try {
            DocumentBuilderFactory documentBuilderFactory = ParserFactory.newDocumentBuilderFactory();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.wmmConfigFile);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName(WMMUR_REALMS);
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName(WMMUR_REALM);
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                boolean bl = false;
                Element element3 = (Element)nodeList2.item(i);
                String string = element3.getAttribute(WMMUR_REALM_ID);
                String string2 = element3.getAttribute(WMMUR_REALM_DELIMITER);
                String string3 = element3.getAttribute(WMMUR_REALM_DEFAULT);
                if (string3 != null && string3.equalsIgnoreCase("true")) {
                    bl = true;
                    this.defaultRealm = string;
                }
                WMMRealm wMMRealm = new WMMRealm(string, string2, bl);
                this.wmmRealmList.add(wMMRealm);
                NodeList nodeList3 = element3.getElementsByTagName(WMMUR_NODE);
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    Element element4 = (Element)nodeList3.item(j);
                    String string4 = element4.getAttribute(WMMUR_WMMNODE);
                    String string5 = element4.getAttribute(WMMUR_DEFAULTPARENT);
                    wMMRealm.addWMMNode(string4, string5);
                }
            }
        }
        catch (Exception exception) {
            throw new MigrationException("MIGRATION_ERROR", new Object[]{exception.getMessage()}, Level.SEVERE, CLASSNAME, "loadWMMConfigFile", (Throwable)exception);
        }
        trcLogger.exiting(CLASSNAME, "loadWMMConfigFile");
    }

    private void migrateWMMConfiguration() throws WIMException {
        trcLogger.entering(CLASSNAME, "migrateWMMConfiguration");
        try {
            DataObject dataObject = this.loadWIMConfig();
            ArrayList<String> arrayList = new ArrayList<String>();
            List list = dataObject.getList("repositories");
            if (list != null && list.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    DataObject dataObject2 = (DataObject)list.get(i);
                    Object object = dataObject2.getList("baseEntries");
                    if (object == null || object.size() <= 0) continue;
                    for (int j = 0; j < object.size(); ++j) {
                        String string = (String)((DataObject)object.get(j)).get("name");
                        if (arrayList.contains(string)) continue;
                        arrayList.add(string);
                    }
                }
            }
            dataObject.unset("realmConfiguration");
            DataObject dataObject3 = dataObject.createDataObject("realmConfiguration");
            dataObject3.set("defaultRealm", (Object)this.defaultRealm);
            for (WMMRealm wMMRealm : this.wmmRealmList) {
                DataObject dataObject4 = dataObject3.createDataObject(WMMUR_REALMS);
                dataObject4.set("name", (Object)wMMRealm.getRealmId());
                dataObject4.set(WMMUR_REALM_DELIMITER, (Object)wMMRealm.getDelimiter());
                dataObject4.set("securityUse", (Object)"active");
                List list2 = wMMRealm.getVMMParticipatingBaseEntries();
                for (Object object : list2) {
                    String string = (String)object;
                    if (arrayList.contains(string)) {
                        DataObject dataObject5 = dataObject4.createDataObject("participatingBaseEntries");
                        dataObject5.set("name", object);
                        continue;
                    }
                    msgLogger.logp(Level.WARNING, CLASSNAME, "migrateWMMConfiguration", "BASE_ENTRY_MIGRATION_WARNING", WIMMessageHelper.generateMsgParms(string));
                }
                List list3 = wMMRealm.getVMMDefaultParents();
                for (Object object : list3) {
                    DataObject dataObject6 = dataObject4.createDataObject("defaultParents");
                    dataObject6.set("entityTypeName", object.getKey());
                    dataObject6.set("parentUniqueName", object.getValue());
                }
                this.createUserGroupIdMappings(dataObject4);
            }
            this.saveWIMConfig(dataObject);
        }
        catch (Exception exception) {
            throw new MigrationException("MIGRATION_ERROR", new Object[]{exception.getMessage()}, Level.SEVERE, CLASSNAME, "migrateWMMConfiguration", (Throwable)exception);
        }
        trcLogger.exiting(CLASSNAME, "migrateWMMConfiguration");
    }

    private void createUserGroupIdMappings(DataObject dataObject) {
        trcLogger.entering(CLASSNAME, "createUserGroupIdMappings");
        String[] stringArray = new String[]{"uniqueUserIdMapping", "userSecurityNameMapping", "userDisplayNameMapping", "uniqueGroupIdMapping", "groupSecurityNameMapping", "groupDisplayNameMapping"};
        for (int i = 0; i < stringArray.length; ++i) {
            String string = (String)this.userGroupIdMappings.get(stringArray[i]);
            DataObject dataObject2 = dataObject.createDataObject(stringArray[i]);
            dataObject2.set("propertyForInput", (Object)string);
            dataObject2.set("propertyForOutput", (Object)string);
        }
        trcLogger.exiting(CLASSNAME, "createUserGroupIdMappings");
    }

    private String getWIMConfigPath() {
        String string = this.wimHome;
        if (string.endsWith("/") || string.endsWith("\\")) {
            string = string.substring(0, string.length() - 1);
        }
        return string + File.separator + "config" + File.separator;
    }

    private DataObject loadWIMConfig() throws WIMException {
        EDataGraph eDataGraph;
        trcLogger.entering(CLASSNAME, "loadWIMConfig");
        String string = this.getWIMConfigPath() + "wimconfig.xml";
        ConfigManager.singleton();
        try {
            eDataGraph = SDOUtil.loadDataGraph((InputStream)new FileInputStream(string), new HashMap());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MigrationException("WIM_CONFIG_XML_FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "loadWIMConfig", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new MigrationException("INVALID_WIM_CONFIG_XML_FILE", WIMMessageHelper.generateMsgParms(string, iOException.getMessage()), CLASSNAME, "loadWIMConfig", (Throwable)iOException);
        }
        trcLogger.exiting(CLASSNAME, "loadWIMConfig");
        return eDataGraph.getRootObject().getDataObject("configurationProvider");
    }

    private void saveWIMConfig(DataObject dataObject) throws WIMException {
        trcLogger.entering(CLASSNAME, "saveWIMConfig");
        String string = this.getWIMConfigPath() + "wimconfig.xml";
        DataGraphHelper.saveDataGraph(dataObject.getDataGraph(), string);
        trcLogger.exiting(CLASSNAME, "saveWIMConfig");
    }
}

