/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration.wmm;

import com.ibm.websphere.wim.exception.MigrationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.sun.jndi.ldap.LdapName;
import java.util.ArrayList;
import javax.naming.InvalidNameException;

public class MemberDNHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = MemberDNHelper.class.getName();
    public static final String MEMBER_DN_SEPARATOR = ",";

    public static String isDN(String string) {
        if (string == null) {
            return null;
        }
        LdapName ldapName = null;
        try {
            ldapName = new LdapName(string);
            return ldapName.getPrefix(ldapName.size()).toString();
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }

    public static String formatDN(String string) throws WIMException {
        if (string == null) {
            return null;
        }
        LdapName ldapName = null;
        try {
            ldapName = new LdapName(string);
            return ldapName.getPrefix(ldapName.size()).toString();
        }
        catch (InvalidNameException invalidNameException) {
            throw new MigrationException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "formatDN(String astrDN)");
        }
    }

    public static String getParentDN(String string) throws WIMException {
        if (string == null) {
            return string;
        }
        String string2 = null;
        try {
            LdapName ldapName = new LdapName(string);
            if (ldapName.size() == 0) {
                return null;
            }
            string2 = ldapName.getPrefix(ldapName.size() - 1).toString();
        }
        catch (InvalidNameException invalidNameException) {
            throw new MigrationException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "String getRDN(String DN)");
        }
        return string2;
    }

    public static String getRDN(String string) throws WIMException {
        if (string == null) {
            return string;
        }
        String string2 = null;
        try {
            LdapName ldapName = new LdapName(string);
            if (ldapName.size() == 0) {
                return string;
            }
            string2 = ldapName.get(ldapName.size() - 1);
        }
        catch (InvalidNameException invalidNameException) {
            throw new MigrationException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "String getRDN(String DN)");
        }
        return string2;
    }

    public static String[] getRDNComponents(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        int n = string.indexOf(43);
        if (n == -1) {
            stringArray = new String[]{string};
            return stringArray;
        }
        if (n == 0) {
            stringArray = new String[]{string.substring(1)};
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object var4_4 = null;
        int n2 = 0;
        while (n > -1) {
            if (string.charAt(n - 1) != '\\') {
                arrayList.add(string.substring(n2, n));
                n2 = n + 1;
            }
            n = string.indexOf(43, n + 1);
        }
        arrayList.add(string.substring(n2));
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getRDNAttrTypesByRDNComponents(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = null;
        int n = stringArray.length;
        stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].indexOf(61);
            if (n2 <= -1) continue;
            stringArray2[i] = stringArray[i].substring(0, n2);
        }
        return stringArray2;
    }

    public static String[] getRDNAttrTypesForComparison(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i].toLowerCase();
        }
        return stringArray2;
    }

    public static String getMemberDN(String string) {
        if (string.indexOf("=") < 0) {
            return null;
        }
        try {
            LdapName ldapName = new LdapName(string);
            return ldapName.getPrefix(ldapName.size()).toString();
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }
}

