/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration.wmm.plugin;

import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.migration.wmm.DataTypeHelper;
import java.util.HashMap;
import java.util.Map;

public class PluginAttribute {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = "com.ibm.ws.wmm.plugin.PluginAttribute";
    private String iWmmAttributeName = null;
    private String iPluginAttributeName = null;
    private short iDataType = 0;
    private String iPluginDataType = null;
    private int iValueLength = 0;
    private String iDefaultValue;
    private String iDefaultAttribute;
    private boolean iMultiValued = false;
    private boolean iReadOnly = false;
    private boolean iCaseExactlyMactch = false;
    private String iDescription = null;
    private String iClassName = null;
    private short[] iApplicableMemberTypes = null;
    private short[] iRequiredMemberTypes = null;
    private Map iExtendProperties = new HashMap();
    private boolean iWMMGenerate = false;

    public PluginAttribute(String string, String string2) {
        this.setPluginAttributeName(string);
        this.setWmmAttributeName(string2);
    }

    public boolean addExtendProperties(String string, String string2) {
        if (string == null) {
            return false;
        }
        if ((string = string.trim()).length() == 0) {
            return false;
        }
        this.iExtendProperties.put(string, string2);
        return true;
    }

    public short[] getApplicableMemberTypes() {
        return this.iApplicableMemberTypes;
    }

    public short getDataType() {
        return this.iDataType;
    }

    public String getDefaultValue() {
        return this.iDefaultValue;
    }

    public String getDefaultAttribute() {
        return this.iDefaultAttribute;
    }

    public String getDescription() {
        return this.iDescription;
    }

    public String getClassName() {
        return this.iClassName;
    }

    public String getExtendProperties(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.iExtendProperties.get(string);
    }

    public String getPluginAttributeName() {
        return this.iPluginAttributeName;
    }

    public String getPluginDataType() {
        return this.iPluginDataType;
    }

    public short[] getRequiredMemberTypes() {
        return this.iRequiredMemberTypes;
    }

    public int getValueLength() {
        return this.iValueLength;
    }

    public String getWmmAttributeName() {
        return this.iWmmAttributeName;
    }

    public boolean isApplicable(short s) {
        if (this.iApplicableMemberTypes == null) {
            return false;
        }
        int n = this.iApplicableMemberTypes.length;
        for (int i = 0; i < n; ++i) {
            if (this.iApplicableMemberTypes[i] != s) continue;
            return true;
        }
        return false;
    }

    public boolean isMultiValued() {
        return this.iMultiValued;
    }

    public boolean isReadOnly() {
        return this.iReadOnly;
    }

    public boolean isWMMGenerate() {
        return this.iWMMGenerate;
    }

    public boolean isRequired(short s) {
        if (this.iRequiredMemberTypes == null) {
            return false;
        }
        int n = this.iRequiredMemberTypes.length;
        for (int i = 0; i < n; ++i) {
            if (this.iRequiredMemberTypes[i] != s) continue;
            return true;
        }
        return false;
    }

    public boolean isCaseExactlyMatch() {
        return this.iCaseExactlyMactch;
    }

    public void setApplicableMemberTypes(short[] sArray) {
        this.iApplicableMemberTypes = sArray;
    }

    public void setDataType(String string) {
        this.iDataType = DataTypeHelper.getDataType(string);
    }

    public void setDefaultValue(String string) {
        this.iDefaultValue = string;
    }

    public void setDefaultAttribute(String string) {
        this.iDefaultAttribute = string;
    }

    public void setDescription(String string) {
        this.iDescription = string;
    }

    public void setClassName(String string) {
        this.iClassName = string;
    }

    public void setMultiValued(String string) {
        this.iMultiValued = new Boolean(string);
    }

    public void setMultiValued(boolean bl) {
        this.iMultiValued = bl;
    }

    public void setCaseExactlyMatch(String string) {
        this.iCaseExactlyMactch = new Boolean(string);
    }

    public void setCaseExactlyMatch(boolean bl) {
        this.iCaseExactlyMactch = bl;
    }

    public void setPluginAttributeName(String string) {
        this.iPluginAttributeName = string;
    }

    public void setPluginDataType(String string) {
        this.iPluginDataType = string;
    }

    public void setReadOnly(String string) {
        this.iReadOnly = new Boolean(string);
    }

    public void setWMMGenerate(String string) {
        this.iWMMGenerate = new Boolean(string);
    }

    public void setReadOnly(boolean bl) {
        this.iReadOnly = bl;
    }

    public void setRequiredMemberTypes(short[] sArray) {
        this.iRequiredMemberTypes = sArray;
    }

    public void setValueLength(int n) {
        this.iValueLength = n;
    }

    public boolean setValueLength(String string) {
        try {
            this.iValueLength = Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void setWmmAttributeName(String string) {
        this.iWmmAttributeName = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append(string).append(this.iPluginAttributeName).append("<=>").append(this.iWmmAttributeName).append(string);
        stringBuffer.append("multiValued:      ").append(this.iMultiValued).append(string);
        stringBuffer.append("caseExactlyMatch: ").append(this.iCaseExactlyMactch).append(string);
        stringBuffer.append("readOnly:         ").append(this.iReadOnly).append(string);
        stringBuffer.append("dataType:         ").append(this.iDataType).append(string);
        stringBuffer.append("pluginDataType:   ").append(this.iPluginDataType).append(string);
        stringBuffer.append("valueLength:      ").append(this.iValueLength).append(string);
        stringBuffer.append("defaultValue:     ").append(this.iDefaultValue).append(string);
        stringBuffer.append("defaultAttribute:     ").append(this.iDefaultAttribute).append(string);
        stringBuffer.append("applicableMemberTypes:     ").append(WIMTraceHelper.printShortArray(this.iApplicableMemberTypes)).append(string);
        stringBuffer.append("requiredMemberTypes:     ").append(WIMTraceHelper.printShortArray(this.iRequiredMemberTypes)).append(string);
        return stringBuffer.toString();
    }
}

