/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration.wmm.plugin;

import com.ibm.websphere.wim.exception.MigrationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.migration.wmm.DataTypeHelper;
import com.ibm.ws.wim.migration.wmm.MemberDNHelper;
import com.ibm.ws.wim.migration.wmm.MemberTypeHelper;
import com.ibm.ws.wim.migration.wmm.PluginHelper;
import com.ibm.ws.wim.migration.wmm.config.MemberType;
import com.ibm.ws.wim.migration.wmm.config.ProfileRepository;
import com.ibm.ws.wim.migration.wmm.datatype.StringSet;
import com.ibm.ws.wim.migration.wmm.plugin.PluginAttribute;
import com.ibm.ws.wim.migration.wmm.plugin.PluginConfigManager;
import com.ibm.ws.wim.migration.wmm.plugin.PluginEntry;
import com.ibm.ws.wim.migration.wmm.plugin.PluginNodeMap;
import com.ibm.ws.wim.util.StringLengthComparator;
import com.ibm.ws.xml.ParserFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PluginConfigManagerImpl
implements PluginConfigManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = PluginConfigManagerImpl.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private String iRepositoryUUID = null;
    private boolean iInitialized = false;
    private short[] iMemberTypes = null;
    private Map iPluginAttrMap = new HashMap();
    private Map iWmmToPluginMap = new HashMap();
    private Map iWmmToPluginMapIgnoreCase = new HashMap();
    private StringSet iMemberReferenceAttrs = StringSet.Factory.getInstance();
    private PluginEntry[] iPluginEntries = null;
    private List iPluginNodeMap = null;
    private String[] iPluginNodes = null;
    private String[] iSuperPlguinNodes = null;
    private String[] iPluginNodesForComparison = null;
    private String[] iWmmNodes = null;
    private String[] iWmmNodesForComparison = null;
    private String[][] iWMMRDNAttrTypes = new String[MemberTypeHelper.getNumberOfMemberTypes()][];
    private boolean iWmmGenerateExtId = false;
    private boolean iTranslateRDN = false;
    private PluginAttribute[] iExtIdAttrs = null;
    private List iExtIdNameList = null;
    private List iExtIdAttrList = null;
    private StringSet iSupportedDatatypes = StringSet.Factory.getInstance();

    public void addMemberReferenceAttribute(String string) {
        this.iMemberReferenceAttrs.add(string);
    }

    public void addPluginAttribute(PluginAttribute pluginAttribute) {
        this.iPluginAttrMap.put(pluginAttribute.getWmmAttributeName(), pluginAttribute);
        this.iWmmToPluginMap.put(pluginAttribute.getWmmAttributeName(), pluginAttribute.getPluginAttributeName());
        this.iWmmToPluginMapIgnoreCase.put(pluginAttribute.getWmmAttributeName().toLowerCase(), pluginAttribute.getPluginAttributeName());
    }

    public void addSupportedDataType(String string) {
        this.iSupportedDatatypes.add(string);
    }

    public boolean addRDNAttrTypes(short s, String[] stringArray) {
        if (!MemberTypeHelper.isValidMemberType(s)) {
            return false;
        }
        this.iWMMRDNAttrTypes[s] = stringArray;
        return true;
    }

    protected PluginAttribute createPluginAttribute(String string, String string2) {
        return new PluginAttribute(string, string2);
    }

    protected PluginEntry createPluginEntry(short s) {
        return new PluginEntry(s);
    }

    public Set getAllWmmAttributeNames() {
        return this.iWmmToPluginMap.keySet();
    }

    public PluginAttribute getExtIdAttribute(short s) {
        if (MemberTypeHelper.isValidMemberType(s)) {
            return this.iExtIdAttrs[s];
        }
        PluginAttribute pluginAttribute = new PluginAttribute("distinguishedName", "extId");
        pluginAttribute.setDataType("STRING");
        pluginAttribute.setMultiValued(false);
        pluginAttribute.setReadOnly(true);
        return pluginAttribute;
    }

    public List getExtIdAttributes() {
        return this.iExtIdAttrList;
    }

    public String getExtIdName(short s) {
        if (MemberTypeHelper.isValidMemberType(s)) {
            PluginAttribute pluginAttribute = this.iExtIdAttrs[s];
            if (pluginAttribute != null) {
                return this.iExtIdAttrs[s].getPluginAttributeName();
            }
            return "distinguishedName";
        }
        return "distinguishedName";
    }

    public List getExtIdNames() {
        return this.iExtIdNameList;
    }

    public StringSet getMemberReferenceAttributes() {
        return this.iMemberReferenceAttrs;
    }

    public short[] getMemberTypes() {
        return this.iMemberTypes;
    }

    public PluginAttribute getPluginAttribute(String string) {
        if (string == null) {
            return null;
        }
        return (PluginAttribute)this.iPluginAttrMap.get(string);
    }

    public String getPluginAttributeName(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.iWmmToPluginMap.get(string);
    }

    public String getPluginAttributeNameByIgnoreCase(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.iWmmToPluginMapIgnoreCase.get(string.toLowerCase());
    }

    public PluginEntry getPluginEntry(short s) {
        if (s < 0) {
            return null;
        }
        if (MemberTypeHelper.isValidMemberType(s)) {
            return this.iPluginEntries[s];
        }
        return null;
    }

    public List getPluginNodeMaps() {
        return this.iPluginNodeMap;
    }

    public String[] getPluginNodes() {
        return this.iPluginNodes;
    }

    public String[] getSuperPluginNodes() {
        return this.iSuperPlguinNodes;
    }

    public String[] getPluginNodesForComparison() {
        return this.iPluginNodesForComparison;
    }

    public StringSet getSupportedDataTypes() {
        return this.iSupportedDatatypes;
    }

    public String[] getWmmNodes() {
        return this.iWmmNodes;
    }

    public String[] getWmmNodesForComparison() {
        return this.iWmmNodesForComparison;
    }

    public String[] getRDNAttrTypes(short s) {
        if (!this.isValidMemberType(s)) {
            return null;
        }
        return this.iWMMRDNAttrTypes[s];
    }

    public String[][] getRDNAttrTypes() {
        return this.iWMMRDNAttrTypes;
    }

    public void initialize(ProfileRepository profileRepository, List list) throws WIMException {
        Map map = profileRepository.getProperties();
        this.setRepositoryUUID(profileRepository.getRepositoryUUID());
        List list2 = profileRepository.getNodeMap();
        if (list2 == null || list2.size() == 0) {
            throw new MigrationException("MIGRATION_WMM_FILE_INVALID", WIMMessageHelper.generateMsgParms("wmm.xml"), CLASSNAME, "initialize");
        }
        this.iPluginEntries = new PluginEntry[list.size()];
        this.setPluginNodeMaps(list2);
        for (MemberType memberType : list) {
            short s = memberType.getName();
            if (!MemberTypeHelper.isValidMemberType(s)) {
                throw new MigrationException("MIGRATION_WMM_FILE_INVALID", WIMMessageHelper.generateMsgParms("wmm.xml"), CLASSNAME, "initialize");
            }
            String[] stringArray = memberType.getRDNAttrTypes();
            this.iWMMRDNAttrTypes[s] = stringArray;
        }
        this.iWmmGenerateExtId = profileRepository.isGenerateExtId();
        this.setMemberTypes(MemberTypeHelper.getMemberTypes());
        this.readPluginAttributeMapFile(profileRepository.getConfigurationFile());
        this.iTranslateRDN = profileRepository.isTranslateRDN();
        this.iInitialized = true;
    }

    public boolean isInitialized() {
        return this.iInitialized;
    }

    public boolean isWmmGenerateExtId() {
        return this.iWmmGenerateExtId;
    }

    public boolean isTranslateRDN() {
        return this.iTranslateRDN;
    }

    protected void readPluginAttributeMapFile(String string) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "readPluginAttributeMapFile(String mapFileName)", WIMTraceHelper.printObjectArray(new Object[]{string}));
        }
        if (string == null || string.trim().length() == 0) {
            throw new MigrationException("FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "readPluginAttributeMapFile(String mapFileName)");
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = ParserFactory.newDocumentBuilderFactory();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string);
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("attributeMap");
            this.iExtIdAttrs = new PluginAttribute[MemberTypeHelper.getNumberOfMemberTypes()];
            this.iExtIdAttrList = new ArrayList(MemberTypeHelper.getNumberOfMemberTypes());
            this.iExtIdNameList = new ArrayList(MemberTypeHelper.getNumberOfMemberTypes());
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                short[] sArray;
                Object object;
                Element element2 = (Element)nodeList.item(i);
                String string2 = element2.getAttribute("wmmAttributeName");
                String string3 = element2.getAttribute("pluginAttributeName");
                if (string2 == null || string3 == null) continue;
                PluginAttribute pluginAttribute = this.createPluginAttribute(string3, string2);
                NamedNodeMap namedNodeMap = element2.getAttributes();
                int n2 = namedNodeMap.getLength();
                for (int j = 0; j < n2; ++j) {
                    Node node = namedNodeMap.item(j);
                    object = node.getNodeName();
                    String string4 = node.getNodeValue();
                    if ("wmmAttributeName".equalsIgnoreCase((String)object) || "pluginAttributeName".equalsIgnoreCase((String)object)) continue;
                    if ("applicableMemberTypes".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setApplicableMemberTypes(MemberTypeHelper.getMemberTypes(string4));
                        continue;
                    }
                    if ("requiredMemberTypes".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setRequiredMemberTypes(MemberTypeHelper.getMemberTypes(string4));
                        continue;
                    }
                    if ("dataType".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setDataType(string4);
                        continue;
                    }
                    if ("pluginDataType".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setPluginDataType(string4);
                        continue;
                    }
                    if ("valueLength".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setValueLength(string4);
                        continue;
                    }
                    if ("multiValued".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setMultiValued(string4);
                        continue;
                    }
                    if ("readOnly".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setReadOnly(string4);
                        continue;
                    }
                    if ("caseExactlyMatch".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setCaseExactlyMatch(string4);
                        continue;
                    }
                    if ("defaultValue".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setDefaultValue(string4);
                        continue;
                    }
                    if ("defaultAttribute".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setDefaultAttribute(string4);
                        continue;
                    }
                    if ("description".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setDescription(string4);
                        continue;
                    }
                    if ("classname".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setClassName(string4);
                        continue;
                    }
                    if ("wmmGenerate".equalsIgnoreCase((String)object)) {
                        pluginAttribute.setWMMGenerate(string4);
                        continue;
                    }
                    if (object == null || ((String)object).trim().length() <= 0) continue;
                    pluginAttribute.addExtendProperties(node.getNodeName(), string4);
                }
                if ("extId".equalsIgnoreCase(string2)) {
                    if (trcLogger.isLoggable(Level.FINER)) {
                        trcLogger.logp(Level.FINER, CLASSNAME, "readPluginAttributeMapFile(String mapFileName)", "extId attribute: " + pluginAttribute);
                    }
                    sArray = pluginAttribute.getApplicableMemberTypes();
                    for (n2 = 0; n2 < sArray.length; ++n2) {
                        this.setExtIdAttribute(sArray[n2], pluginAttribute);
                    }
                    this.addExtIdAttribute(pluginAttribute);
                    continue;
                }
                this.addPluginAttribute(pluginAttribute);
                sArray = pluginAttribute.getApplicableMemberTypes();
                for (n2 = 0; n2 < sArray.length; ++n2) {
                    short s = sArray[n2];
                    object = this.getPluginEntry(s);
                    if (object == null) {
                        object = this.createPluginEntry(s);
                    }
                    ((PluginEntry)object).addPluginAttribute(pluginAttribute);
                    this.setPluginEntry(s, (PluginEntry)object);
                }
                this.addSupportedDataType(DataTypeHelper.getDataTypeName(pluginAttribute.getDataType()));
                if (pluginAttribute.getDataType() != 6) continue;
                this.addMemberReferenceAttribute(string2);
            }
        }
        catch (Exception exception) {
            throw new MigrationException("MIGRATION_ERROR", WIMMessageHelper.generateMsgParms(WIMMessageHelper.generateMsgParms(exception.getLocalizedMessage())), CLASSNAME, "readPluginAttributeMapFile(String mapFileName)");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "readPluginAttributeMapFile(String mapFileName)", WIMTraceHelper.printObjectArray(new Object[]{this.iPluginAttrMap}));
        }
    }

    public void setExtIdAttribute(short s, PluginAttribute pluginAttribute) {
        this.iExtIdAttrs[s] = pluginAttribute;
    }

    public void addExtIdAttribute(PluginAttribute pluginAttribute) {
        String string = pluginAttribute.getPluginAttributeName();
        boolean bl = false;
        for (int i = 0; i < this.iExtIdAttrList.size(); ++i) {
            PluginAttribute pluginAttribute2 = (PluginAttribute)this.iExtIdAttrList.get(i);
            if (!pluginAttribute2.getPluginAttributeName().equals(string)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            this.iExtIdAttrList.add(pluginAttribute);
            this.iExtIdNameList.add(pluginAttribute.getPluginAttributeName());
        }
    }

    public void setMemberTypes(short[] sArray) {
        this.iMemberTypes = sArray;
    }

    public boolean setPluginEntry(short s, PluginEntry pluginEntry) {
        if (s < 0) {
            return false;
        }
        if (MemberTypeHelper.isValidMemberType(s)) {
            this.iPluginEntries[s] = pluginEntry;
            return true;
        }
        return false;
    }

    public void setPluginNodeMaps(List list) throws WIMException {
        String string;
        String[] stringArray;
        int n;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "setPluginNodeMaps(List pluginNodeMaps)", WIMTraceHelper.printObjectArray(new Object[]{list}));
        }
        int n2 = list.size();
        HashMap<String, String> hashMap = new HashMap<String, String>(n2);
        HashMap<String, String> hashMap2 = new HashMap<String, String>(n2);
        String[] stringArray2 = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray = (String[])list.get(n);
            String string2 = stringArray.getPluginNode();
            string = stringArray.getNode();
            if (string2 == null || string == null) continue;
            stringArray2[n] = string2 = MemberDNHelper.formatDN(string2);
            string = MemberDNHelper.formatDN(string);
            hashMap2.put(string.toLowerCase(), string2);
            hashMap.put(string.toLowerCase(), string);
        }
        n = hashMap2.size();
        stringArray = hashMap2.keySet().toArray(new String[0]);
        Arrays.sort(stringArray, new StringLengthComparator());
        this.iPluginNodeMap = new ArrayList(n);
        this.iPluginNodes = new String[n];
        this.iPluginNodesForComparison = new String[n];
        this.iWmmNodes = new String[n];
        this.iWmmNodesForComparison = new String[n];
        for (int i = 0; i < n; ++i) {
            string = stringArray[i];
            String string3 = (String)hashMap.get(string);
            String string4 = (String)hashMap2.get(string);
            String string5 = string4.toLowerCase();
            this.iPluginNodes[i] = string4;
            this.iPluginNodesForComparison[i] = string5;
            this.iWmmNodes[i] = string3;
            this.iWmmNodesForComparison[i] = string;
            PluginNodeMap pluginNodeMap = new PluginNodeMap();
            pluginNodeMap.setPluginNode(string5);
            pluginNodeMap.setNode(string);
            this.iPluginNodeMap.add(pluginNodeMap);
        }
        this.iSuperPlguinNodes = PluginHelper.getSuperNodes(stringArray2);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "setPluginNodeMaps(List pluginNodeMaps)", "NodeMaps: " + this.iPluginNodeMap + ", SuperNodes: " + WIMTraceHelper.printObjectArray(this.iSuperPlguinNodes));
        }
    }

    public void setWmmGenerateExtId(boolean bl) {
        this.iWmmGenerateExtId = bl;
    }

    public boolean isValidMemberType(short s) {
        for (int i = 0; i < this.iMemberTypes.length; ++i) {
            if (s != this.iMemberTypes[i]) continue;
            return true;
        }
        return false;
    }

    public void setRepositoryUUID(String string) {
        this.iRepositoryUUID = string;
    }

    public String getRepositoryUUID() {
        return this.iRepositoryUUID;
    }
}

