/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration.wmm.plugin;

import com.ibm.ws.wim.migration.wmm.plugin.PluginAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PluginEntry {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private short iMemberType;
    private Set iRequiredWmmAttrs = null;
    private Set iRequiredAttrs = null;
    private Set iAttrsWithDefault = null;
    private Set iAttrsWithDefaultAttr = null;
    private Set iWmmAttrsWithDefault = null;
    private Set iWmmAttrsWithDefaultAttr = null;
    private Map iPluginToWmmMap = null;
    private Map iWmmToPluginMap = null;

    public PluginEntry(short s) {
        this.iMemberType = s;
        this.iRequiredAttrs = new HashSet();
        this.iRequiredWmmAttrs = new HashSet();
        this.iAttrsWithDefault = new HashSet();
        this.iWmmAttrsWithDefault = new HashSet();
        this.iAttrsWithDefaultAttr = new HashSet();
        this.iWmmAttrsWithDefaultAttr = new HashSet();
        this.iWmmToPluginMap = new HashMap();
        this.iPluginToWmmMap = new HashMap();
    }

    public void addPluginAttribute(PluginAttribute pluginAttribute) {
        String string = pluginAttribute.getPluginAttributeName();
        String string2 = pluginAttribute.getWmmAttributeName();
        if (string != null && string2 != null) {
            string2 = string2.trim();
            string = string.trim().toLowerCase();
            this.iWmmToPluginMap.put(string2, string);
            this.iPluginToWmmMap.put(string, string2);
            if (pluginAttribute.isRequired(this.getMemberType())) {
                this.iRequiredAttrs.add(string);
                this.iRequiredWmmAttrs.add(string2);
            }
            if (pluginAttribute.getDefaultValue() != null && pluginAttribute.getDefaultValue().trim().length() > 0) {
                this.iAttrsWithDefault.add(string);
                this.iWmmAttrsWithDefault.add(string2);
            }
            if (pluginAttribute.getDefaultAttribute() != null && pluginAttribute.getDefaultAttribute().trim().length() > 0) {
                this.iAttrsWithDefaultAttr.add(string);
                this.iWmmAttrsWithDefaultAttr.add(string2);
            }
        }
    }

    public short getMemberType() {
        return this.iMemberType;
    }

    public String getPluginAttributeName(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.iWmmToPluginMap.get(string);
    }

    public Set getPluginAttributesWithDefaultValue() {
        return this.iAttrsWithDefault;
    }

    public Set getPluginAttributesWithDefaultAttribute() {
        return this.iAttrsWithDefaultAttr;
    }

    public Set getRequiredPluginAttributes() {
        return this.iRequiredAttrs;
    }

    public Set getRequiredWmmAttributes() {
        return this.iRequiredWmmAttrs;
    }

    public Set getSupportedPluginAttributes() {
        return this.iPluginToWmmMap.keySet();
    }

    public Set getSupportedWmmAttributes() {
        return this.iWmmToPluginMap.keySet();
    }

    public String getWmmAttributeName(String string) {
        if (string == null) {
            return null;
        }
        return (String)this.iPluginToWmmMap.get(string.toLowerCase());
    }

    public Set getWmmAttributesWithDefaultValue() {
        return this.iWmmAttrsWithDefault;
    }

    public Set getWmmAttributesWithDefaultAttribute() {
        return this.iWmmAttrsWithDefaultAttr;
    }

    public boolean isPluginAttributeRequired(String string) {
        if (string == null) {
            return false;
        }
        return this.iRequiredAttrs.contains(string.toLowerCase());
    }

    public boolean isPluginAttributeSupported(String string) {
        if (string == null) {
            return false;
        }
        return this.iPluginToWmmMap.containsKey(string.toLowerCase());
    }

    public boolean isWmmAttributeRequired(String string) {
        if (string == null) {
            return false;
        }
        return this.iRequiredWmmAttrs.contains(string);
    }

    public boolean isWmmAttributeSupported(String string) {
        if (string == null) {
            return false;
        }
        return this.iWmmToPluginMap.containsKey(string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("memberType:").append(this.getMemberType()).append(", ");
        stringBuffer.append("supportedPluginAttributes:").append(this.iPluginToWmmMap.keySet());
        stringBuffer.append("requiredAttributes:").append(this.iRequiredAttrs.toString());
        stringBuffer.append("supportedWmmAttributes:").append(this.iWmmToPluginMap.keySet());
        stringBuffer.append("requiredWmmAttributes:").append(this.iRequiredWmmAttrs.toString());
        return stringBuffer.toString();
    }
}

