/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.migration.wmm.xml.config;

import com.ibm.websphere.wim.exception.MigrationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.migration.wmm.config.MemberManager;
import com.ibm.ws.wim.migration.wmm.config.MemberRepository;
import com.ibm.ws.wim.migration.wmm.config.MemberType;
import com.ibm.ws.wim.migration.wmm.config.ProfileRepository;
import com.ibm.ws.wim.migration.wmm.config.impl.FederationRepositoryImpl;
import com.ibm.ws.wim.migration.wmm.config.impl.LookAsideRepositoryImpl;
import com.ibm.ws.wim.migration.wmm.config.impl.MemberManagerImpl;
import com.ibm.ws.wim.migration.wmm.config.impl.MemberTypeImpl;
import com.ibm.ws.wim.migration.wmm.config.impl.NodeMapImpl;
import com.ibm.ws.wim.migration.wmm.config.impl.ProfileEntryTypeImpl;
import com.ibm.ws.wim.migration.wmm.config.impl.ProfileRepositoryImpl;
import com.ibm.ws.wim.util.PasswordEncryptionUtil;
import com.ibm.ws.xml.ParserFactory;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XML2WMMConfiguration {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = "com.ibm.ws.wmm.xml.configuration.XML2WMMConfiguration";
    private static int wmmConfig = 0;
    private boolean lookAside = false;
    private boolean federation = false;
    private MemberManager memberManagerConfiguration = null;
    private String iWMMConfigPath = null;
    private String iWMMConfigFile = null;
    private static XML2WMMConfiguration instance = null;

    private XML2WMMConfiguration() {
    }

    public static MemberManager getWmmConfiguration(String string, String string2) throws WIMException {
        if (instance == null) {
            instance = new XML2WMMConfiguration();
        }
        return instance.convertXMLConfigurationToWMMConfiguration(string, string2);
    }

    public MemberManager convertXMLConfigurationToWMMConfiguration(String string, String string2) throws WIMException {
        this.iWMMConfigPath = string;
        this.iWMMConfigFile = string2;
        this.memberManagerConfiguration = new MemberManagerImpl();
        try {
            String string3;
            String string4;
            DocumentBuilderFactory documentBuilderFactory = ParserFactory.newDocumentBuilderFactory();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(string + string2);
            Element element = document.getDocumentElement();
            this.memberManagerConfiguration.setDefaultRealmName(element.getAttribute("defaultRealmName"));
            this.memberManagerConfiguration.setUniqueIdGeneratorClassName(element.getAttribute("uniqueIdGeneratorClassName"));
            this.memberManagerConfiguration.setSoftGroupAdderClassName(element.getAttribute("softGroupAdderClassName"));
            this.memberManagerConfiguration.setLookAside(new Boolean(element.getAttribute("lookAside")));
            this.memberManagerConfiguration.setHorizontalPartitioning(new Boolean(element.getAttribute("horizontalPartitioning")));
            String string5 = element.getAttribute("configurationFile");
            this.memberManagerConfiguration.setConfigurationFile(this.getAbsolutePath(string5));
            this.memberManagerConfiguration.setMaximumSearchResults(Integer.valueOf(element.getAttribute("maximumSearchResults")));
            this.memberManagerConfiguration.setSearchTimeout(Integer.valueOf(element.getAttribute("searchTimeOut")));
            this.memberManagerConfiguration.setMaximumSearchResultsForSortingAndPaging(Integer.valueOf(element.getAttribute("maximumSearchResultsForSortingAndPaging")));
            this.memberManagerConfiguration.setMaximumTotalSearchResultsForSortingAndPaging(Integer.valueOf(element.getAttribute("maximumTotalSearchResultsForSortingAndPaging")));
            this.memberManagerConfiguration.setPagingMemberObject(new Boolean(element.getAttribute("pagingMemberObject")));
            this.memberManagerConfiguration.setTimeToRemovePagedCacheEntry(Integer.valueOf(element.getAttribute("timeToRemovePagedCacheEntry")));
            String string6 = element.getAttribute("userSecurityNameAttribute");
            if (string6 != null && string6.length() > 0) {
                this.memberManagerConfiguration.setUserSecurityNameAttribute(string6);
            }
            if ((string4 = element.getAttribute("passwordAttribute")) != null && string4.length() > 0) {
                this.memberManagerConfiguration.setPasswordAttribute(string4);
            }
            if ((string3 = element.getAttribute("certificateFilter")) != null && string3.length() > 0) {
                this.memberManagerConfiguration.setCertificateFilter(string3);
            }
            this.lookAside = this.memberManagerConfiguration.isLookAside();
            this.federation = this.memberManagerConfiguration.isHorizontalPartitioning();
            for (Node node = document.getDocumentElement().getFirstChild(); node != null; node = node.getNextSibling()) {
                String string7 = node.getNodeName();
                if ("supportedMemberTypes".equalsIgnoreCase(string7)) {
                    this.parseSupportedMemberTypes(node);
                    continue;
                }
                if (!"repositories".equalsIgnoreCase(string7)) continue;
                this.parseRepositories(node);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new MigrationException("FILE_NOT_FOUND", WIMMessageHelper.generateMsgParms(string + string2), Level.SEVERE, CLASSNAME, "convertXMLConfigurationToWMMConfiguration()", (Throwable)fileNotFoundException);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        return this.memberManagerConfiguration;
    }

    private void parseSupportedMemberTypes(Node node) {
        short s = 0;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (!"supportedMemberType".equalsIgnoreCase(node2.getNodeName())) continue;
            Element element = (Element)node2;
            MemberTypeImpl memberTypeImpl = new MemberTypeImpl();
            memberTypeImpl.setName(new Short(s));
            memberTypeImpl.setStringName(element.getAttribute("name"));
            memberTypeImpl.setRDNAttrTypes(element.getAttribute("rdnAttrTypes"));
            memberTypeImpl.setDefaultParentMember(element.getAttribute("defaultParentMember"));
            memberTypeImpl.setDefaultProfileRepository(element.getAttribute("defaultProfileRepository"));
            this.memberManagerConfiguration.addSupportedMemberType(memberTypeImpl);
            s = (short)(s + 1);
        }
    }

    private void parseRepositories(Node node) throws WIMException {
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            MemberRepository memberRepository;
            if (1 != node2.getNodeType() || (memberRepository = this.returnRepository(node2.getNodeName())) == null) continue;
            this.initializeRepository(memberRepository, (Element)node2);
            this.memberManagerConfiguration.addMemberRepository(memberRepository);
        }
    }

    private MemberRepository returnRepository(String string) {
        if ("federationRepository".equalsIgnoreCase(string)) {
            if (this.federation) {
                return new FederationRepositoryImpl();
            }
            return null;
        }
        if ("ldapRepository".equalsIgnoreCase(string)) {
            return new ProfileRepositoryImpl();
        }
        if ("databaseRepository".equalsIgnoreCase(string)) {
            this.memberManagerConfiguration.setUsingDataSource(true);
            return new ProfileRepositoryImpl();
        }
        if ("lookAsideRepository".equalsIgnoreCase(string)) {
            if (this.lookAside) {
                this.memberManagerConfiguration.setUsingDataSource(true);
                return new LookAsideRepositoryImpl();
            }
            return null;
        }
        if ("profileRepository".equalsIgnoreCase(string)) {
            return new ProfileRepositoryImpl();
        }
        return null;
    }

    private void initializeRepository(MemberRepository memberRepository, Element element) throws WIMException {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string = node.getNodeName();
            String string2 = node.getNodeValue();
            String string3 = element.getNodeName();
            if (string3.equalsIgnoreCase("databaseRepository")) {
                memberRepository.setRepositoryType("DB");
            } else if (string3.equalsIgnoreCase("ldapRepository")) {
                memberRepository.setRepositoryType("LDAP");
            } else if (string3.equalsIgnoreCase("federationRepository")) {
                memberRepository.setRepositoryType("FED");
            } else if (string3.equalsIgnoreCase("lookAsideRepository")) {
                memberRepository.setRepositoryType("LA");
            } else {
                memberRepository.setRepositoryType("CUSTOM");
            }
            if ("adapterClassName".equalsIgnoreCase(string)) {
                memberRepository.setAdapterClassName(string2);
                continue;
            }
            if ("adapterVersion".equalsIgnoreCase(string)) {
                memberRepository.setAdapterVersion(string2);
                continue;
            }
            if ("UUID".equalsIgnoreCase(string)) {
                memberRepository.setRepositoryUUID(string2);
                continue;
            }
            if ("configurationFile".equalsIgnoreCase(string)) {
                memberRepository.setConfigurationFile(this.getAbsolutePath(string2));
                continue;
            }
            if ("specVersion".equalsIgnoreCase(string)) {
                memberRepository.setSpecVersion(string2);
                continue;
            }
            if ("vendor".equalsIgnoreCase(string)) {
                memberRepository.setVendor(string2);
                continue;
            }
            if ("supportTransactions".equalsIgnoreCase(string)) {
                memberRepository.setSupportTransactions(new Boolean(string2));
                continue;
            }
            if (memberRepository instanceof ProfileRepository && "wmmGenerateExtId".equalsIgnoreCase(string)) {
                ((ProfileRepository)memberRepository).setGenerateExtId(new Boolean(string2));
                continue;
            }
            if (memberRepository instanceof ProfileRepository && "translateRDN".equalsIgnoreCase(string)) {
                ((ProfileRepository)memberRepository).setTranslateRDN(new Boolean(string2));
                continue;
            }
            if (memberRepository instanceof ProfileRepository && "supportDynamicAttributes".equalsIgnoreCase(string)) {
                ((ProfileRepository)memberRepository).setSupportDynamicAttributes(new Boolean(string2));
                continue;
            }
            if (memberRepository instanceof ProfileRepository && "supportGetPersonByAccountName".equalsIgnoreCase(string)) {
                ((ProfileRepository)memberRepository).setSupportGetPersonByAccountName(new Boolean(string2));
                continue;
            }
            if (memberRepository instanceof ProfileRepository && "profileRepositoryForGroups".equalsIgnoreCase(string)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                ((ProfileRepository)memberRepository).setProfileRepositoryForGroups(arrayList);
                continue;
            }
            if (memberRepository instanceof ProfileRepository && "adminPassword".equalsIgnoreCase(string)) {
                try {
                    string2 = PasswordEncryptionUtil.decrypt(string2.trim(), null).trim();
                }
                catch (NullPointerException nullPointerException) {
                    System.out.println("NPE occured, assume the password is not encrypted!");
                }
                memberRepository.setProperty(string, string2);
                continue;
            }
            try {
                memberRepository.setProperty(string, Integer.valueOf(string2));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                memberRepository.setProperty(string, string2);
            }
        }
        if (memberRepository instanceof ProfileRepository) {
            this.initializeProfileRepository((ProfileRepository)memberRepository, element);
        }
    }

    private void initializeProfileRepository(ProfileRepository profileRepository, Element element) {
        if (element.hasChildNodes()) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType()) continue;
                if ("nodeMaps".equalsIgnoreCase(node.getNodeName())) {
                    this.initializeRepositoryNodeMaps(profileRepository, (Element)node);
                    continue;
                }
                if ("supportedLdapEntryTypes".equalsIgnoreCase(node.getNodeName())) {
                    this.initializeSupportedLdapTypes(profileRepository, (Element)node);
                    continue;
                }
                this.initializeRepositoryMemberActions(profileRepository, (Element)node);
            }
        }
    }

    private void initializeRepositoryNodeMaps(ProfileRepository profileRepository, Element element) {
        if (element.hasChildNodes()) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType()) continue;
                NodeMapImpl nodeMapImpl = new NodeMapImpl();
                nodeMapImpl.setNode(((Element)node).getAttribute("node"));
                nodeMapImpl.setPluginNode(((Element)node).getAttribute("pluginNode"));
                profileRepository.addNodeMap(nodeMapImpl);
            }
        }
    }

    private void initializeRepositoryMemberActions(ProfileRepository profileRepository, Element element) {
        if ("readMemberType".equalsIgnoreCase(element.getNodeName())) {
            profileRepository.setReadMemberType(this.getMemberTypes(element));
        } else if ("createMemberType".equalsIgnoreCase(element.getNodeName())) {
            profileRepository.setCreateMemberType(this.getMemberTypes(element));
        } else if ("deleteMemberType".equalsIgnoreCase(element.getNodeName())) {
            profileRepository.setRemoveMemberType(this.getMemberTypes(element));
        } else if ("moveMemberType".equalsIgnoreCase(element.getNodeName())) {
            profileRepository.setMoveMemberType(this.getMemberTypes(element));
        } else if ("renameMemberType".equalsIgnoreCase(element.getNodeName())) {
            profileRepository.setRenameMemberType(this.getMemberTypes(element));
        } else if ("updateMemberType".equalsIgnoreCase(element.getNodeName())) {
            profileRepository.setUpdateMemberType(this.getMemberTypes(element));
        }
    }

    private List getMemberTypes(Node node) {
        ArrayList<Short> arrayList = new ArrayList<Short>();
        if (node.hasChildNodes()) {
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                if (!"memberType".equalsIgnoreCase(node2.getNodeName())) continue;
                String string = ((Element)node2).getAttribute("name");
                Short s = this.getMemberType(string);
                if (s == null) {
                    System.out.println("ERR: memberTypeId == null ");
                    continue;
                }
                arrayList.add(s);
            }
        }
        return arrayList;
    }

    private Short getMemberType(String string) {
        List list = this.memberManagerConfiguration.getSupportedMemberTypes();
        for (int i = 0; i < list.size(); ++i) {
            MemberType memberType = (MemberType)list.get(i);
            if (!memberType.getStringName().equalsIgnoreCase(string)) continue;
            return memberType.getName();
        }
        return null;
    }

    private void initializeSupportedLdapTypes(ProfileRepository profileRepository, Element element) {
        if (element.hasChildNodes()) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (1 != node.getNodeType()) continue;
                ProfileEntryTypeImpl profileEntryTypeImpl = new ProfileEntryTypeImpl();
                profileEntryTypeImpl.setName(this.getMemberType(((Element)node).getAttribute("name")));
                profileEntryTypeImpl.setRDNAttrTypes(((Element)node).getAttribute("rdnAttrTypes"));
                profileEntryTypeImpl.setDefiningObjectClass(((Element)node).getAttribute("objectClassesForRead"));
                String string = ((Element)node).getAttribute("objectClassesForWrite");
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                while (stringTokenizer.hasMoreTokens()) {
                    profileEntryTypeImpl.addObjectClass(stringTokenizer.nextToken());
                }
                String string2 = ((Element)node).getAttribute("searchBases");
                profileEntryTypeImpl.setSearchBases(string2);
                String string3 = ((Element)node).getAttribute("auxilaryClasses");
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ";");
                while (stringTokenizer2.hasMoreTokens()) {
                    profileEntryTypeImpl.addAuxiliaryObjectClass(stringTokenizer2.nextToken());
                }
                String string4 = ((Element)node).getAttribute("searchFilter");
                profileEntryTypeImpl.setSearchFilter(string4);
                profileRepository.addSupportedProfileEntryType(profileEntryTypeImpl);
            }
        }
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private InputStream returnMainXml(String string) {
        InputStream inputStream = null;
        ClassLoader classLoader = this.getClassLoader();
        inputStream = classLoader != null ? classLoader.getResourceAsStream(string) : ClassLoader.getSystemResourceAsStream(string);
        return inputStream;
    }

    public static MemberManager getMemberManagerConfiguration(String string) {
        MemberManager memberManager = null;
        try {
            InitialContext initialContext = new InitialContext();
            memberManager = (MemberManager)initialContext.lookup(string);
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            memberManager = null;
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            memberManager = null;
        }
        return memberManager;
    }

    public static void storeMemberManagerConfiguration(String string, MemberManager memberManager) {
        try {
            InitialContext initialContext = new InitialContext();
            try {
                Object object = initialContext.lookup(string);
                initialContext.rebind(string, (Object)memberManager);
            }
            catch (NameNotFoundException nameNotFoundException) {
                if (wmmConfig == 0) {
                    initialContext.bind(string, (Object)memberManager);
                    if (!"MembershipProvider".equals(string)) {
                        initialContext.bind("MembershipProvider", (Object)memberManager);
                        ++wmmConfig;
                    }
                }
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
        }
    }

    private static void testMemberManagerSerialization(MemberManager memberManager) {
        List list = memberManager.getMemberRepositories();
        List list2 = memberManager.getSupportedMemberTypes();
        for (Object object : list2) {
            XML2WMMConfiguration.testSerialization(object);
        }
        for (Object e2 : list) {
            XML2WMMConfiguration.testSerialization(e2);
            if (!(e2 instanceof ProfileRepository)) continue;
            ProfileRepository profileRepository = (ProfileRepository)e2;
            for (Object e3 : profileRepository.getNodeMap()) {
                XML2WMMConfiguration.testSerialization(e3);
            }
            for (Object e3 : profileRepository.getSupportedProfileEntryType()) {
                XML2WMMConfiguration.testSerialization(e3);
            }
        }
        XML2WMMConfiguration.testSerialization(memberManager);
    }

    private static void testSerialization(Object object) {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            string = object.getClass().getName() + " is  serializable !!!";
        }
        catch (NotSerializableException notSerializableException) {
            string = object.getClass().getName() + " is not serializable :(";
        }
        catch (IOException iOException) {
            string = "an IO exception when serializing " + object.getClass().getName();
        }
        System.out.println("\n\n---------------------------\n " + string + "\n\n" + object.toString() + " \n\n-------------------\n");
    }

    public String getWMMConfigPath() {
        return this.iWMMConfigPath;
    }

    public String getWMMConfigFile() {
        return this.iWMMConfigFile;
    }

    public String getAbsolutePath(String string) {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            string = this.getWMMConfigPath() + string;
        }
        return string;
    }
}

