/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.pluginmanager;

import com.ibm.websphere.wim.pluginmanager.context.PluginManagerConstants;
import com.ibm.ws.wim.configmodel.InlineExit;
import com.ibm.ws.wim.configmodel.ModificationSubscriber;
import com.ibm.ws.wim.configmodel.ModificationSubscriberList;
import com.ibm.ws.wim.configmodel.NotificationSubscriber;
import com.ibm.ws.wim.configmodel.NotificationSubscriberList;
import com.ibm.ws.wim.configmodel.PostExit;
import com.ibm.ws.wim.configmodel.PreExit;
import com.ibm.ws.wim.configmodel.TopicEmitter;
import com.ibm.ws.wim.pluginmanager.ExitPointExecList;
import com.ibm.ws.wim.pluginmanager.SubscriberRealmInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class EmitterReference {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private String emitterName;
    private String preExitPointName;
    private String postExitPointName;
    private HashSet inlineExitNames;
    private HashMap exitPointMap;
    private static String newline = System.getProperty("line.separator");

    public EmitterReference(String string) {
        this.emitterName = string;
        this.preExitPointName = string + "." + (Object)((Object)PluginManagerConstants.PREEXIT_LITERAL);
        this.postExitPointName = string + "." + (Object)((Object)PluginManagerConstants.POSTEXIT_LITERAL);
        this.exitPointMap = new HashMap();
        this.inlineExitNames = new HashSet();
    }

    private Object getSubscriber(Vector vector, String string) {
        SubscriberRealmInfo subscriberRealmInfo = null;
        for (SubscriberRealmInfo subscriberRealmInfo2 : vector) {
            String string2 = subscriberRealmInfo2.getSubscriberName();
            if (!string2.equals(string)) continue;
            subscriberRealmInfo = subscriberRealmInfo2;
            break;
        }
        return subscriberRealmInfo;
    }

    private boolean checkChangeInModSubscriberList(ModificationSubscriber[] modificationSubscriberArray, HashMap hashMap, Vector vector) {
        boolean bl = false;
        for (int i = 0; modificationSubscriberArray != null && i < modificationSubscriberArray.length; ++i) {
            String string = modificationSubscriberArray[i].getModificationSubscriberReference();
            HashSet hashSet = new HashSet(modificationSubscriberArray[i].getRealmList());
            if (hashMap.containsKey(string)) {
                bl = true;
                break;
            }
            Object object = this.getSubscriber(vector, string);
            if (object == null) {
                bl = true;
                break;
            }
            SubscriberRealmInfo subscriberRealmInfo = (SubscriberRealmInfo)object;
            HashSet hashSet2 = subscriberRealmInfo.getRealmSet();
            if (hashSet2.equals(hashSet)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean checkChangeInNotSubscriberList(NotificationSubscriber[] notificationSubscriberArray, HashMap hashMap, Vector vector) {
        boolean bl = false;
        for (int i = 0; notificationSubscriberArray != null && i < notificationSubscriberArray.length; ++i) {
            String string = notificationSubscriberArray[i].getNotificationSubscriberReference();
            HashSet hashSet = new HashSet(notificationSubscriberArray[i].getRealmList());
            if (hashMap.containsKey(string)) {
                bl = true;
                break;
            }
            Object object = this.getSubscriber(vector, string);
            if (object == null) {
                bl = true;
                break;
            }
            SubscriberRealmInfo subscriberRealmInfo = (SubscriberRealmInfo)object;
            HashSet hashSet2 = subscriberRealmInfo.getRealmSet();
            if (hashSet2.equals(hashSet)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean doesInlineExist(String string) {
        String string2 = this.emitterName + "." + string;
        return this.exitPointMap.containsKey(string2);
    }

    public String getEmitterName() {
        return this.emitterName;
    }

    public ExitPointExecList getPreExit() {
        ExitPointExecList exitPointExecList = (ExitPointExecList)this.exitPointMap.get(this.preExitPointName);
        return exitPointExecList;
    }

    public ExitPointExecList getPostExit() {
        ExitPointExecList exitPointExecList = (ExitPointExecList)this.exitPointMap.get(this.postExitPointName);
        return exitPointExecList;
    }

    public ExitPointExecList[] getInlineExits() {
        ExitPointExecList[] exitPointExecListArray = null;
        int n = this.inlineExitNames.size();
        if (n > 0) {
            exitPointExecListArray = new ExitPointExecList[n];
            Iterator iterator = this.inlineExitNames.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                exitPointExecListArray[n2++] = (ExitPointExecList)this.exitPointMap.get(iterator.next());
            }
        }
        return exitPointExecListArray;
    }

    public Vector getInlineExitModificationList(String string) {
        String string2 = this.emitterName + "." + string;
        Object v = this.exitPointMap.get(string2);
        ExitPointExecList exitPointExecList = null;
        Vector vector = null;
        if (v != null && v instanceof ExitPointExecList) {
            exitPointExecList = (ExitPointExecList)v;
            vector = exitPointExecList.getModificationList();
        }
        return vector;
    }

    public Vector getPostExitModificationList() {
        ExitPointExecList exitPointExecList = (ExitPointExecList)this.exitPointMap.get(this.postExitPointName);
        return exitPointExecList.getModificationList();
    }

    public Vector getPostExitNotificationList() {
        ExitPointExecList exitPointExecList = (ExitPointExecList)this.exitPointMap.get(this.postExitPointName);
        return exitPointExecList.getNotificationList();
    }

    public Vector getPreExitModificationList() {
        ExitPointExecList exitPointExecList = (ExitPointExecList)this.exitPointMap.get(this.preExitPointName);
        return exitPointExecList.getModificationList();
    }

    public Vector getPreExitNotificationList() {
        ExitPointExecList exitPointExecList = (ExitPointExecList)this.exitPointMap.get(this.preExitPointName);
        return exitPointExecList.getNotificationList();
    }

    public boolean isChangedInlineExits(TopicEmitter topicEmitter, HashMap hashMap) {
        boolean bl = false;
        InlineExit[] inlineExitArray = topicEmitter.getInlineExitAsArray();
        int n = this.exitPointMap.size() - 2;
        if (n != inlineExitArray.length) {
            bl = true;
        }
        if (!bl) {
            for (int i = 0; i < inlineExitArray.length; ++i) {
                InlineExit inlineExit = inlineExitArray[i];
                String string = inlineExit.getInlineExitName();
                ModificationSubscriberList modificationSubscriberList = inlineExit.getModificationSubscriberList();
                ModificationSubscriber[] modificationSubscriberArray = null;
                if (modificationSubscriberList != null) {
                    modificationSubscriberArray = modificationSubscriberList.getModificationSubscriberAsArray();
                }
                if (this.doesInlineExist(string)) {
                    Vector vector = this.getInlineExitModificationList(string);
                    if (modificationSubscriberArray == null && vector.size() != 0 || modificationSubscriberArray != null && vector.size() != modificationSubscriberArray.length) {
                        bl = true;
                        break;
                    }
                    bl = this.checkChangeInModSubscriberList(modificationSubscriberArray, hashMap, vector);
                    if (!bl) continue;
                    break;
                }
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isChangedPostExit(TopicEmitter topicEmitter, HashMap hashMap) {
        boolean bl = false;
        PostExit postExit = topicEmitter.getPostExit();
        NotificationSubscriberList notificationSubscriberList = null;
        ModificationSubscriberList modificationSubscriberList = null;
        if (postExit != null) {
            notificationSubscriberList = postExit.getNotificationSubscriberList();
            modificationSubscriberList = postExit.getModificationSubscriberList();
        }
        NotificationSubscriber[] notificationSubscriberArray = null;
        ModificationSubscriber[] modificationSubscriberArray = null;
        if (notificationSubscriberList != null) {
            notificationSubscriberArray = notificationSubscriberList.getNotificationSubscriberAsArray();
        }
        if (modificationSubscriberList != null) {
            modificationSubscriberArray = modificationSubscriberList.getModificationSubscriberAsArray();
        }
        Vector vector = this.getPostExitNotificationList();
        Vector vector2 = this.getPostExitModificationList();
        if (notificationSubscriberArray == null && vector.size() != 0 || modificationSubscriberArray == null && vector2.size() != 0) {
            bl = true;
        }
        if (!bl) {
            if (notificationSubscriberArray != null && vector.size() != notificationSubscriberArray.length) {
                bl = true;
            }
            if (modificationSubscriberArray != null && vector2.size() != modificationSubscriberArray.length) {
                bl = true;
            }
        }
        if (!bl) {
            bl = this.checkChangeInModSubscriberList(modificationSubscriberArray, hashMap, vector2);
        }
        if (!bl) {
            bl = this.checkChangeInNotSubscriberList(notificationSubscriberArray, hashMap, vector);
        }
        return bl;
    }

    public boolean isChangedPreExit(TopicEmitter topicEmitter, HashMap hashMap) {
        boolean bl = false;
        PreExit preExit = topicEmitter.getPreExit();
        NotificationSubscriberList notificationSubscriberList = null;
        ModificationSubscriberList modificationSubscriberList = null;
        if (preExit != null) {
            notificationSubscriberList = preExit.getNotificationSubscriberList();
            modificationSubscriberList = preExit.getModificationSubscriberList();
        }
        NotificationSubscriber[] notificationSubscriberArray = null;
        ModificationSubscriber[] modificationSubscriberArray = null;
        if (notificationSubscriberList != null) {
            notificationSubscriberArray = notificationSubscriberList.getNotificationSubscriberAsArray();
        }
        if (modificationSubscriberList != null) {
            modificationSubscriberArray = modificationSubscriberList.getModificationSubscriberAsArray();
        }
        Vector vector = this.getPreExitNotificationList();
        Vector vector2 = this.getPreExitModificationList();
        if (notificationSubscriberArray == null && vector.size() != 0) {
            bl = true;
        }
        if (modificationSubscriberArray == null && vector2.size() != 0) {
            bl = true;
        }
        if (!bl) {
            if (notificationSubscriberArray != null && vector.size() != notificationSubscriberArray.length) {
                bl = true;
            }
            if (modificationSubscriberArray != null && vector2.size() != modificationSubscriberArray.length) {
                bl = true;
            }
        }
        if (!bl) {
            bl = this.checkChangeInNotSubscriberList(notificationSubscriberArray, hashMap, vector);
        }
        if (!bl) {
            bl = this.checkChangeInModSubscriberList(modificationSubscriberArray, hashMap, vector2);
        }
        return bl;
    }

    public void setInlineExitExecList(ExitPointExecList exitPointExecList, String string) {
        String string2 = this.emitterName + "." + string;
        exitPointExecList.setName(string2);
        this.inlineExitNames.add(string2);
        this.exitPointMap.put(string2, exitPointExecList);
    }

    public void setPostExitExecList(ExitPointExecList exitPointExecList) {
        exitPointExecList.setName(this.postExitPointName);
        this.exitPointMap.put(this.postExitPointName, exitPointExecList);
    }

    public void setPreExitExecList(ExitPointExecList exitPointExecList) {
        exitPointExecList.setName(this.preExitPointName);
        this.exitPointMap.put(this.preExitPointName, exitPointExecList);
    }

    public String printEmitterReference() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("EmitterName: ").append(this.emitterName).append(newline);
        for (String string : this.exitPointMap.keySet()) {
            ExitPointExecList exitPointExecList = (ExitPointExecList)this.exitPointMap.get(string);
            stringBuffer.append("+++++++++++++++++++++++++++++" + newline);
            stringBuffer.append(exitPointExecList.printExitPointExecList());
            stringBuffer.append("+++++++++++++++++++++++++++++" + newline);
        }
        return stringBuffer.toString();
    }
}

