/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.pluginmanager;

import com.ibm.websphere.wim.exception.PluginConfigException;
import com.ibm.websphere.wim.exception.SubscriberException;
import com.ibm.websphere.wim.pluginmanager.context.PluginManagerConstants;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.Routines;
import com.ibm.ws.wim.configmodel.InlineExit;
import com.ibm.ws.wim.configmodel.ModificationSubscriber;
import com.ibm.ws.wim.configmodel.ModificationSubscriberList;
import com.ibm.ws.wim.configmodel.NotificationSubscriber;
import com.ibm.ws.wim.configmodel.NotificationSubscriberList;
import com.ibm.ws.wim.configmodel.PluginManagerConfigurationType;
import com.ibm.ws.wim.configmodel.PostExit;
import com.ibm.ws.wim.configmodel.PreExit;
import com.ibm.ws.wim.configmodel.SubscriberType;
import com.ibm.ws.wim.configmodel.TopicEmitter;
import com.ibm.ws.wim.configmodel.TopicRegistrationList;
import com.ibm.ws.wim.configmodel.TopicSubscriber;
import com.ibm.ws.wim.configmodel.TopicSubscriberList;
import com.ibm.ws.wim.pluginmanager.EmitterReference;
import com.ibm.ws.wim.pluginmanager.ExitPointExecList;
import com.ibm.ws.wim.pluginmanager.PGSubscriptionManager;
import com.ibm.ws.wim.pluginmanager.SubscriberRealmInfo;
import com.ibm.wsspi.wim.pluginmanager.Subscriber;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PGConfigManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = PGConfigManager.class.getName();
    private static Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static PGConfigManager instance;
    private PGSubscriptionManager subManager = null;

    private PGConfigManager() {
    }

    public static synchronized PGConfigManager getConfigurationManager() {
        PGConfigManager pGConfigManager = instance;
        if (pGConfigManager == null) {
            pGConfigManager = instance = new PGConfigManager();
        }
        return pGConfigManager;
    }

    private void checkForNullorEmptyString(String string, String string2) throws PluginConfigException {
        if (string == null || string.trim().equals("")) {
            throw new PluginConfigException(string2 + " is either null or empty for Subscriber.");
        }
    }

    private HashMap loadSubscribersFromList(TopicSubscriber[] topicSubscriberArray, PGSubscriptionManager pGSubscriptionManager) throws PluginConfigException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Routines.enterMethod(trcLogger, CLASSNAME, "loadSubscribersFromList", Level.FINEST);
        TopicSubscriber[] topicSubscriberArray2 = topicSubscriberArray;
        if (trcLogger.isLoggable(Level.FINE)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Loading a total of ").append(topicSubscriberArray.length).append(" Topic-Subscribers.");
            Routines.logMessage(trcLogger, CLASSNAME, "loadSubscribersFromList", Level.FINE, stringBuffer.toString());
        }
        for (int i = 0; i < topicSubscriberArray2.length; ++i) {
            String string = topicSubscriberArray2[i].getTopicSubscriberName();
            String string2 = topicSubscriberArray2[i].getClassName();
            SubscriberType subscriberType = topicSubscriberArray2[i].getTopicSubscriberType();
            this.checkForNullorEmptyString(string, "topicSubscriberName");
            this.checkForNullorEmptyString(string2, "className");
            this.checkForNullorEmptyString(subscriberType.getName(), "topicSubscriberType");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object object;
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    clazz = classLoader.loadClass(string2);
                }
                if (pGSubscriptionManager.isSubscriberAvailable(string)) {
                    Object object2;
                    object = pGSubscriptionManager.getSubscriber(string);
                    String string3 = object.getClass().getName();
                    if (string3.equals(string2)) continue;
                    if (trcLogger.isLoggable(Level.FINE)) {
                        object2 = new StringBuffer();
                        ((StringBuffer)object2).append("Re-registering subscriber ").append(string);
                        ((StringBuffer)object2).append(" Old-ClassName: ").append(string3);
                        ((StringBuffer)object2).append(" New-ClassName: ").append(string2);
                        Routines.logMessage(trcLogger, CLASSNAME, "loadSubscribersFromList", Level.FINE, ((StringBuffer)object2).toString());
                    }
                    object2 = (Subscriber)clazz.newInstance();
                    hashtable.put("topicSubscriberName", string);
                    object2.initSubscriber(hashtable);
                    pGSubscriptionManager.registerSubscriber(string, (Subscriber)object2);
                    hashMap.put(string, object2);
                    continue;
                }
                if (trcLogger.isLoggable(Level.FINE)) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("Registering subscriber '").append(string);
                    ((StringBuffer)object).append("' of type '").append(subscriberType.getName()).append("'");
                    ((StringBuffer)object).append(" with classame '").append(string2).append("'.");
                    Routines.logMessage(trcLogger, CLASSNAME, "loadSubscribersFromList", Level.FINE, ((StringBuffer)object).toString());
                }
                object = (Subscriber)clazz.newInstance();
                hashtable.put("topicSubscriberName", string);
                object.initSubscriber(hashtable);
                pGSubscriptionManager.registerSubscriber(string, (Subscriber)object);
                hashMap.put(string, object);
                continue;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new PluginConfigException("PLUGIN_MANAGER_SUBSCRIBER_NOT_FOUND_ERROR", new Object[]{string2, string}, Level.SEVERE, CLASSNAME, "loadSubscribersFromList", (Throwable)classNotFoundException);
            }
            catch (SubscriberException subscriberException) {
                throw new PluginConfigException("PLUGIN_MANAGER_SUBSCRIBER_LOAD_FAILURE", new Object[]{string}, Level.SEVERE, CLASSNAME, "loadSubscribersFromList", (Throwable)subscriberException);
            }
            catch (Exception exception) {
                throw new PluginConfigException("PLUGIN_MANAGER_SUBSCRIBER_LOAD_FAILURE", new Object[]{string}, Level.SEVERE, CLASSNAME, "loadSubscribersFromList", (Throwable)exception);
            }
        }
        Routines.exitMethod(trcLogger, CLASSNAME, "loadSubscribersFromList", Level.FINEST);
        return hashMap;
    }

    private EmitterReference createEmitterRef(TopicEmitter topicEmitter) throws PluginConfigException {
        String string = topicEmitter.getTopicEmitterName();
        PreExit preExit = topicEmitter.getPreExit();
        InlineExit[] inlineExitArray = topicEmitter.getInlineExitAsArray();
        PostExit postExit = topicEmitter.getPostExit();
        EmitterReference emitterReference = new EmitterReference(string);
        String string2 = PluginManagerConstants.PREEXIT_LITERAL.getName();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(PluginManagerConstants.INLINEEXIT_LITERAL.getName());
        String string3 = PluginManagerConstants.POSTEXIT_LITERAL.getName();
        ModificationSubscriberList modificationSubscriberList = null;
        NotificationSubscriberList notificationSubscriberList = null;
        ModificationSubscriber[] modificationSubscriberArray = null;
        NotificationSubscriber[] notificationSubscriberArray = null;
        ExitPointExecList exitPointExecList = null;
        if (preExit != null) {
            modificationSubscriberList = preExit.getModificationSubscriberList();
            notificationSubscriberList = preExit.getNotificationSubscriberList();
            if (modificationSubscriberList != null) {
                modificationSubscriberArray = modificationSubscriberList.getModificationSubscriberAsArray();
            }
            if (notificationSubscriberList != null) {
                notificationSubscriberArray = notificationSubscriberList.getNotificationSubscriberAsArray();
            }
            exitPointExecList = this.getExitPointExecList(string, string2, notificationSubscriberArray, modificationSubscriberArray);
            emitterReference.setPreExitExecList(exitPointExecList);
        } else {
            exitPointExecList = this.getExitPointExecList(string, string2, null, null);
            emitterReference.setPreExitExecList(exitPointExecList);
        }
        if (inlineExitArray != null) {
            for (int i = 0; i < inlineExitArray.length; ++i) {
                modificationSubscriberList = null;
                notificationSubscriberList = null;
                modificationSubscriberArray = null;
                notificationSubscriberArray = null;
                exitPointExecList = null;
                InlineExit inlineExit = inlineExitArray[i];
                String string4 = inlineExit.getInlineExitName();
                modificationSubscriberList = inlineExit.getModificationSubscriberList();
                if (modificationSubscriberList != null) {
                    modificationSubscriberArray = modificationSubscriberList.getModificationSubscriberAsArray();
                }
                stringBuffer.append(string4);
                if (emitterReference.doesInlineExist(string4)) {
                    throw new PluginConfigException("PLUGIN_MANAGER_MULTI_INLINE_DUPLICATE_NAME_ERROR", new Object[]{string4}, Level.SEVERE, CLASSNAME, "createEmitterRef");
                }
                exitPointExecList = this.getExitPointExecList(string, stringBuffer.toString(), null, modificationSubscriberArray);
                emitterReference.setInlineExitExecList(exitPointExecList, string4);
            }
        }
        modificationSubscriberList = null;
        notificationSubscriberList = null;
        modificationSubscriberArray = null;
        notificationSubscriberArray = null;
        exitPointExecList = null;
        if (postExit != null) {
            modificationSubscriberList = postExit.getModificationSubscriberList();
            notificationSubscriberList = postExit.getNotificationSubscriberList();
            if (modificationSubscriberList != null) {
                modificationSubscriberArray = modificationSubscriberList.getModificationSubscriberAsArray();
            }
            if (notificationSubscriberList != null) {
                notificationSubscriberArray = notificationSubscriberList.getNotificationSubscriberAsArray();
            }
            exitPointExecList = this.getExitPointExecList(string, string3, notificationSubscriberArray, modificationSubscriberArray);
            emitterReference.setPostExitExecList(exitPointExecList);
        } else {
            exitPointExecList = this.getExitPointExecList(string, string3, null, null);
            emitterReference.setPostExitExecList(exitPointExecList);
        }
        return emitterReference;
    }

    private boolean emitterHasChanged(PGSubscriptionManager pGSubscriptionManager, HashMap hashMap, TopicEmitter topicEmitter) {
        boolean bl = false;
        EmitterReference emitterReference = pGSubscriptionManager.getEmitter(topicEmitter.getTopicEmitterName());
        if (emitterReference != null && (emitterReference.isChangedPreExit(topicEmitter, hashMap) || emitterReference.isChangedInlineExits(topicEmitter, hashMap) || emitterReference.isChangedPostExit(topicEmitter, hashMap))) {
            bl = true;
        }
        return bl;
    }

    private HashMap loadEmittersFromList(TopicEmitter[] topicEmitterArray, PGSubscriptionManager pGSubscriptionManager, HashMap hashMap) throws PluginConfigException {
        String string = "loadEmittersFromList";
        Routines.enterMethod(trcLogger, CLASSNAME, string, Level.FINEST);
        HashMap<String, EmitterReference> hashMap2 = new HashMap<String, EmitterReference>();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < topicEmitterArray.length; ++i) {
            EmitterReference emitterReference;
            TopicEmitter topicEmitter = topicEmitterArray[i];
            String string2 = topicEmitter.getTopicEmitterName();
            if (hashSet.contains(string2)) {
                throw new PluginConfigException("PLUGIN_MANAGER_MULTI_TOPIC_EMITTER_DUPLICATE_NAME_ERROR", new Object[]{string2}, Level.SEVERE, CLASSNAME, string);
            }
            hashSet.add(string2);
            if (string2 == null) {
                throw new PluginConfigException("Please check the configuration file and set the attribute 'topicEmitterName' for an emitter.");
            }
            PreExit preExit = topicEmitter.getPreExit();
            InlineExit[] inlineExitArray = topicEmitter.getInlineExitAsArray();
            PostExit postExit = topicEmitter.getPostExit();
            if (pGSubscriptionManager.isEmitterAvailable(string2)) {
                if (!this.emitterHasChanged(pGSubscriptionManager, hashMap, topicEmitter)) continue;
                emitterReference = this.createEmitterRef(topicEmitter);
                pGSubscriptionManager.setEmitter(emitterReference);
                hashMap2.put(string2, emitterReference);
                continue;
            }
            emitterReference = this.createEmitterRef(topicEmitter);
            pGSubscriptionManager.setEmitter(emitterReference);
            hashMap2.put(string2, emitterReference);
        }
        Routines.exitMethod(trcLogger, CLASSNAME, string, Level.FINEST);
        return hashMap2;
    }

    private String invalidSubscriberTypeMsg(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(" point of Topic-Emitter '").append(string3);
        stringBuffer.append("' has a noncompliant Topic-Subscriber '").append(string4);
        stringBuffer.append("' of SubscriberType '").append(string2);
        stringBuffer.append("' stored in the ");
        String string5 = SubscriberType.MODIFICATION_SUBSCRIBER_LITERAL.getName();
        String string6 = SubscriberType.NOTIFICATION_SUBSCRIBER_LITERAL.getName();
        if (string2.equals(string5)) {
            stringBuffer.append(" NotificationList.");
        } else if (string2.equals(string6)) {
            stringBuffer.append(" ModificationList.");
        }
        return stringBuffer.toString();
    }

    private String makeSubscriberRefInvalidMsg(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append(" point of Topic-Emitter '").append(string3);
        stringBuffer.append("' has an invalid ").append(string2).append(" Reference ");
        stringBuffer.append("'").append(string4).append("' which is not found. ");
        stringBuffer.append("Please check the configuration file.");
        return stringBuffer.toString();
    }

    private ExitPointExecList getExitPointExecList(String string, String string2, NotificationSubscriber[] notificationSubscriberArray, ModificationSubscriber[] modificationSubscriberArray) throws PluginConfigException {
        SubscriberRealmInfo subscriberRealmInfo;
        HashSet hashSet;
        com.ibm.wsspi.wim.pluginmanager.SubscriberType subscriberType;
        Object object;
        String string3;
        int n;
        ExitPointExecList exitPointExecList = new ExitPointExecList(string);
        if (notificationSubscriberArray != null) {
            for (n = 0; n < notificationSubscriberArray.length; ++n) {
                string3 = notificationSubscriberArray[n].getNotificationSubscriberReference();
                if (this.subManager.isSubscriberAvailable(string3)) {
                    object = this.subManager.getSubscriber(string3);
                    subscriberType = object.getSubscriberType();
                    if (subscriberType.getValue() != 0) {
                        throw new PluginConfigException("PLUGIN_MANAGER_INVALID_SUBSCRIBER_TYPE_ERROR", new Object[]{string2, string, string3, subscriberType.getName()}, Level.SEVERE, CLASSNAME, "getExitPointExecList");
                    }
                } else {
                    object = SubscriberType.NOTIFICATION_SUBSCRIBER_LITERAL.getName();
                    throw new PluginConfigException("PLUGIN_MANAGER_INVALID_SUBSCRIBER_REF_ERROR", new Object[]{string2, string, object, string3}, Level.SEVERE, CLASSNAME, "getExitPointExecList");
                }
                hashSet = new HashSet(notificationSubscriberArray[n].getRealmList());
                subscriberRealmInfo = new SubscriberRealmInfo((Subscriber)object, hashSet);
                exitPointExecList.addNotificationSubscriber(subscriberRealmInfo);
            }
        }
        if (modificationSubscriberArray != null) {
            for (n = 0; n < modificationSubscriberArray.length; ++n) {
                string3 = modificationSubscriberArray[n].getModificationSubscriberReference();
                if (this.subManager.isSubscriberAvailable(string3)) {
                    object = this.subManager.getSubscriber(string3);
                    subscriberType = object.getSubscriberType();
                    if (subscriberType.getValue() != 1) {
                        throw new PluginConfigException("PLUGIN_MANAGER_INVALID_SUBSCRIBER_TYPE_ERROR", new Object[]{string2, string, string3, subscriberType.getName()}, Level.SEVERE, CLASSNAME, "getExitPointExecList");
                    }
                } else {
                    object = SubscriberType.MODIFICATION_SUBSCRIBER_LITERAL.getName();
                    throw new PluginConfigException("PLUGIN_MANAGER_INVALID_SUBSCRIBER_REF_ERROR", new Object[]{string2, string, object, string3}, Level.SEVERE, CLASSNAME, "getExitPointExecList");
                }
                hashSet = new HashSet(modificationSubscriberArray[n].getRealmList());
                subscriberRealmInfo = new SubscriberRealmInfo((Subscriber)object, hashSet);
                exitPointExecList.addModificationSubscriber(subscriberRealmInfo);
            }
        }
        return exitPointExecList;
    }

    public void initializeConfiguration(PluginManagerConfigurationType pluginManagerConfigurationType, PGSubscriptionManager pGSubscriptionManager) throws PluginConfigException {
        Object object;
        Object object2;
        String string = "initializeConfiguration";
        Routines.enterMethod(trcLogger, CLASSNAME, string, Level.FINEST);
        this.subManager = pGSubscriptionManager;
        TopicSubscriberList topicSubscriberList = pluginManagerConfigurationType.getTopicSubscriberList();
        TopicRegistrationList topicRegistrationList = pluginManagerConfigurationType.getTopicRegistrationList();
        HashMap hashMap = this.loadSubscribersFromList(topicSubscriberList.getTopicSubscriberAsArray(), pGSubscriptionManager);
        if (hashMap.size() > 0) {
            Routines.logMessage(trcLogger, CLASSNAME, string, Level.FINER, "Changed Subscriber List --> BEGIN");
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                String string2 = (String)object2.next();
                Object object3 = (Subscriber)hashMap.get(string2);
                object = new StringBuffer();
                ((StringBuffer)object).append(" SubscriberName: ").append(object3.getSubscriberName());
                ((StringBuffer)object).append(" SubscriberType: ").append(object3.getSubscriberType().getName());
                ((StringBuffer)object).append(" SubscriberClass: ").append(object3.getClass().getName());
                Routines.logMessage(trcLogger, CLASSNAME, string, Level.FINER, ((StringBuffer)object).toString());
            }
            Routines.logMessage(trcLogger, CLASSNAME, string, Level.FINER, "Changed Subscriber List --> END");
        }
        if (((HashMap)(object2 = this.loadEmittersFromList(topicRegistrationList.getTopicEmitterAsArray(), pGSubscriptionManager, hashMap))).size() > 0) {
            Routines.logMessage(trcLogger, CLASSNAME, string, Level.FINER, "Changed Emitter List --> BEGIN");
            for (Object object3 : ((HashMap)object2).keySet()) {
                object = (EmitterReference)((HashMap)object2).get(object3);
                Routines.logMessage(trcLogger, CLASSNAME, string, Level.FINER, ((EmitterReference)object).printEmitterReference());
            }
            Routines.logMessage(trcLogger, CLASSNAME, string, Level.FINER, "Changed Emitter List --> END");
        }
        Routines.exitMethod(trcLogger, CLASSNAME, string, Level.FINEST);
    }
}

