/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.pluginmanager;

import com.ibm.websphere.wim.exception.SubscriberException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.Routines;
import com.ibm.ws.wim.pluginmanager.EmitterReference;
import com.ibm.ws.wim.pluginmanager.ExitPointExecList;
import com.ibm.wsspi.wim.pluginmanager.Subscriber;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PGSubscriptionManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = PGSubscriptionManager.class.getName();
    private static Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static PGSubscriptionManager instance;
    private HashMap subscriberMap = new HashMap();
    private HashMap emitterRegistrations = new HashMap();
    private HashMap emptyTopicEmitterList = new HashMap();

    public void clearAllSubscriptions() {
        this.subscriberMap.clear();
        this.emitterRegistrations.clear();
        this.emptyTopicEmitterList.clear();
    }

    public void printSubscriptions() {
        String string = "printSubscriptions";
        StringBuffer stringBuffer = new StringBuffer();
        if (trcLogger.isLoggable(Level.FINEST)) {
            Object object;
            stringBuffer.append("Subscribers List: BEGIN ---------->\n");
            for (String string2 : this.subscriberMap.keySet()) {
                object = (Subscriber)this.subscriberMap.get(string2);
                stringBuffer.append(" SubscriberName: " + object.getSubscriberName());
                stringBuffer.append(" SubscriberType: " + object.getSubscriberType().getName());
                stringBuffer.append(" SubscriberClass: " + object.getClass().getName()).append("\n");
            }
            stringBuffer.append("Subscribers List: END ---------->\n");
            stringBuffer.append("EmitterRegistration List: BEGIN ---------------\n");
            for (String string2 : this.emitterRegistrations.keySet()) {
                object = (EmitterReference)this.emitterRegistrations.get(string2);
                stringBuffer.append(((EmitterReference)object).printEmitterReference());
            }
            stringBuffer.append("EmitterRegistration List: END --------------->\n");
            Routines.logMessage(trcLogger, CLASSNAME, string, Level.FINEST, stringBuffer.toString());
        }
    }

    private PGSubscriptionManager() {
    }

    public static PGSubscriptionManager getSubscriptionManager() {
        PGSubscriptionManager pGSubscriptionManager = instance;
        if (pGSubscriptionManager == null) {
            pGSubscriptionManager = instance = new PGSubscriptionManager();
        }
        return pGSubscriptionManager;
    }

    public void setEmitter(EmitterReference emitterReference) {
        String string = emitterReference.getEmitterName();
        this.emitterRegistrations.put(string, emitterReference);
    }

    public EmitterReference getEmitter(String string) {
        EmitterReference emitterReference = null;
        if (this.emitterRegistrations.containsKey(string)) {
            emitterReference = (EmitterReference)this.emitterRegistrations.get(string);
        }
        return emitterReference;
    }

    public boolean isEmitterEmpty(String string) {
        boolean bl = true;
        if (this.emptyTopicEmitterList.containsKey(string)) {
            Boolean bl2 = (Boolean)this.emptyTopicEmitterList.get(string);
            bl = bl2;
        } else {
            EmitterReference emitterReference = this.getEmitter(string);
            int n = 0;
            Vector vector = emitterReference.getPreExitModificationList();
            if (vector != null) {
                n += vector.size();
            }
            if ((vector = emitterReference.getPreExitNotificationList()) != null) {
                n += vector.size();
            }
            if ((vector = emitterReference.getPostExitModificationList()) != null) {
                n += vector.size();
            }
            if ((vector = emitterReference.getPostExitNotificationList()) != null) {
                n += vector.size();
            }
            ExitPointExecList[] exitPointExecListArray = emitterReference.getInlineExits();
            for (int i = 0; exitPointExecListArray != null && i < exitPointExecListArray.length; ++i) {
                vector = exitPointExecListArray[i].getModificationList();
                if (vector == null) continue;
                n += vector.size();
            }
            if (n > 0) {
                bl = false;
                this.emptyTopicEmitterList.put(string, false);
            } else {
                this.emptyTopicEmitterList.put(string, true);
            }
        }
        return bl;
    }

    public boolean isEmitterAvailable(String string) {
        return this.emitterRegistrations.containsKey(string);
    }

    public void registerSubscriber(String string, Subscriber subscriber) {
        this.subscriberMap.put(string, subscriber);
    }

    public boolean isSubscriberAvailable(String string) {
        return this.subscriberMap.containsKey(string);
    }

    public Subscriber getSubscriber(String string) {
        return (Subscriber)this.subscriberMap.get(string);
    }

    public void shutdownSubscribers() {
        String string = "shutdownSubscribers";
        Iterator iterator = this.subscriberMap.keySet().iterator();
        while (iterator.hasNext()) {
            Subscriber subscriber = (Subscriber)this.subscriberMap.get(iterator.next());
            try {
                subscriber.shutdownSubscriber();
            }
            catch (SubscriberException subscriberException) {
                Routines.logException(trcLogger, CLASSNAME, string, Level.WARNING, subscriberException.getReasonString(), subscriberException);
            }
        }
    }
}

