/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.pluginmanager;

import com.ibm.websphere.wim.exception.PluginConfigException;
import com.ibm.websphere.wim.exception.SubscriberCriticalException;
import com.ibm.websphere.wim.exception.SubscriberException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.pluginmanager.context.ContextFactory;
import com.ibm.websphere.wim.pluginmanager.context.EmitterExceptionContext;
import com.ibm.websphere.wim.pluginmanager.context.ExceptionContext;
import com.ibm.websphere.wim.pluginmanager.context.InlineExitContext;
import com.ibm.websphere.wim.pluginmanager.context.ModificationListContext;
import com.ibm.websphere.wim.pluginmanager.context.ModificationSubscriberContext;
import com.ibm.websphere.wim.pluginmanager.context.NotificationListContext;
import com.ibm.websphere.wim.pluginmanager.context.NotificationSubscriberContext;
import com.ibm.websphere.wim.pluginmanager.context.PluginManagerConstants;
import com.ibm.websphere.wim.pluginmanager.context.PostExitContext;
import com.ibm.websphere.wim.pluginmanager.context.PreExitContext;
import com.ibm.websphere.wim.pluginmanager.context.SubscriberExecContext;
import com.ibm.websphere.wim.pluginmanager.context.SubscriberExecStatus;
import com.ibm.websphere.wim.pluginmanager.context.UIDContext;
import com.ibm.websphere.wim.pluginmanager.context.impl.ContextFactoryImpl;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.Routines;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.PluginManagerConfigurationType;
import com.ibm.ws.wim.configmodel.TopicEmitter;
import com.ibm.ws.wim.configmodel.TopicRegistrationList;
import com.ibm.ws.wim.pluginmanager.DefaultPluginManagerConfig;
import com.ibm.ws.wim.pluginmanager.EmitterReference;
import com.ibm.ws.wim.pluginmanager.PGConfigManager;
import com.ibm.ws.wim.pluginmanager.PGSubscriptionManager;
import com.ibm.ws.wim.pluginmanager.RuntimeEmitterContext;
import com.ibm.ws.wim.pluginmanager.SubscriberRealmInfo;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import com.ibm.wsspi.wim.pluginmanager.ModificationSubscriber;
import com.ibm.wsspi.wim.pluginmanager.NotificationSubscriber;
import com.ibm.wsspi.wim.pluginmanager.Subscriber;
import commonj.sdo.DataObject;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = PluginManager.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static PluginManager instance = null;
    private static PGConfigManager configManager;
    private static PGSubscriptionManager subscriptionManager;
    private static ContextFactory expContextFactory;
    private ConcurrentHashMap transInProcess;
    private boolean inShutdownProcess;

    private PluginManager() throws PluginConfigException, WIMException {
        this.initPluginManagerConfiguration();
        this.inShutdownProcess = false;
        this.transInProcess = new ConcurrentHashMap();
    }

    private void initPluginManagerConfiguration() throws PluginConfigException, WIMException {
        ConfigurationProviderType configurationProviderType = (ConfigurationProviderType)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                return ConfigManager.singleton().getConfig();
            }
        });
        configManager = PGConfigManager.getConfigurationManager();
        subscriptionManager = PGSubscriptionManager.getSubscriptionManager();
        PluginManagerConfigurationType pluginManagerConfigurationType = configurationProviderType.getPluginManagerConfiguration();
        if (pluginManagerConfigurationType == null) {
            pluginManagerConfigurationType = configurationProviderType.createPluginManagerConfiguration();
            this.initPluginManager(pluginManagerConfigurationType, true);
        } else {
            this.initPluginManager(pluginManagerConfigurationType, false);
        }
    }

    public void initPluginManager(PluginManagerConfigurationType pluginManagerConfigurationType, boolean bl) throws PluginConfigException {
        trcLogger.entering(CLASSNAME, "initPluginManager", "emptyConfig=" + bl);
        if (bl) {
            pluginManagerConfigurationType.createTopicRegistrationList();
            pluginManagerConfigurationType.createTopicSubscriberList();
            TopicRegistrationList topicRegistrationList = pluginManagerConfigurationType.getTopicRegistrationList();
            Vector vector = DefaultPluginManagerConfig.getDefaultVectorList();
            for (String string : vector) {
                TopicEmitter topicEmitter = topicRegistrationList.createTopicEmitter();
                topicEmitter.setTopicEmitterName(string);
            }
        }
        configManager.initializeConfiguration(pluginManagerConfigurationType, subscriptionManager);
        trcLogger.exiting(CLASSNAME, "initPluginManager");
    }

    public void shutdownPluginManager() {
        this.inShutdownProcess = true;
        subscriptionManager.shutdownSubscribers();
    }

    public static PluginManager getPluginManager() throws PluginConfigException, WIMException {
        PluginManager pluginManager = instance;
        if (instance == null) {
            pluginManager = instance = new PluginManager();
        }
        return pluginManager;
    }

    public static PluginManager singleton() throws PluginConfigException, WIMException {
        return PluginManager.getPluginManager();
    }

    private ModificationSubscriberContext createModificationSubContext(EmitterExceptionContext emitterExceptionContext, String string, int n, Throwable throwable) {
        ModificationSubscriberContext modificationSubscriberContext = null;
        SubscriberExecContext subscriberExecContext = null;
        ModificationListContext modificationListContext = null;
        String string2 = emitterExceptionContext.getTopicEmitterName();
        switch (n) {
            case 0: {
                PreExitContext preExitContext = emitterExceptionContext.getPreExit();
                preExitContext.setFailedSubscriber(string2);
                preExitContext.setIsSuccessful(false);
                modificationListContext = preExitContext.getModificationListContext();
                modificationSubscriberContext = modificationListContext.createSubscriberExecuteContext();
                break;
            }
            case 2: {
                PostExitContext postExitContext = emitterExceptionContext.getPostExit();
                postExitContext.setFailedSubscriber(string2);
                postExitContext.setIsSuccessful(false);
                modificationListContext = postExitContext.getModificationListContext();
                modificationSubscriberContext = modificationListContext.createSubscriberExecuteContext();
                break;
            }
            case 1: {
                InlineExitContext inlineExitContext = emitterExceptionContext.getInlineExitContext(string);
                inlineExitContext.setFailedSubscriber(string2);
                inlineExitContext.setIsSuccessful(false);
                modificationListContext = inlineExitContext.getModificationListContext();
                modificationSubscriberContext = modificationListContext.createSubscriberExecuteContext();
                break;
            }
        }
        emitterExceptionContext.setAnyPluginFailure(false);
        modificationSubscriberContext.setSubscriberName(string2);
        subscriberExecContext = modificationSubscriberContext.createExecuteContext();
        if (throwable instanceof SubscriberException) {
            this.setExceptionContext(subscriberExecContext, (SubscriberException)throwable);
        } else {
            subscriberExecContext.setReasonString(throwable.getMessage());
            subscriberExecContext.setExceptionMsg(Routines.getErrorMessage(throwable));
            subscriberExecContext.setStatus(SubscriberExecStatus.FAILURE_LITERAL);
        }
        return modificationSubscriberContext;
    }

    private NotificationSubscriberContext createNotificationSubContext(EmitterExceptionContext emitterExceptionContext, int n, String string, Throwable throwable) {
        NotificationListContext notificationListContext = null;
        NotificationSubscriberContext notificationSubscriberContext = null;
        SubscriberExecContext subscriberExecContext = null;
        switch (n) {
            case 0: {
                PreExitContext preExitContext = emitterExceptionContext.getPreExit();
                preExitContext.setFailedSubscriber(string);
                preExitContext.setIsSuccessful(false);
                notificationListContext = preExitContext.getNotificationListContext();
                notificationSubscriberContext = notificationListContext.createSubscriberExecuteContext();
                break;
            }
            case 2: {
                PostExitContext postExitContext = emitterExceptionContext.getPostExit();
                postExitContext.setFailedSubscriber(string);
                postExitContext.setIsSuccessful(false);
                notificationListContext = postExitContext.getNotificationListContext();
                notificationSubscriberContext = notificationListContext.createSubscriberExecuteContext();
                break;
            }
        }
        notificationSubscriberContext.setSubscriberName(string);
        subscriberExecContext = notificationSubscriberContext.createExecuteContext();
        if (throwable instanceof SubscriberException) {
            this.setExceptionContext(subscriberExecContext, (SubscriberException)throwable);
        } else {
            subscriberExecContext.setReasonString(throwable.getMessage());
            subscriberExecContext.setExceptionMsg(Routines.getErrorMessage(throwable));
            subscriberExecContext.setStatus(SubscriberExecStatus.FAILURE_LITERAL);
        }
        return notificationSubscriberContext;
    }

    private void recoveryExecSubscriberList(HashSet hashSet, int n, String string, String string2, String string3, ExceptionContext exceptionContext) {
        String string4 = "recoveryExecSubscriberList";
        for (SubscriberRealmInfo subscriberRealmInfo : hashSet) {
            Subscriber subscriber = subscriberRealmInfo.getSubscriber();
            String string5 = subscriberRealmInfo.getSubscriberName();
            Routines.logMessage(trcLogger, CLASSNAME, string4, Level.FINEST, string5);
            try {
                subscriber.recovery(string2, n, string, exceptionContext);
            }
            catch (SubscriberException subscriberException) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Exception occured during recovery of subscriber '");
                stringBuffer.append(subscriber.getSubscriberName());
                stringBuffer.append("' of Topic-Emitter '").append(string2).append("'.");
                Routines.logException(trcLogger, CLASSNAME, string4, Level.FINE, stringBuffer.toString(), subscriberException);
            }
        }
    }

    private NotificationListContext getNotificationListContext(int n, EmitterExceptionContext emitterExceptionContext) {
        NotificationListContext notificationListContext = null;
        switch (n) {
            case 0: {
                notificationListContext = emitterExceptionContext.getPreExit().getNotificationListContext();
                if (notificationListContext != null) break;
                notificationListContext = emitterExceptionContext.getPreExit().createNotificationListContext();
                break;
            }
            case 2: {
                notificationListContext = emitterExceptionContext.getPostExit().getNotificationListContext();
                if (notificationListContext != null) break;
                notificationListContext = emitterExceptionContext.getPostExit().createNotificationListContext();
            }
        }
        return notificationListContext;
    }

    private ModificationListContext getModificationListContext(int n, EmitterExceptionContext emitterExceptionContext, String string) {
        ModificationListContext modificationListContext = null;
        switch (n) {
            case 0: {
                modificationListContext = emitterExceptionContext.getPreExit().getModificationListContext();
                if (modificationListContext != null) break;
                modificationListContext = emitterExceptionContext.getPreExit().createModificationListContext();
                break;
            }
            case 2: {
                modificationListContext = emitterExceptionContext.getPostExit().getModificationListContext();
                if (modificationListContext != null) break;
                modificationListContext = emitterExceptionContext.getPostExit().createModificationListContext();
                break;
            }
            case 1: {
                modificationListContext = emitterExceptionContext.getInlineExitContext(string).getModificationListContext();
                if (modificationListContext != null) break;
                modificationListContext = emitterExceptionContext.getInlineExitContext(string).createModificationListContext();
            }
        }
        return modificationListContext;
    }

    private boolean initModifyExecute(HashSet hashSet, HashSet hashSet2, Vector vector, ExceptionContext exceptionContext, EmitterExceptionContext emitterExceptionContext, DataObject dataObject, DataObject dataObject2, String string, int n, String string2) throws SubscriberCriticalException {
        boolean bl = true;
        boolean bl2 = false;
        String string3 = emitterExceptionContext.getTopicEmitterName();
        ModificationListContext modificationListContext = this.getModificationListContext(n, emitterExceptionContext, string2);
        Iterator iterator = vector.iterator();
        DataObject dataObject3 = null;
        DataObject dataObject4 = null;
        if (dataObject != null) {
            dataObject3 = dataObject.getDataGraph().getRootObject().getDataObject("Root");
        }
        if (dataObject2 != null) {
            dataObject4 = dataObject2.getDataGraph().getRootObject().getDataObject("Root");
        }
        int n2 = 0;
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            Object object3;
            SubscriberRealmInfo subscriberRealmInfo = (SubscriberRealmInfo)iterator.next();
            HashSet hashSet3 = subscriberRealmInfo.getRealmSet();
            ModificationSubscriber modificationSubscriber = (ModificationSubscriber)subscriberRealmInfo.getSubscriber();
            String string4 = subscriberRealmInfo.getSubscriberName();
            try {
                boolean bl3 = false;
                if (hashSet3.contains("All") || string != null && hashSet3.contains(string)) {
                    Routines.logMessage(trcLogger, CLASSNAME, "initModifyExecute", Level.FINEST, string4);
                    ++n2;
                    switch (n) {
                        case 0: {
                            bl2 = modificationSubscriber.preExitCall(string3, dataObject3);
                            break;
                        }
                        case 2: {
                            bl2 = modificationSubscriber.postExitCall(string3, dataObject3, dataObject4);
                            break;
                        }
                        case 1: {
                            bl2 = modificationSubscriber.inlineExitCall(string3, dataObject3, string2);
                        }
                    }
                    this.addExecutedSubscriber(hashSet2, subscriberRealmInfo);
                    hashSet.add(subscriberRealmInfo);
                    bl3 = true;
                    if (!bl2) {
                        bl = false;
                        modificationListContext.setVetoed(true);
                        modificationListContext.setVetoSubscriberName(string4);
                        Routines.logMessage(trcLogger, CLASSNAME, "initModifyExecute", Level.FINEST, string4 + " has vetoed.");
                    }
                }
                if (!bl3 || (object3 = modificationListContext.getSubscriberExecuteContextAsArray()) != null && ((ModificationSubscriberContext[])object3).length >= n2) continue;
                object2 = modificationListContext.createSubscriberExecuteContext();
                object2.setSubscriberName(modificationSubscriber.getSubscriberName());
                object = object2.createExecuteContext();
                object.setStatus(SubscriberExecStatus.SUCCESS_LITERAL);
            }
            catch (Throwable throwable) {
                Routines.logException(trcLogger, CLASSNAME, "initModifyExecute", Level.WARNING, "", throwable);
                object3 = this.createModificationSubContext(emitterExceptionContext, string2, n, throwable);
                object2 = object3.getExecuteContext();
                this.setFailedSubscriberContext(emitterExceptionContext, n, string2, string4);
                object = null;
                boolean bl4 = true;
                if (throwable instanceof SubscriberException) {
                    object = (SubscriberException)throwable;
                    this.setExceptionContext((SubscriberExecContext)object2, (SubscriberException)object);
                    bl4 = false;
                }
                if (!bl4 && (object == null || !((Object)((Object)((SubscriberException)object).getStatus())).equals((Object)SubscriberExecStatus.FAILURE_LITERAL))) continue;
                throw new SubscriberCriticalException(string4, emitterExceptionContext, throwable);
            }
        }
        return bl;
    }

    private void commitOrRollback(boolean bl, HashSet hashSet, DataObject dataObject, EmitterExceptionContext emitterExceptionContext, int n, String string) throws SubscriberCriticalException {
        String string2 = "initiateCommit";
        Iterator iterator = hashSet.iterator();
        String string3 = emitterExceptionContext.getTopicEmitterName();
        ModificationListContext modificationListContext = this.getModificationListContext(n, emitterExceptionContext, string);
        DataObject dataObject2 = null;
        if (dataObject != null) {
            dataObject2 = dataObject.getDataGraph().getRootObject().getDataObject("Root");
        }
        while (iterator.hasNext()) {
            SubscriberRealmInfo subscriberRealmInfo = (SubscriberRealmInfo)iterator.next();
            ModificationSubscriber modificationSubscriber = (ModificationSubscriber)subscriberRealmInfo.getSubscriber();
            String string4 = modificationSubscriber.getSubscriberName();
            Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, string4);
            try {
                if (bl) {
                    modificationSubscriber.commit(string3, dataObject2, n, string);
                    continue;
                }
                modificationSubscriber.rollback(string3, dataObject2, n, string);
            }
            catch (Throwable throwable) {
                ModificationSubscriberContext modificationSubscriberContext = modificationListContext.getSubscriberExecuteContext(string4);
                SubscriberExecContext subscriberExecContext = null;
                subscriberExecContext = bl ? modificationSubscriberContext.createCommitContext() : modificationSubscriberContext.createRollbackContext();
                this.setFailedSubscriberContext(emitterExceptionContext, n, string, string4);
                SubscriberException subscriberException = null;
                boolean bl2 = true;
                if (throwable instanceof SubscriberException) {
                    subscriberException = (SubscriberException)throwable;
                    this.setExceptionContext(subscriberExecContext, subscriberException);
                    bl2 = false;
                    Routines.logException(trcLogger, CLASSNAME, string2, Level.WARNING, subscriberException.getReasonString(), throwable);
                } else {
                    subscriberExecContext.setReasonString(throwable.getMessage());
                    subscriberExecContext.setExceptionMsg(Routines.getErrorMessage(throwable));
                    subscriberExecContext.setStatus(SubscriberExecStatus.FAILURE_LITERAL);
                    Routines.logException(trcLogger, CLASSNAME, string2, Level.WARNING, throwable.getMessage(), throwable);
                }
                if (!bl2 && (subscriberException == null || !((Object)((Object)subscriberException.getStatus())).equals((Object)SubscriberExecStatus.FAILURE_LITERAL))) continue;
                throw new SubscriberCriticalException(string4, emitterExceptionContext, throwable);
            }
        }
    }

    private void setFailedSubscriberContext(EmitterExceptionContext emitterExceptionContext, int n, String string, String string2) {
        switch (n) {
            case 0: {
                PreExitContext preExitContext = emitterExceptionContext.getPreExit();
                preExitContext.setIsSuccessful(false);
                preExitContext.setFailedSubscriber(string2);
                break;
            }
            case 2: {
                PostExitContext postExitContext = emitterExceptionContext.getPostExit();
                postExitContext.setIsSuccessful(false);
                postExitContext.setFailedSubscriber(string2);
                break;
            }
            case 1: {
                InlineExitContext inlineExitContext = emitterExceptionContext.getInlineExitContext(string);
                inlineExitContext.setIsSuccessful(false);
                inlineExitContext.setFailedSubscriber(string2);
                break;
            }
        }
    }

    private void addExecutedSubscriber(HashSet hashSet, SubscriberRealmInfo subscriberRealmInfo) {
        Iterator iterator = hashSet.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            SubscriberRealmInfo subscriberRealmInfo2 = (SubscriberRealmInfo)iterator.next();
            if (!subscriberRealmInfo2.getSubscriberName().equals(subscriberRealmInfo.getSubscriberName())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            hashSet.add(subscriberRealmInfo);
        }
    }

    public void initNotifyExecute(HashSet hashSet, Vector vector, ExceptionContext exceptionContext, EmitterExceptionContext emitterExceptionContext, DataObject dataObject, DataObject dataObject2, String string, int n, String string2) throws SubscriberCriticalException {
        String string3 = "initNotifyExecute";
        NotificationListContext notificationListContext = this.getNotificationListContext(n, emitterExceptionContext);
        Iterator iterator = vector.iterator();
        int n2 = 0;
        DataObject dataObject3 = null;
        DataObject dataObject4 = null;
        if (dataObject != null) {
            dataObject3 = dataObject.getDataGraph().getRootObject().getDataObject("Root");
        }
        if (dataObject2 != null) {
            dataObject4 = dataObject2.getDataGraph().getRootObject().getDataObject("Root");
        }
        String string4 = emitterExceptionContext.getTopicEmitterName();
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            NotificationSubscriberContext[] notificationSubscriberContextArray;
            SubscriberRealmInfo subscriberRealmInfo = (SubscriberRealmInfo)iterator.next();
            HashSet hashSet2 = subscriberRealmInfo.getRealmSet();
            NotificationSubscriber notificationSubscriber = (NotificationSubscriber)subscriberRealmInfo.getSubscriber();
            String string5 = subscriberRealmInfo.getSubscriberName();
            try {
                boolean bl = false;
                if (hashSet2.contains("All") || string != null && hashSet2.contains(string)) {
                    Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, string5);
                    ++n2;
                    switch (n) {
                        case 0: {
                            notificationSubscriber.preExitCall(string4, dataObject3);
                            break;
                        }
                        case 2: {
                            notificationSubscriber.postExitCall(string4, dataObject3, dataObject4);
                        }
                    }
                    this.addExecutedSubscriber(hashSet, subscriberRealmInfo);
                    bl = true;
                }
                if (!bl || (notificationSubscriberContextArray = notificationListContext.getSubscriberExecuteContextAsArray()) != null && notificationSubscriberContextArray.length >= n2) continue;
                object2 = notificationListContext.createSubscriberExecuteContext();
                object2.setSubscriberName(notificationSubscriber.getSubscriberName());
                object = object2.createExecuteContext();
                object.setStatus(SubscriberExecStatus.SUCCESS_LITERAL);
            }
            catch (Throwable throwable) {
                notificationSubscriberContextArray = this.createNotificationSubContext(emitterExceptionContext, n, string5, throwable);
                object2 = notificationSubscriberContextArray.getExecuteContext();
                object = null;
                boolean bl = true;
                if (throwable instanceof SubscriberException) {
                    object = (SubscriberException)throwable;
                    this.setExceptionContext((SubscriberExecContext)object2, (SubscriberException)object);
                    bl = false;
                } else {
                    object2.setReasonString(throwable.getMessage());
                    object2.setExceptionMsg(Routines.getErrorMessage(throwable));
                    object2.setStatus(SubscriberExecStatus.FAILURE_LITERAL);
                }
                if (!bl && (object == null || !((Object)((Object)((SubscriberException)object).getStatus())).equals((Object)SubscriberExecStatus.FAILURE_LITERAL))) continue;
                throw new SubscriberCriticalException(string5, emitterExceptionContext, throwable);
            }
        }
    }

    private void setExceptionContext(SubscriberExecContext subscriberExecContext, SubscriberException subscriberException) {
        subscriberExecContext.setExceptionMsg(subscriberException.getExceptionMsg());
        subscriberExecContext.setStatus(subscriberException.getStatus());
        subscriberExecContext.setReasonCode(subscriberException.getReasonCode());
        subscriberExecContext.setReasonString(subscriberException.getReasonString());
    }

    public DataObject preExitCall(String string, DataObject dataObject) throws SubscriberCriticalException {
        String string2 = "preExitCall";
        if (this.inShutdownProcess) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("PluginManager in shutdown mode or is shutdown.");
            throw new SubscriberCriticalException(stringBuffer.toString());
        }
        if (subscriptionManager.isEmitterAvailable(string) && subscriptionManager.isEmitterEmpty(string)) {
            Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINE, string + " emitter function doesnot have any subscribers.");
            return dataObject;
        }
        int n = 0;
        String string3 = PluginManagerConstants.PREEXIT_LITERAL.getName();
        DataObject dataObject2 = dataObject;
        if (subscriptionManager.isEmitterAvailable(string)) {
            Object object;
            Object object2;
            String string4 = Routines.getUniqueID();
            EmitterReference emitterReference = subscriptionManager.getEmitter(string);
            RuntimeEmitterContext runtimeEmitterContext = new RuntimeEmitterContext(emitterReference);
            HashSet hashSet = runtimeEmitterContext.getExecutedSubscriberList();
            this.transInProcess.put(string4, runtimeEmitterContext);
            DataObject dataObject3 = dataObject.getDataGraph().getRootObject().getDataObject("Root");
            List list = dataObject3.getList("contexts");
            String string5 = null;
            DataObject dataObject4 = null;
            DataObject dataObject5 = null;
            for (int i = 0; i < list.size(); ++i) {
                object2 = (DataObject)list.get(i);
                object = object2.getString("key");
                if (object != null && ((String)object).equals(PluginManagerConstants.REALM_LITERAL.getName())) {
                    string5 = object2.getString("value");
                    continue;
                }
                if (object != null && ((String)object).equals(PluginManagerConstants.PLUGIN_UID_CONTEXT_LITERAL.getName())) {
                    dataObject4 = object2;
                    continue;
                }
                if (object == null || !((String)object).equals(PluginManagerConstants.PLUGIN_EXCEPTION_CONTEXT_LITERAL.getName())) continue;
                dataObject5 = object2;
            }
            Object var16_18 = null;
            object2 = null;
            object = null;
            if (dataObject4 != null) {
                object2 = (UIDContext)dataObject4.get("value");
            } else {
                dataObject4 = dataObject3.createDataObject("contexts");
                object2 = expContextFactory.createUIDContext();
                dataObject4.set("key", (Object)PluginManagerConstants.PLUGIN_UID_CONTEXT_LITERAL.getName());
                dataObject4.set("value", object2);
            }
            if (dataObject5 != null) {
                object = (ExceptionContext)dataObject5.get("value");
            } else {
                dataObject5 = dataObject3.createDataObject("contexts");
                object = expContextFactory.createExceptionContext();
                dataObject5.set("key", (Object)PluginManagerConstants.PLUGIN_EXCEPTION_CONTEXT_LITERAL.getName());
                dataObject5.set("value", object);
            }
            EmitterExceptionContext emitterExceptionContext = object.createEmitterExceptionContext();
            emitterExceptionContext.setTopicEmitterName(string);
            emitterExceptionContext.setAnyPluginFailure(false);
            PreExitContext preExitContext = emitterExceptionContext.createPreExit();
            preExitContext.setIsSuccessful(true);
            object2.getUID().add(string4);
            String string6 = string + ".preExit";
            Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN " + string6);
            try {
                Vector vector = emitterReference.getPreExitNotificationList();
                Vector vector2 = emitterReference.getPreExitModificationList();
                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Execute Notification Subscribers --->");
                if (!vector.isEmpty()) {
                    this.initNotifyExecute(hashSet, vector, (ExceptionContext)object, emitterExceptionContext, dataObject, null, string5, n, null);
                }
                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Execute Notification Subscribers <---");
                HashSet hashSet2 = new HashSet();
                if (!vector2.isEmpty()) {
                    Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Execute Modification Subscribers --->");
                    boolean bl = this.initModifyExecute(hashSet2, hashSet, vector2, (ExceptionContext)object, emitterExceptionContext, dataObject, null, string5, n, null);
                    Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Execute Modification Subscribers <---");
                    if (bl) {
                        Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Commit Modification Subscribers --->");
                        this.commitOrRollback(true, hashSet2, dataObject, emitterExceptionContext, n, null);
                        Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Commit Modification Subscribers <---");
                    } else {
                        Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Rollback Modification Subscribers --->");
                        this.commitOrRollback(false, hashSet2, dataObject, emitterExceptionContext, n, null);
                        Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Rollback Modification Subscribers <---");
                    }
                }
            }
            catch (SubscriberCriticalException subscriberCriticalException) {
                emitterExceptionContext.setAnyPluginFailure(true);
                preExitContext.setIsSuccessful(false);
                preExitContext.setFailedSubscriber(subscriberCriticalException.getCriticalSubscriber());
                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "Failed Subscriber: " + subscriberCriticalException.getCriticalSubscriber());
                this.transInProcess.remove(string4);
                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Recovery for Subscribers --->");
                this.recoveryExecSubscriberList(hashSet, n, null, string, string3, (ExceptionContext)object);
                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Recovery for Subscribers <---");
                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END " + string6);
                throw subscriberCriticalException;
            }
            Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END " + string6);
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, string2, "Topic-Emitter " + string + " is not configured.");
        }
        return dataObject2;
    }

    public DataObject inlineExitCall(String string, DataObject dataObject, String string2) throws SubscriberCriticalException {
        if (subscriptionManager.isEmitterAvailable(string) && subscriptionManager.isEmitterEmpty(string)) {
            return dataObject;
        }
        String string3 = "inlineExitCall";
        int n = 1;
        String string4 = PluginManagerConstants.INLINEEXIT_LITERAL.getName();
        DataObject dataObject2 = dataObject;
        if (subscriptionManager.isEmitterAvailable(string)) {
            Object object;
            Object object2;
            UIDContext uIDContext = null;
            ExceptionContext exceptionContext = null;
            DataObject dataObject3 = dataObject.getDataGraph().getRootObject().getDataObject("Root");
            List list = dataObject3.getList("contexts");
            String string5 = null;
            DataObject dataObject4 = null;
            DataObject dataObject5 = null;
            for (int i = 0; i < list.size(); ++i) {
                object2 = (DataObject)list.get(i);
                object = object2.getString("key");
                if (object != null && ((String)object).equals(PluginManagerConstants.REALM_LITERAL.getName())) {
                    string5 = object2.getString("value");
                    continue;
                }
                if (object != null && ((String)object).equals(PluginManagerConstants.PLUGIN_UID_CONTEXT_LITERAL.getName())) {
                    dataObject4 = object2;
                    continue;
                }
                if (object == null || !((String)object).equals(PluginManagerConstants.PLUGIN_EXCEPTION_CONTEXT_LITERAL.getName())) continue;
                dataObject5 = object2;
            }
            if (dataObject4 != null && dataObject5 != null) {
                uIDContext = (UIDContext)dataObject4.get("value");
                exceptionContext = (ExceptionContext)dataObject5.get("value");
                String string6 = (String)uIDContext.getUID().get(uIDContext.getUID().size() - 1);
                object2 = (RuntimeEmitterContext)this.transInProcess.get(string6);
                if (object2 != null) {
                    object = ((RuntimeEmitterContext)object2).getEmitterReference();
                    List list2 = exceptionContext.getEmitterExceptionContext();
                    EmitterExceptionContext emitterExceptionContext = (EmitterExceptionContext)list2.get(list2.size() - 1);
                    HashSet hashSet = ((RuntimeEmitterContext)object2).getExecutedSubscriberList();
                    HashSet hashSet2 = new HashSet();
                    InlineExitContext inlineExitContext = emitterExceptionContext.createInlineExit();
                    inlineExitContext.setIsSuccessful(true);
                    inlineExitContext.setInlineExitName(string2);
                    String string7 = string + ".inlineExit." + string2;
                    Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "BEGIN " + string7);
                    try {
                        Vector vector = ((EmitterReference)object).getInlineExitModificationList(string2);
                        if (!vector.isEmpty()) {
                            Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "BEGIN Execute Modification Subscribers --->");
                            boolean bl = this.initModifyExecute(hashSet2, hashSet, vector, exceptionContext, emitterExceptionContext, dataObject, null, string5, n, string2);
                            Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "END Execute Modification Subscribers <---");
                            if (bl) {
                                Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "BEGIN Commit Modification Subscribers --->");
                                this.commitOrRollback(true, hashSet2, dataObject, emitterExceptionContext, n, string2);
                                Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "END Commit Modification Subscribers <---");
                            } else {
                                Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "BEGIN Rollback Modification Subscribers --->");
                                this.commitOrRollback(false, hashSet2, dataObject, emitterExceptionContext, n, string2);
                                Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "END Rollback Modification Subscribers <---");
                            }
                        }
                    }
                    catch (SubscriberCriticalException subscriberCriticalException) {
                        emitterExceptionContext.setAnyPluginFailure(true);
                        inlineExitContext.setIsSuccessful(false);
                        inlineExitContext.setFailedSubscriber(subscriberCriticalException.getCriticalSubscriber());
                        Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "Failed Subscriber: " + subscriberCriticalException.getCriticalSubscriber());
                        this.transInProcess.remove(string6);
                        Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "BEGIN Recovery for Subscribers --->");
                        this.recoveryExecSubscriberList(hashSet, n, string2, string, string4, exceptionContext);
                        Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "END Recovery for Subscribers <---");
                        Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "END " + string7);
                        throw subscriberCriticalException;
                    }
                    Routines.logMessage(trcLogger, CLASSNAME, string3, Level.FINEST, "END " + string7);
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DataGraph daisyChainDG does not have a properly set UIDContext or ExceptionContext element.");
                Routines.logMessage(trcLogger, CLASSNAME, string3, Level.SEVERE, stringBuffer.toString());
            }
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, string3, "Topic-Emitter " + string + " is not configured.");
        }
        return dataObject2;
    }

    public DataObject postExitCall(String string, DataObject dataObject, DataObject dataObject2) throws SubscriberCriticalException {
        if (subscriptionManager.isEmitterAvailable(string) && subscriptionManager.isEmitterEmpty(string)) {
            return dataObject2;
        }
        String string2 = "postExitCall";
        int n = 2;
        String string3 = PluginManagerConstants.POSTEXIT_LITERAL.getName();
        DataObject dataObject3 = dataObject2;
        if (subscriptionManager.isEmitterAvailable(string)) {
            Object object;
            Object object2;
            UIDContext uIDContext = null;
            ExceptionContext exceptionContext = null;
            DataObject dataObject4 = dataObject.getDataGraph().getRootObject().getDataObject("Root");
            List list = dataObject4.getList("contexts");
            String string4 = null;
            DataObject dataObject5 = null;
            DataObject dataObject6 = null;
            for (int i = 0; i < list.size(); ++i) {
                object2 = (DataObject)list.get(i);
                object = object2.getString("key");
                if (object != null && ((String)object).equals(PluginManagerConstants.REALM_LITERAL.getName())) {
                    string4 = object2.getString("value");
                    continue;
                }
                if (object != null && ((String)object).equals(PluginManagerConstants.PLUGIN_UID_CONTEXT_LITERAL.getName())) {
                    dataObject5 = object2;
                    continue;
                }
                if (object == null || !((String)object).equals(PluginManagerConstants.PLUGIN_EXCEPTION_CONTEXT_LITERAL.getName())) continue;
                dataObject6 = object2;
            }
            if (dataObject5 != null && dataObject6 != null) {
                uIDContext = (UIDContext)dataObject5.get("value");
                exceptionContext = (ExceptionContext)dataObject6.get("value");
                String string5 = (String)uIDContext.getUID().get(uIDContext.getUID().size() - 1);
                object2 = (RuntimeEmitterContext)this.transInProcess.get(string5);
                if (object2 != null) {
                    object = ((RuntimeEmitterContext)object2).getEmitterReference();
                    List list2 = exceptionContext.getEmitterExceptionContext();
                    EmitterExceptionContext emitterExceptionContext = (EmitterExceptionContext)list2.get(list2.size() - 1);
                    HashSet hashSet = ((RuntimeEmitterContext)object2).getExecutedSubscriberList();
                    PostExitContext postExitContext = emitterExceptionContext.createPostExit();
                    postExitContext.setIsSuccessful(true);
                    String string6 = string + ".postExit";
                    Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN " + string6);
                    try {
                        Vector vector = ((EmitterReference)object).getPostExitModificationList();
                        Vector vector2 = ((EmitterReference)object).getPostExitNotificationList();
                        HashSet hashSet2 = new HashSet();
                        if (!vector.isEmpty()) {
                            Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Execute Modification Subscribers --->");
                            boolean bl = this.initModifyExecute(hashSet2, hashSet, vector, exceptionContext, emitterExceptionContext, dataObject, dataObject2, string4, n, null);
                            Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Execute Modification Subscribers <---");
                            if (bl) {
                                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Commit Modification Subscribers --->");
                                this.commitOrRollback(true, hashSet2, dataObject, emitterExceptionContext, n, null);
                                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Commit Modification Subscribers <---");
                            } else {
                                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Rollback Modification Subscribers --->");
                                this.commitOrRollback(false, hashSet2, dataObject, emitterExceptionContext, n, null);
                                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Rollback Modification Subscribers <---");
                            }
                        }
                        if (!vector2.isEmpty()) {
                            Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Execute Notification Subscribers --->");
                            this.initNotifyExecute(hashSet, vector2, exceptionContext, emitterExceptionContext, dataObject, dataObject2, string4, n, null);
                            Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Execute Notification Subscribers <---");
                        }
                        this.transInProcess.remove(string5);
                    }
                    catch (SubscriberCriticalException subscriberCriticalException) {
                        emitterExceptionContext.setAnyPluginFailure(true);
                        postExitContext.setIsSuccessful(false);
                        postExitContext.setFailedSubscriber(subscriberCriticalException.getCriticalSubscriber());
                        Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "Failed Subscriber: " + subscriberCriticalException.getCriticalSubscriber());
                        this.transInProcess.remove(string5);
                        Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "BEGIN Recovery for Subscribers --->");
                        this.recoveryExecSubscriberList(hashSet, n, null, string, string3, exceptionContext);
                        Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END Recovery for Subscribers <---");
                        Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END " + string6);
                        throw subscriberCriticalException;
                    }
                    Routines.logMessage(trcLogger, CLASSNAME, string2, Level.FINEST, "END " + string6);
                }
            } else {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("DataGraph daisyChainDG does not have a properly set UIDContext or ExceptionContext element.");
                Routines.logMessage(trcLogger, CLASSNAME, string2, Level.SEVERE, stringBuffer.toString());
            }
        } else {
            trcLogger.logp(Level.FINER, CLASSNAME, string2, "Topic-Emitter " + string + " is not configured.");
        }
        this.cleanPluginManagerContext(dataObject3);
        return dataObject3;
    }

    public void cleanPluginManagerContext(DataObject dataObject) {
        Object object;
        Object object2;
        int n;
        if (dataObject == null) {
            return;
        }
        DataObject dataObject2 = dataObject.getDataGraph().getRootObject().getDataObject("Root");
        List list = dataObject2.getList("contexts");
        Object var4_4 = null;
        Object object3 = null;
        Object object4 = null;
        for (n = 0; n < list.size(); ++n) {
            object2 = (DataObject)list.get(n);
            object = object2.getString("key");
            if (object != null && ((String)object).equals(PluginManagerConstants.PLUGIN_UID_CONTEXT_LITERAL.getName())) {
                object3 = object2;
                continue;
            }
            if (object == null || !((String)object).equals(PluginManagerConstants.PLUGIN_EXCEPTION_CONTEXT_LITERAL.getName())) continue;
            object4 = object2;
        }
        n = 0;
        object2 = null;
        object = null;
        if (object3 != null && object4 != null) {
            object2 = (UIDContext)object3.get("value");
            object = (ExceptionContext)object4.get("value");
            List list2 = object2.getUID();
            list2.remove(list2.size() - 1);
            if (list2.size() == 0) {
                n = 1;
            }
            List list3 = object.getEmitterExceptionContext();
            list3.remove(list3.size() - 1);
            if (list3.size() == 0) {
                n = 1;
            }
            if (n != 0) {
                for (int i = 0; i < list.size(); ++i) {
                    DataObject dataObject3 = (DataObject)list.get(i);
                    String string = dataObject3.getString("key");
                    if (string != null && string.equals(PluginManagerConstants.PLUGIN_UID_CONTEXT_LITERAL.getName())) {
                        list.remove(i);
                        --i;
                        continue;
                    }
                    if (string == null || !string.equals(PluginManagerConstants.PLUGIN_EXCEPTION_CONTEXT_LITERAL.getName())) continue;
                    list.remove(i);
                    --i;
                }
            }
        }
    }

    static {
        expContextFactory = new ContextFactoryImpl();
    }
}

