/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.plugins.orgview.impl;

import com.ibm.websphere.wim.exception.EntityIdentifierNotSpecifiedException;
import com.ibm.websphere.wim.exception.InvalidArgumentException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.exception.SubscriberException;
import com.ibm.websphere.wim.pluginmanager.context.SubscriberExecStatus;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.util.ControlsHelper;
import com.ibm.wsspi.wim.plugins.orgview.ViewProcessor;
import com.ibm.wsspi.wim.plugins.orgview.impl.BaseViewProcessorImpl;
import commonj.sdo.DataObject;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class DefaultDAViewProcessorImpl
extends BaseViewProcessorImpl
implements ViewProcessor {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = DefaultDAViewProcessorImpl.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    public final String VIEW_PROCESSOR_NAME = "DefaultDAViewProcessor";
    public final String VIEW_NAME = "DefaultDAView";
    public final String DA_VIEW_CONCOCTED_UUID_PREFIX = "DefaultDAViewUUID_";
    public final String DA_VIEW_ROOT_ENTRY_NAME = "/root";
    public final String DA_VIEW_ENTRY_NAME_PREFIX = "/root/";
    public final String DA_VIEW_CONCOCTED_ENTRY_NAME = "Concocted";

    public String getViewName() {
        return "DefaultDAView";
    }

    public DataObject mapViewIdentifierToWIMIdentifier(DataObject dataObject, DataObject dataObject2) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "mapViewIdentifierToWIMIdentifier(entityDO, viewIdentifier)", WIMTraceHelper.printDataObject(dataObject));
        }
        String string = dataObject2.getString("viewEntryUniqueId");
        DataObject dataObject3 = null;
        if (!string.startsWith("DefaultDAViewUUID_")) {
            dataObject3 = dataObject.createDataObject("identifier");
            dataObject3.setString("uniqueId", dataObject2.getString("viewEntryUniqueId"));
            String string2 = dataObject2.getString("uniqueName").substring("/root/".length());
            dataObject3.setString("uniqueName", string2);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "mapViewIdentifierToWIMIdentifier(entityDO, viewIdentifier)", WIMTraceHelper.printDataObject(dataObject));
        }
        return null;
    }

    public DataObject mapWIMIdentifierToViewIdentifier(DataObject dataObject, DataObject dataObject2) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "mapWIMIdentifierToViewIdentifier(entityDO, wimIdentifier)", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject3 = dataObject.createDataObject("viewIdentifiers");
        dataObject3.setString("viewName", this.getViewName());
        if (dataObject2.getString("uniqueName") != null) {
            dataObject3.setString("viewEntryName", "/root/" + dataObject2.getString("uniqueName"));
        }
        if (dataObject2.getString("uniqueId") != null) {
            dataObject3.setString("viewEntryUniqueId", dataObject2.getString("uniqueId"));
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "mapWIMIdentifierToViewIdentifier(entityDO, wimIdentifier)", WIMTraceHelper.printDataObject(dataObject));
        }
        return dataObject3;
    }

    public DataObject simulateEntityCreation(DataObject dataObject) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "simulateEntityCreation(entityDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        DataObject dataObject2 = dataObject.createDataObject("viewIdentifiers");
        dataObject2.setString("viewName", "DefaultDAView");
        dataObject2.setString("viewEntryName", "/root/Concocted");
        dataObject2.setString("viewEntryUniqueId", "");
        if (bl) {
            trcLogger.exiting(CLASSNAME, "simulateEntityCreation(entityDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return dataObject2;
    }

    public boolean addAncestorsToDataObject(DataObject dataObject, DataObject dataObject2) {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "addAncestorsToDataObject(entityDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if (dataObject2 == null) {
            return false;
        }
        String string = dataObject2.getString("viewEntryName");
        if (!string.equals("/root")) {
            DataObject dataObject3 = dataObject.createDataObject("parent", "http://www.ibm.com/websphere/wim", "OrgContainer");
            DataObject dataObject4 = dataObject3.createDataObject("viewIdentifiers");
            dataObject4.setString("viewName", "DefaultDAView");
            dataObject4.setString("viewEntryUniqueId", "DefaultDAViewUUID_/root");
            dataObject4.setString("viewEntryName", "/root");
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "addAncestorsToDataObject(entityDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getInViewExplicit(String string, DataObject dataObject) throws SubscriberException {
        int n;
        List list;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "getInViewExplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if ((list = dataObject.getList("entities")) == null || list.size() == 0) {
            return false;
        }
        Map map = ControlsHelper.getControlMap(dataObject.getDataGraph());
        DataObject dataObject2 = (DataObject)map.get("AncestorControl");
        if (dataObject2 != null) {
            n = dataObject2.getInt("level");
            if (n < 0) {
                throw new SubscriberException(SubscriberExecStatus.FAILURE_LITERAL, "INVALID_LEVEL_IN_CONTROL", CLASSNAME, (Throwable)new InvalidArgumentException("INVALID_LEVEL_IN_CONTROL", WIMMessageHelper.generateMsgParms(new Integer(n), "AncestorControl"), Level.WARNING, CLASSNAME, "getInViewExplicit(rootDO)"));
            }
        } else {
            DataObject dataObject3 = (DataObject)map.get("DescendantControl");
            if (dataObject3 != null) {
                throw new SubscriberException(SubscriberExecStatus.FAILURE_LITERAL, "OPERATION_NOT_SUPPORTED", CLASSNAME, (Throwable)new OperationNotSupportedException("OPERATION_NOT_SUPPORTED", WIMMessageHelper.generateMsgParms("DescendantControl"), Level.WARNING, CLASSNAME, "getInViewExplicit(rootDO)"));
            }
        }
        for (n = 0; n < list.size(); ++n) {
            DataObject dataObject4 = (DataObject)list.get(n);
            DataObject dataObject5 = this.getViewIdentifierForEntity(dataObject4, this.getViewName());
            DataObject dataObject6 = dataObject4.getDataObject("identifier");
            if (dataObject5 == null && dataObject6 == null) {
                if (!string.equalsIgnoreCase("com.ibm.ws.wim.authz.ProfileSecurityManager")) throw new SubscriberException(SubscriberExecStatus.FAILURE_LITERAL, "ENTITY_IDENTIFIER_NOT_SPECIFIED", CLASSNAME, (Throwable)new OperationNotSupportedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", WIMMessageHelper.generateMsgParms(dataObject4), Level.WARNING, CLASSNAME, "getInViewExplicit(rootDO)"));
                this.simulateEntityCreation(dataObject4);
            } else {
                if (dataObject5 != null && dataObject6 != null) continue;
                if (dataObject5 != null) {
                    dataObject6 = this.mapViewIdentifierToWIMIdentifier(dataObject4, dataObject5);
                } else if (dataObject6 != null) {
                    dataObject5 = this.mapWIMIdentifierToViewIdentifier(dataObject4, dataObject6);
                }
            }
            if (dataObject2 == null) continue;
            this.addAncestorsToDataObject(dataObject4, dataObject5);
        }
        if (!bl) return true;
        trcLogger.exiting(CLASSNAME, "getInViewExplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        return true;
    }

    public boolean createInViewExplicit(String string, DataObject dataObject) throws SubscriberException {
        List list;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "createInViewExplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        if ((list = dataObject.getList("entities")) == null || list.size() == 0) {
            return false;
        }
        DataObject dataObject2 = (DataObject)list.get(0);
        DataObject dataObject3 = dataObject2.getDataObject("identifier");
        if (dataObject3 == null) {
            throw new SubscriberException(SubscriberExecStatus.FAILURE_LITERAL, "ENTITY_IDENTIFIER_NOT_SPECIFIED", CLASSNAME, (Throwable)new EntityIdentifierNotSpecifiedException("ENTITY_IDENTIFIER_NOT_SPECIFIED", WIMMessageHelper.generateMsgParms(dataObject2), Level.WARNING, CLASSNAME, "createInViewExplicit(rootDO)"));
        }
        this.mapWIMIdentifierToViewIdentifier(dataObject2, dataObject3);
        if (bl) {
            trcLogger.exiting(CLASSNAME, "createInViewExplicit(rootDO)", WIMTraceHelper.printDataObject(dataObject));
        }
        return true;
    }

    public boolean deleteInViewExplicit(String string, DataObject dataObject) {
        return true;
    }
}

