/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry;

import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.RealmManager;
import com.ibm.ws.wim.registry.WIMUserRegistryDefines;
import com.ibm.ws.wim.registry.util.BridgeUtils;
import com.ibm.ws.wim.registry.util.DisplayNameBridge;
import com.ibm.ws.wim.registry.util.LoginBridge;
import com.ibm.ws.wim.registry.util.MembershipBridge;
import com.ibm.ws.wim.registry.util.SearchBridge;
import com.ibm.ws.wim.registry.util.SecurityNameBridge;
import com.ibm.ws.wim.registry.util.UniqueIdBridge;
import com.ibm.ws.wim.registry.util.ValidBridge;
import com.ibm.ws.wim.security.authz.AuthPrivilegedException;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.rmi.RemoteException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WIMUserRegistry
implements UserRegistry,
WIMUserRegistryDefines {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005, 2009";
    private final String className = WIMUserRegistry.class.getName();
    private Logger wimUserRegistryTrace = WIMLogger.getTraceLogger(this.className);
    private static final String TOKEN_DELIMETER = "::";
    private BridgeUtils mappingUtils = new BridgeUtils();
    private LoginBridge loginBridge = new LoginBridge();
    private DisplayNameBridge displayBridge = new DisplayNameBridge();
    private SecurityNameBridge securityBridge = new SecurityNameBridge();
    private UniqueIdBridge uniqueBridge = new UniqueIdBridge();
    private ValidBridge validBridge = new ValidBridge();
    private SearchBridge searchBridge = new SearchBridge();
    private MembershipBridge membershipBridge = new MembershipBridge();

    public WIMUserRegistry() {
        String string = "WIMUserRegistry";
        if (this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
            this.wimUserRegistryTrace.entering(this.className, string);
        }
        if (this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
            this.wimUserRegistryTrace.exiting(this.className, string);
        }
    }

    public void initialize(Properties properties) throws CustomRegistryException, RemoteException {
        String string = "initialize";
        if (this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
            this.wimUserRegistryTrace.entering(this.className, string, "inputProperties = " + properties);
        }
        this.mappingUtils.initialize(properties);
        if (this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
            this.wimUserRegistryTrace.exiting(this.className, string);
        }
    }

    public String checkPassword(final String string, final String string2) throws PasswordCheckFailedException, CustomRegistryException, RemoteException {
        try {
            return (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string3 = "checkPassword";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string3, "inputUser = \"" + string + "\", inputPassword = *");
                    }
                    String string22 = WIMUserRegistry.this.loginBridge.checkPassword(string, string2);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string3, "returnValue = \"" + string22 + "\"");
                    }
                    return string22;
                }
            });
        }
        catch (WIMException wIMException) {
            this.wimUserRegistryTrace.log(Level.FINER, wIMException.toString());
            this.handlePasswordCheckFailedException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public String mapCertificate(final X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException, RemoteException {
        try {
            return (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string = "mapCertificate";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string, "inputCertificates = " + x509CertificateArray);
                    }
                    String string2 = WIMUserRegistry.this.loginBridge.mapCertificate(x509CertificateArray);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string, "returnValue = \"" + string2 + "\"");
                    }
                    return string2;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleCertificateExceptions(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public String getRealm() throws CustomRegistryException, RemoteException {
        try {
            return (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string = "getRealm";
                    String string2 = "";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string);
                    }
                    try {
                        string2 = RealmManager.singleton().getDefaultRealmName();
                    }
                    catch (WIMException wIMException) {
                        throw new CustomRegistryException(wIMException);
                    }
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string, "returnValue = \"" + string2 + "\"");
                    }
                    return string2;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public Result getUsers(final String string, final int n) throws CustomRegistryException, RemoteException {
        try {
            return (Result)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string2 = "getUsers";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string2, "inputPattern = \"" + string + "\", inputLimit = \"" + Integer.toString(n) + "\"");
                    }
                    Result result = WIMUserRegistry.this.searchBridge.getUsers(string, n);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string2, "returnValue = \"" + result + "\"");
                    }
                    return result;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public String getUserDisplayName(final String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            return (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string3 = "getUserDisplayName";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string3, "inputSecurityName = \"" + string + "\"");
                    }
                    String string2 = WIMUserRegistry.this.displayBridge.getUserDisplayName(string);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string3, "returnValue = \"" + string2 + "\"");
                    }
                    return string2;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleEntryNotFoundException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public String getUniqueUserId(final String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            return (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String[] stringArray;
                    String string5 = "getUniqueUserId";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string5, "inputUserSecurityName = \"" + string + "\"");
                    }
                    String string2 = (stringArray = string.split(WIMUserRegistry.TOKEN_DELIMETER, 2)).length > 1 ? stringArray[0] : null;
                    String string3 = string2 == null ? string : stringArray[1];
                    String string4 = WIMUserRegistry.this.uniqueBridge.getUniqueUserId(string3);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string5, "returnValue = \"" + string4 + "\"");
                    }
                    return string4;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleEntryNotFoundException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public String getUserSecurityName(final String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            return (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string4;
                    String string2 = "getUserSecurityName";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string2, "inputUniqueUserId = \"" + string + "\"");
                    }
                    if ((string4 = string).startsWith("user:") || string4.startsWith("group:")) {
                        string4 = WSSecurityPropagationHelper.getUserFromUniqueID(string4);
                    }
                    String string3 = WIMUserRegistry.this.securityBridge.getUserSecurityName(string4);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string2, "returnValue = \"" + string3 + "\"");
                    }
                    return string3;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleEntryNotFoundException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public boolean isValidUser(final String string) throws CustomRegistryException, RemoteException {
        try {
            return (Boolean)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string2 = "isValidUser";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string2, "inputUserSecurityName = \"" + string + "\"");
                    }
                    boolean bl = WIMUserRegistry.this.validBridge.isValidUser(string);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string2, "returnValue = \"" + Boolean.toString(bl) + "\"");
                    }
                    return bl;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public Result getGroups(final String string, final int n) throws CustomRegistryException, RemoteException {
        try {
            return (Result)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string2 = "getGroups";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string2, "inputPattern = \"" + string + "\", inputLimit = \"" + Integer.toString(n) + "\"");
                    }
                    Result result = WIMUserRegistry.this.searchBridge.getGroups(string, n);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string2, "returnValue = \"" + result + "\"");
                    }
                    return result;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public String getGroupDisplayName(final String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            return (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string3 = "getGroupDisplayName";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string3, "inputGroupSecurityName = \"" + string + "\"");
                    }
                    String string2 = WIMUserRegistry.this.displayBridge.getGroupDisplayName(string);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string3, "returnValue = \"" + string2 + "\"");
                    }
                    return string2;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleEntryNotFoundException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public String getUniqueGroupId(final String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            return (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string3 = "getUniqueGroupId";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string3, "inputGroupSecurityName = \"" + string + "\"");
                    }
                    String string2 = WIMUserRegistry.this.uniqueBridge.getUniqueGroupId(string);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string3, "returnValue = \"" + string2 + "\"");
                    }
                    return string2;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleEntryNotFoundException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public List getUniqueGroupIds(final String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            return (List)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string3;
                    String string2 = "getUniqueGroupIds";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string2, "inputUniqueUserId = \"" + string + "\"");
                    }
                    if ((string3 = string).startsWith("user:") || string3.startsWith("group:")) {
                        string3 = WSSecurityPropagationHelper.getUserFromUniqueID(string3);
                    }
                    List list = WIMUserRegistry.this.membershipBridge.getUniqueGroupIds(string3);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string2, "returnValue = \"" + list + "\"");
                    }
                    return list;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleEntryNotFoundException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public String getGroupSecurityName(final String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            return (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string3 = "getGroupSecurityName";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string3, "inputUniqueGroupId = \"" + string + "\"");
                    }
                    String string2 = WIMUserRegistry.this.securityBridge.getGroupSecurityName(string);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string3, "returnValue = \"" + string2 + "\"");
                    }
                    return string2;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleEntryNotFoundException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public boolean isValidGroup(final String string) throws CustomRegistryException, RemoteException {
        try {
            return (Boolean)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string2 = "isValidGroup";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string2, "inputGroupSecurityName = \"" + string + "\"");
                    }
                    boolean bl = WIMUserRegistry.this.validBridge.isValidGroup(string);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string2, "returnValue = \"" + Boolean.toString(bl) + "\"");
                    }
                    return bl;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public List getGroupsForUser(final String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            return (List)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string2 = "getGroupsForUser";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string2, "inputUserSecurityName = \"" + string + "\"");
                    }
                    List list = WIMUserRegistry.this.membershipBridge.getGroupsForUser(string);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string2, "returnValue = \"" + list + "\"");
                    }
                    return list;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleEntryNotFoundException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public Result getUsersForGroup(final String string, final int n) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException {
        try {
            return (Result)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    String string2 = "getUsersForGroup";
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.entering(WIMUserRegistry.this.className, string2, "inputGroupSecurityName = \"" + string + "\", inputLimit = " + Integer.toString(n) + "\"");
                    }
                    Result result = WIMUserRegistry.this.membershipBridge.getUsersForGroup(string, n);
                    if (WIMUserRegistry.this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
                        WIMUserRegistry.this.wimUserRegistryTrace.exiting(WIMUserRegistry.this.className, string2, "returnValue = " + result);
                    }
                    return result;
                }
            });
        }
        catch (WIMException wIMException) {
            this.handleNotImplementedException(wIMException);
            this.handleEntryNotFoundException(wIMException);
            this.handleCustomRemoteExceptions(wIMException);
            throw new CustomRegistryException(wIMException);
        }
    }

    public WSCredential createCredential(String string) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "createCredential";
        if (this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
            this.wimUserRegistryTrace.entering(this.className, string2, "inputUserSecurityName = \"" + string + "\"");
        }
        WSCredential wSCredential = null;
        if (this.wimUserRegistryTrace.isLoggable(Level.FINER)) {
            this.wimUserRegistryTrace.exiting(this.className, string2, "returnValue = \"" + wSCredential + "\"");
        }
        return wSCredential;
    }

    private void handleCustomRemoteExceptions(WIMException wIMException) throws CustomRegistryException, RemoteException {
        if (wIMException instanceof AuthPrivilegedException) {
            if (wIMException.getCause() instanceof CustomRegistryException) {
                throw (CustomRegistryException)wIMException.getCause();
            }
            if (wIMException.getCause() instanceof RemoteException) {
                throw (RemoteException)wIMException.getCause();
            }
        }
    }

    private void handleEntryNotFoundException(WIMException wIMException) throws EntryNotFoundException {
        if (wIMException instanceof AuthPrivilegedException && wIMException.getCause() instanceof EntryNotFoundException) {
            throw (EntryNotFoundException)wIMException.getCause();
        }
    }

    private void handlePasswordCheckFailedException(WIMException wIMException) throws PasswordCheckFailedException {
        if (wIMException instanceof AuthPrivilegedException && wIMException.getCause() instanceof PasswordCheckFailedException) {
            throw (PasswordCheckFailedException)wIMException.getCause();
        }
    }

    private void handleCertificateExceptions(WIMException wIMException) throws CertificateMapNotSupportedException, CertificateMapFailedException {
        if (wIMException instanceof AuthPrivilegedException) {
            if (wIMException.getCause() instanceof CertificateMapNotSupportedException) {
                throw (CertificateMapNotSupportedException)wIMException.getCause();
            }
            if (wIMException.getCause() instanceof CertificateMapFailedException) {
                throw (CertificateMapFailedException)wIMException.getCause();
            }
        }
    }

    private void handleNotImplementedException(WIMException wIMException) throws NotImplementedException {
        if (wIMException instanceof AuthPrivilegedException && wIMException.getCause() instanceof NotImplementedException) {
            throw (NotImplementedException)wIMException.getCause();
        }
    }
}

