/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry.util;

import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.wim.Service;
import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.CertificateMapFailedException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.RealmManager;
import com.ibm.ws.wim.SPIServiceProvider;
import com.ibm.ws.wim.registry.WIMUserRegistryDefines;
import com.ibm.ws.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.wim.util.UniqueNameHelper;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BridgeUtils
implements WIMUserRegistryDefines {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private final String className = BridgeUtils.class.getName();
    private Logger bridgeUtilsLog = WIMLogger.getMessageLogger(this.className);
    private Logger bridgeUtilsTrace = WIMLogger.getTraceLogger(this.className);
    private static Service wimService = null;
    private static String wimServiceLock = "WIM_SERVICE_LOCK";
    private static short groupLevel = 0;
    private static String groupLevelLock = "GROUP_LEVEL_LOCK";

    public BridgeUtils() {
        String string = "BridgeUtils";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string);
        }
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Properties properties) throws CustomRegistryException, RemoteException {
        String string;
        block28: {
            String string2;
            string = "initialize";
            if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
                this.bridgeUtilsTrace.entering(this.className, string, "inputProperties = " + properties);
            }
            try {
                string2 = wimServiceLock;
                synchronized (string2) {
                    wimService = ServiceProvider.singleton();
                }
            }
            catch (WIMException wIMException) {
                throw new CustomRegistryException(wIMException);
            }
            string2 = (String)properties.get("com.ibm.ws.wim.registry.grouplevel");
            try {
                if (string2 == null || string2.equals("")) {
                    String string3 = groupLevelLock;
                    synchronized (string3) {
                        groupLevel = 0;
                        break block28;
                    }
                }
                if (Short.parseShort(string2) == 1) {
                    String string4 = groupLevelLock;
                    synchronized (string4) {
                        groupLevel = 1;
                        break block28;
                    }
                }
                if (Short.parseShort(string2) == 0) {
                    String string5 = groupLevelLock;
                    synchronized (string5) {
                        groupLevel = 0;
                        break block28;
                    }
                }
                String string6 = groupLevelLock;
                synchronized (string6) {
                    groupLevel = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                String string7 = groupLevelLock;
                synchronized (string7) {
                    groupLevel = 0;
                }
            }
        }
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeSPIServiceProvider(Properties properties) throws CustomRegistryException, RemoteException {
        String string = "initializeSPIServiceProvider";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string, "inputProperties = " + properties);
        }
        try {
            String string2 = wimServiceLock;
            synchronized (string2) {
                wimService = new SPIServiceProvider((String)properties.get("SESSIONID"));
            }
        }
        catch (WIMException wIMException) {
            throw new CustomRegistryException(wIMException);
        }
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string);
        }
    }

    protected void validateId(String string) throws WIMException {
        String string2 = "validateId";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string2, "inputId = \"" + string + "\"");
        }
        if (string == null) {
            throw new WIMException(string);
        }
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string2);
        }
    }

    protected void validateLimit(int n) throws WIMException {
        String string = "validateLimit";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string, "inputLimit = \"" + n + "\"");
        }
        if (n < 0) {
            throw new WIMException(Integer.toString(n));
        }
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string);
        }
    }

    protected void validateCertificateArray(X509Certificate[] x509CertificateArray) throws CertificateMapFailedException {
        String string = "validateCertificateArray";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string, "inputCertificates = \"" + x509CertificateArray + "\"");
        }
        if (x509CertificateArray == null || x509CertificateArray[0] == null) {
            throw new CertificateMapFailedException();
        }
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string);
        }
    }

    protected IDAndRealm seperateIDAndRealm(String string) throws WIMException {
        String string2 = "seperateIDAndRealm";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.logp(Level.FINER, this.className, string2, "inputString = \"" + string + "\"");
        }
        String string3 = RealmManager.singleton().getDefaultRealmName();
        String string4 = RealmManager.singleton().getDelimiter(string3);
        Set set = RealmManager.singleton().getRealmNames();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string5 : set) {
            String string6 = RealmManager.singleton().getDelimiter(string5);
            hashMap.put(string5, string6);
        }
        return this.seperateIDAndRealm(string, string3, string4, set, hashMap);
    }

    protected IDAndRealm seperateIDAndRealm(String string, String string2, String string3, Set set, Map map) throws WIMException {
        String string4 = "seperateIDAndRealm";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string4, "inputString = \"" + string + "\"");
            this.bridgeUtilsTrace.entering(this.className, string4, "defaultRealm=" + string2 + ", defaultRealmDelimiter=" + string3 + ", realms=" + set + ", realmsDelimiter=" + map);
        }
        IDAndRealm iDAndRealm = null;
        boolean bl = false;
        boolean bl2 = false;
        Iterator iterator = set.iterator();
        block0: while (iterator.hasNext() && !bl) {
            StringBuffer stringBuffer = new StringBuffer();
            String string5 = (String)iterator.next();
            String string6 = (String)map.get(string5);
            iDAndRealm = new IDAndRealm();
            for (int i = string.length() - 1; i >= 0; --i) {
                if (Character.toString(string.charAt(i)).equals(string6)) {
                    if (!iDAndRealm.isRealmDefined()) {
                        if (i - 1 >= 0 && string.charAt(i - 1) == '\\') {
                            stringBuffer.append(string.charAt(i));
                            --i;
                            continue;
                        }
                        String string7 = stringBuffer.reverse().toString();
                        if (!string5.equals(string7)) continue block0;
                        iDAndRealm.setDelimiter(string6);
                        iDAndRealm.setRealm(string7);
                        stringBuffer.setLength(0);
                        bl2 = true;
                        continue;
                    }
                    if (i - 1 >= 0 && string.charAt(i - 1) == '\\') {
                        stringBuffer.append(string.charAt(i));
                        --i;
                        continue;
                    }
                    throw new WIMException(string);
                }
                if (i == 0 && bl2) {
                    stringBuffer.append(string.charAt(i));
                    iDAndRealm.setId(stringBuffer.reverse().toString());
                    bl = true;
                    continue block0;
                }
                if (i == 0) {
                    stringBuffer.append(string.charAt(i));
                    iDAndRealm.setId(stringBuffer.reverse().toString());
                    stringBuffer.setLength(0);
                    continue;
                }
                stringBuffer.append(string.charAt(i));
            }
        }
        if (!iDAndRealm.isRealmDefined()) {
            iDAndRealm.setDelimiter(string3);
            iDAndRealm.setRealm(string2);
        }
        if (!bl && iDAndRealm.getId() == "") {
            iDAndRealm.setId(string);
        }
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string4, "returnValue = \"" + iDAndRealm + "\"");
        }
        return iDAndRealm;
    }

    public boolean isIdentifierTypeProperty(String string) {
        String string2 = "isIdentifierTypeProperty";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string2, "inputProperty = \"" + string + "\"");
        }
        boolean bl = false;
        if (string != null && (string.equals("uniqueId") || string.equals("uniqueName") || string.equals("externalId") || string.equals("externalName"))) {
            bl = true;
        }
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string2, "returnValue = \"" + Boolean.toString(bl) + "\"");
        }
        return bl;
    }

    protected void createRealmDataObject(DataObject dataObject, String string) {
        String string2 = "createRealmDataObject";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string2, "inputRootDataObject = \"" + dataObject + "\", inputRealm = \"" + string + "\"");
        }
        DataObject dataObject2 = dataObject.createDataObject("contexts");
        dataObject2.set("key", (Object)"realm");
        dataObject2.set("value", (Object)string);
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string2);
        }
    }

    protected void createPropertyControlDataObject(DataObject dataObject, String string) {
        String string2 = "createPropertyControlDataObject";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string2, "inputRootDataObject = \"" + dataObject + "\", inputProperty = \"" + string + "\"");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
        dataObject2.getList("properties").add(string);
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string2);
        }
    }

    protected void createLoginControlDataObject(DataObject dataObject, String string) {
        String string2 = "createLoginControlDataObject";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string2, "inputRootDataObject = \"" + dataObject + "\", inputProperty = \"" + string + "\"");
        }
        DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "LoginControl");
        dataObject2.getList("properties").add(string);
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string2);
        }
    }

    protected DataObject getEntityByIdentifier(DataObject dataObject, String string, String string2, String string3, BridgeUtils bridgeUtils) throws WIMException, RemoteException {
        String string4 = "getEntityByIdentifier";
        this.bridgeUtilsTrace.entering(this.className, string4, "inputRootDataObject = \"" + dataObject + "\", inputAttrName = \"" + string + "\", inputAttrValue = \"" + string2 + "\", outputAttrName = \"" + string3 + "\"");
        boolean bl = bridgeUtils.isIdentifierTypeProperty(string);
        boolean bl2 = string.equals("externalName");
        boolean bl3 = bridgeUtils.isIdentifierTypeProperty(string3);
        DataObject dataObject2 = null;
        if (bl) {
            if (!bl3) {
                bridgeUtils.createPropertyControlDataObject(dataObject, string3);
            }
            DataObject dataObject3 = dataObject.createDataObject("entities");
            dataObject3.createDataObject("identifier").setString(string, string2);
            if (bl2) {
                dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "ExternalNameControl");
            }
            dataObject2 = bridgeUtils.getWimService().get(dataObject);
        }
        this.bridgeUtilsTrace.exiting(this.className, string4, "returnValue = \"" + dataObject2 + "\"");
        return dataObject2;
    }

    protected void logException(Exception exception, String string) {
        String string2 = "logException";
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.entering(this.className, string2, "inputToLog = \"" + exception + "\" inputClassname = \"" + string + "\"");
        }
        if (this.bridgeUtilsLog.isLoggable(Level.FINER)) {
            this.bridgeUtilsLog.logp(Level.SEVERE, string, string2, "", WIMMessageHelper.generateMsgParms(exception));
        }
        if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
            this.bridgeUtilsTrace.exiting(this.className, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Service getWimService() {
        String string = wimServiceLock;
        synchronized (string) {
            return wimService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getGroupDepth() {
        String string = groupLevelLock;
        synchronized (string) {
            return groupLevel;
        }
    }

    protected String getRealInputAttrName(String string, String string2, boolean bl) {
        String string3 = "getRealInputAttrName";
        this.bridgeUtilsTrace.entering(this.className, string3, "inputAttrName = \"" + string + "\", id = \"" + string2 + "\", isUser = \"" + bl + "\"");
        boolean bl2 = UniqueNameHelper.isDN(string2) != null;
        boolean bl3 = this.isIdentifierTypeProperty(string);
        if (!bl3 && bl2) {
            if (this.bridgeUtilsLog.isLoggable(Level.FINER)) {
                this.bridgeUtilsLog.logp(Level.FINE, this.className, string3, "WARNING: the propertyForInput " + string + " doesn't match the format of input value " + string2 + ", switch to uniqueName");
            }
            string = "uniqueName";
        } else if (bl3 && !bl2) {
            if (bl) {
                if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
                    this.bridgeUtilsTrace.logp(Level.WARNING, this.className, "", "the propertyForInput " + string + " doesn't match the format of input value " + string2 + ", switch to principalName");
                }
                string = "principalName";
            } else {
                if (this.bridgeUtilsTrace.isLoggable(Level.FINER)) {
                    this.bridgeUtilsTrace.logp(Level.WARNING, this.className, "", "the propertyForInput " + string + " doesn't match the format of input value " + string2 + ", swith to cn");
                }
                string = "cn";
            }
        }
        this.bridgeUtilsTrace.exiting(this.className, string3, "returnValue = \"" + string + "\"");
        return string;
    }
}

