/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry.util;

import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InvalidIdentifierException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.wim.registry.util.BridgeUtils;
import com.ibm.ws.wim.registry.util.TypeMappings;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DisplayNameBridge {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private final String className = DisplayNameBridge.class.getName();
    private Logger displayNameBridgeTrace = WIMLogger.getTraceLogger(this.className);
    private TypeMappings propertyMap = new TypeMappings();
    private BridgeUtils mappingUtils = new BridgeUtils();

    public DisplayNameBridge() {
        String string = "DisplayNameBridge";
        if (this.displayNameBridgeTrace.isLoggable(Level.FINER)) {
            this.displayNameBridgeTrace.entering(this.className, string);
        }
        if (this.displayNameBridgeTrace.isLoggable(Level.FINER)) {
            this.displayNameBridgeTrace.exiting(this.className, string);
        }
    }

    public String getUserDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "getUserDisplayName";
        if (this.displayNameBridgeTrace.isLoggable(Level.FINER)) {
            this.displayNameBridgeTrace.entering(this.className, string2, "inputUserSecurityName = \"" + string + "\"");
        }
        String string3 = "";
        try {
            Object object;
            String string4;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            String string5 = "'";
            String string6 = iDAndRealm.getId();
            if (string6.indexOf("'") != -1) {
                string5 = "\"";
            }
            String string7 = this.propertyMap.getInputUserSecurityName(iDAndRealm.getRealm());
            DataObject dataObject2 = this.mappingUtils.getEntityByIdentifier(dataObject, string7 = this.mappingUtils.getRealInputAttrName(string7, string6, true), string6, string4 = this.propertyMap.getOutputUserDisplayName(iDAndRealm.getRealm()), this.mappingUtils);
            if (dataObject2 != null) {
                dataObject = dataObject2;
            } else {
                object = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserDisplayName(iDAndRealm.getRealm()))) {
                    object.getList("properties").add(this.propertyMap.getOutputUserDisplayName(iDAndRealm.getRealm()));
                }
                object.setString("expression", "//entities[@xsi:type='LoginAccount' and " + string7 + "=" + string5 + string6 + string5 + "]");
                dataObject = this.mappingUtils.getWimService().search(dataObject);
            }
            object = dataObject.getList("entities");
            if (object.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            if (object.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            DataObject dataObject3 = (DataObject)object.get(0);
            string3 = !this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserDisplayName(iDAndRealm.getRealm())) ? dataObject3.getString(this.propertyMap.getOutputUserDisplayName(iDAndRealm.getRealm())) : dataObject3.getString("identifier/" + this.propertyMap.getOutputUserDisplayName(iDAndRealm.getRealm()));
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof EntityNotFoundException || wIMException instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.displayNameBridgeTrace.isLoggable(Level.FINER)) {
            this.displayNameBridgeTrace.exiting(this.className, string2, "returnValue = \"" + string3 + "\"");
        }
        return string3;
    }

    public String getGroupDisplayName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "getGroupDisplayName";
        if (this.displayNameBridgeTrace.isLoggable(Level.FINER)) {
            this.displayNameBridgeTrace.entering(this.className, string2, "inputGroupSecurityName = \"" + string + "\"");
        }
        String string3 = "";
        try {
            Object object;
            String string4;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            String string5 = "'";
            String string6 = iDAndRealm.getId();
            if (string6.indexOf("'") != -1) {
                string5 = "\"";
            }
            String string7 = this.propertyMap.getInputGroupSecurityName(iDAndRealm.getRealm());
            DataObject dataObject2 = this.mappingUtils.getEntityByIdentifier(dataObject, string7 = this.mappingUtils.getRealInputAttrName(string7, string6, false), string6, string4 = this.propertyMap.getOutputGroupDisplayName(iDAndRealm.getRealm()), this.mappingUtils);
            if (dataObject2 != null) {
                dataObject = dataObject2;
            } else {
                object = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupDisplayName(iDAndRealm.getRealm()))) {
                    object.getList("properties").add(this.propertyMap.getOutputGroupDisplayName(iDAndRealm.getRealm()));
                }
                object.setString("expression", "//entities[@xsi:type='Group' and " + string7 + "=" + string5 + string6 + string5 + "]");
                dataObject = this.mappingUtils.getWimService().search(dataObject);
            }
            object = dataObject.getList("entities");
            if (object.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            if (object.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            DataObject dataObject3 = (DataObject)object.get(0);
            string3 = !this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupDisplayName(iDAndRealm.getRealm())) ? dataObject3.getString(this.propertyMap.getOutputGroupDisplayName(iDAndRealm.getRealm())) : dataObject3.getString("identifier/" + this.propertyMap.getOutputGroupDisplayName(iDAndRealm.getRealm()));
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof EntityNotFoundException || wIMException instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.displayNameBridgeTrace.isLoggable(Level.FINER)) {
            this.displayNameBridgeTrace.exiting(this.className, string2, "returnValue = \"" + string3 + "\"");
        }
        return string3;
    }
}

