/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry.util;

import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.PasswordCheckFailedException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.ws.wim.RealmManager;
import com.ibm.ws.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.wim.registry.util.BridgeUtils;
import com.ibm.ws.wim.registry.util.TypeMappings;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoginBridge {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private final String className = LoginBridge.class.getName();
    private Logger loginBridgeTrace = WIMLogger.getTraceLogger(this.className);
    private TypeMappings propertyMap = new TypeMappings();
    private BridgeUtils mappingUtils = new BridgeUtils();

    public LoginBridge() {
        String string = "LoginBridge";
        if (this.loginBridgeTrace.isLoggable(Level.FINER)) {
            this.loginBridgeTrace.entering(this.className, string);
        }
        if (this.loginBridgeTrace.isLoggable(Level.FINER)) {
            this.loginBridgeTrace.exiting(this.className, string);
        }
    }

    public String checkPassword(String string, String string2) throws com.ibm.websphere.security.PasswordCheckFailedException, CustomRegistryException, RemoteException {
        String string3 = "checkPassword";
        if (this.loginBridgeTrace.isLoggable(Level.FINER)) {
            this.loginBridgeTrace.entering(this.className, string3, "inputUser = \"" + string + "\", inputPassword = *");
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            DataObject dataObject;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject2 = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject2, iDAndRealm.getRealm());
                dataObject = dataObject2.createDataObject("contexts");
                dataObject.set("key", (Object)"allowOperationIfReposDown");
                dataObject.set("value", (Object)RealmManager.singleton().getAllowOperationIfReposDown(iDAndRealm.getRealm()));
            }
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                this.mappingUtils.createLoginControlDataObject(dataObject2, this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()));
            }
            dataObject = dataObject2.createDataObject("entities", "http://www.ibm.com/websphere/wim", "LoginAccount");
            dataObject.set("principalName", (Object)iDAndRealm.getId());
            dataObject.set("password", (Object)PasswordUtil.getByteArrayPassword(string2));
            dataObject2 = this.mappingUtils.getWimService().login(dataObject2);
            List list = dataObject2.getList("entities");
            if (list.isEmpty()) {
                throw new PasswordCheckFailedException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string3);
            }
            DataObject dataObject3 = (DataObject)list.get(0);
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                stringBuffer.append(dataObject3.getString(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())));
            } else {
                stringBuffer.append(dataObject3.getString("identifier/" + this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())));
            }
            if (iDAndRealm.isRealmDefined() && !RealmManager.singleton().getDefaultRealmName().equals(iDAndRealm.getRealm())) {
                stringBuffer.append(iDAndRealm.getDelimiter() + iDAndRealm.getRealm());
            }
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof PasswordCheckFailedException) {
                throw new com.ibm.websphere.security.PasswordCheckFailedException(wIMException);
            }
            if (wIMException instanceof EntityNotFoundException) {
                throw new com.ibm.websphere.security.PasswordCheckFailedException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.loginBridgeTrace.isLoggable(Level.FINER)) {
            this.loginBridgeTrace.exiting(this.className, string3, "returnValue = \"" + stringBuffer + "\"");
        }
        return stringBuffer.toString();
    }

    public String mapCertificate(X509Certificate[] x509CertificateArray) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException, RemoteException {
        String string = "mapCertificate";
        if (this.loginBridgeTrace.isLoggable(Level.FINER)) {
            this.loginBridgeTrace.entering(this.className, string, "inputCertificates = \"" + x509CertificateArray + "\"");
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.mappingUtils.validateCertificateArray(x509CertificateArray);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm("");
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                this.mappingUtils.createLoginControlDataObject(dataObject, this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()));
            }
            DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "LoginAccount");
            dataObject2.getList("certificate").add(x509CertificateArray[0].getEncoded());
            dataObject = this.mappingUtils.getWimService().login(dataObject);
            List list = dataObject.getList("entities");
            if (list.isEmpty()) {
                throw new com.ibm.websphere.wim.exception.CertificateMapFailedException();
            }
            DataObject dataObject3 = (DataObject)list.get(0);
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                stringBuffer.append(dataObject3.getString(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())));
            } else {
                stringBuffer.append(dataObject3.getString("identifier/" + this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())));
            }
            if (iDAndRealm.isRealmDefined() && !RealmManager.singleton().getDefaultRealmName().equals(iDAndRealm.getRealm())) {
                stringBuffer.append(iDAndRealm.getDelimiter() + iDAndRealm.getRealm());
            }
        }
        catch (CertificateEncodingException certificateEncodingException) {
            this.mappingUtils.logException(certificateEncodingException, this.className);
            throw new CustomRegistryException(certificateEncodingException);
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof com.ibm.websphere.wim.exception.CertificateMapNotSupportedException) {
                throw new CertificateMapNotSupportedException(wIMException);
            }
            if (wIMException instanceof com.ibm.websphere.wim.exception.CertificateMapFailedException) {
                throw new CertificateMapFailedException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.loginBridgeTrace.isLoggable(Level.FINER)) {
            this.loginBridgeTrace.exiting(this.className, string, "returnValue = \"" + stringBuffer + "\"");
        }
        return stringBuffer.toString();
    }
}

