/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry.util;

import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InvalidIdentifierException;
import com.ibm.websphere.wim.exception.InvalidUniqueNameException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.RealmManager;
import com.ibm.ws.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.wim.registry.util.BridgeUtils;
import com.ibm.ws.wim.registry.util.TypeMappings;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MembershipBridge {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private final String className = MembershipBridge.class.getName();
    private Logger membershipBridgeTrace = WIMLogger.getTraceLogger(this.className);
    private TypeMappings propertyMap = new TypeMappings();
    private BridgeUtils mappingUtils = new BridgeUtils();

    public MembershipBridge() {
        String string = "MembershipBridge";
        if (this.membershipBridgeTrace.isLoggable(Level.FINER)) {
            this.membershipBridgeTrace.entering(this.className, string);
        }
        if (this.membershipBridgeTrace.isLoggable(Level.FINER)) {
            this.membershipBridgeTrace.exiting(this.className, string);
        }
    }

    public List getGroupsForUser(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "getGroupsForUser";
        if (this.membershipBridgeTrace.isLoggable(Level.FINER)) {
            this.membershipBridgeTrace.entering(this.className, string2, "inputUserSecurityName = \"" + string + "\"");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Object object;
            String string3;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            String string4 = "'";
            String string5 = iDAndRealm.getId();
            if (string5.indexOf("'") != -1) {
                string4 = "\"";
            }
            String string6 = this.propertyMap.getInputUserSecurityName(iDAndRealm.getRealm());
            DataObject dataObject2 = this.mappingUtils.getEntityByIdentifier(dataObject, string6 = this.mappingUtils.getRealInputAttrName(string6, string5, true), string5, string3 = this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()), this.mappingUtils);
            if (dataObject2 != null) {
                dataObject = dataObject2;
            } else {
                object = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                object.setString("expression", "//entities[@xsi:type='LoginAccount' and " + string6 + "=" + string4 + string5 + string4 + "]");
                dataObject = this.mappingUtils.getWimService().search(dataObject);
            }
            object = dataObject.getList("entities");
            if (object.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            if (object.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            DataObject dataObject3 = (DataObject)object.get(0);
            iDAndRealm.setId(dataObject3.getString("identifier/uniqueName"));
            dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            dataObject3 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMembershipControl");
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()))) {
                dataObject3.getList("properties").add(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()));
            }
            dataObject3.setString("level", Short.toString(this.mappingUtils.getGroupDepth()));
            dataObject3.setString("expression", "@xsi:type='Group'");
            DataObject dataObject4 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "LoginAccount");
            dataObject4.createDataObject("identifier").setString("uniqueName", iDAndRealm.getId());
            dataObject = this.mappingUtils.getWimService().get(dataObject);
            List list = dataObject.getList("entities");
            if (list.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            DataObject dataObject5 = (DataObject)list.get(0);
            List list2 = dataObject5.getList("groups");
            if (!list2.isEmpty()) {
                for (int i = 0; i < list2.size(); ++i) {
                    DataObject dataObject6 = (DataObject)list2.get(i);
                    if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()))) {
                        arrayList.add(dataObject6.getString(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm())));
                        continue;
                    }
                    arrayList.add(dataObject6.getString("identifier/" + this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm())));
                }
            }
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof EntityNotFoundException || wIMException instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.membershipBridgeTrace.isLoggable(Level.FINER)) {
            this.membershipBridgeTrace.exiting(this.className, string2, "returnValue = \"" + arrayList + "\"");
        }
        return arrayList;
    }

    public Result getUsersForGroup(String string, int n) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "getUsersForGroup";
        if (this.membershipBridgeTrace.isLoggable(Level.FINER)) {
            this.membershipBridgeTrace.entering(this.className, string2, "inputGroupSecurityName = \"" + string + "\", inputLimit = \"" + Integer.toString(n) + "\"");
        }
        Result result = new Result();
        try {
            Object object;
            String string3;
            this.mappingUtils.validateId(string);
            this.mappingUtils.validateLimit(n);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            String string4 = "'";
            String string5 = iDAndRealm.getId();
            if (string5.indexOf("'") != -1) {
                string4 = "\"";
            }
            String string6 = this.propertyMap.getInputGroupSecurityName(iDAndRealm.getRealm());
            DataObject dataObject2 = this.mappingUtils.getEntityByIdentifier(dataObject, string6 = this.mappingUtils.getRealInputAttrName(string6, string5, false), string5, string3 = "uniqueName", this.mappingUtils);
            if (dataObject2 != null) {
                dataObject = dataObject2;
            } else {
                object = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                object.setString("expression", "//entities[@xsi:type='Group' and " + string6 + "=" + string4 + string5 + string4 + "]");
                dataObject = this.mappingUtils.getWimService().search(dataObject);
            }
            object = dataObject.getList("entities");
            if (object.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            if (object.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            DataObject dataObject3 = (DataObject)object.get(0);
            iDAndRealm.setId(dataObject3.getString("identifier/uniqueName"));
            dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            dataObject3 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMemberControl");
            dataObject3.setString("level", Short.toString(this.mappingUtils.getGroupDepth()));
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                dataObject3.getList("properties").add(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()));
            }
            if (n != 0) {
                dataObject3.setString("countLimit", Integer.toString(n + 1));
            } else {
                dataObject3.setString("countLimit", Integer.toString(n));
            }
            dataObject3.setString("expression", "@xsi:type='LoginAccount'");
            DataObject dataObject4 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "Group");
            dataObject4.createDataObject("identifier").setString("uniqueName", iDAndRealm.getId());
            dataObject = this.mappingUtils.getWimService().get(dataObject);
            List list = dataObject.getList("entities");
            if (list.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            DataObject dataObject5 = (DataObject)list.get(0);
            List list2 = dataObject5.getList("members");
            if (!list2.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < list2.size(); ++i) {
                    if (n != 0 && i == n) {
                        result.setHasMore();
                        break;
                    }
                    DataObject dataObject6 = (DataObject)list2.get(i);
                    if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                        arrayList.add(dataObject6.getString(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())));
                        continue;
                    }
                    arrayList.add(dataObject6.getString("identifier/" + this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())));
                }
                result.setList(arrayList);
            } else {
                result.setList(new ArrayList());
            }
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof EntityNotFoundException || wIMException instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.membershipBridgeTrace.isLoggable(Level.FINER)) {
            this.membershipBridgeTrace.exiting(this.className, string2, "returnValue = \"" + result + "\"");
        }
        return result;
    }

    public List getUniqueGroupIds(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "getUniqueGroupIds";
        if (this.membershipBridgeTrace.isLoggable(Level.FINER)) {
            this.membershipBridgeTrace.entering(this.className, string2, "inputUniqueUserId = \"" + string + "\"");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            DataObject dataObject;
            List list;
            DataObject dataObject2;
            DataObject dataObject3;
            String string3;
            String string4;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject4 = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject4, iDAndRealm.getRealm());
                string4 = dataObject4.createDataObject("contexts");
                string4.set("key", (Object)"allowOperationIfReposDown");
                string4.set("value", (Object)RealmManager.singleton().getAllowOperationIfReposDown(iDAndRealm.getRealm()));
            }
            string4 = "'";
            String string5 = iDAndRealm.getId();
            if (string5.indexOf("'") != -1) {
                string4 = "\"";
            }
            String string6 = this.propertyMap.getInputUniqueUserId(iDAndRealm.getRealm());
            DataObject dataObject5 = this.mappingUtils.getEntityByIdentifier(dataObject4, string6 = this.mappingUtils.getRealInputAttrName(string6, string5, true), string5, string3 = this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm()), this.mappingUtils);
            if (dataObject5 != null) {
                dataObject4 = dataObject5;
            } else {
                dataObject3 = dataObject4.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                dataObject2 = dataObject4.createDataObject("contexts");
                dataObject2.set("key", (Object)"allowOperationIfReposDown");
                dataObject2.set("value", (Object)RealmManager.singleton().getAllowOperationIfReposDown("allowOperationIfReposDown"));
                dataObject3.setString("expression", "//entities[@xsi:type='LoginAccount' and " + string6 + "=" + string4 + string5 + string4 + "]");
                dataObject4 = this.mappingUtils.getWimService().search(dataObject4);
                list = dataObject4.getList("entities");
                if (list.isEmpty()) {
                    throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
                }
                if (list.size() != 1) {
                    throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
                }
                dataObject = (DataObject)list.get(0);
                iDAndRealm.setId(dataObject.getString("identifier/uniqueName"));
            }
            dataObject4 = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject4, iDAndRealm.getRealm());
                dataObject3 = dataObject4.createDataObject("contexts");
                dataObject3.set("key", (Object)"allowOperationIfReposDown");
                dataObject3.set("value", (Object)RealmManager.singleton().getAllowOperationIfReposDown(iDAndRealm.getRealm()));
            }
            dataObject3 = dataObject4.createDataObject("controls", "http://www.ibm.com/websphere/wim", "GroupMembershipControl");
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm()))) {
                dataObject3.getList("properties").add(this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm()));
            }
            dataObject3.setString("level", Short.toString(this.mappingUtils.getGroupDepth()));
            dataObject3.setString("expression", "@xsi:type='Group'");
            dataObject2 = dataObject4.createDataObject("entities", "http://www.ibm.com/websphere/wim", "LoginAccount");
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getInputUniqueUserId(iDAndRealm.getRealm()))) {
                dataObject2.createDataObject("identifier").setString("uniqueName", iDAndRealm.getId());
            } else {
                dataObject2.createDataObject("identifier").setString(this.propertyMap.getInputUniqueUserId(iDAndRealm.getRealm()), iDAndRealm.getId());
                if (this.propertyMap.getInputUniqueUserId(iDAndRealm.getRealm()).equals("externalName")) {
                    dataObject4.createDataObject("controls", "http://www.ibm.com/websphere/wim", "ExternalNameControl");
                }
            }
            dataObject4 = this.mappingUtils.getWimService().get(dataObject4);
            list = dataObject4.getList("entities");
            if (list.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            dataObject = (DataObject)list.get(0);
            List list2 = dataObject.getList("groups");
            if (!list2.isEmpty()) {
                for (int i = 0; i < list2.size(); ++i) {
                    DataObject dataObject6 = (DataObject)list2.get(i);
                    if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm()))) {
                        arrayList.add(dataObject6.getString(this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm())));
                        continue;
                    }
                    arrayList.add(dataObject6.getString("identifier/" + this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm())));
                }
            }
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof EntityNotFoundException) {
                throw new EntryNotFoundException(wIMException);
            }
            if (wIMException instanceof InvalidUniqueNameException) {
                throw new EntryNotFoundException(wIMException);
            }
            if (wIMException instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.membershipBridgeTrace.isLoggable(Level.FINER)) {
            this.membershipBridgeTrace.exiting(this.className, string2, "returnValue = \"" + arrayList + "\"");
        }
        return arrayList;
    }
}

