/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry.util;

import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.wim.registry.util.BridgeUtils;
import com.ibm.ws.wim.registry.util.TypeMappings;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchBridge {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private final String className = SearchBridge.class.getName();
    private Logger searchBridgeTrace = WIMLogger.getTraceLogger(this.className);
    private TypeMappings propertyMap = new TypeMappings();
    private BridgeUtils mappingUtils = new BridgeUtils();
    private String groupRDN = "cn";

    public SearchBridge() {
        String string = "SearchBridge";
        if (this.searchBridgeTrace.isLoggable(Level.FINER)) {
            this.searchBridgeTrace.entering(this.className, string);
        }
        try {
            List list = ConfigManager.singleton().getRDNProperties("Group");
            if (list != null && list.size() > 0) {
                this.groupRDN = (String)list.get(0);
            }
        }
        catch (WIMException wIMException) {
            this.searchBridgeTrace.log(Level.FINE, wIMException.getMessage(), wIMException);
        }
        if (this.searchBridgeTrace.isLoggable(Level.FINER)) {
            this.searchBridgeTrace.exiting(this.className, string);
        }
    }

    public Result getUsers(String string, int n) throws CustomRegistryException, RemoteException {
        String string2 = "getUsers";
        if (this.searchBridgeTrace.isLoggable(Level.FINER)) {
            this.searchBridgeTrace.entering(this.className, string2, "inputPattern = \"" + string + "\", inputLimit = \"" + Integer.toString(n) + "\"");
        }
        Result result = new Result();
        try {
            String string3;
            boolean bl;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            if (bl = this.mappingUtils.isIdentifierTypeProperty(string3 = this.propertyMap.getInputUserSecurityName(iDAndRealm.getRealm()))) {
                string3 = "principalName";
            }
            DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                dataObject2.getList("properties").add(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()));
            }
            String string4 = "'";
            String string5 = iDAndRealm.getId();
            if (string5.indexOf("'") != -1) {
                string4 = "\"";
            }
            dataObject2.setString("expression", "//entities[@xsi:type='LoginAccount' and " + string3 + "=" + string4 + string5 + string4 + "]");
            if (n > 0) {
                dataObject2.setString("countLimit", Integer.toString(n + 1));
            } else {
                dataObject2.setString("countLimit", Integer.toString(n));
            }
            dataObject = this.mappingUtils.getWimService().search(dataObject);
            List list = dataObject.getList("entities");
            if (!list.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < list.size(); ++i) {
                    if (n > 0 && i == n) {
                        result.setHasMore();
                        break;
                    }
                    DataObject dataObject3 = (DataObject)list.get(i);
                    if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                        arrayList.add(dataObject3.getString(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())));
                        continue;
                    }
                    arrayList.add(dataObject3.getString("identifier/" + this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())));
                }
                result.setList(arrayList);
            } else {
                result.setList(new ArrayList());
            }
        }
        catch (WIMException wIMException) {
            if (wIMException instanceof EntityNotFoundException) {
                result.setList(new ArrayList());
            }
            this.mappingUtils.logException(wIMException, this.className);
            throw new CustomRegistryException(wIMException);
        }
        if (this.searchBridgeTrace.isLoggable(Level.FINER)) {
            this.searchBridgeTrace.exiting(this.className, string2, "returnValue = \"" + result + "\"");
        }
        return result;
    }

    public Result getGroups(String string, int n) throws CustomRegistryException, RemoteException {
        String string2 = "getGroups";
        if (this.searchBridgeTrace.isLoggable(Level.FINER)) {
            this.searchBridgeTrace.entering(this.className, string2, "inputPattern = \"" + string + "\", inputLimit = \"" + Integer.toString(n) + "\"");
        }
        Result result = new Result();
        try {
            String string3;
            boolean bl;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            if (bl = this.mappingUtils.isIdentifierTypeProperty(string3 = this.propertyMap.getInputGroupSecurityName(iDAndRealm.getRealm()))) {
                string3 = this.groupRDN;
            }
            DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
            if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()))) {
                dataObject2.getList("properties").add(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()));
            }
            String string4 = "'";
            String string5 = iDAndRealm.getId();
            if (string5.indexOf("'") != -1) {
                string4 = "\"";
            }
            dataObject2.setString("expression", "//entities[@xsi:type='Group' and " + string3 + "=" + string4 + string5 + string4 + "]");
            if (n > 0) {
                dataObject2.setString("countLimit", Integer.toString(n + 1));
            } else {
                dataObject2.setString("countLimit", Integer.toString(n));
            }
            dataObject = this.mappingUtils.getWimService().search(dataObject);
            List list = dataObject.getList("entities");
            if (!list.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < list.size(); ++i) {
                    if (n > 0 && i == n) {
                        result.setHasMore();
                        break;
                    }
                    DataObject dataObject3 = (DataObject)list.get(i);
                    if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()))) {
                        arrayList.add(dataObject3.getString(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm())));
                        continue;
                    }
                    arrayList.add(dataObject3.getString("identifier/" + this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm())));
                }
                result.setList(arrayList);
            } else {
                result.setList(new ArrayList());
            }
        }
        catch (WIMException wIMException) {
            if (wIMException instanceof EntityNotFoundException) {
                result.setList(new ArrayList());
            }
            this.mappingUtils.logException(wIMException, this.className);
            throw new CustomRegistryException(wIMException);
        }
        if (this.searchBridgeTrace.isLoggable(Level.FINER)) {
            this.searchBridgeTrace.exiting(this.className, string2, "returnValue = \"" + result + "\"");
        }
        return result;
    }
}

