/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry.util;

import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.EntityNotInRealmScopeException;
import com.ibm.websphere.wim.exception.InvalidIdentifierException;
import com.ibm.websphere.wim.exception.InvalidUniqueNameException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.RealmManager;
import com.ibm.ws.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.wim.registry.util.BridgeUtils;
import com.ibm.ws.wim.registry.util.TypeMappings;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecurityNameBridge {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private final String className = SecurityNameBridge.class.getName();
    private Logger securityNameBridgeTrace = WIMLogger.getTraceLogger(this.className);
    private TypeMappings propertyMap = new TypeMappings();
    private BridgeUtils mappingUtils = new BridgeUtils();

    public SecurityNameBridge() {
        String string = "SecurityNameBridge";
        if (this.securityNameBridgeTrace.isLoggable(Level.FINER)) {
            this.securityNameBridgeTrace.entering(this.className, string);
        }
        if (this.securityNameBridgeTrace.isLoggable(Level.FINER)) {
            this.securityNameBridgeTrace.exiting(this.className, string);
        }
    }

    public String getUserSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "getUserSecurityName";
        if (this.securityNameBridgeTrace.isLoggable(Level.FINER)) {
            this.securityNameBridgeTrace.entering(this.className, string2, "inputUniqueUserId = \"" + string + "\"");
        }
        String string3 = "";
        try {
            String string4;
            Object object;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
                object = dataObject.createDataObject("contexts");
                object.set("key", (Object)"allowOperationIfReposDown");
                object.set("value", (Object)RealmManager.singleton().getAllowOperationIfReposDown(iDAndRealm.getRealm()));
            }
            if (this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getInputUniqueUserId(iDAndRealm.getRealm()))) {
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                    this.mappingUtils.createPropertyControlDataObject(dataObject, this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()));
                }
                object = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "LoginAccount");
                object.createDataObject("identifier").setString(this.propertyMap.getInputUniqueUserId(iDAndRealm.getRealm()), iDAndRealm.getId());
                if (this.propertyMap.getInputUniqueUserId(iDAndRealm.getRealm()).equals("externalName")) {
                    dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "ExternalNameControl");
                }
                dataObject = this.mappingUtils.getWimService().get(dataObject);
            } else {
                object = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                    object.getList("properties").add(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()));
                }
                string4 = "'";
                String string5 = iDAndRealm.getId();
                if (string5.indexOf("'") != -1) {
                    string4 = "\"";
                }
                object.setString("expression", "//entities[@xsi:type='LoginAccount' and " + this.propertyMap.getInputUniqueUserId(iDAndRealm.getRealm()) + "=" + string4 + string5 + string4 + "]");
                dataObject = this.mappingUtils.getWimService().search(dataObject);
            }
            object = dataObject.getList("entities");
            if (object.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            if (object.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            string4 = (DataObject)object.get(0);
            string3 = !this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())) ? string4.getString(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm())) : string4.getString("identifier/" + this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()));
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof EntityNotFoundException) {
                throw new EntryNotFoundException(wIMException);
            }
            if (wIMException instanceof EntityNotInRealmScopeException) {
                throw new EntryNotFoundException(wIMException);
            }
            if (wIMException instanceof InvalidUniqueNameException) {
                throw new EntryNotFoundException(wIMException);
            }
            if (wIMException instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.securityNameBridgeTrace.isLoggable(Level.FINER)) {
            this.securityNameBridgeTrace.exiting(this.className, string2, "returnValue = \"" + string3 + "\"");
        }
        return string3;
    }

    public String getGroupSecurityName(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "getGroupSecurityName";
        if (this.securityNameBridgeTrace.isLoggable(Level.FINER)) {
            this.securityNameBridgeTrace.entering(this.className, string2, "inputUniqueGroupId = \"" + string + "\"");
        }
        String string3 = "";
        try {
            String string4;
            Object object;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            if (this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getInputUniqueGroupId(iDAndRealm.getRealm()))) {
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()))) {
                    this.mappingUtils.createPropertyControlDataObject(dataObject, this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()));
                }
                object = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "Group");
                object.createDataObject("identifier").setString(this.propertyMap.getInputUniqueGroupId(iDAndRealm.getRealm()), iDAndRealm.getId());
                if (this.propertyMap.getInputUniqueGroupId(iDAndRealm.getRealm()).equals("externalName")) {
                    dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "ExternalNameControl");
                }
                dataObject = this.mappingUtils.getWimService().get(dataObject);
            } else {
                object = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()))) {
                    object.getList("properties").add(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()));
                }
                string4 = "'";
                String string5 = iDAndRealm.getId();
                if (string5.indexOf("'") != -1) {
                    string4 = "\"";
                }
                object.setString("expression", "//entities[@xsi:type='Group' and " + this.propertyMap.getInputUniqueGroupId(iDAndRealm.getRealm()) + "=" + string4 + string5 + string4 + "]");
                dataObject = this.mappingUtils.getWimService().search(dataObject);
            }
            object = dataObject.getList("entities");
            if (object.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            if (object.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            string4 = (DataObject)object.get(0);
            string3 = !this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm())) ? string4.getString(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm())) : string4.getString("identifier/" + this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()));
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof EntityNotFoundException) {
                throw new EntryNotFoundException(wIMException);
            }
            if (wIMException instanceof EntityNotInRealmScopeException) {
                throw new EntryNotFoundException(wIMException);
            }
            if (wIMException instanceof InvalidUniqueNameException) {
                throw new EntryNotFoundException(wIMException);
            }
            if (wIMException instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.securityNameBridgeTrace.isLoggable(Level.FINER)) {
            this.securityNameBridgeTrace.exiting(this.className, string2, "returnValue = \"" + string3 + "\"");
        }
        return string3;
    }
}

