/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry.util;

import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.InvalidIdentifierException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.RealmManager;
import com.ibm.ws.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.wim.registry.util.BridgeUtils;
import com.ibm.ws.wim.registry.util.TypeMappings;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UniqueIdBridge {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private final String className = UniqueIdBridge.class.getName();
    private Logger uniqueIdBridgeTrace = WIMLogger.getTraceLogger(this.className);
    private TypeMappings propertyMap = new TypeMappings();
    private BridgeUtils mappingUtils = new BridgeUtils();
    private String groupRDN = "cn";

    public UniqueIdBridge() {
        String string = "UniqueIdBridge";
        if (this.uniqueIdBridgeTrace.isLoggable(Level.FINER)) {
            this.uniqueIdBridgeTrace.entering(this.className, string);
        }
        try {
            List list = ConfigManager.singleton().getRDNProperties("Group");
            if (list != null && list.size() > 0) {
                this.groupRDN = (String)list.get(0);
            }
        }
        catch (WIMException wIMException) {
            this.uniqueIdBridgeTrace.log(Level.FINE, wIMException.getMessage(), wIMException);
        }
        if (this.uniqueIdBridgeTrace.isLoggable(Level.FINER)) {
            this.uniqueIdBridgeTrace.exiting(this.className, string);
        }
    }

    public String getUniqueUserId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "getUniqueUserId";
        if (this.uniqueIdBridgeTrace.isLoggable(Level.FINER)) {
            this.uniqueIdBridgeTrace.entering(this.className, string2, "inputUserSecurityName = \"" + string + "\"");
        }
        String string3 = "";
        try {
            Object object;
            String string4;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
                string4 = dataObject.createDataObject("contexts");
                string4.set("key", (Object)"allowOperationIfReposDown");
                string4.set("value", (Object)RealmManager.singleton().getAllowOperationIfReposDown(iDAndRealm.getRealm()));
            }
            string4 = "'";
            String string5 = iDAndRealm.getId();
            if (string5.indexOf("'") != -1) {
                string4 = "\"";
            }
            String string6 = this.propertyMap.getInputUserSecurityName(iDAndRealm.getRealm());
            string6 = this.mappingUtils.getRealInputAttrName(string6, string5, true);
            String string7 = this.propertyMap.getOutputUniqueUserId(iDAndRealm.getRealm());
            DataObject dataObject2 = null;
            dataObject2 = this.mappingUtils.getEntityByIdentifier(dataObject, string6, string5, string7, this.mappingUtils);
            if (dataObject2 != null) {
                dataObject = dataObject2;
            } else {
                object = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUniqueUserId(iDAndRealm.getRealm()))) {
                    object.getList("properties").add(this.propertyMap.getOutputUniqueUserId(iDAndRealm.getRealm()));
                }
                object.setString("expression", "//entities[@xsi:type='LoginAccount' and " + string6 + "=" + string4 + string5 + string4 + "]");
                dataObject = this.mappingUtils.getWimService().search(dataObject);
            }
            object = dataObject.getList("entities");
            if (object.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            if (object.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            DataObject dataObject3 = (DataObject)object.get(0);
            string3 = !this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUniqueUserId(iDAndRealm.getRealm())) ? dataObject3.getString(this.propertyMap.getOutputUniqueUserId(iDAndRealm.getRealm())) : dataObject3.getString("identifier/" + this.propertyMap.getOutputUniqueUserId(iDAndRealm.getRealm()));
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof EntityNotFoundException || wIMException instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.uniqueIdBridgeTrace.isLoggable(Level.FINER)) {
            this.uniqueIdBridgeTrace.exiting(this.className, string2, "returnValue = \"" + string3 + "\"");
        }
        return string3;
    }

    public String getUniqueGroupId(String string) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        String string2 = "getUniqueGroupId";
        if (this.uniqueIdBridgeTrace.isLoggable(Level.FINER)) {
            this.uniqueIdBridgeTrace.entering(this.className, string2, "inputGroupSecurityName = \"" + string + "\"");
        }
        String string3 = "";
        try {
            Object object;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            String string4 = "'";
            String string5 = iDAndRealm.getId();
            if (string5.indexOf("'") != -1) {
                string4 = "\"";
            }
            String string6 = this.propertyMap.getInputGroupSecurityName(iDAndRealm.getRealm());
            string6 = this.mappingUtils.getRealInputAttrName(string6, string5, false);
            String string7 = this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm());
            DataObject dataObject2 = null;
            dataObject2 = this.mappingUtils.getEntityByIdentifier(dataObject, string6, string5, string7, this.mappingUtils);
            if (dataObject2 != null) {
                dataObject = dataObject2;
            } else {
                object = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm()))) {
                    object.getList("properties").add(this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm()));
                }
                object.setString("expression", "//entities[@xsi:type='Group' and " + string6 + "=" + string4 + string5 + string4 + "]");
                dataObject = this.mappingUtils.getWimService().search(dataObject);
            }
            object = dataObject.getList("entities");
            if (object.isEmpty()) {
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            if (object.size() != 1) {
                throw new EntityNotFoundException("MULTIPLE_PRINCIPALS_FOUND", WIMMessageHelper.generateMsgParms(string), this.className, string2);
            }
            DataObject dataObject3 = (DataObject)object.get(0);
            string3 = !this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm())) ? dataObject3.getString(this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm())) : dataObject3.getString("identifier/" + this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm()));
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            if (wIMException instanceof EntityNotFoundException || wIMException instanceof InvalidIdentifierException) {
                throw new EntryNotFoundException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (this.uniqueIdBridgeTrace.isLoggable(Level.FINER)) {
            this.uniqueIdBridgeTrace.exiting(this.className, string2, "returnValue = \"" + string3 + "\"");
        }
        return string3;
    }
}

