/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry.util;

import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.wim.Service;
import com.ibm.websphere.wim.exception.EntityNotFoundException;
import com.ibm.websphere.wim.exception.PasswordCheckFailedException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.ws.wim.SPIServiceProvider;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.configmodel.ConfigurationProviderType;
import com.ibm.ws.wim.configmodel.RealmConfigurationType;
import com.ibm.ws.wim.configmodel.RealmType;
import com.ibm.ws.wim.configmodel.UserRegistryInfoMappingType;
import com.ibm.ws.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.wim.registry.util.BridgeUtils;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserRegistryValidator {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = UserRegistryValidator.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    public static final String SESSION_ID = "SESSIONID";
    private BridgeUtils mappingUtils = new BridgeUtils();
    private Service SPIService = null;
    private ConfigurationProviderType configDO = null;
    private RealmConfigurationType realmConfig = null;
    private String defaultRealm = null;
    private String defaultRealmDelimiter = null;
    private Set virtualRealms = new HashSet();
    private Map virtualRealmsDelimiter = new HashMap();

    public UserRegistryValidator(String string) throws CustomRegistryException, RemoteException {
        String string2 = "<init>";
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, string2, "sessionId = " + string);
        }
        Properties properties = new Properties();
        properties.put(SESSION_ID, string);
        this.initialize(properties);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, string2);
        }
    }

    public void initialize(Properties properties) throws CustomRegistryException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "initialize", "inputProperties = " + properties);
        }
        try {
            this.SPIService = new SPIServiceProvider((String)properties.get(SESSION_ID));
            trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "SPIService initialized: " + this.SPIService);
            this.configDO = (ConfigurationProviderType)this.SPIService.getConfig();
            this.realmConfig = this.configDO.getRealmConfiguration();
            this.defaultRealm = this.realmConfig.getDefaultRealm();
            trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "default realm=" + this.defaultRealm);
            List list = this.realmConfig.getRealms();
            for (int i = 0; i < list.size(); ++i) {
                RealmType realmType = (RealmType)list.get(i);
                if (this.defaultRealm.equals(realmType.getName())) {
                    this.defaultRealmDelimiter = realmType.getDelimiter();
                }
                this.virtualRealms.add(realmType.getName());
                this.virtualRealmsDelimiter.put(realmType.getName(), realmType.getDelimiter());
            }
            trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "realms=" + this.virtualRealms);
            trcLogger.logp(Level.FINE, CLASSNAME, "initialize", "realmsDelimiter=" + this.virtualRealmsDelimiter);
        }
        catch (WIMException wIMException) {
            throw new CustomRegistryException(wIMException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "initialize");
        }
    }

    public String checkPassword(String string, String string2) throws com.ibm.websphere.security.PasswordCheckFailedException, CustomRegistryException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "checkPassword", "inputUser = \"" + string + "\", inputPassword = *");
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string, this.defaultRealm, this.defaultRealmDelimiter, this.virtualRealms, this.virtualRealmsDelimiter);
            DataObject dataObject = this.SPIService.createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            if (!this.mappingUtils.isIdentifierTypeProperty(this.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                this.mappingUtils.createLoginControlDataObject(dataObject, this.getOutputUserSecurityName(iDAndRealm.getRealm()));
            }
            DataObject dataObject2 = dataObject.createDataObject("entities", "http://www.ibm.com/websphere/wim", "LoginAccount");
            trcLogger.logp(Level.FINE, CLASSNAME, "checkPassword", "DataObject with LoginAccount=" + WIMTraceHelper.printDataGraph(dataObject));
            dataObject2.set("principalName", (Object)iDAndRealm.getId());
            dataObject2.set("password", (Object)PasswordUtil.getByteArrayPassword(string2));
            trcLogger.logp(Level.FINE, CLASSNAME, "checkPassword", "DataObject before login=" + WIMTraceHelper.printDataGraph(dataObject));
            dataObject = this.SPIService.login(dataObject);
            trcLogger.logp(Level.FINE, CLASSNAME, "checkPassword", "DataObject after login=" + WIMTraceHelper.printDataGraph(dataObject));
            List list = dataObject.getList("entities");
            if (list.isEmpty()) {
                throw new PasswordCheckFailedException("ENTITY_NOT_FOUND", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "checkPassword");
            }
            DataObject dataObject3 = (DataObject)list.get(0);
            if (!this.mappingUtils.isIdentifierTypeProperty(this.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                stringBuffer.append(dataObject3.getString(this.getOutputUserSecurityName(iDAndRealm.getRealm())));
            } else {
                stringBuffer.append(dataObject3.getString("identifier/" + this.getOutputUserSecurityName(iDAndRealm.getRealm())));
            }
            if (iDAndRealm.isRealmDefined() && !this.defaultRealm.equals(iDAndRealm.getRealm())) {
                stringBuffer.append(iDAndRealm.getDelimiter() + iDAndRealm.getRealm());
            }
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, CLASSNAME);
            if (wIMException instanceof PasswordCheckFailedException) {
                throw new com.ibm.websphere.security.PasswordCheckFailedException(wIMException);
            }
            if (wIMException instanceof EntityNotFoundException) {
                throw new com.ibm.websphere.security.PasswordCheckFailedException(wIMException);
            }
            throw new CustomRegistryException(wIMException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "checkPassword", "returnValue = \"" + stringBuffer + "\"");
        }
        return stringBuffer.toString();
    }

    public Result getUsers(String string, int n) throws CustomRegistryException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getUsers", "inputPattern = \"" + string + "\", inputLimit = \"" + Integer.toString(n) + "\"");
        }
        Result result = new Result();
        try {
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string, this.defaultRealm, this.defaultRealmDelimiter, this.virtualRealms, this.virtualRealmsDelimiter);
            DataObject dataObject = this.SPIService.createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject, iDAndRealm.getRealm());
            }
            DataObject dataObject2 = dataObject.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
            if (!this.mappingUtils.isIdentifierTypeProperty(this.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                dataObject2.getList("properties").add(this.getOutputUserSecurityName(iDAndRealm.getRealm()));
            }
            String string2 = "'";
            String string3 = iDAndRealm.getId();
            if (string3.indexOf("'") != -1) {
                string2 = "\"";
            }
            dataObject2.setString("expression", "//entities[@xsi:type='LoginAccount' and " + this.getInputUserSecurityName(iDAndRealm.getRealm()) + "=" + string2 + string3 + string2 + "]");
            if (n > 0) {
                dataObject2.setString("countLimit", Integer.toString(n + 1));
            } else {
                dataObject2.setString("countLimit", Integer.toString(n));
            }
            trcLogger.logp(Level.FINE, CLASSNAME, "getUsers", "DataObject before search=" + WIMTraceHelper.printDataGraph(dataObject));
            dataObject = this.SPIService.search(dataObject);
            trcLogger.logp(Level.FINE, CLASSNAME, "getUsers", "DataObject after search=" + WIMTraceHelper.printDataGraph(dataObject));
            List list = dataObject.getList("entities");
            if (!list.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int i = 0; i < list.size(); ++i) {
                    if (n > 0 && i == n) {
                        result.setHasMore();
                        break;
                    }
                    DataObject dataObject3 = (DataObject)list.get(i);
                    if (!this.mappingUtils.isIdentifierTypeProperty(this.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                        arrayList.add(dataObject3.getString(this.getOutputUserSecurityName(iDAndRealm.getRealm())));
                        continue;
                    }
                    arrayList.add(dataObject3.getString("identifier/" + this.getOutputUserSecurityName(iDAndRealm.getRealm())));
                }
                result.setList(arrayList);
            } else {
                result.setList(new ArrayList());
            }
        }
        catch (WIMException wIMException) {
            if (wIMException instanceof EntityNotFoundException) {
                result.setList(new ArrayList());
            }
            this.mappingUtils.logException(wIMException, CLASSNAME);
            throw new CustomRegistryException(wIMException);
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getUsers", "returnValue = \"" + result.getList() + "\"");
        }
        return result;
    }

    private String getOutputUserSecurityName(String string) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getOutputUserSecurityName", "realmName=" + string);
        }
        String string2 = null;
        ConfigurationProviderType configurationProviderType = (ConfigurationProviderType)this.SPIService.getConfig();
        RealmConfigurationType realmConfigurationType = configurationProviderType.getRealmConfiguration();
        RealmType realmType = ConfigUtils.getRealm(string, realmConfigurationType, true);
        UserRegistryInfoMappingType userRegistryInfoMappingType = realmType.getUserSecurityNameMapping();
        string2 = userRegistryInfoMappingType.getPropertyForOutput();
        if (string2 == null || string2.equals("")) {
            string2 = "principalName";
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getOutputUserSecurityName", "returnValue=" + string2);
        }
        return string2;
    }

    private String getInputUserSecurityName(String string) throws WIMException, RemoteException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "getInputUserSecurityName", "realmName=" + string);
        }
        String string2 = null;
        ConfigurationProviderType configurationProviderType = (ConfigurationProviderType)this.SPIService.getConfig();
        RealmConfigurationType realmConfigurationType = configurationProviderType.getRealmConfiguration();
        RealmType realmType = ConfigUtils.getRealm(string, realmConfigurationType, true);
        UserRegistryInfoMappingType userRegistryInfoMappingType = realmType.getUserSecurityNameMapping();
        string2 = userRegistryInfoMappingType.getPropertyForInput();
        if (string2 == null || string2.equals("")) {
            string2 = "principalName";
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "getInputUserSecurityName", "returnValue=" + string2);
        }
        return string2;
    }
}

