/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.registry.util;

import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.registry.dataobject.IDAndRealm;
import com.ibm.ws.wim.registry.util.BridgeUtils;
import com.ibm.ws.wim.registry.util.TypeMappings;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValidBridge {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private final String className = ValidBridge.class.getName();
    private Logger validBridgeTrace = WIMLogger.getTraceLogger(this.className);
    private TypeMappings propertyMap = new TypeMappings();
    private BridgeUtils mappingUtils = new BridgeUtils();

    public ValidBridge() {
        String string = "ValidBridge";
        if (this.validBridgeTrace.isLoggable(Level.FINER)) {
            this.validBridgeTrace.entering(this.className, string);
        }
        if (this.validBridgeTrace.isLoggable(Level.FINER)) {
            this.validBridgeTrace.exiting(this.className, string);
        }
    }

    public boolean isValidUser(String string) throws CustomRegistryException, RemoteException {
        String string2 = "isValidUser";
        if (this.validBridgeTrace.isLoggable(Level.FINER)) {
            this.validBridgeTrace.entering(this.className, string2, "inputUserSecurityName = \"" + string + "\"");
        }
        boolean bl = false;
        try {
            Object object;
            String string3;
            String string4;
            DataObject dataObject;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject2 = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject2, iDAndRealm.getRealm());
            }
            String string5 = "'";
            String string6 = iDAndRealm.getId();
            if (string6.indexOf("'") != -1) {
                string5 = "\"";
            }
            if ((dataObject = this.mappingUtils.getEntityByIdentifier(dataObject2, string4 = this.propertyMap.getInputUserSecurityName(iDAndRealm.getRealm()), string6, string3 = this.propertyMap.getOutputUniqueUserId(iDAndRealm.getRealm()), this.mappingUtils)) != null) {
                dataObject2 = dataObject;
            } else {
                object = dataObject2.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()))) {
                    object.getList("properties").add(this.propertyMap.getOutputUserSecurityName(iDAndRealm.getRealm()));
                }
                object.setString("expression", "//entities[@xsi:type='LoginAccount' and " + this.propertyMap.getInputUserSecurityName(iDAndRealm.getRealm()) + "=" + string5 + string6 + string5 + "]");
                dataObject2 = this.mappingUtils.getWimService().search(dataObject2);
            }
            object = dataObject2.getList("entities");
            if (object.size() == 1) {
                bl = true;
            }
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            throw new CustomRegistryException(wIMException);
        }
        if (this.validBridgeTrace.isLoggable(Level.FINER)) {
            this.validBridgeTrace.exiting(this.className, string2, new Object[]{Boolean.toString(bl)});
        }
        return bl;
    }

    public boolean isValidGroup(String string) throws CustomRegistryException, RemoteException {
        String string2 = "isValidGroup";
        if (this.validBridgeTrace.isLoggable(Level.FINER)) {
            this.validBridgeTrace.entering(this.className, string2, new Object[]{string});
        }
        boolean bl = false;
        try {
            Object object;
            String string3;
            String string4;
            DataObject dataObject;
            this.mappingUtils.validateId(string);
            IDAndRealm iDAndRealm = this.mappingUtils.seperateIDAndRealm(string);
            DataObject dataObject2 = this.mappingUtils.getWimService().createRootDataObject();
            if (iDAndRealm.isRealmDefined()) {
                this.mappingUtils.createRealmDataObject(dataObject2, iDAndRealm.getRealm());
            }
            String string5 = "'";
            String string6 = iDAndRealm.getId();
            if (string6.indexOf("'") != -1) {
                string5 = "\"";
            }
            if ((dataObject = this.mappingUtils.getEntityByIdentifier(dataObject2, string4 = this.propertyMap.getInputGroupSecurityName(iDAndRealm.getRealm()), string6, string3 = this.propertyMap.getOutputUniqueGroupId(iDAndRealm.getRealm()), this.mappingUtils)) != null) {
                dataObject2 = dataObject;
            } else {
                object = dataObject2.createDataObject("controls", "http://www.ibm.com/websphere/wim", "SearchControl");
                if (!this.mappingUtils.isIdentifierTypeProperty(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()))) {
                    object.getList("properties").add(this.propertyMap.getOutputGroupSecurityName(iDAndRealm.getRealm()));
                }
                object.setString("expression", "//entities[@xsi:type='Group' and " + this.propertyMap.getInputGroupSecurityName(iDAndRealm.getRealm()) + "=" + string5 + string6 + string5 + "]");
                dataObject2 = this.mappingUtils.getWimService().search(dataObject2);
            }
            object = dataObject2.getList("entities");
            if (object.size() == 1) {
                bl = true;
            }
        }
        catch (WIMException wIMException) {
            this.mappingUtils.logException(wIMException, this.className);
            throw new CustomRegistryException(wIMException);
        }
        if (this.validBridgeTrace.isLoggable(Level.FINER)) {
            this.validBridgeTrace.exiting(this.className, string2, "returnValue = \"" + Boolean.toString(bl) + "\"");
        }
        return bl;
    }
}

