/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.schema;

import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.config.ConfigUtils;
import com.ibm.ws.wim.schema.SchemaValidator;
import commonj.sdo.DataObject;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DataModelManagerHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2009";
    private static final String CLASSNAME = DataModelManagerHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static final String IS_MULTI_VALUE = "isMultiValued";
    public static final String SCHEMA_MESSAGE_KEY = "Message_key";
    public static final String MSG_PARAMS = "MSG_Params_key";

    public Map addPropertyToEntityTypes(String string, Map map) throws WIMException, RemoteException {
        boolean bl = trcLogger.isLoggable(Level.FINER);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (bl) {
            trcLogger.entering(CLASSNAME, "addPropertyToEntityTypes", "params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        DataObject dataObject = null;
        String string2 = (String)map.get("nsURI");
        String string3 = (String)map.get("dataType");
        Boolean bl2 = (Boolean)map.get(IS_MULTI_VALUE);
        String string4 = (String)map.get("name");
        List list = (List)map.get("entityTypeNames");
        List list2 = (List)map.get("requiredEntityTypeNames");
        List list3 = (List)map.get("repositoryIds");
        String string5 = (String)map.get("nsPrefix");
        String string6 = (String)map.get("applicationId");
        list2 = list2 == null ? new ArrayList() : list2;
        list3 = list3 == null ? new ArrayList() : list3;
        SchemaValidator.validateDataType(string3, string4);
        SchemaValidator.validateEntityTypeName(list);
        SchemaValidator.validateRequiredEntityTypeName(list, list2);
        SchemaValidator.validateRepositoryId(list3);
        SchemaValidator.validateNameSpaceAttributes(string2, string5);
        string2 = null != string2 ? string2.trim() : "";
        String string7 = string5 = null != string5 ? string5.trim() : "";
        if (string2.length() == 0 && string5.length() == 0) {
            string2 = "http://www.ibm.com/websphere/wim";
            string5 = SchemaManager.singleton().getNsPrefix(string2);
        } else if (string2.length() == 0) {
            string2 = SchemaManager.singleton().getNsURI(string5);
        } else if (string5.length() == 0) {
            string5 = SchemaManager.singleton().getNsPrefix(string2);
        }
        ServiceProvider serviceProvider = ServiceProvider.singleton();
        dataObject = serviceProvider.createRootDataObject();
        DataObject dataObject2 = dataObject.createDataObject("schema");
        String string8 = "propertySchema";
        if (list3 != null && list3.size() > 0 && list3.contains("LA")) {
            string8 = "extensionPropertySchema";
            list3.remove("LA");
        }
        DataObject dataObject3 = dataObject2.createDataObject(string8);
        dataObject3.set("nsURI", (Object)string2);
        dataObject3.set("dataType", (Object)string3);
        dataObject3.set("multiValued", (Object)bl2);
        dataObject3.set("propertyName", (Object)string4);
        dataObject3.set("repositoryIds", (Object)list3);
        dataObject3.set("nsPrefix", (Object)string5);
        List list4 = dataObject3.getList("applicableEntityTypeNames");
        list4.addAll(list);
        List list5 = dataObject3.getList("requiredEntityTypeNames");
        if (list5 != null && list2.size() > 0) {
            list5.addAll(list2);
        }
        if (null != string6 && string6.trim().length() > 0) {
            DataObject dataObject4 = dataObject3.createDataObject("metaData");
            dataObject4.set("name", (Object)"applicationId");
            dataObject4.getList("values").add(string6.trim());
        }
        dataObject = serviceProvider.createSchema(dataObject);
        hashMap.put(SCHEMA_MESSAGE_KEY, "EXTEND_SCHEMA_PROPERTY_EXTENSION_SUCCESSFUL");
        hashMap.put(MSG_PARAMS, WIMMessageHelper.generateMsgParms(string4, list.toString()));
        if (bl) {
            trcLogger.exiting(CLASSNAME, "addPropertyToEntityTypes", "params=" + WIMTraceHelper.printMapWithoutPassword(hashMap));
        }
        return hashMap;
    }

    public Map listPropertyExtensions(String string, Map map) throws WIMException {
        String string2;
        boolean bl = trcLogger.isLoggable(Level.FINER);
        if (bl) {
            trcLogger.entering(CLASSNAME, "listPropertyExtensions", "params=" + WIMTraceHelper.printMapWithoutPassword(map));
        }
        string2 = (string2 = (String)map.get("applicationId")) == null ? "" : string2;
        String string3 = File.separator;
        String string4 = ConfigManager.singleton().getWIMHomePath() + "model" + string3 + "wimxmlextension.xml";
        SchemaManager schemaManager = SchemaManager.singleton();
        DataObject dataObject = schemaManager.getWimXmlExtXml(string4);
        if (null == dataObject) {
            if (bl) {
                trcLogger.exiting(CLASSNAME, "listPropertyExtensions", "Exiting since root representing WIMXMLExtension.xml is null");
            }
            return new HashMap();
        }
        DataObject dataObject2 = dataObject.getDataObject("schema");
        List list = dataObject2.getList("propertySchema");
        HashMap hashMap = new HashMap();
        for (int i = 0; i < list.size(); ++i) {
            String string5;
            Object object;
            DataObject dataObject3 = (DataObject)list.get(i);
            List list2 = dataObject3.getList("metaData");
            String string6 = "";
            for (int j = 0; j < list2.size(); ++j) {
                object = (DataObject)list2.get(j);
                string5 = object.getString("name");
                if (!"applicationId".equals(string5)) continue;
                string6 = object.getList("values").size() > 0 ? object.getList("values").get(0).toString() : "";
                break;
            }
            if (string2.length() != 0 && !string2.equals(string6)) continue;
            String string7 = (String)dataObject3.get("propertyName");
            object = (String)dataObject3.get("nsURI");
            string5 = (String)dataObject3.get("dataType");
            Object object2 = dataObject3.get("nsPrefix");
            Boolean bl2 = dataObject3.getBoolean("multiValued");
            List list3 = ConfigUtils.convertEList(dataObject3.getList("applicableEntityTypeNames"));
            List list4 = dataObject3.getList("repositoryIds").size() > 0 ? ConfigUtils.convertEList(dataObject3.getList("repositoryIds")) : null;
            List list5 = dataObject3.getList("requiredEntityTypeNames").size() > 0 ? ConfigUtils.convertEList(dataObject3.getList("requiredEntityTypeNames")) : null;
            String string8 = null != object2 && ((String)object2).length() > 0 ? (String)object2 : null;
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            hashMap2.put("nsURI", object);
            hashMap2.put("dataType", string5);
            if (null != string8) {
                hashMap2.put("nsPrefix", string8);
            }
            hashMap2.put(IS_MULTI_VALUE, bl2);
            if (null != list4) {
                hashMap2.put("repositoryIds", list4);
            }
            hashMap2.put("entityTypeNames", list3);
            if (null != list5) {
                hashMap2.put("requiredEntityTypeNames", list5);
            }
            if (string6.length() > 0) {
                hashMap2.put("applicationId", string6);
            }
            hashMap.put(string7, hashMap2);
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "listPropertyExtensions", "Extended Properties are :" + ((Object)hashMap).toString());
        }
        return hashMap;
    }
}

