/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.schema;

import com.ibm.websphere.wim.exception.InvalidEntityTypeException;
import com.ibm.websphere.wim.exception.InvalidRepositoryIdException;
import com.ibm.websphere.wim.exception.InvalidSchemaException;
import com.ibm.websphere.wim.exception.WIMConfigurationException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.SchemaManager;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;

public class SchemaValidator {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2009";
    private static final String CLASSNAME = SchemaValidator.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);

    public static void validateEntityTypeName(List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateEntityTypeName", "The list of Applicable Entity types are " + list);
        }
        for (int i = 0; i < list.size(); ++i) {
            EClass eClass;
            String string = (String)list.get(i);
            String string2 = null;
            int n = string.indexOf(":");
            if (n > 1) {
                string2 = string.substring(0, n);
                if (null == SchemaManager.singleton().getNsURI(string2)) {
                    throw new InvalidSchemaException("INVALID_NS_PREFIX_FOR_ENTITY_TYPE_OR_PROPERTY", WIMMessageHelper.generateMsgParms(string2, string.substring(n + 1)), Level.SEVERE, CLASSNAME, "validateEntityTypeName");
                }
            }
            if ((eClass = SchemaManager.singleton().getEClass(string)) != null) continue;
            throw new InvalidEntityTypeException("EXTEND_SCHEMA_PROPERTY_EXTENSION_INVALID_APPLICABLE_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "validateEntityTypeName");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateEntityTypeName");
        }
    }

    public static void validateRequiredEntityTypeName(List list, List list2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateRequiredEntityTypeName", "The list of Applicable Entity types are " + list + " and Required Entity types are " + list2);
        }
        if (list2 == null || list2.size() == 0) {
            return;
        }
        for (int i = 0; i < list2.size(); ++i) {
            String string = (String)list2.get(i);
            EClass eClass = SchemaManager.singleton().getEClass(string);
            if (eClass == null) {
                throw new InvalidEntityTypeException("EXTEND_SCHEMA_PROPERTY_EXTENSION_INVALID_REQUIRED_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "validateRequiredEntityTypeName");
            }
            if (list.contains(string)) continue;
            throw new InvalidEntityTypeException("EXTEND_SCHEMA_PROPERTY_EXTENSION_INVALID_REQUIRED_NOTIN_APPLICABLE_ENTITY_TYPE", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "validateRequiredEntityTypeName");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateRequiredEntityTypeName");
        }
    }

    public static void validateDataType(String string, String string2) throws WIMException {
        EDataType eDataType;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateDataType", "The property Name is " + string2 + " and Datatype is " + string);
        }
        if ((eDataType = SchemaManager.singleton().getEDataType(string)) == null) {
            throw new WIMConfigurationException("EXTEND_SCHEMA_PROPERTY_EXTENSION_INVALID_DATA_TYPE", WIMMessageHelper.generateMsgParms(string, string2), Level.SEVERE, CLASSNAME, "validateDataType");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateDataType");
        }
    }

    public static void validateRepositoryId(List list) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateRepositoryId", "The list of repositories are " + list);
        }
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            if (string.equalsIgnoreCase("LA") || RepositoryManager.singleton().getRepository(string) != null) continue;
            throw new InvalidRepositoryIdException("INVALID_REPOSITORY_ID", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "validateRepositoryId");
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateRepositoryId");
        }
    }

    public static void validateNameSpaceAttributes(String string, String string2) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "validateNameSpaceAttributes", "The name space URI is  " + string + " and the nsprefix is " + string2);
        }
        if (string == null && string2 == null) {
            return;
        }
        if (string == null && (string2 != null || string2.trim().length() > 0)) {
            if (null == SchemaManager.singleton().getNsURI(string2)) {
                throw new InvalidSchemaException("NO_NS_PREFIX_FOR_NS_URI", WIMMessageHelper.generateMsgParms(string), Level.SEVERE, CLASSNAME, "validateNameSpaceAttributes");
            }
        } else if (string2 == null && (string != null || string.trim().length() > 0)) {
            if (null == SchemaManager.singleton().getNsPrefix(string)) {
                throw new InvalidSchemaException("INVALID_NS_PREFIX", WIMMessageHelper.generateMsgParms(string2), Level.SEVERE, CLASSNAME, "validateNameSpaceAttributes");
            }
        } else {
            String string3 = SchemaManager.singleton().getNsURI(string2.trim());
            String string4 = SchemaManager.singleton().getNsPrefix(string.trim());
            if (!(null == string3 && null == string4 || string.trim().equals(string3) && string2.trim().equals(string4))) {
                throw new InvalidSchemaException("DUPLICATE_NS_PREFIX", WIMMessageHelper.generateMsgParms(string2, string), Level.SEVERE, CLASSNAME, "validateNameSpaceAttributes");
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "validateNameSpaceAttributes");
        }
    }
}

