/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.security.authz;

import com.ibm.websphere.wim.security.authz.Entitlement;
import com.ibm.ws.wim.security.authz.EntitlementHelper;
import commonj.sdo.DataObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.sdo.EDataObject;

public class EntitlementRequest {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private boolean isExclusive = false;
    private boolean isRolesDesired = false;
    private boolean isObjectEntitlementsDesired = false;
    private boolean isAttributeEntitlementsDesired = false;
    private Set entitlementAttributes;
    private Entitlement entitlementFilter;
    private Entitlement entitlementCheck;

    public EntitlementRequest(DataObject dataObject) {
        List list = dataObject.getList("controls");
        for (DataObject dataObject2 : list) {
            if (!((EDataObject)dataObject2).eClass().getName().equals("EntitlementControl")) continue;
            this.isExclusive = dataObject2.getBoolean("getExclusively");
            this.isRolesDesired = dataObject2.getBoolean("getRoles");
            this.isObjectEntitlementsDesired = dataObject2.getBoolean("getObjectEntitlements");
            this.isAttributeEntitlementsDesired = dataObject2.getBoolean("getAttributeEntitlements");
            if (dataObject2.getList("entitlementAttributes").size() != 0) {
                this.entitlementAttributes = new HashSet(dataObject2.getList("entitlementAttributes"));
            }
            this.entitlementFilter = EntitlementHelper.getEntitlementFromDataObject(dataObject2.getDataObject("entitlementFilter"));
            this.entitlementCheck = EntitlementHelper.getEntitlementFromDataObject(dataObject2.getDataObject("entitlementCheck"));
            break;
        }
    }

    public EntitlementRequest(boolean bl, boolean bl2, boolean bl3, boolean bl4, Set set, Entitlement entitlement, Entitlement entitlement2) {
        this.isExclusive = bl;
        this.isRolesDesired = bl2;
        this.isObjectEntitlementsDesired = bl3;
        this.isAttributeEntitlementsDesired = bl4;
        this.entitlementAttributes = set;
        this.entitlementFilter = entitlement;
        this.entitlementCheck = entitlement2;
    }

    public boolean isEmpty() {
        return !this.isRolesDesired && !this.isObjectEntitlementsDesired && !this.isAttributeEntitlementsDesired && this.entitlementFilter == null && this.entitlementCheck == null;
    }

    public boolean isExclusive() {
        return this.isExclusive;
    }

    public boolean isRolesDesired() {
        return this.isRolesDesired;
    }

    public boolean isObjectEntitlementsDesired() {
        return this.isObjectEntitlementsDesired;
    }

    public boolean isAttributeEntitlementsDesired() {
        return this.isAttributeEntitlementsDesired;
    }

    public Set getEntitlementAttributes() {
        return this.entitlementAttributes;
    }

    public Entitlement getEntitlementFilter() {
        return this.entitlementFilter;
    }

    public Entitlement getEntitlementCheck() {
        return this.entitlementCheck;
    }
}

