/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.security.authz;

import com.ibm.sec.auth.subjectx.VirtualPrincipal;
import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wim.ServiceProvider;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.security.authz.AuthSystemException;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.security.authz.AccessHandler;
import com.ibm.ws.wim.security.authz.EntityResource;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import com.ibm.ws.wim.security.authz.SDOHelper;
import com.ibm.ws.wim.security.authz.jacc.GroupPrincipal;
import com.ibm.ws.wim.security.authz.jacc.UserPrincipal;
import com.ibm.ws.wim.util.DataGraphHelper;
import commonj.sdo.DataObject;
import java.rmi.RemoteException;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class ProfileAccessHandler
implements AccessHandler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = ProfileAccessHandler.class.getName();
    private static final Logger msgLogger = WIMLogger.getMessageLogger("com.ibm.ws.wim.security.authz");
    private static final Logger trcLogger = WIMLogger.getTraceLogger("com.ibm.ws.wim.security.authz");
    private static final String CONTEXT_PARAM_ENTITY_TYPE = "_ENTITY-TYPE";
    private static ThreadLocal subjectAttrCache = new ThreadLocal();
    private static ThreadLocal resourceAttrCache = new ThreadLocal();

    public void clearThreadCache() {
        trcLogger.entering(CLASSNAME, "clearThreadCache()");
        subjectAttrCache.set(new Hashtable());
        resourceAttrCache.set(new Hashtable());
        trcLogger.exiting(CLASSNAME, "clearThreadCache()");
    }

    public Map getContextParameters(Resource resource) {
        trcLogger.entering(CLASSNAME, "getContextParameters()");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        DataObject dataObject = ((EntityResource)resource).getRoot();
        List list = dataObject.getList("contexts");
        for (DataObject dataObject2 : list) {
            hashtable.put(dataObject2.getString("key"), dataObject2.get("value"));
        }
        hashtable.put(CONTEXT_PARAM_ENTITY_TYPE, ((EntityResource)resource).getEntityType());
        trcLogger.exiting(CLASSNAME, "getContextParameters() - " + hashtable);
        return hashtable;
    }

    public Set getResourceAttributeNames(Resource resource) {
        trcLogger.entering(CLASSNAME, "getResourceAttributeNames()");
        Set set = SDOHelper.getEntityAttributes(((EntityResource)resource).getEntity(), true, true);
        trcLogger.exiting(CLASSNAME, "getResourceAttributeNames()");
        return set;
    }

    public Object getResourceAttribute(final Resource resource, final String string, final Set set) {
        Object object;
        trcLogger.entering(CLASSNAME, "getResourceAttribute()");
        try {
            object = ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ProfileAccessHandler.this.getEntityAttribute(((EntityResource)resource).getEntity(), string, (Map)resourceAttrCache.get(), set);
                }
            });
        }
        catch (WIMException wIMException) {
            return null;
        }
        trcLogger.exiting(CLASSNAME, "getResourceAttribute()");
        return object;
    }

    public Set getSubjectAttributeNames(Subject subject) {
        trcLogger.entering(CLASSNAME, "getSubjectAttributeNames()");
        Set set = SDOHelper.getEntityAttributes(this.createSubjectEntity(subject), true, true);
        trcLogger.exiting(CLASSNAME, "getSubjectAttributeNames()");
        return set;
    }

    public Object getSubjectAttribute(final Subject subject, final String string, final Set set) {
        Object object;
        trcLogger.entering(CLASSNAME, "getSubjectAttribute()");
        try {
            object = ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ProfileAccessHandler.this.getEntityAttribute(ProfileAccessHandler.this.createSubjectEntity(subject), string, (Map)subjectAttrCache.get(), set);
                }
            });
        }
        catch (WIMException wIMException) {
            return null;
        }
        trcLogger.exiting(CLASSNAME, "getSubjectAttribute()");
        return object;
    }

    public Principal getSubjectPrincipal(Subject subject) {
        Principal principal = VirtualPrincipal.AnonymousUser;
        WSCredential wSCredential = this.getWSCredential(subject);
        if (wSCredential != null) {
            try {
                principal = new UserPrincipal(wSCredential.getAccessId());
            }
            catch (Exception exception) {
                msgLogger.log(Level.WARNING, "AUTH_SUBJECT_CRED_FAILURE", exception);
            }
        }
        return principal;
    }

    private String getSubjectUniqueName(Subject subject) {
        String string = VirtualPrincipal.AnonymousUser.getName();
        WSCredential wSCredential = this.getWSCredential(subject);
        if (wSCredential != null) {
            try {
                string = wSCredential.getUniqueSecurityName();
            }
            catch (Exception exception) {
                msgLogger.log(Level.WARNING, "AUTH_SUBJECT_CRED_FAILURE", exception);
            }
        }
        return string;
    }

    public Set getSubjectGroups(Subject subject) {
        HashSet<GroupPrincipal> hashSet = new HashSet<GroupPrincipal>();
        WSCredential wSCredential = this.getWSCredential(subject);
        if (wSCredential != null) {
            try {
                Iterator iterator = wSCredential.getGroupIds().iterator();
                while (iterator.hasNext()) {
                    hashSet.add(new GroupPrincipal((String)iterator.next()));
                }
            }
            catch (Exception exception) {
                msgLogger.log(Level.WARNING, "AUTH_SUBJECT_CRED_FAILURE", exception);
            }
        }
        return hashSet;
    }

    public Set getSubjectRelationships(Subject subject, Resource resource) {
        trcLogger.entering(CLASSNAME, "getSubjectRelationships()");
        String string = null;
        HashSet<String> hashSet = new HashSet<String>();
        DataObject dataObject = ((EntityResource)resource).getEntity();
        String string2 = this.getSubjectUniqueName(subject);
        if (dataObject.get("identifier") != null) {
            string = dataObject.getString("identifier/uniqueName");
        }
        if (string2 != null && string != null && string2.equals(string)) {
            hashSet.add("Owner");
        }
        trcLogger.exiting(CLASSNAME, "getSubjectRelationships() - " + hashSet);
        return hashSet;
    }

    private WSCredential getWSCredential(Subject subject) {
        WSCredential wSCredential = null;
        Iterator<WSCredential> iterator = subject.getPublicCredentials(WSCredential.class).iterator();
        if (iterator.hasNext()) {
            wSCredential = iterator.next();
        }
        return wSCredential;
    }

    private Object getEntityAttribute(DataObject dataObject, String string, Map map, Set set) {
        String string2 = null;
        String string3 = null;
        Object object = null;
        trcLogger.log(Level.FINEST, "Looking up attribute ''{0}'' for ''{1}'' to evaluate a conditional permission...", new Object[]{string, SDOHelper.getEntityDisplayName(dataObject)});
        Object v = map.get(string);
        object = v;
        if (v == null) {
            try {
                DataObject dataObject2;
                Set set2;
                SchemaManager schemaManager = SchemaManager.singleton();
                if (dataObject.get("identifier") != null) {
                    string2 = dataObject.getString("identifier/uniqueName");
                    string3 = dataObject.getString("identifier/uniqueId");
                }
                if (string2 != null || string3 != null) {
                    ServiceProvider serviceProvider = ServiceProvider.singleton();
                    DataObject dataObject3 = serviceProvider.createRootDataObject();
                    dataObject3.getList("entities").add(DataGraphHelper.cloneDataObject(dataObject));
                    DataObject dataObject4 = dataObject3.createDataObject("controls", "http://www.ibm.com/websphere/wim", "PropertyControl");
                    set2 = SDOHelper.getEntityAttributes(dataObject, true, true);
                    if (!set2.contains(string)) {
                        set2.add(string);
                    }
                    Iterator iterator = set2.iterator();
                    while (iterator.hasNext()) {
                        String string4 = (String)iterator.next();
                        if (string4.equals(string) || set.contains(string4)) {
                            dataObject4.getList("properties").add(string4);
                            continue;
                        }
                        iterator.remove();
                    }
                    DataObject dataObject5 = serviceProvider.get(dataObject3);
                    dataObject2 = dataObject5.getDataObject("entities.0");
                } else {
                    dataObject2 = dataObject;
                }
                set2 = SDOHelper.getEntityAttributes(dataObject2, false, true);
                for (String string4 : set2) {
                    HashSet hashSet = dataObject2.get(schemaManager.getProperty(dataObject2.getType(), string4));
                    if (hashSet instanceof List) {
                        hashSet = new HashSet((List)((Object)hashSet));
                    }
                    if (hashSet != null) {
                        map.put(string4, hashSet);
                    }
                    if (!string.equals(string4)) continue;
                    object = hashSet;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException(new AuthSystemException("AUTH_RULE_ATTR_FAILURE", new Object[]{string, SDOHelper.getEntityDisplayName(dataObject)}, exception, Level.SEVERE));
            }
        }
        if (object == null) {
            object = "$NON-APPLICABLE$";
            msgLogger.log(Level.WARNING, "AUTH_RULE_ATTR_MISSING", new Object[]{string, SDOHelper.getEntityDisplayName(dataObject)});
        }
        trcLogger.log(Level.FINEST, "Found attribute ''{0}''=''{1}'' for ''{2}'' to evaluate a conditional permission", new Object[]{string, object, SDOHelper.getEntityDisplayName(dataObject)});
        return object;
    }

    private DataObject createEntity(String string, String string2) throws WIMException, RemoteException {
        DataObject dataObject = ServiceProvider.singleton().createDataObject("http://www.ibm.com/websphere/wim", string);
        dataObject.createDataObject("identifier");
        dataObject.setString("identifier/uniqueName", string2);
        return dataObject;
    }

    private DataObject createSubjectEntity(Subject subject) {
        DataObject dataObject = null;
        try {
            String string = this.getSubjectUniqueName(subject);
            dataObject = this.createEntity("Entity", string);
            String string2 = SDOHelper.getEntityType(dataObject, false);
            string2 = string2.substring(0, string2.length() - 1);
            if (string2.indexOf(47) != -1) {
                string2 = string2.substring(string2.lastIndexOf(47) + 1);
            }
            dataObject = this.createEntity(string2, string);
        }
        catch (Exception exception) {
            trcLogger.log(Level.FINE, exception.getMessage(), exception);
        }
        return dataObject;
    }
}

