/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.security.authz;

import com.ibm.sec.auth.subjectx.VirtualPrincipal;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.security.authz.AccessException;
import com.ibm.websphere.wim.security.authz.AuthSystemException;
import com.ibm.websphere.wim.security.authz.Entitlement;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.pluginmanager.PluginManager;
import com.ibm.ws.wim.security.authz.AccessHandler;
import com.ibm.ws.wim.security.authz.AuthPrivilegedException;
import com.ibm.ws.wim.security.authz.EntitlementHelper;
import com.ibm.ws.wim.security.authz.EntitlementRequest;
import com.ibm.ws.wim.security.authz.EntityResource;
import com.ibm.ws.wim.security.authz.ProfileAccessHandler;
import com.ibm.ws.wim.security.authz.SDOHelper;
import com.ibm.ws.wim.security.authz.jacc.JACCPolicyDefinition;
import com.ibm.ws.wim.security.authz.jacc.JACCSecurityManager;
import com.ibm.ws.wim.util.DataGraphHelper;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.File;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;

public class ProfileSecurityManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static ProfileSecurityManager profileSecMgr = null;
    private static final String CLASSNAME = ProfileSecurityManager.class.getName();
    private static final Logger msgLogger = WIMLogger.getMessageLogger("com.ibm.ws.wim.security.authz");
    private static final Logger trcLogger = WIMLogger.getTraceLogger("com.ibm.ws.wim.security.authz");
    private AccessHandler accessHandler = new ProfileAccessHandler();
    private boolean isSecurityEnabled = false;
    private boolean isAttributeGroupingEnabled;
    private JACCSecurityManager secManager;
    private String defaultAttributeGroup;
    private Map attributeGroups;
    private Subject runAsSubject;

    private ProfileSecurityManager() {
    }

    public static synchronized ProfileSecurityManager singleton() {
        trcLogger.entering(CLASSNAME, "singleton()");
        if (profileSecMgr == null) {
            profileSecMgr = new ProfileSecurityManager();
        }
        trcLogger.exiting(CLASSNAME, "singleton()");
        return profileSecMgr;
    }

    public synchronized void initialize(DataGraph dataGraph) throws WIMException {
        this.initialize(dataGraph, null);
    }

    public synchronized void initialize(DataGraph dataGraph, JACCSecurityManager jACCSecurityManager) throws WIMException {
        trcLogger.entering(CLASSNAME, "initialize()");
        if (this.secManager == null) {
            DataObject dataObject = dataGraph.getRootObject().getDataObject("configurationProvider");
            DataObject dataObject2 = dataObject.getDataObject("authorization");
            this.isSecurityEnabled = dataObject2.getBoolean("isSecurityEnabled");
            if (this.isSecurityEnabled) {
                if (jACCSecurityManager == null) {
                    String string = ConfigManager.singleton().getWIMHomePath() + File.separator + JACCPolicyDefinition.POLICY_SUBDIR;
                    JACCPolicyDefinition jACCPolicyDefinition = !dataObject2.getBoolean("useSystemJACCProvider") ? new JACCPolicyDefinition(dataObject2.getString("jaccPolicyClass"), dataObject2.getString("jaccRoleMappingClass"), dataObject2.getString("jaccPolicyConfigFactoryClass"), dataObject2.getString("jaccRoleMappingConfigFactoryClass"), string) : new JACCPolicyDefinition();
                    if (dataObject2.getBoolean("importPolicyFromFile")) {
                        jACCPolicyDefinition.loadPolicy(dataObject2.getString("jaccRoleToPermissionPolicyId"), dataObject2.getString("jaccPrincipalToRolePolicyId"), string + File.separator + dataObject2.getString("jaccRoleToPermissionPolicyFileName"), string + File.separator + dataObject2.getString("jaccPrincipalToRolePolicyFileName"));
                    }
                    this.secManager = jACCPolicyDefinition;
                } else {
                    this.secManager = jACCSecurityManager;
                }
                this.secManager.registerPolicy(dataObject2.getString("jaccRoleToPermissionPolicyId"), dataObject2.getString("jaccPrincipalToRolePolicyId"), this.accessHandler);
                this.loadAttributeGroups(dataObject2);
                msgLogger.log(Level.INFO, "AUTH_INIT_SUCCESS");
            }
        }
        trcLogger.exiting(CLASSNAME, "initialize()");
    }

    private void loadAttributeGroups(DataObject dataObject) throws WIMException {
        trcLogger.entering(CLASSNAME, "loadAttributeGroups()");
        this.isAttributeGroupingEnabled = dataObject.getBoolean("isAttributeGroupingEnabled");
        this.defaultAttributeGroup = dataObject.getString("defaultAttributeGroup");
        List list = dataObject.getList("attributeGroups");
        this.attributeGroups = new Hashtable();
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject2 = (DataObject)list.get(i);
            String string = dataObject2.getString("groupName");
            int n = dataObject2.getList("attributeNames").size();
            for (int j = 0; j < n; ++j) {
                String string2 = dataObject2.getString("attributeNames." + Integer.toString(j));
                if (this.attributeGroups.put(string2, string) == null) continue;
                throw new AuthSystemException("AUTH_ATTR_MULTIPLE_GROUP", new Object[]{string2}, Level.SEVERE);
            }
        }
        trcLogger.exiting(CLASSNAME, "loadAttributeGroups()");
    }

    public void refreshPolicy() {
        trcLogger.entering(CLASSNAME, "refreshPolicy()");
        if (this.isSecurityEnabled) {
            this.secManager.refreshPolicy();
        }
        trcLogger.entering(CLASSNAME, "refreshPolicy()");
    }

    public void checkPermission_SuperUser(Entitlement entitlement) throws WIMException {
        trcLogger.entering(CLASSNAME, "checkPermission_SuperUser()");
        if (this.isSecurityEnabled && this.secManager.isServerSecurityEnabled() && !this.secManager.isSuperUser(this.getCallerSubject())) {
            throw new AccessException(this.getCallerSubjectUniqueName(), "administrator", entitlement, Level.SEVERE);
        }
        trcLogger.exiting(CLASSNAME, "checkPermission_SuperUser()");
    }

    public boolean isCallerSuperUser() throws WIMException {
        trcLogger.entering(CLASSNAME, "isCallerSuperUser()");
        boolean bl = this.isSecurityEnabled && this.secManager.isSuperUser(this.getCallerSubject());
        trcLogger.exiting(CLASSNAME, "isCallerSuperUser() - " + bl);
        return bl;
    }

    public void checkPermission_CREATE(EntityResource entityResource) throws WIMException {
        trcLogger.entering(CLASSNAME, "checkPermission_CREATE()");
        Subject subject = this.getCallerSubject();
        if (this.isSecurityEnabled) {
            if (this.secManager.isSuperUser(subject)) {
                trcLogger.log(Level.FINER, "Bypassing the authorization check because the caller has **SUPER USER** status");
                return;
            }
            String string = SDOHelper.getEntityType(entityResource.getEntity(), true);
            String string2 = this.getDelegatedAdminViewId(entityResource, "CREATE");
            entityResource = new EntityResource(entityResource, string, string2);
            Entitlement entitlement = new Entitlement("CREATE", string);
            boolean bl = this.secManager.hasEntitlement(subject, entityResource, entitlement);
            this.checkAccessResult(entityResource, entitlement, bl);
            this.checkAttributePermissions(entityResource, "WRITE", false, false);
        }
        trcLogger.exiting(CLASSNAME, "checkPermission_CREATE()");
    }

    public void checkPermission_DELETE(EntityResource entityResource, boolean bl) throws WIMException {
        trcLogger.entering(CLASSNAME, "checkPermission_DELETE()");
        Subject subject = this.getCallerSubject();
        if (this.isSecurityEnabled) {
            if (this.secManager.isSuperUser(subject)) {
                trcLogger.log(Level.FINER, "Bypassing the authorization check because the caller has **SUPER USER** status");
                return;
            }
            String string = SDOHelper.getEntityType(entityResource.getEntity(), false);
            String string2 = this.getDelegatedAdminViewId(entityResource, "DELETE");
            entityResource = new EntityResource(entityResource, string, string2);
            Entitlement entitlement = new Entitlement("DELETE", string);
            Entitlement entitlement2 = new Entitlement("DELETE_DESCENDANTS", string);
            boolean bl2 = this.secManager.hasEntitlement(subject, entityResource, bl ? entitlement2 : entitlement);
            if (!bl && !bl2) {
                bl2 = this.secManager.hasEntitlement(subject, entityResource, entitlement2);
            }
            this.checkAccessResult(entityResource, bl ? entitlement2 : entitlement, bl2);
        }
        trcLogger.exiting(CLASSNAME, "checkPermission_DELETE()");
    }

    public void checkPermission_UPDATE(EntityResource entityResource) throws WIMException {
        trcLogger.entering(CLASSNAME, "checkPermission_UPDATE()");
        Subject subject = this.getCallerSubject();
        if (this.isSecurityEnabled) {
            if (this.secManager.isSuperUser(subject)) {
                trcLogger.log(Level.FINER, "Bypassing the authorization check because the caller has **SUPER USER** status");
                return;
            }
            String string = SDOHelper.getEntityType(entityResource.getEntity(), false);
            String string2 = this.getDelegatedAdminViewId(entityResource, "UPDATE");
            entityResource = new EntityResource(entityResource, string, string2);
            Entitlement entitlement = new Entitlement("UPDATE", string);
            boolean bl = this.secManager.hasEntitlement(subject, entityResource, entitlement);
            this.checkAccessResult(entityResource, entitlement, bl);
            this.checkAttributePermissions(entityResource, "WRITE", false, false);
        }
        trcLogger.exiting(CLASSNAME, "checkPermission_UPDATE()");
    }

    public DataObject checkPermission_GET(EntityResource entityResource) throws WIMException {
        trcLogger.entering(CLASSNAME, "checkPermission_GET()");
        Subject subject = this.getCallerSubject();
        if (this.isSecurityEnabled) {
            if (this.secManager.isSuperUser(subject)) {
                trcLogger.log(Level.FINER, "Bypassing the authorization check because the caller has **SUPER USER** status");
                return entityResource.getEntity();
            }
            String string = SDOHelper.getEntityType(entityResource.getEntity(), true);
            String string2 = this.getDelegatedAdminViewId(entityResource, "GET");
            entityResource = new EntityResource(entityResource, string, string2);
            Entitlement entitlement = new Entitlement("GET", string);
            boolean bl = this.secManager.hasEntitlement(subject, entityResource, entitlement);
            this.checkAccessResult(entityResource, entitlement, bl);
            this.checkAttributePermissions(entityResource, "READ", true, true);
        }
        trcLogger.exiting(CLASSNAME, "checkPermission_GET()");
        return entityResource.getEntity();
    }

    public DataObject checkPermission_LOGIN(EntityResource entityResource) throws WIMException {
        trcLogger.entering(CLASSNAME, "checkPermission_LOGIN()");
        trcLogger.exiting(CLASSNAME, "checkPermission_LOGIN()");
        return entityResource.getEntity();
    }

    public DataObject checkPermission_SEARCH(EntityResource entityResource, Entitlement entitlement) throws WIMException {
        trcLogger.entering(CLASSNAME, "checkPermission_SEARCH()");
        Subject subject = this.getCallerSubject();
        boolean bl = false;
        if (this.isSecurityEnabled) {
            Entitlement entitlement2;
            String string;
            if (this.secManager.isSuperUser(subject)) {
                trcLogger.log(Level.FINER, "Bypassing the authorization check because the caller has **SUPER USER** status");
                return entityResource.getEntity();
            }
            String string2 = SDOHelper.getEntityType(entityResource.getEntity(), true);
            boolean bl2 = this.secManager.hasEntitlement(subject, entityResource = new EntityResource(entityResource, string2, string = this.getDelegatedAdminViewId(entityResource, "SEARCH")), entitlement2 = new Entitlement("SEARCH", string2));
            if (bl2 && entitlement != null) {
                entitlement2 = this.getMappedEntitlement(entitlement);
                bl2 = this.secManager.hasEntitlement(subject, entityResource, entitlement2);
                bl = true;
            }
            if (!bl2) {
                this.traceAccessResult(bl ? "Entitlement check for principal ''{0}'' failed for the following entitlement\n    ''{1}'' ''{2}''" : "Access check for principal ''{0}'' failed for the following entitlement\n    ''{1}'' ''{2}''", Level.FINE, entityResource, entitlement2);
                return null;
            }
            this.traceAccessResult(bl ? "Entitlement check for principal ''{0}'' succeeded for the following entitlement\n    ''{1}'' ''{2}''" : "Access check for principal ''{0}'' succeeded for the following entitlement\n    ''{1}'' ''{2}''", Level.FINEST, entityResource, entitlement2);
            this.checkAttributePermissions(entityResource, "READ", true, false);
        }
        trcLogger.exiting(CLASSNAME, "checkPermission_SEARCH()");
        return entityResource.getEntity();
    }

    private void checkAttributePermissions(EntityResource entityResource, String string, boolean bl, boolean bl2) throws WIMException {
        trcLogger.entering(CLASSNAME, "checkAttributePermissions()");
        Subject subject = this.getCallerSubject();
        Hashtable hashtable = new Hashtable();
        DataObject dataObject = entityResource.getEntity();
        Set set = SDOHelper.getEntityAttributes(dataObject, false, false);
        for (String string2 : set) {
            String string3 = this.getGroupForAttribute(string2);
            if (bl2 && SDOHelper.isAttributeEntityType(dataObject, string2)) {
                List<DataObject> list;
                if (!SDOHelper.isAttributeMultiValued(dataObject, string2)) {
                    list = new ArrayList();
                    list.add(dataObject.getDataObject(string2));
                } else {
                    list = dataObject.getList(string2);
                }
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.checkPermission_GET(new EntityResource(entityResource.getRoot(), (DataObject)iterator.next()));
                }
                continue;
            }
            Entitlement entitlement = new Entitlement(string, entityResource.getEntityType(), string3);
            boolean bl3 = this.hasAttributeEntitlement(subject, entityResource, entitlement, hashtable);
            if (!bl3 && string.equals("READ") && bl) {
                dataObject.unset(string2);
                this.traceAccessResult("Access check for principal ''{0}'' failed for the following entitlement\n    ''{1}'' ''{2}''", Level.FINE, entityResource, entitlement);
                continue;
            }
            this.checkAccessResult(entityResource, entitlement, bl3);
        }
        trcLogger.exiting(CLASSNAME, "checkAttributePermissions()");
    }

    private boolean hasAttributeEntitlement(Subject subject, EntityResource entityResource, Entitlement entitlement, Map map) throws WIMException {
        trcLogger.entering(CLASSNAME, "hasAttributeEntitlement()");
        String string = entitlement.getMethod() + ":" + entitlement.getAttribute();
        Boolean bl = (Boolean)map.get(string);
        if (bl == null) {
            bl = this.secManager.hasEntitlement(subject, entityResource, entitlement);
            map.put(string, bl);
        }
        trcLogger.exiting(CLASSNAME, "hasAttributeEntitlement()");
        return bl;
    }

    private Entitlement getMappedEntitlement(Entitlement entitlement) {
        trcLogger.entering(CLASSNAME, "getMappedEntitlement()");
        Entitlement entitlement2 = entitlement.isAttributeEntitlement() ? new Entitlement(entitlement.getMethod(), entitlement.getObject(), this.getGroupForAttribute(entitlement.getAttribute())) : entitlement;
        trcLogger.exiting(CLASSNAME, "getMappedEntitlement()");
        return entitlement2;
    }

    public Set getRoles(EntityResource entityResource) throws WIMException {
        trcLogger.entering(CLASSNAME, "getRoles()");
        Subject subject = this.getCallerSubject();
        Set set = null;
        if (this.isSecurityEnabled) {
            entityResource = new EntityResource(entityResource, SDOHelper.getEntityType(entityResource.getEntity(), true), this.getDelegatedAdminViewId(entityResource, "GET_ENTITLEMENTS"));
            set = this.secManager.getRoles(subject, entityResource);
        }
        trcLogger.exiting(CLASSNAME, "getRoles()");
        return set;
    }

    public boolean doesEntitlementExist(EntityResource entityResource, Entitlement entitlement) throws WIMException {
        trcLogger.entering(CLASSNAME, "doesEntitlementExist()");
        Subject subject = this.getCallerSubject();
        boolean bl = false;
        if (this.isSecurityEnabled) {
            entityResource = new EntityResource(entityResource, SDOHelper.getEntityType(entityResource.getEntity(), true), this.getDelegatedAdminViewId(entityResource, "GET_ENTITLEMENTS"));
            bl = this.secManager.doesEntitlementExist(subject, entityResource, this.getMappedEntitlement(entitlement));
        }
        trcLogger.exiting(CLASSNAME, "doesEntitlementExist()");
        return bl;
    }

    public Set getEntitlements(EntityResource entityResource, EntitlementRequest entitlementRequest) throws WIMException {
        trcLogger.entering(CLASSNAME, "getEntitlements()");
        Subject subject = this.getCallerSubject();
        HashSet<Entitlement> hashSet = null;
        Hashtable hashtable = new Hashtable();
        if (this.isSecurityEnabled) {
            String string = SDOHelper.getEntityType(entityResource.getEntity(), true);
            String string2 = this.getDelegatedAdminViewId(entityResource, "GET_ENTITLEMENTS");
            entityResource = new EntityResource(entityResource, string, string2);
            Set set = this.secManager.getEntitlements(subject, entityResource);
            hashSet = new HashSet<Entitlement>();
            for (Entitlement entitlement : set) {
                if (!entitlementRequest.isObjectEntitlementsDesired() || entitlement.isAttributeEntitlement() || !this.isEntitlementApplicable(string, entitlement) || hashSet.contains(entitlement = new Entitlement(entitlement.getMethod(), string))) continue;
                hashSet.add(entitlement);
            }
            if (entitlementRequest.isAttributeEntitlementsDesired()) {
                Set set2 = entitlementRequest.getEntitlementAttributes() == null ? SDOHelper.getEntityAttributes(entityResource.getEntity(), true, false) : entitlementRequest.getEntitlementAttributes();
                for (String string3 : set2) {
                    String string4 = this.getGroupForAttribute(string3);
                    if (!SDOHelper.isAttributeEntityType(entityResource.getEntity(), string3) && this.hasAttributeEntitlement(subject, entityResource, new Entitlement("READ", string, string4), hashtable)) {
                        hashSet.add(new Entitlement("READ", string, string3));
                    }
                    if (!this.hasAttributeEntitlement(subject, entityResource, new Entitlement("WRITE", string, string4), hashtable)) continue;
                    hashSet.add(new Entitlement("WRITE", string, string3));
                }
            }
        }
        trcLogger.exiting(CLASSNAME, "getEntitlements()");
        return hashSet;
    }

    public DataObject setEntitlements(DataObject dataObject, DataObject dataObject2, EntitlementRequest entitlementRequest) throws WIMException {
        trcLogger.entering(CLASSNAME, "setEntitlements(DataObject inputRoot, DataObject outputRoot, EntitlementRequest entitleRequest)");
        if (this.isSecurityEnabled && !entitlementRequest.isEmpty()) {
            List list = dataObject2.getList("entities");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.setEntitlements(new EntityResource(dataObject, (DataObject)iterator.next()), entitlementRequest);
            }
        }
        trcLogger.exiting(CLASSNAME, "setEntitlements(DataObject inputRoot, DataObject outputRoot, EntitlementRequest entitleRequest)");
        return dataObject2;
    }

    private DataObject setEntitlements(EntityResource entityResource, EntitlementRequest entitlementRequest) throws WIMException {
        trcLogger.entering(CLASSNAME, "setEntitlements(EntityResource resource, EntitlementRequest entitleRequest)");
        DataObject dataObject = entityResource.getEntity();
        DataObject dataObject2 = dataObject.createDataObject("entitlementInfo");
        if (entitlementRequest.isRolesDesired()) {
            dataObject2.setList("roles", new ArrayList(this.getRoles(entityResource)));
        }
        if (entitlementRequest.isObjectEntitlementsDesired() || entitlementRequest.isAttributeEntitlementsDesired()) {
            Set set = this.getEntitlements(entityResource, entitlementRequest);
            for (Entitlement entitlement : set) {
                DataObject dataObject3 = dataObject2.createDataObject("entitlements");
                EntitlementHelper.setEntitlementToDataObject(entitlement, dataObject3);
            }
        }
        if (entitlementRequest.getEntitlementCheck() != null) {
            dataObject2.setBoolean("entitlementCheckResult", this.doesEntitlementExist(entityResource, entitlementRequest.getEntitlementCheck()));
        }
        Set set = SDOHelper.getEntityAttributes(dataObject, false, false);
        for (String string : set) {
            List<DataObject> list;
            if (!SDOHelper.isAttributeEntityType(dataObject, string)) continue;
            if (!SDOHelper.isAttributeMultiValued(dataObject, string)) {
                list = new ArrayList();
                list.add(dataObject.getDataObject(string));
            } else {
                list = dataObject.getList(string);
            }
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                this.setEntitlements(new EntityResource(entityResource.getRoot(), (DataObject)iterator.next()), entitlementRequest);
            }
        }
        trcLogger.exiting(CLASSNAME, "setEntitlements(EntityResource resource, EntitlementRequest entitleRequest)");
        return dataObject;
    }

    private boolean isEntitlementApplicable(String string, Entitlement entitlement) {
        Entitlement entitlement2 = new Entitlement(entitlement.getMethod(), string, entitlement.getAttribute());
        return EntitlementHelper.getMethodPermission(entitlement).implies(EntitlementHelper.getMethodPermission(entitlement2));
    }

    void setRunAsSubject(Subject subject) {
        this.runAsSubject = subject;
    }

    public Object runAsSuperUser(PrivilegedExceptionAction privilegedExceptionAction) throws WIMException {
        Object object;
        trcLogger.entering(CLASSNAME, "runAsSuperUser()");
        if (this.isSecurityEnabled) {
            try {
                object = this.secManager.runAsSuperUser(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (privilegedActionException.getCause() instanceof WIMException) {
                    throw (WIMException)privilegedActionException.getCause();
                }
                throw new AuthPrivilegedException("An error occured while performing a task as the super user", privilegedActionException.getCause(), Level.FINE);
            }
        }
        try {
            object = privilegedExceptionAction.run();
        }
        catch (Exception exception) {
            if (exception instanceof WIMException) {
                throw (WIMException)exception;
            }
            throw new AuthPrivilegedException("An error occured while performing a task as the super user", exception, Level.FINE);
        }
        trcLogger.exiting(CLASSNAME, "runAsSuperUser()");
        return object;
    }

    private Subject getAnonymousSubject() {
        return (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Subject subject = new Subject();
                subject.getPrincipals().add(VirtualPrincipal.AnonymousUser);
                return subject;
            }
        });
    }

    private Subject getCallerSubject() throws WIMException {
        trcLogger.entering(CLASSNAME, "getCallerSubject()");
        try {
            return (Subject)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * Unable to fully structure code
                 */
                public Object run() throws AuthSystemException {
                    var1_1 = ProfileSecurityManager.access$000(ProfileSecurityManager.this);
                    if (ProfileSecurityManager.access$100(ProfileSecurityManager.this)) {
                        if (ProfileSecurityManager.access$200(ProfileSecurityManager.this) == null) {
                            try {
                                var1_1 = WSSubject.getRunAsSubject();
                                if (var1_1 == null) {
                                    var1_1 = WSSubject.getCallerSubject();
                                }
                                if (var1_1 != null && ProfileSecurityManager.access$300(ProfileSecurityManager.this).getSubjectPrincipal(var1_1).getName() != null) ** GOTO lbl14
                                var1_1 = ProfileSecurityManager.access$000(ProfileSecurityManager.this);
                            }
                            catch (Exception var3_2) {
                                throw new AuthSystemException("AUTH_SUBJECT_FAILURE", var3_2, Level.WARNING);
                            }
                        } else {
                            var1_1 = ProfileSecurityManager.access$200(ProfileSecurityManager.this);
                        }
lbl14:
                        // 3 sources

                        var2_3 = ProfileSecurityManager.access$300(ProfileSecurityManager.this).getSubjectPrincipal(var1_1);
                        ProfileSecurityManager.access$400().log(Level.FINER, "The caller subject principal name is ''{0}''", new Object[]{var2_3.getName()});
                    }
                    ProfileSecurityManager.access$400().exiting(ProfileSecurityManager.access$500(), "getCallerSubject()");
                    return var1_1;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (AuthSystemException)privilegedActionException.getException();
        }
    }

    private String getCallerSubjectUniqueName() throws WIMException {
        trcLogger.entering(CLASSNAME, "getCallerSubjectUniqueName()");
        Subject subject = this.getCallerSubject();
        Principal principal = subject.getPrincipals().iterator().next();
        String string = ((Object)principal).equals(VirtualPrincipal.AnonymousUser) && this.secManager.isSuperUser(subject) ? "**SUPER USER**" : this.accessHandler.getSubjectPrincipal(this.getCallerSubject()).getName();
        trcLogger.exiting(CLASSNAME, "getCallerSubjectUniqueName()");
        return string;
    }

    private String getGroupForAttribute(String string) {
        String string2;
        trcLogger.entering(CLASSNAME, "getGroupForAttribute()");
        if (this.isAttributeGroupingEnabled) {
            string2 = (String)this.attributeGroups.get(string);
            if (string2 == null) {
                string2 = this.defaultAttributeGroup;
            }
            trcLogger.log(Level.FINEST, "The attribute ''{0}'' was mapped to group ''{1}'' for the access check", new Object[]{string, string2});
        } else {
            string2 = string;
        }
        trcLogger.exiting(CLASSNAME, "getGroupForAttribute()");
        return string2;
    }

    private Set getAttributesForGroup(String string) {
        trcLogger.entering(CLASSNAME, "getAttributesForGroup()");
        HashSet<Object> hashSet = new HashSet<Object>();
        if (this.isAttributeGroupingEnabled) {
            for (Map.Entry entry : this.attributeGroups.entrySet()) {
                if (!entry.getValue().equals(string)) continue;
                hashSet.add(entry.getKey());
            }
        } else {
            hashSet.add(string);
        }
        trcLogger.exiting(CLASSNAME, "getAttributesForGroup()");
        return hashSet;
    }

    private void traceAccessResult(String string, Level level, EntityResource entityResource, Entitlement entitlement) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.log(level, string, new Object[]{this.getCallerSubjectUniqueName(), entitlement.toSimpleString(), SDOHelper.getEntityDisplayName(entityResource.getEntity())});
        }
    }

    private void checkAccessResult(EntityResource entityResource, Entitlement entitlement, boolean bl) throws WIMException {
        if (!bl) {
            throw new AccessException(this.getCallerSubjectUniqueName(), SDOHelper.getEntityDisplayName(entityResource.getEntity()), entityResource.getResourceId(), entitlement, Level.SEVERE);
        }
        this.traceAccessResult("Access check for principal ''{0}'' succeeded for the following entitlement\n    ''{1}'' ''{2}''", Level.FINEST, entityResource, entitlement);
    }

    private String getDelegatedAdminViewId(EntityResource entityResource, String string) throws WIMException {
        trcLogger.entering(CLASSNAME, "getDelegatedAdminViewId()");
        String string2 = null;
        String string3 = "DefaultDAView";
        DataObject dataObject = entityResource.getEntity();
        if (string.equals("GET_ENTITLEMENTS")) {
            string2 = SDOHelper.getEntityViewId(string3, dataObject);
        }
        if (string2 == null) {
            String string4 = "com.ibm.ws.wim.authz.ProfileSecurityManager";
            DataObject dataObject2 = DataGraphHelper.cloneDataObject(dataObject);
            if (string.equals("CREATE")) {
                dataObject2.unset("identifier");
            }
            DataObject dataObject3 = SchemaManager.singleton().createRootDataObject();
            dataObject3.getList("entities").add(dataObject2);
            DataObject dataObject4 = dataObject3.createDataObject("controls", "http://www.ibm.com/websphere/wim", "ViewControl");
            dataObject4.setString("viewName", string3);
            dataObject3 = PluginManager.getPluginManager().preExitCall(string4, dataObject3);
            dataObject3 = PluginManager.getPluginManager().inlineExitCall(string4, dataObject3, "getInViewExplicit");
            dataObject3 = PluginManager.getPluginManager().postExitCall(string4, dataObject3, dataObject3);
            DataObject dataObject5 = dataObject3.getDataGraph().getRootObject().getDataObject("Root");
            DataObject dataObject6 = dataObject5.getDataObject("entities.0");
            string2 = SDOHelper.getEntityViewId(string3, dataObject6);
        }
        if (string2 == null) {
            throw new AuthSystemException("AUTH_VIEW_PLUGIN_FAILURE", new Object[]{SDOHelper.getEntityDisplayName(entityResource.getEntity())}, Level.SEVERE);
        }
        trcLogger.log(Level.FINEST, "The entity ''{0}'' was mapped to the delegated administration path ''{1}''", new Object[]{SDOHelper.getEntityDisplayName(entityResource.getEntity()), string2});
        trcLogger.exiting(CLASSNAME, "getDelegatedAdminViewId()");
        return string2;
    }

    static /* synthetic */ Subject access$000(ProfileSecurityManager profileSecurityManager) {
        return profileSecurityManager.getAnonymousSubject();
    }

    static /* synthetic */ boolean access$100(ProfileSecurityManager profileSecurityManager) {
        return profileSecurityManager.isSecurityEnabled;
    }

    static /* synthetic */ Subject access$200(ProfileSecurityManager profileSecurityManager) {
        return profileSecurityManager.runAsSubject;
    }

    static /* synthetic */ AccessHandler access$300(ProfileSecurityManager profileSecurityManager) {
        return profileSecurityManager.accessHandler;
    }

    static /* synthetic */ Logger access$400() {
        return trcLogger;
    }

    static /* synthetic */ String access$500() {
        return CLASSNAME;
    }
}

