/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.security.authz;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.wim.ProfileManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.security.authz.ProfileSecurityManager;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.sdo.EProperty;
import org.eclipse.emf.ecore.sdo.EType;

public class SDOHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = SDOHelper.class.getName();
    private static final Logger msgLogger = WIMLogger.getMessageLogger("com.ibm.ws.wim.security.authz");
    private static final Logger trcLogger = WIMLogger.getTraceLogger("com.ibm.ws.wim.security.authz");
    static final String NAMESPACE = "http://www.ibm.com/websphere/wim";
    static final String CLASSNAME_ENTITY = "Entity";
    static final String CLASSNAME_PERSON = "Person";
    static final String CLASSNAME_PROPERTYCTRL = "PropertyControl";
    static final String CLASSNAME_VIEWCTRL = "ViewControl";
    static final String CLASSNAME_ENTITLECTRL = "EntitlementControl";
    static final String PROPERTY_ROOT = "Root";
    static final String PROPERTY_ROOT_CONTEXTS = "contexts";
    static final String PROPERTY_ROOT_CONTROLS = "controls";
    static final String PROPERTY_ROOT_ENTITIES = "entities";
    static final String PROPERTY_CONTEXT_KEY = "key";
    static final String PROPERTY_CONTEXT_VALUE = "value";
    static final String PROPERTY_PROPERTYCTRL_PROPERTIES = "properties";
    static final String PROPERTY_ENTITLECTRL_GET_EXCLUSIVELY = "getExclusively";
    static final String PROPERTY_ENTITLECTRL_GET_ROLES = "getRoles";
    static final String PROPERTY_ENTITLECTRL_GET_OBJ_ENTITLE = "getObjectEntitlements";
    static final String PROPERTY_ENTITLECTRL_GET_ATTR_ENTITLE = "getAttributeEntitlements";
    static final String PROPERTY_ENTITLECTRL_ENTITLE_ATTR = "entitlementAttributes";
    static final String PROPERTY_ENTITLECTRL_ENTITLE_FILTER = "entitlementFilter";
    static final String PROPERTY_ENTITLECTRL_ENTITLE_CHECK = "entitlementCheck";
    static final String PROPERTY_VIEWCTRL_VIEWNAME = "viewName";
    static final String PROPERTY_ENTITY_IDENTIFIER = "identifier";
    static final String PROPERTY_ENTITY_UNIQUENAME = "identifier/uniqueName";
    static final String PROPERTY_ENTITY_UNIQUEID = "identifier/uniqueId";
    static final String PROPERTY_ENTITY_VIEW_IDS = "viewIdentifiers";
    static final String PROPERTY_ENTITY_VIEW_IDS_VIEWNAME = "viewName";
    static final String PROPERTY_ENTITY_VIEW_IDS_ENTRYNAME = "viewEntryName";
    static final String PROPERTY_ENTITY_ENTITLEINFO = "entitlementInfo";
    static final String PROPERTY_ENTITLEINFO_ROLES = "roles";
    static final String PROPERTY_ENTITLEINFO_ENTITLEMENTS = "entitlements";
    static final String PROPERTY_ENTITLEINFO_CHECKRESULT = "entitlementCheckResult";
    static final String PROPERTY_ENTITLEMENT_METHOD = "method";
    static final String PROPERTY_ENTITLEMENT_OBJECT = "object";
    static final String PROPERTY_ENTITLEMENT_ATTRIBUTE = "attribute";
    static final String CONFIG_ROOT = "configurationProvider";
    static final String CONFIG_AUTHORIZATION = "authorization";
    static final String CONFIG_SECURITY_ENABLED = "isSecurityEnabled";
    static final String CONFIG_USE_SYSTEM_JACC_PROVIDER = "useSystemJACCProvider";
    static final String CONFIG_IMPORT_POLICY_FROM_FILE = "importPolicyFromFile";
    static final String CONFIG_ATTRIB_GROUPING_ENABLED = "isAttributeGroupingEnabled";
    static final String CONFIG_JACC_POLICY_CLASS = "jaccPolicyClass";
    static final String CONFIG_JACC_ROLEMAPPING_CLASS = "jaccRoleMappingClass";
    static final String CONFIG_JACC_POLICY_FACTORY_CLASS = "jaccPolicyConfigFactoryClass";
    static final String CONFIG_JACC_ROLEMAPPING_FACTORY_CLASS = "jaccRoleMappingConfigFactoryClass";
    static final String CONFIG_JACC_ROLEPERMISSION_POLICY_ID = "jaccRoleToPermissionPolicyId";
    static final String CONFIG_JACC_PRINCIPALROLE_POLICY_ID = "jaccPrincipalToRolePolicyId";
    static final String CONFIG_JACC_ROLEPERMISSION_FILENAME = "jaccRoleToPermissionPolicyFileName";
    static final String CONFIG_JACC_PRINCIPALROLE_FILENAME = "jaccPrincipalToRolePolicyFileName";
    static final String CONFIG_DEFAULT_ATTR_GROUP = "defaultAttributeGroup";
    static final String CONFIG_ATTRGROUPS = "attributeGroups";
    static final String CONFIG_ATTRGROUPS_GROUPNAME = "groupName";
    static final String CONFIG_ATTRGROUPS_ATTRNAMES = "attributeNames";
    public static final boolean TRUST_SDO_TYPE = true;
    public static final boolean TRUST_NOT_SDO_TYPE = false;
    public static final boolean GET_ATTR_ALL = true;
    public static final boolean GET_ATTR_ACTIVE = false;
    public static final boolean GET_QUALIFIED = true;
    public static final boolean GET_UNQUALIFIED = false;

    public static String getEntityDisplayName(DataObject dataObject) {
        String string = null;
        if (dataObject != null && dataObject.get(PROPERTY_ENTITY_IDENTIFIER) != null && (string = dataObject.getString(PROPERTY_ENTITY_UNIQUENAME)) == null) {
            string = dataObject.getString(PROPERTY_ENTITY_UNIQUEID);
        }
        return string == null ? "<non-existent>" : string;
    }

    public static String getEntityViewId(String string, DataObject dataObject) {
        String string2 = null;
        List list = dataObject.getList(PROPERTY_ENTITY_VIEW_IDS);
        for (DataObject dataObject2 : list) {
            if (!dataObject2.getString("viewName").equals(string)) continue;
            string2 = dataObject2.getString(PROPERTY_ENTITY_VIEW_IDS_ENTRYNAME);
            break;
        }
        return string2;
    }

    public static Set getEntityAttributes(DataObject dataObject, boolean bl, boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        List list = dataObject.getType().getProperties();
        for (Property property : list) {
            if (!bl && !dataObject.isSet(property)) continue;
            String string = bl2 ? SDOHelper.getQualifiedPropertyName(property) : property.getName();
            hashSet.add(string);
        }
        return hashSet;
    }

    public static String getEntityType(DataObject dataObject, boolean bl) throws WIMException {
        EClass eClass;
        if (!bl) {
            final DataObject dataObject2 = dataObject.getDataObject(PROPERTY_ENTITY_IDENTIFIER);
            if (dataObject2 == null) {
                return "<unknown type>";
            }
            String string = (String)ProfileSecurityManager.singleton().runAsSuperUser(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return ProfileManager.singleton().getEntityType(dataObject2);
                }
            });
            eClass = SchemaManager.singleton().getEClass(string);
        } else {
            eClass = ((EDataObject)dataObject).eClass();
        }
        String string = SDOHelper.getClassHierarchy(eClass);
        trcLogger.log(Level.FINEST, "The entity ''{0}'' is of type ''{1}''", new Object[]{SDOHelper.getEntityDisplayName(dataObject), string});
        return string;
    }

    public static String getEntityAttributeType(DataObject dataObject, String string) throws WIMException {
        String string2 = dataObject.getType().getProperty(string).getType().getName();
        EClass eClass = SchemaManager.singleton().getEClass(string2);
        return eClass != null ? SDOHelper.getClassHierarchy(eClass) : string2;
    }

    public static String getClassHierarchy(EClass eClass) throws WIMException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = SDOHelper.getQualifiedClassName(eClass);
        stringBuffer.append(string + "/");
        if (eClass.getESuperTypes().size() != 0) {
            eClass = (EClass)eClass.getESuperTypes().iterator().next();
            while (eClass != null) {
                string = SDOHelper.getQualifiedClassName(eClass);
                stringBuffer.insert(0, string + "/");
                eClass = eClass.getESuperTypes().size() != 0 ? (EClass)eClass.getESuperTypes().iterator().next() : null;
            }
        }
        return stringBuffer.toString();
    }

    private static String getQualifiedClassName(EClass eClass) throws WIMException {
        SchemaManager schemaManager = SchemaManager.singleton();
        return schemaManager.getQualifiedTypeName(eClass.getEPackage().getNsURI(), eClass.getName());
    }

    private static String getQualifiedPropertyName(Property property) {
        try {
            SchemaManager schemaManager = SchemaManager.singleton();
            return schemaManager.getQualifiedPropertyName(((EProperty)property).getEStructuralFeature());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean isAttributeEntityType(DataObject dataObject, String string) throws WIMException {
        if (dataObject.getType().getProperty(string) != null) {
            EClassifier eClassifier = ((EType)dataObject.getType().getProperty(string).getType()).getEClassifier();
            return SDOHelper.isAttributeComplex(dataObject, string) && SDOHelper.getClassHierarchy((EClass)eClassifier).startsWith(CLASSNAME_ENTITY);
        }
        return false;
    }

    public static boolean isAttributeComplex(DataObject dataObject, String string) {
        return dataObject.getType().getProperty(string).getType().getProperties().size() > 0;
    }

    public static boolean isAttributeMultiValued(DataObject dataObject, String string) {
        return dataObject.getType().getProperty(string).isMany();
    }
}

