/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.security.authz.jacc;

import com.ibm.sec.auth.subjectx.VirtualPrincipal;
import com.ibm.sec.authz.jaccx.condition.ConditionalPermission;
import com.ibm.sec.authz.jaccx.condition.OwnerCondition;
import com.ibm.sec.authz.jaccx.resource.TreeBasedResource;
import com.ibm.sec.authz.jaccx.resource.TreeBasedResourceScope;
import com.ibm.sec.authz.jaccx.role.RoleMappingConfiguration;
import com.ibm.sec.authz.jaccx.role.ScopedRoleAssignmentCondition;
import com.ibm.sec.authz.jaccx.xml.XMLSerializable;
import com.ibm.sec.authz.provider.MethodPermission;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.security.authz.AuthSystemException;
import com.ibm.ws.wim.security.authz.jacc.JACCSecurityManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Permission;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.jacc.PolicyConfiguration;

public class JACCPolicyDefinition
extends JACCSecurityManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final boolean POLICY_EXISTS = true;
    public static final boolean POLICY_NOT_EXIST = false;
    public static final String POLICY_ID = "WIM Policy";
    public static final String ROLEMAPPING_ID = "WIM Policy";
    public static final String POLICY_SUBDIR = "config" + File.separator + "authz";
    public static final String RESOURCE_ROOT = "/root";
    public static final String OBJECT_ACCOUNT = "Entity/RolePlayer/Party/LoginAccount/*";
    public static final String ATTRGROUP_SENSITIVE = "sensitive";
    public static final String ATTRGROUP_UNCHECKED = "unchecked";
    public static final String ROLE_ACCOUNT_OWNER = "Account-Owner-Role";
    private static final int SOURCE_INTERNAL = 1;
    private static final int SOURCE_FILE = 2;
    private static final String CLASSNAME = JACCPolicyDefinition.class.getName();
    private static final Logger msgLogger = WIMLogger.getMessageLogger("com.ibm.ws.wim.security.authz");
    private static final Logger trcLogger = WIMLogger.getTraceLogger("com.ibm.ws.wim.security.authz");

    public JACCPolicyDefinition() {
        trcLogger.entering(CLASSNAME, "JACCPolicyDefinition()");
        trcLogger.exiting(CLASSNAME, "JACCPolicyDefinition()");
    }

    public JACCPolicyDefinition(String string, String string2, String string3, String string4, String string5) throws AuthSystemException {
        super(string, string2, string3, string4, string5);
        trcLogger.entering(CLASSNAME, "JACCPolicyDefinition(...");
        trcLogger.exiting(CLASSNAME, "JACCPolicyDefinition(...)");
    }

    public void createPolicy(String string, String string2, String string3, String string4) throws AuthSystemException {
        trcLogger.entering(CLASSNAME, "createPolicy()");
        try {
            this.createRoletoPermissionPolicy(string, string3, 1);
            this.createPrincipalToRolePolicy(string, string4, 1);
        }
        catch (Exception exception) {
            throw new AuthSystemException("AUTH_INIT_FAILURE", exception, Level.SEVERE);
        }
        trcLogger.exiting(CLASSNAME, "createPolicy()");
    }

    public void loadPolicy(String string, String string2, String string3, String string4) throws AuthSystemException {
        trcLogger.entering(CLASSNAME, "loadPolicy()");
        try {
            this.createRoletoPermissionPolicy(string, string3, 2);
            this.createPrincipalToRolePolicy(string, string4, 2);
        }
        catch (Exception exception) {
            throw new AuthSystemException("AUTH_INIT_FAILURE", exception, Level.SEVERE);
        }
        trcLogger.exiting(CLASSNAME, "loadPolicy()");
    }

    private void createRoletoPermissionPolicy(String string, String string2, int n) throws Exception {
        trcLogger.entering(CLASSNAME, "createRoleToPermissionPolicy()");
        HashSet<MethodPermission> hashSet = new HashSet<MethodPermission>();
        String[] stringArray = new String[]{OBJECT_ACCOUNT};
        PolicyConfiguration policyConfiguration = this.getPolicyConfigFactory().getPolicyConfiguration(string, true);
        if (n == 1) {
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(new MethodPermission(stringArray[i], "SEARCH"));
                hashSet.add(new MethodPermission(stringArray[i], "UPDATE"));
                hashSet.add(new MethodPermission(stringArray[i], ATTRGROUP_SENSITIVE, "WRITE"));
                hashSet.add(new MethodPermission(stringArray[i], ATTRGROUP_UNCHECKED, "READ"));
                hashSet.add(new MethodPermission(stringArray[i], ATTRGROUP_UNCHECKED, "WRITE"));
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                policyConfiguration.addToRole(ROLE_ACCOUNT_OWNER, (Permission)new ConditionalPermission((Permission)iterator.next(), OwnerCondition.OWNER_CONDITION));
            }
        } else {
            ((XMLSerializable)policyConfiguration).readXML(new FileInputStream(string2));
        }
        policyConfiguration.commit();
        this.getPolicy().refresh();
        if (n == 1 && string2 != null) {
            ((XMLSerializable)policyConfiguration).writeXML(new FileOutputStream(string2));
            System.out.println("Successfully exported role-to-permission policy to file " + string2);
        }
        trcLogger.exiting(CLASSNAME, "createRoleToPermissionPolicy()");
    }

    private void createPrincipalToRolePolicy(String string, String string2, int n) throws Exception {
        trcLogger.entering(CLASSNAME, "createPrincipalToRolePolicy()");
        String string3 = this.getRoleMappingContext(string).getContextID();
        RoleMappingConfiguration roleMappingConfiguration = this.getRoleMappingConfigFactory().getRoleMappingConfiguration(string3, true);
        if (n == 1) {
            roleMappingConfiguration.setCombiningAlgorithm("most-specific-block-overrides");
            TreeBasedResource treeBasedResource = new TreeBasedResource("", RESOURCE_ROOT);
            TreeBasedResourceScope treeBasedResourceScope = new TreeBasedResourceScope(treeBasedResource, 4);
            roleMappingConfiguration.addToPrincipal(VirtualPrincipal.AllAuthenticatedUsers, new ScopedRoleAssignmentCondition(ROLE_ACCOUNT_OWNER, treeBasedResourceScope));
        } else {
            ((XMLSerializable)((Object)roleMappingConfiguration)).readXML(new FileInputStream(string2));
        }
        roleMappingConfiguration.commit();
        this.getRoleMapping().refresh();
        if (n == 1 && string2 != null) {
            ((XMLSerializable)((Object)roleMappingConfiguration)).writeXML(new FileOutputStream(string2));
            System.out.println("Successfully exported principal-to-role policy to file " + string2);
        }
        trcLogger.exiting(CLASSNAME, "createPrincipalToRolePolicy()");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2) {
            System.out.println("Syntax: <output policy filename> <output rolemapping filename>\n");
            System.exit(1);
        }
        JACCPolicyDefinition jACCPolicyDefinition = new JACCPolicyDefinition("com.ibm.sec.authz.provider.CommonAuthzPolicy", "com.ibm.sec.authz.provider.CommonAuthzRoleMapping", "com.ibm.sec.authz.provider.CommonAuthzPolicyConfigurationFactory", "com.ibm.sec.authz.provider.CommonAuthzRoleMappingConfigurationFactory", null);
        jACCPolicyDefinition.createPolicy("WIM Policy", "WIM Policy", stringArray[0], stringArray[1]);
    }
}

