/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.security.authz.jacc;

import com.ibm.sec.auth.subjectx.SubjectAttributes;
import com.ibm.sec.authz.jaccx.DefaultEvaluationContext;
import com.ibm.sec.authz.jaccx.EntitlementPolicy;
import com.ibm.sec.authz.jaccx.EvaluationContext;
import com.ibm.sec.authz.jaccx.condition.AttributeName;
import com.ibm.sec.authz.jaccx.condition.RequestContext;
import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.sec.authz.jaccx.resource.ResourceContext;
import com.ibm.sec.authz.jaccx.role.RoleMapping;
import com.ibm.sec.authz.jaccx.role.RoleMappingConfigurationFactory;
import com.ibm.sec.authz.jaccx.role.RoleMappingContext;
import com.ibm.sec.authz.jaccx.role.RoleMappingContextFactory;
import com.ibm.sec.authz.provider.CommonAuthzSystemPolicy;
import com.ibm.sec.authz.provider.MethodPermission;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.security.authz.AuthSystemException;
import com.ibm.websphere.wim.security.authz.Entitlement;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.wim.security.authz.AccessHandler;
import com.ibm.ws.wim.security.authz.EntitlementHelper;
import com.ibm.ws.wim.security.authz.jacc.PolicyContextHandlerImpl;
import com.ibm.ws.wim.security.authz.jacc.RequestContextHandlerImpl;
import com.ibm.ws.wim.security.authz.jacc.ResourceContextHandlerImpl;
import com.ibm.ws.wim.security.authz.jacc.SubjectAttributesHandlerImpl;
import java.io.File;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;

public class JACCSecurityManager {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String AUTHZ_HOME_DIR = "commonauthz.home";
    public static final String AUTHZ_POLICY_DIR = "commonauthz.policydir";
    public static final String AUTHZ_RUNTIME_DIR = "commonauthz.runtimedir";
    public static final String WIM_AUTHZ_POLICY_DIR = "wim.commonauthz.policydir";
    public static final String WIM_AUTHZ_RUNTIME_DIR = "wim.commonauthz.runtimedir";
    public static final String AUTHZ_ROLEMAPPING_CLASS = "com.ibm.sec.authz.jaccx.role.RoleMapping.provider";
    public static final String AUTHZ_ROLEMAPPINGCFG_CLASS = "com.ibm.sec.authz.jaccx.role.RoleMappingConfigurationFactory.provider";
    public static final String JACC_SUBJECT_KEY = "javax.security.auth.Subject.container";
    public static final String REQUEST_PREFIX = "com.ibm.websphere.wim.Context.";
    public static final String SUBJECT_PREFIX = "com.ibm.websphere.wim.Subject.";
    public static final String RESOURCE_PREFIX = "com.ibm.websphere.wim.Entity.";
    public static final String ATTRVALUE_NON_APPLICABLE = "$NON-APPLICABLE$";
    private static final String CLASSNAME = JACCSecurityManager.class.getName();
    private static final Logger msgLogger = WIMLogger.getMessageLogger("com.ibm.ws.wim.security.authz");
    private static final Logger trcLogger = WIMLogger.getTraceLogger("com.ibm.ws.wim.security.authz");
    private Object policy;
    private Object roleMapping;
    private Object policyConfigFactory;
    private Object roleMappingConfigFactory;
    private String policyContextId;
    private String appContextId;
    private RequestContext requestContext;
    private SubjectAttributes subjectAttributes;
    private ResourceContext resourceContext;
    private AccessHandler accessHandler;
    private Subject superUserSubject = new Subject();
    private static ThreadLocal runAsSubject = new ThreadLocal();

    public JACCSecurityManager() {
        trcLogger.entering(CLASSNAME, "JACCSecurityManager()");
        trcLogger.exiting(CLASSNAME, "JACCSecurityManager()");
    }

    public JACCSecurityManager(String string, String string2, String string3, String string4, String string5) throws AuthSystemException {
        trcLogger.entering(CLASSNAME, "JACCSecurityManager(...)");
        try {
            ClassLoader classLoader;
            if (string5 != null) {
                this.setProviderPaths(string5);
            }
            if ((classLoader = Thread.currentThread().getContextClassLoader()) == null) {
                classLoader = this.getClass().getClassLoader();
            }
            System.setProperty(AUTHZ_ROLEMAPPING_CLASS, string2);
            System.setProperty(AUTHZ_ROLEMAPPINGCFG_CLASS, string4);
            this.policy = (Policy)classLoader.loadClass(string).newInstance();
            this.policyConfigFactory = (PolicyConfigurationFactory)classLoader.loadClass(string3).newInstance();
            CommonAuthzSystemPolicy.setPolicy((Policy)this.policy);
        }
        catch (Exception exception) {
            throw new AuthSystemException("AUTH_INIT_FAILURE", exception, Level.SEVERE);
        }
        trcLogger.exiting(CLASSNAME, "JACCSecurityManager(...)");
    }

    private void setProviderPaths(String string) throws Exception {
        trcLogger.entering(CLASSNAME, "setProviderPaths()");
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = File.separator;
        AdminService adminService = AdminServiceFactory.getAdminService();
        if (adminService != null) {
            string2 = adminService.getCellName();
            string3 = adminService.getNodeName();
            string4 = adminService.getProcessName();
        }
        String string6 = System.getProperty("user.install.root");
        String string7 = string6 + string5 + "etc";
        String string8 = string6 + string5 + "temp";
        if (string2 != null) {
            string8 = string6 + string5 + "config" + string5 + "cells" + string5 + string2 + string5 + "nodes" + string5 + string3 + string5 + "servers" + string5 + string4;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper != null && platformHelper.isZOS() && platformHelper.isServantJvm()) {
                string8 = string8 + string5 + platformHelper.getServantToken();
            }
        }
        System.setProperty(AUTHZ_HOME_DIR, string);
        System.setProperty(AUTHZ_POLICY_DIR, WIM_AUTHZ_POLICY_DIR);
        System.setProperty(AUTHZ_RUNTIME_DIR, WIM_AUTHZ_RUNTIME_DIR);
        System.setProperty(WIM_AUTHZ_POLICY_DIR, string7);
        System.setProperty(WIM_AUTHZ_RUNTIME_DIR, string8);
        trcLogger.log(Level.FINER, "Setting system property commonauthz.home=" + System.getProperty(AUTHZ_HOME_DIR));
        trcLogger.log(Level.FINER, "Setting system property commonauthz.policydir=" + System.getProperty(AUTHZ_POLICY_DIR));
        trcLogger.log(Level.FINER, "Setting system property commonauthz.runtimedir=" + System.getProperty(AUTHZ_RUNTIME_DIR));
        trcLogger.log(Level.FINER, "Setting system property wim.commonauthz.policydir=" + System.getProperty(WIM_AUTHZ_POLICY_DIR));
        trcLogger.log(Level.FINER, "Setting system property wim.commonauthz.runtimedir=" + System.getProperty(WIM_AUTHZ_RUNTIME_DIR));
        trcLogger.exiting(CLASSNAME, "setProviderPaths()");
    }

    public void registerPolicy(String string, String string2, AccessHandler accessHandler) throws AuthSystemException {
        trcLogger.entering(CLASSNAME, "registerPolicy()");
        try {
            this.policyContextId = string;
            this.appContextId = string2;
            this.accessHandler = accessHandler;
            this.refreshPolicy();
            this.createContextHandlers();
        }
        catch (Exception exception) {
            throw new AuthSystemException("AUTH_INIT_FAILURE", exception, Level.SEVERE);
        }
        trcLogger.exiting(CLASSNAME, "registerPolicy()");
    }

    public void refreshPolicy() {
        trcLogger.entering(CLASSNAME, "refreshPolicy()");
        this.getPolicy().refresh();
        this.getRoleMapping().refresh();
        trcLogger.exiting(CLASSNAME, "refreshPolicy()");
    }

    private String getSubjectName(Subject subject) {
        return this.accessHandler.getSubjectPrincipal(subject).getName();
    }

    private Subject getServerSubject() throws WSSecurityException {
        return ContextManagerFactory.getInstance().getServerSubject();
    }

    private boolean isCallerServerSubject(Subject subject, Subject subject2) throws CredentialDestroyedException, CredentialExpiredException {
        trcLogger.entering(CLASSNAME, "isCallerServerSubject()");
        boolean bl = false;
        WSCredential wSCredential = SubjectHelper.getWSCredentialFromSubject(subject);
        WSCredential wSCredential2 = SubjectHelper.getWSCredentialFromSubject(subject2);
        if (wSCredential2 != null && wSCredential2.isCurrent() && wSCredential != null && !wSCredential.isUnauthenticated() && wSCredential.isCurrent()) {
            String string = wSCredential.getRealmUniqueSecurityName();
            String string2 = wSCredential2.getRealmUniqueSecurityName();
            if (string != null && string.equals(string2)) {
                bl = true;
            }
        }
        trcLogger.exiting(CLASSNAME, "isCallerServerSubject()");
        return bl;
    }

    private boolean isCallerAdministrator(Subject subject) throws WSSecurityException {
        Boolean bl;
        trcLogger.entering(CLASSNAME, "isCallerAdministrator()");
        boolean bl2 = false;
        final Subject subject2 = subject;
        try {
            bl = (Boolean)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WSSecurityException {
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    return contextManager.isGrantedAdminRole(new String[]{"administrator"}, subject2);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (WSSecurityException)privilegedActionException.getException();
        }
        bl2 = bl;
        trcLogger.exiting(CLASSNAME, "isCallerAdministrator()");
        return bl2;
    }

    public boolean isServerSecurityEnabled() {
        trcLogger.entering(CLASSNAME, "isServerSecurityEnabled()");
        boolean bl = true;
        try {
            ContextManager contextManager = ContextManagerFactory.getInstance();
            bl = contextManager.getServerSubject() != null && contextManager.isServerSubjectCreated();
        }
        catch (Exception exception) {
            trcLogger.log(Level.FINE, exception.getMessage(), exception);
        }
        trcLogger.exiting(CLASSNAME, "isServerSecurityEnabled() - " + bl);
        return bl;
    }

    public boolean isSuperUser(Subject subject) throws AuthSystemException {
        trcLogger.entering(CLASSNAME, "isSuperUser()");
        boolean bl = runAsSubject.get() == this.superUserSubject;
        try {
            if (this.isServerSecurityEnabled()) {
                bl = this.isCallerAdministrator(subject);
                if (bl) {
                    trcLogger.log(Level.FINER, "The caller is running as the **WAS ADMINISTRATOR**");
                } else {
                    trcLogger.log(Level.FINER, "The caller is NOT running as the WAS ADMINISTRATOR");
                }
            }
        }
        catch (WSSecurityException wSSecurityException) {
            trcLogger.log(Level.FINE, "Skipping administrator role check: " + wSSecurityException.getMessage());
        }
        catch (Exception exception) {
            throw new AuthSystemException("AUTH_CHECK_FAILURE", new Object[]{this.getSubjectName(subject)}, exception, Level.SEVERE);
        }
        if (bl) {
            trcLogger.log(Level.FINER, "The caller will be granted **SUPER USER** status");
        }
        trcLogger.exiting(CLASSNAME, "isSuperUser()");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object runAsSuperUser(PrivilegedExceptionAction privilegedExceptionAction) throws PrivilegedActionException {
        Object object;
        block6: {
            trcLogger.entering(CLASSNAME, "runAsSuperUser()");
            Subject subject = (Subject)runAsSubject.get();
            runAsSubject.set(this.superUserSubject);
            try {
                if (this.isServerSecurityEnabled()) {
                    object = ContextManagerFactory.getInstance().runAsSystem(privilegedExceptionAction);
                    break block6;
                }
                try {
                    object = privilegedExceptionAction.run();
                }
                catch (Exception exception) {
                    throw new PrivilegedActionException(exception);
                }
            }
            finally {
                runAsSubject.set(subject);
            }
        }
        trcLogger.exiting(CLASSNAME, "runAsSuperUser()");
        return object;
    }

    public Set getRoles(Subject subject, Resource resource) throws AuthSystemException {
        trcLogger.entering(CLASSNAME, "getRoles()");
        HashSet hashSet = new HashSet();
        try {
            EvaluationContext evaluationContext = this.createEvaluationContext(subject, resource);
            Iterator iterator = this.getRoleMapping().getRoles(this.getRoleMappingContext(), evaluationContext);
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        catch (Exception exception) {
            throw new AuthSystemException("AUTH_CHECK_FAILURE", new Object[]{this.getSubjectName(subject)}, exception, Level.SEVERE);
        }
        trcLogger.exiting(CLASSNAME, "getRoles()");
        return hashSet;
    }

    public boolean doesEntitlementExist(Subject subject, Resource resource, Entitlement entitlement) throws AuthSystemException {
        boolean bl;
        trcLogger.entering(CLASSNAME, "doesEntitlementExist()");
        try {
            EvaluationContext evaluationContext = this.createEvaluationContext(subject, resource);
            bl = this.getRoleMapping().hasPermissionAtOrUnderneath(this.policyContextId, evaluationContext, EntitlementHelper.getMethodPermission(entitlement));
        }
        catch (Exception exception) {
            throw new AuthSystemException("AUTH_CHECK_FAILURE", new Object[]{this.getSubjectName(subject)}, exception, Level.SEVERE);
        }
        trcLogger.exiting(CLASSNAME, "doesEntitlementExist()");
        return bl;
    }

    public boolean hasEntitlement(Subject subject, Resource resource, Entitlement entitlement) throws AuthSystemException {
        boolean bl;
        trcLogger.entering(CLASSNAME, "hasEntitlement()");
        final Subject subject2 = subject;
        final Entitlement entitlement2 = entitlement;
        try {
            if (this.isSuperUser(subject)) {
                trcLogger.exiting(CLASSNAME, "hasEntitlement()");
                return true;
            }
            final EvaluationContext evaluationContext = this.createEvaluationContext(subject, resource);
            Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ProtectionDomain protectionDomain = new ProtectionDomain(null, null, null, new Principal[]{JACCSecurityManager.this.accessHandler.getSubjectPrincipal(subject2)});
                    return ((EntitlementPolicy)((Object)JACCSecurityManager.this.getPolicy())).implies(JACCSecurityManager.this.policyContextId, evaluationContext, protectionDomain, EntitlementHelper.getMethodPermission(entitlement2));
                }
            });
            bl = bl2;
        }
        catch (Exception exception) {
            throw new AuthSystemException("AUTH_CHECK_FAILURE", new Object[]{this.getSubjectName(subject)}, exception, Level.SEVERE);
        }
        trcLogger.exiting(CLASSNAME, "hasEntitlement()");
        return bl;
    }

    public Set getEntitlements(Subject subject, Resource resource) throws AuthSystemException {
        trcLogger.entering(CLASSNAME, "getEntitlements()");
        HashSet<Entitlement> hashSet = new HashSet<Entitlement>();
        try {
            EvaluationContext evaluationContext = this.createEvaluationContext(subject, resource);
            PermissionCollection permissionCollection = this.getRoleMapping().getPermissions(this.policyContextId, evaluationContext);
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                Permission permission = enumeration.nextElement();
                if (!(permission instanceof MethodPermission)) continue;
                hashSet.add(EntitlementHelper.getEntitlement((MethodPermission)permission));
            }
        }
        catch (Exception exception) {
            throw new AuthSystemException("AUTH_CHECK_FAILURE", new Object[]{this.getSubjectName(subject)}, exception, Level.SEVERE);
        }
        trcLogger.exiting(CLASSNAME, "getEntitlements()");
        return hashSet;
    }

    private void createContextHandlers() throws ClassNotFoundException, PolicyContextException {
        trcLogger.entering(CLASSNAME, "createContextHandlers()");
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet hashSet4 = new HashSet();
        hashSet4.addAll(((EntitlementPolicy)((Object)this.getPolicy())).getReferencedAttributeNames(this.policyContextId));
        hashSet4.addAll(this.getRoleMapping().getReferencedAttributeNames(this.getRoleMappingContext()));
        for (AttributeName attributeName : hashSet4) {
            if (attributeName.getSource() == 2 && attributeName.getAttributeName().startsWith(REQUEST_PREFIX)) {
                hashSet.add(attributeName.getAttributeName());
            }
            if (attributeName.getSource() == 1 && attributeName.getAttributeName().startsWith(SUBJECT_PREFIX)) {
                hashSet2.add(attributeName.getAttributeName());
            }
            if (attributeName.getSource() != 3 || !attributeName.getAttributeName().startsWith(RESOURCE_PREFIX)) continue;
            hashSet3.add(attributeName.getAttributeName());
        }
        this.requestContext = new RequestContext();
        RequestContextHandlerImpl requestContextHandlerImpl = new RequestContextHandlerImpl(hashSet);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            this.requestContext.registerHandler((String)iterator.next(), requestContextHandlerImpl, true);
        }
        hashSet2.add("user");
        hashSet2.add("group");
        this.subjectAttributes = new SubjectAttributes();
        SubjectAttributesHandlerImpl subjectAttributesHandlerImpl = new SubjectAttributesHandlerImpl(hashSet2, this.accessHandler);
        iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            this.subjectAttributes.registerHandler((String)iterator.next(), subjectAttributesHandlerImpl, true);
        }
        hashSet3.add("is-owner");
        this.resourceContext = new ResourceContext();
        ResourceContextHandlerImpl resourceContextHandlerImpl = new ResourceContextHandlerImpl(hashSet3, this.accessHandler);
        iterator = hashSet3.iterator();
        while (iterator.hasNext()) {
            this.resourceContext.registerHandler((String)iterator.next(), resourceContextHandlerImpl, true);
        }
        trcLogger.exiting(CLASSNAME, "createContextHandlers()");
    }

    private EvaluationContext createEvaluationContext(Subject subject, Resource resource) throws PolicyContextException {
        trcLogger.entering(CLASSNAME, "createEvaluationContext()");
        DefaultEvaluationContext defaultEvaluationContext = new DefaultEvaluationContext();
        PolicyContextHandlerImpl policyContextHandlerImpl = new PolicyContextHandlerImpl(subject, resource, this.requestContext, this.subjectAttributes, this.resourceContext);
        defaultEvaluationContext.registerHandler(JACC_SUBJECT_KEY, policyContextHandlerImpl, true);
        defaultEvaluationContext.registerHandler(Resource.JACC_RESOURCE_KEY, policyContextHandlerImpl, true);
        defaultEvaluationContext.registerHandler(RequestContext.JACC_REQUEST_CONTEXT_KEY, policyContextHandlerImpl, true);
        defaultEvaluationContext.registerHandler(SubjectAttributes.JACC_SUBJECT_ATTRIBUTES_KEY, policyContextHandlerImpl, true);
        defaultEvaluationContext.registerHandler(ResourceContext.JACC_RESOURCE_CONTEXT_KEY, policyContextHandlerImpl, true);
        this.requestContext.setHandlerData(this.accessHandler.getContextParameters(resource));
        this.accessHandler.clearThreadCache();
        trcLogger.exiting(CLASSNAME, "createEvaluationContext()");
        return defaultEvaluationContext;
    }

    protected Policy getPolicy() {
        return this.policy == null ? Policy.getPolicy() : (Policy)this.policy;
    }

    protected RoleMapping getRoleMapping() {
        return this.roleMapping == null ? RoleMapping.getRoleMapping() : (RoleMapping)this.roleMapping;
    }

    protected PolicyConfigurationFactory getPolicyConfigFactory() throws ClassNotFoundException, PolicyContextException {
        return this.policyConfigFactory == null ? PolicyConfigurationFactory.getPolicyConfigurationFactory() : (PolicyConfigurationFactory)this.policyConfigFactory;
    }

    protected RoleMappingConfigurationFactory getRoleMappingConfigFactory() throws PolicyContextException {
        return this.roleMappingConfigFactory == null ? RoleMappingConfigurationFactory.getRoleMappingConfigurationFactory() : (RoleMappingConfigurationFactory)this.roleMappingConfigFactory;
    }

    protected RoleMappingContext getRoleMappingContext() throws PolicyContextException, ClassNotFoundException {
        return ((RoleMappingContextFactory)((Object)this.getPolicy())).getRoleMappingContext(this.policyContextId);
    }

    protected RoleMappingContext getRoleMappingContext(String string) throws PolicyContextException, ClassNotFoundException {
        return ((RoleMappingContextFactory)((Object)this.getPolicy())).getRoleMappingContext(string);
    }
}

