/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.security.authz.jacc;

import com.ibm.sec.auth.subjectx.SubjectAttributes;
import com.ibm.sec.authz.jaccx.condition.RequestContext;
import com.ibm.sec.authz.jaccx.resource.Resource;
import com.ibm.sec.authz.jaccx.resource.ResourceContext;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;
import javax.security.jacc.PolicyContextHandler;

class PolicyContextHandlerImpl
implements PolicyContextHandler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private Set supportedKeys;
    private Subject subject;
    private Resource resource;
    private RequestContext requestContext;
    private SubjectAttributes subjectAttributes;
    private ResourceContext resourceContext;

    public PolicyContextHandlerImpl(Subject subject, Resource resource, RequestContext requestContext, SubjectAttributes subjectAttributes, ResourceContext resourceContext) {
        this.subject = subject;
        this.resource = resource;
        this.requestContext = requestContext;
        this.subjectAttributes = subjectAttributes;
        this.resourceContext = resourceContext;
        this.supportedKeys = new HashSet();
        this.supportedKeys.add("javax.security.auth.Subject.container");
        this.supportedKeys.add(Resource.JACC_RESOURCE_KEY);
        this.supportedKeys.add(RequestContext.JACC_REQUEST_CONTEXT_KEY);
        this.supportedKeys.add(SubjectAttributes.JACC_SUBJECT_ATTRIBUTES_KEY);
        this.supportedKeys.add(ResourceContext.JACC_RESOURCE_CONTEXT_KEY);
    }

    public String[] getKeys() throws PolicyContextException {
        return this.supportedKeys.toArray(new String[this.supportedKeys.size()]);
    }

    public boolean supports(String string) throws PolicyContextException {
        return this.supportedKeys.contains(string);
    }

    public Object getContext(String string, Object object) throws PolicyContextException {
        if (string.equals("javax.security.auth.Subject.container")) {
            return this.subject;
        }
        if (string.equals(Resource.JACC_RESOURCE_KEY)) {
            return this.resource;
        }
        if (string.equals(RequestContext.JACC_REQUEST_CONTEXT_KEY)) {
            return this.requestContext;
        }
        if (string.equals(SubjectAttributes.JACC_SUBJECT_ATTRIBUTES_KEY)) {
            return this.subjectAttributes;
        }
        if (string.equals(ResourceContext.JACC_RESOURCE_CONTEXT_KEY)) {
            return this.resourceContext;
        }
        return null;
    }
}

