/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.security.authz.jacc;

import com.ibm.sec.auth.subjectx.SubjectAttributesHandler;
import com.ibm.ws.wim.security.authz.AccessHandler;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

class SubjectAttributesHandlerImpl
implements SubjectAttributesHandler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String KEY_PREFIX = "com.ibm.websphere.wim.Subject.";
    private Set supportedKeys;
    private Set referencedAttrs = new HashSet();
    private AccessHandler accessHandler;

    public SubjectAttributesHandlerImpl(Set set, AccessHandler accessHandler) {
        this.supportedKeys = set;
        this.accessHandler = accessHandler;
        for (String string : set) {
            if (!string.startsWith(KEY_PREFIX)) continue;
            this.referencedAttrs.add(string.substring(KEY_PREFIX.length()));
        }
    }

    public String[] getAttributeNames() {
        return this.supportedKeys.toArray(new String[this.supportedKeys.size()]);
    }

    public boolean supports(String string) {
        return this.supportedKeys.contains(string);
    }

    public Object getAttribute(Subject subject, String string) {
        Object object = null;
        if (string.equals("user")) {
            return this.accessHandler.getSubjectPrincipal(subject);
        }
        if (string.equals("group")) {
            return this.accessHandler.getSubjectGroups(subject);
        }
        if (string.startsWith(KEY_PREFIX)) {
            object = this.accessHandler.getSubjectAttribute(subject, string.substring(KEY_PREFIX.length()), this.referencedAttrs);
        }
        return object;
    }
}

