/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.tx;

import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.extensionhelper.ExtensionHelper;
import com.ibm.ws.extensionhelper.TransactionControl;
import com.ibm.ws.extensionhelper.TxHandle;
import com.ibm.ws.extensionhelper.exception.InconsistentTransactionException;
import com.ibm.ws.wim.EnvironmentManager;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;

public class JTAHelper {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private final String className = JTAHelper.class.getName();
    private Logger jtaHelperTrace = WIMLogger.getTraceLogger(this.className);
    public final String EXT_HELPER = "services:websphere/ExtensionHelper";

    public JTAHelper() {
        String string = "JTAHelper";
    }

    public TransactionControl getTransactionControl(TransactionControl transactionControl, EnvironmentManager environmentManager) {
        TransactionControl transactionControl2;
        String string;
        block5: {
            string = "getTransactionControl";
            if (this.jtaHelperTrace.isLoggable(Level.FINER)) {
                this.jtaHelperTrace.entering(this.className, string, "inputTxControl = \"" + transactionControl + "\", inputEnvManager = \"" + environmentManager + "\"");
            }
            transactionControl2 = transactionControl;
            if (transactionControl == null && environmentManager != null && !environmentManager.isDirectAccessMode()) {
                try {
                    InitialContext initialContext = new InitialContext();
                    ExtensionHelper extensionHelper = (ExtensionHelper)initialContext.lookup("services:websphere/ExtensionHelper");
                    transactionControl2 = extensionHelper.getTransactionControl();
                }
                catch (NamingException namingException) {
                    if (!this.jtaHelperTrace.isLoggable(Level.FINE)) break block5;
                    this.jtaHelperTrace.logp(Level.SEVERE, this.className, string, "", WIMMessageHelper.generateMsgParms(namingException));
                }
            }
        }
        if (this.jtaHelperTrace.isLoggable(Level.FINER)) {
            this.jtaHelperTrace.exiting(this.className, string, "returnValue = \"" + transactionControl2 + "\"");
        }
        return transactionControl2;
    }

    public boolean useTransaction(TransactionControl transactionControl, EnvironmentManager environmentManager) {
        String string = "useTransaction";
        boolean bl = false;
        if (this.jtaHelperTrace.isLoggable(Level.FINER)) {
            this.jtaHelperTrace.entering(this.className, string, "inputTxControl = \"" + transactionControl + "\", inputEnvManager = \"" + environmentManager + "\"");
        }
        boolean bl2 = bl = transactionControl != null && environmentManager != null && !environmentManager.isDirectAccessMode();
        if (this.jtaHelperTrace.isLoggable(Level.FINER)) {
            this.jtaHelperTrace.exiting(this.className, string, "returnValue = \"" + bl + "\"");
        }
        return bl;
    }

    public void closeTransaction(String string, TransactionControl transactionControl, TxHandle txHandle, boolean bl) {
        String string2 = "closeTransaction";
        if (this.jtaHelperTrace.isLoggable(Level.FINER)) {
            this.jtaHelperTrace.entering(this.className, string2, "inputMethod = \"" + string + "\", inputControl = \"" + transactionControl + "\", inputHandle = \"" + txHandle + "\", inputSuccess = \"" + bl + "\"");
        }
        if (bl) {
            try {
                transactionControl.postinvoke(txHandle);
            }
            catch (SystemException systemException) {
                if (this.jtaHelperTrace.isLoggable(Level.FINE)) {
                    this.jtaHelperTrace.logp(Level.SEVERE, this.className, string, "", WIMMessageHelper.generateMsgParms((Object)systemException));
                }
                transactionControl.handleException(txHandle);
            }
            catch (InvalidTransactionException invalidTransactionException) {
                if (this.jtaHelperTrace.isLoggable(Level.FINE)) {
                    this.jtaHelperTrace.logp(Level.SEVERE, this.className, string, "", WIMMessageHelper.generateMsgParms((Object)invalidTransactionException));
                }
                transactionControl.handleException(txHandle);
            }
            catch (InconsistentTransactionException inconsistentTransactionException) {
                if (this.jtaHelperTrace.isLoggable(Level.FINE)) {
                    this.jtaHelperTrace.logp(Level.SEVERE, this.className, string, "", WIMMessageHelper.generateMsgParms(inconsistentTransactionException));
                }
                transactionControl.handleException(txHandle);
            }
        } else {
            transactionControl.handleException(txHandle);
        }
        if (this.jtaHelperTrace.isLoggable(Level.FINER)) {
            this.jtaHelperTrace.exiting(this.className, string2);
        }
    }

    public void handleException(Exception exception) throws WIMException, RemoteException {
        String string = "handleException";
        if (this.jtaHelperTrace.isLoggable(Level.FINE)) {
            this.jtaHelperTrace.logp(Level.SEVERE, this.className, string, "", WIMMessageHelper.generateMsgParms(exception));
        }
        if (exception instanceof WIMException) {
            throw (WIMException)exception;
        }
        if (exception instanceof RemoteException) {
            throw (RemoteException)exception;
        }
        throw new WIMException(exception);
    }
}

