/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.util;

import com.ibm.websphere.wim.async.Ticket;
import com.ibm.websphere.wim.exception.InvalidTicketException;
import com.ibm.websphere.wim.exception.OperationNotSupportedException;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.util.ControlsHelper;
import commonj.sdo.DataObject;
import java.util.Map;

public class AsyncUtils {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = AsyncUtils.class.getName();

    public static DataObject getRequestControl(DataObject dataObject) {
        Map map = ControlsHelper.getControlMap(dataObject);
        return (DataObject)map.get("RequestControl");
    }

    public static DataObject getResponseControl(DataObject dataObject) {
        Map map = ControlsHelper.getControlMap(dataObject);
        return (DataObject)map.get("ResponseControl");
    }

    public static Ticket getTicket(DataObject dataObject) throws InvalidTicketException {
        String string;
        Ticket ticket = null;
        DataObject dataObject2 = AsyncUtils.getRequestControl(dataObject);
        if (dataObject2 == null) {
            dataObject2 = AsyncUtils.getResponseControl(dataObject);
        }
        if (dataObject2 != null && (string = dataObject2.getString("ticket")) != null) {
            ticket = new Ticket(string);
        }
        return ticket;
    }

    public static boolean isCheckAsyncOperationStatus(DataObject dataObject) {
        String string;
        boolean bl = false;
        DataObject dataObject2 = AsyncUtils.getRequestControl(dataObject);
        if (dataObject2 != null && (string = dataObject2.getString("ticket")) != null && string.trim().length() > 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isOperationComplete(DataObject dataObject) {
        boolean bl = true;
        DataObject dataObject2 = AsyncUtils.getResponseControl(dataObject);
        if (dataObject2 != null) {
            bl = dataObject2.getBoolean("complete");
        }
        return bl;
    }

    public static String getRepositoryId(DataObject dataObject) throws InvalidTicketException {
        String string;
        String string2 = null;
        DataObject dataObject2 = AsyncUtils.getRequestControl(dataObject);
        if (dataObject2 == null) {
            dataObject2 = AsyncUtils.getResponseControl(dataObject);
        }
        if (dataObject2 != null && (string = dataObject2.getString("ticket")) != null && string.trim().length() > 0) {
            Ticket ticket = new Ticket(string);
            string2 = ticket.getRepositoryId();
        }
        return string2;
    }

    public static void asyncOperationNotSupported(DataObject dataObject, String string, String string2, String string3) throws OperationNotSupportedException {
        DataObject dataObject2 = AsyncUtils.getRequestControl(dataObject);
        if (dataObject2 != null) {
            String string4 = dataObject2.getString("requiredInteractionStyle");
            if (string4 != null && string4.equals("async")) {
                throw new OperationNotSupportedException("ASYNC_OPERATION_NOT_SUPPORTED_BY_REPOSITORY", WIMMessageHelper.generateMsgParms(string), string2, string3);
            }
            String string5 = dataObject2.getString("ticket");
            if (string5 != null && string5.trim().length() > 0) {
                throw new OperationNotSupportedException("ASYNC_OPERATION_NOT_SUPPORTED_BY_REPOSITORY", WIMMessageHelper.generateMsgParms(string), string2, string3);
            }
        }
    }

    public static void setPostProcessing(DataObject dataObject, String string) throws InvalidTicketException {
        Ticket ticket = AsyncUtils.getTicket(dataObject);
        if (ticket != null) {
            ticket.setPostProcess(string);
            DataObject dataObject2 = AsyncUtils.getResponseControl(dataObject);
            dataObject2.setString("ticket", ticket.toString());
        }
    }

    public static void setPostProcessing(DataObject dataObject, DataObject dataObject2) throws InvalidTicketException {
        Ticket ticket = AsyncUtils.getTicket(dataObject2);
        if (ticket != null) {
            String string = ticket.getPostProcess();
            AsyncUtils.setPostProcessing(dataObject, string);
        }
    }

    public static String getPostProcessing(DataObject dataObject) throws InvalidTicketException {
        String string = null;
        Ticket ticket = AsyncUtils.getTicket(dataObject);
        if (ticket != null) {
            string = ticket.getPostProcess();
        }
        return string;
    }

    public static void setPagingSize(DataObject dataObject, int n) throws InvalidTicketException {
        Ticket ticket = AsyncUtils.getTicket(dataObject);
        if (ticket != null) {
            ticket.setPagingSize(n);
            DataObject dataObject2 = AsyncUtils.getResponseControl(dataObject);
            dataObject2.setString("ticket", ticket.toString());
        }
    }

    public static int getPagingSize(DataObject dataObject) throws InvalidTicketException {
        int n = 0;
        Ticket ticket = AsyncUtils.getTicket(dataObject);
        if (ticket != null) {
            n = ticket.getPagingSize();
        }
        return n;
    }

    public static void setCountLimit(DataObject dataObject, int n) throws InvalidTicketException {
        Ticket ticket = AsyncUtils.getTicket(dataObject);
        if (ticket != null) {
            ticket.setCountLimit(n);
            DataObject dataObject2 = AsyncUtils.getResponseControl(dataObject);
            dataObject2.setString("ticket", ticket.toString());
        }
    }

    public static int getCountLimit(DataObject dataObject) throws InvalidTicketException {
        int n = 0;
        Ticket ticket = AsyncUtils.getTicket(dataObject);
        if (ticket != null) {
            n = ticket.getCountLimit();
        }
        return n;
    }

    public static void setSearchLimit(DataObject dataObject, int n) throws InvalidTicketException {
        Ticket ticket = AsyncUtils.getTicket(dataObject);
        if (ticket != null) {
            ticket.setSearchLimit(n);
            DataObject dataObject2 = AsyncUtils.getResponseControl(dataObject);
            dataObject2.setString("ticket", ticket.toString());
        }
    }

    public static int getSearchLimit(DataObject dataObject) throws InvalidTicketException {
        int n = 0;
        Ticket ticket = AsyncUtils.getTicket(dataObject);
        if (ticket != null) {
            n = ticket.getSearchLimit();
        }
        return n;
    }
}

