/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.util;

import com.ibm.websphere.wim.copyright.IBMCopyright;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.websphere.wim.util.SDOHelper;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.federation.FederationEntity;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.sdo.EDataGraph;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.util.EcoreEList;

public class DataGraphHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    static final String XML_COPYRIGHT = IBMCopyright.RUNTIME_COPYRIGHT_NOTICE_FOR_XML_2005;
    private static final String CLASSNAME = DataGraphHelper.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private static List allCtxProps = new ArrayList();
    private static List allReferences = new ArrayList();
    public static final List EMPTY_LIST = new ArrayList();
    public static final List WILDCARD_LIST = new ArrayList();
    public static final String WILDCARD = "*";
    public static final List IDENTIFIER_REF = new ArrayList();

    public static String getPersonUniqueNameFromAccountUniqueName(String string) {
        String string2 = null;
        int n = string.indexOf(44);
        string2 = string.substring(n + 1, string.length());
        return string2;
    }

    public static String getPersonUniqueIdFromAccountUniqueId(String string) {
        String string2 = null;
        string2 = string.substring(0, string.length() - 4);
        return string2;
    }

    public static DataObject cloneDataObject(DataObject dataObject) {
        return SDOHelper.cloneDataObject(dataObject);
    }

    public static DataObject cloneRootDataObject(DataObject dataObject) {
        return SDOHelper.cloneRootDataObject(dataObject);
    }

    public static DataObject deepCloneRootDataObject(DataObject dataObject) {
        return SDOHelper.deepCloneRootDataObject(dataObject);
    }

    public static EObject cloneEObject(EObject eObject) {
        return SDOHelper.cloneEObject(eObject);
    }

    public static List cloneList(List list) {
        EList eList = null;
        if (list != null) {
            eList = (EList)((EcoreEList)list).clone();
        }
        return eList;
    }

    public static byte[] insertCopyright(ByteArrayOutputStream byteArrayOutputStream) throws Exception {
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = stringBuffer.indexOf("<?");
        int n2 = stringBuffer.indexOf("?>");
        if (n == 0 && n2 > 0) {
            stringBuffer.insert(n2 + 2, XML_COPYRIGHT);
            return stringBuffer.toString().getBytes("UTF-8");
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static void saveDataGraph(DataGraph dataGraph, String string) throws WIMSystemException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ((EDataGraph)dataGraph).getDataGraphResource().save((OutputStream)byteArrayOutputStream, null);
            byte[] byArray = DataGraphHelper.insertCopyright(byteArrayOutputStream);
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new WIMSystemException("ERROR_WRITING_FILE", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), CLASSNAME, "saveDataGraph(DataGraph,String)", (Throwable)exception);
        }
    }

    public static void saveDataGraphWithoutCopyright(DataGraph dataGraph, String string) throws WIMSystemException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            ((EDataGraph)dataGraph).getDataGraphResource().save((OutputStream)fileOutputStream, null);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            throw new WIMSystemException("ERROR_WRITING_FILE", WIMMessageHelper.generateMsgParms(string, exception.getMessage()), CLASSNAME, "saveDataGraphWithoutCopyright(DataGraph,String)", (Throwable)exception);
        }
    }

    public static void copyDataObject(DataObject dataObject, DataObject dataObject2, List list, List list2, List list3) throws Exception {
        List list4;
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        boolean bl = trcLogger.isLoggable(Level.FINEST);
        EClass eClass = ((EDataObject)dataObject2).eClass();
        if (bl) {
            String string = "srcType=" + dataObject2.getType().getName() + ", destType=" + dataObject.getType().getName() + ", props=" + list + ", ctxProps=" + list2 + ", refs=" + list3;
            trcLogger.entering(CLASSNAME, "copyDataObject", string);
        }
        if (list != null && list.size() > 0) {
            boolean bl2 = false;
            if (list.contains(WILDCARD)) {
                bl2 = true;
                if (bl) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "copyDataObject", "copy all props=true");
                }
            }
            object4 = eClass.getEAllAttributes();
            for (n = 0; n < object4.size(); ++n) {
                object3 = (EAttribute)object4.get(n);
                object2 = object3.getName();
                if (DataGraphHelper.isOperationalProps(object2) && !list.contains(object2)) continue;
                if (!((String)object2).equals("ibmPrimaryEmail") && !((String)object2).equals("ibmJobTitle")) {
                    if (!dataObject2.isSet((String)object2) || !bl2 && !list.contains(object2)) continue;
                    if (bl) {
                        trcLogger.logp(Level.FINEST, CLASSNAME, "copyDataObject", "copying prop " + (String)object2);
                    }
                    if (dataObject.isSet((String)object2)) {
                        dataObject.unset((String)object2);
                    }
                    dataObject.set((String)object2, dataObject2.get((String)object2));
                    continue;
                }
                if (((String)object2).equals("ibmPrimaryEmail")) {
                    if (!dataObject2.isSet((String)object2)) continue;
                    object = "ibm-primaryEmail";
                    if (!bl2 && !list.contains(object)) continue;
                    if (bl) {
                        trcLogger.logp(Level.FINEST, CLASSNAME, "copyDataObject", "copying prop " + (String)object);
                    }
                    if (dataObject.isSet((String)object)) {
                        dataObject.unset((String)object);
                    }
                    dataObject.set((String)object, dataObject2.get("ibmPrimaryEmail"));
                    continue;
                }
                if (!dataObject2.isSet((String)object2)) continue;
                object = "ibm-jobTitle";
                if (!bl2 && !list.contains(object)) continue;
                if (bl) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "copyDataObject", "copying prop " + (String)object);
                }
                if (dataObject.isSet((String)object)) {
                    dataObject.unset((String)object);
                }
                dataObject.set((String)object, dataObject2.get("ibmJobTitle"));
            }
        }
        if (list2 != null && list2.size() > 0) {
            boolean bl3 = false;
            object4 = null;
            object4 = new ArrayList();
            for (n = 0; n < list2.size(); ++n) {
                object3 = null;
                object2 = list2.get(n);
                if (object2 instanceof String) {
                    object3 = (String)object2;
                } else {
                    object = (DataObject)list2.get(n);
                    object3 = object.getString("value");
                }
                if (WILDCARD.equals(object3)) {
                    bl3 = true;
                    if (!bl) continue;
                    trcLogger.logp(Level.FINEST, CLASSNAME, "copyDataObject", "copy all ctxprops=true");
                    continue;
                }
                object4.add(object3);
            }
            EList eList = eClass.getEAllReferences();
            for (int i = 0; i < eList.size(); ++i) {
                String string;
                String string2;
                object2 = (EReference)eList.get(i);
                object = object2.getName();
                if (!dataObject2.isSet((String)object) || !DataGraphHelper.isContextProperty(dataObject2, (EReference)object2)) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                if (!bl3 && object4.contains(object)) {
                    for (int j = 0; j < list2.size(); ++j) {
                        DataObject dataObject3 = (DataObject)list2.get(j);
                        string2 = dataObject3.getString("value");
                        if (!string2.equals(object) || (string = dataObject3.getString("lang")) == null || string.equals("") || string.equals(WILDCARD)) continue;
                        arrayList.add(string);
                    }
                }
                if (bl) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "copyDataObject", "copying context prop=" + (String)object + " for langs=" + arrayList);
                }
                list4 = dataObject2.getList((String)object);
                if (dataObject.isSet((String)object)) {
                    dataObject.unset((String)object);
                }
                for (int j = 0; j < list4.size(); ++j) {
                    string2 = (DataObject)list4.get(j);
                    string = string2.getString("lang");
                    if (arrayList.size() != 0 && !arrayList.contains(string)) continue;
                    DataObject dataObject4 = dataObject.createDataObject((String)object);
                    dataObject4.setString("value", string2.getString("value"));
                    dataObject4.setString("lang", string);
                }
            }
        }
        if (list3 != null && list3.size() > 0) {
            boolean bl4 = false;
            if (list3.contains(WILDCARD)) {
                bl4 = true;
                if (bl) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "copyDataObject", "copy all refs=true");
                }
            }
            object4 = eClass.getEAllReferences();
            for (n = 0; n < object4.size(); ++n) {
                EReference eReference = (EReference)object4.get(n);
                object2 = eReference.getName();
                if (!dataObject2.isSet(object2) || DataGraphHelper.isContextProperty(dataObject2, eReference) || !bl4 && !list3.contains(object2)) continue;
                if (bl) {
                    trcLogger.logp(Level.FINEST, CLASSNAME, "copyDataObject", "copying reference=" + (String)object2);
                }
                if (dataObject.isSet((String)object2)) {
                    dataObject.unset((String)object2);
                }
                if (eReference.isMany()) {
                    object = dataObject2.getList((String)object2);
                    for (int i = 0; i < object.size(); ++i) {
                        list4 = (DataObject)object.get(i);
                        DataObject dataObject5 = dataObject.createDataObject((String)object2);
                        DataGraphHelper.copyDataObject(dataObject5, (DataObject)list4, WILDCARD_LIST, WILDCARD_LIST, null);
                    }
                    continue;
                }
                object = dataObject2.getDataObject((String)object2);
                DataObject dataObject6 = dataObject.createDataObject((String)object2);
                DataGraphHelper.copyDataObject(dataObject6, (DataObject)object, WILDCARD_LIST, WILDCARD_LIST, null);
            }
        }
        if (bl) {
            trcLogger.exiting(CLASSNAME, "copyDataObject", eClass.getName());
        }
    }

    private static boolean isOperationalProps(String string) {
        return "createTimestamp".equals(string) || "modifyTimestamp".equals(string);
    }

    public static boolean isContextProperty(DataObject dataObject, EReference eReference) throws Exception {
        boolean bl = false;
        String string = eReference.getName();
        if (allCtxProps.contains(string)) {
            bl = true;
        } else if (!allReferences.contains(string)) {
            DataObject dataObject2 = null;
            dataObject2 = eReference.isMany() ? dataObject.getDataObject(eReference.getName() + ".0") : dataObject.getDataObject(eReference.getName());
            EClass eClass = SchemaManager.singleton().getEClass(dataObject2.getType().getName());
            if (eClass.getEReferences().size() == 0) {
                EList eList = eClass.getEAttributes();
                for (int i = 0; i < eList.size(); ++i) {
                    EAttribute eAttribute = (EAttribute)eList.get(i);
                    if (!"lang".equals(eAttribute.getName())) continue;
                    bl = true;
                }
            }
            if (bl) {
                allCtxProps.add(string);
            } else {
                allReferences.add(string);
            }
            if (trcLogger.isLoggable(Level.FINEST)) {
                trcLogger.logp(Level.FINEST, CLASSNAME, "isContextProperty", "all context propeties=" + allCtxProps);
                trcLogger.logp(Level.FINEST, CLASSNAME, "isContextProperty", "all references=" + allReferences);
            }
        }
        return bl;
    }

    public static void prepareIdentifierFromFedRepository(DataObject dataObject) throws WIMException {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "prepareIdentifier(id)");
        }
        String string = dataObject.getString("uniqueId");
        String string2 = dataObject.getString("uniqueName");
        RepositoryManager repositoryManager = RepositoryManager.singleton();
        String string3 = null;
        String string4 = null;
        if (string != null && string.trim().length() != 0) {
            if (repositoryManager.isEntryJoin()) {
                FederationEntity federationEntity = repositoryManager.getFederationRepository().lookupByUniqueId(string);
                string2 = federationEntity.getUniqueName();
                string3 = federationEntity.getRepositoryId();
                string4 = federationEntity.getExternalId();
            }
        } else if (string2 != null && string2.trim().length() != 0 && repositoryManager.isEntryJoin()) {
            FederationEntity federationEntity = repositoryManager.getFederationRepository().lookupByUniqueName(string2);
            string = federationEntity.getUniqueId();
            string3 = federationEntity.getRepositoryId();
            string4 = federationEntity.getExternalId();
        }
        dataObject.setString("uniqueId", string);
        dataObject.setString("uniqueName", string2);
        dataObject.setString("repositoryId", string3);
        dataObject.setString("externalId", string4);
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "prepareIdentifier(id)");
        }
    }

    static {
        IDENTIFIER_REF.add("identifier");
        WILDCARD_LIST.add(WILDCARD);
    }
}

