/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.util;

import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.ws.wim.ConfigManager;
import com.ibm.ws.wim.RepositoryManager;
import com.ibm.ws.wim.federation.FederationEntity;
import com.ibm.ws.wim.util.Base64Coder;
import com.ibm.ws.wim.util.StringUtil;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.cert.X509Certificate;

public class LoginHelper {
    private static final String CLASSNAME = "LoginHelper";
    private static final String USER_SECURITY_NAME_PROPERTY = "userSecurityNameProperty";
    private static final String CONTEXT_KEY_REALM = "WIM.Realm";

    public static String getRepositoryIdByUniqueId(String string) throws WIMException {
        String string2 = null;
        if (RepositoryManager.singleton().isEntryJoin()) {
            FederationEntity federationEntity = RepositoryManager.singleton().getFederationRepository().get(string);
            if (federationEntity != null) {
                String string3;
                string2 = string3 = federationEntity.getRepositoryId();
            }
        } else {
            string2 = RepositoryManager.singleton().getRepositoryIds()[0];
        }
        return string2;
    }

    public static Set getSpecifiedRealms(DataObject dataObject) {
        HashSet<String> hashSet = new HashSet<String>();
        List list = dataObject.getList("contexts");
        for (int i = 0; i < list.size(); ++i) {
            DataObject dataObject2 = (DataObject)list.get(i);
            String string = dataObject2.getString("key");
            if (string == null || !string.equals(CONTEXT_KEY_REALM)) continue;
            String string2 = dataObject2.getString("value");
            hashSet.add(string2);
        }
        return hashSet;
    }

    public static Set getWimNodes(Set set) throws WIMException {
        HashSet<String> hashSet = new HashSet<String>();
        if (set != null) {
            for (String string : set) {
                String string2 = LoginHelper.getWimNode(string);
                if (string2 == null) continue;
                hashSet.add(string2);
            }
        }
        return hashSet;
    }

    public static String getWimNode(String string) throws WIMException {
        String string2 = null;
        return string2;
    }

    private static DataObject getUserRegistryConfigNode() throws WIMException {
        DataObject dataObject = ConfigManager.singleton().getConfig();
        DataObject dataObject2 = dataObject.getDataObject("UserRegistry");
        return dataObject2;
    }

    public static String getUserSecurityName() throws WIMException {
        String string = null;
        DataObject dataObject = LoginHelper.getUserRegistryConfigNode();
        string = dataObject.getString(USER_SECURITY_NAME_PROPERTY);
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    public static String mapCertificate(X509Certificate x509Certificate) throws WIMException {
        String string = null;
        try {
            string = x509Certificate.getSubjectDN().getName();
        }
        catch (Exception exception) {
            throw new WIMSystemException(new CertificateMapNotSupportedException(exception.getMessage()));
        }
        if (!LoginHelper.isValidUser(string)) {
            throw new WIMSystemException(new CertificateMapFailedException(string));
        }
        return null;
    }

    public static boolean isValidUser(String string) {
        return true;
    }

    public static String getRealmFromDataGraph(DataGraph dataGraph) {
        return null;
    }

    public static String[] parseFilter(String string) throws WIMException {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n < n3) {
            n = string.indexOf("${", n2);
            if (n == -1) {
                if (n2 >= n3) break;
                vector.addElement(string.substring(n2));
                break;
            }
            if (n2 < n) {
                vector.addElement(string.substring(n2, n - 1));
            }
            if ((n = string.indexOf("}", n2 = n)) == -1) {
                throw new WIMSystemException("new CertificateMapFailedException (\"_ERR_CERTIFICATE_FILTER_SYNTAX\", CLASSNAME, METHODNAME, \"\")");
            }
            vector.addElement(string.substring(n2, ++n));
            n2 = n;
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static Object getFilterValue(X509Certificate x509Certificate, String string) throws CertificateMapFailedException {
        if (string.equals("${UniqueKey}")) {
            return LoginHelper.getUniqueKey(x509Certificate);
        }
        if (string.equals("${PublicKey}")) {
            return x509Certificate.getPublicKey().getEncoded();
        }
        if (!string.equals("${BasicConstraints}")) {
            if (string.startsWith("${Issuer")) {
                return LoginHelper.getDnSubField(string.substring(8, string.length() - 1), x509Certificate.getIssuerDN().getName());
            }
            if (!string.equals("${IssuerUniqueID}") && !string.equals("${KeyUsage}")) {
                if (string.equals("${NotAfter}")) {
                    return x509Certificate.getNotAfter().toString();
                }
                if (string.equals("${NotBefore}")) {
                    return x509Certificate.getNotBefore().toString();
                }
                if (string.equals("${SerialNumber}")) {
                    return x509Certificate.getSerialNumber();
                }
                if (string.equals("${SigAlgName}")) {
                    return x509Certificate.getSigAlgName();
                }
                if (string.equals("${SigAlgOID}")) {
                    return x509Certificate.getSigAlgOID();
                }
                if (string.equals("${SigAlgParams}")) {
                    return x509Certificate.getSigAlgParams();
                }
                if (!string.equals("${Signature}")) {
                    if (string.startsWith("${Subject")) {
                        return LoginHelper.getDnSubField(string.substring(9, string.length() - 1), x509Certificate.getSubjectDN().getName());
                    }
                    if (!string.equals("${SubjectUniqueID}")) {
                        if (string.equals("${TBSCertificate}")) {
                            throw new CertificateMapFailedException("WMMMessageKey._ERR_CERTIFICATE_FILTER_NOT_SUPPORTED, CLASSNAME, METHODNAME, WMMMessageHelper.generateMsgParms(\"getTBSCertificate()\")");
                        }
                        if (string.equals("${Version}")) {
                            return new Integer(x509Certificate.getVersion());
                        }
                        throw new CertificateMapFailedException("WMMMessageKey._ERR_CERTIFICATE_FILTER_UNKNOWN_FIELD, CLASSNAME, METHODNAME, WMMMessageHelper.generateMsgParms(filterElement)");
                    }
                }
            }
        }
        return null;
    }

    public static String getDnSubField(String string, String string2) throws CertificateMapFailedException {
        block4: {
            String string3;
            String string4;
            if (string.equals("DN")) {
                return string2;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            do {
                try {
                    string4 = stringTokenizer.nextToken(",= ");
                    string3 = stringTokenizer.nextToken(",");
                    if (string3 == null) continue;
                    string3 = string3.substring(1);
                }
                catch (NoSuchElementException noSuchElementException) {
                    break block4;
                }
            } while (!string4.equals(string));
            return string3;
        }
        throw new CertificateMapFailedException("WMMMessageKey._ERR_CERTIFICATE_FILTER_UNKNOWN_FIELD, CLASSNAME, METHODNAME, WMMMessageHelper.generateMsgParms(\"DN: \" + varName)");
    }

    public static String getUniqueKey(X509Certificate x509Certificate) {
        StringBuffer stringBuffer = new StringBuffer("subjectDN:");
        stringBuffer.append(x509Certificate.getSubjectDN().getName()).append("issuerDN:").append(x509Certificate.getIssuerDN().getName());
        return Base64Coder.base64Encode(LoginHelper.getDigest(stringBuffer.toString()));
    }

    public static String getDigest(String string) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            return null;
        }
        messageDigest.update(StringUtil.getBytes(string));
        return StringUtil.toString(messageDigest.digest());
    }
}

