/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.util;

import com.ibm.websphere.wim.exception.WIMSystemException;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.util.PasswordUtil;
import com.ibm.ws.wim.util.CipherObjectPool;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class PasswordEncryptionUtil {
    private static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = "com.ibm.ws.wim.util.PasswordEncryptionUtil";
    private static final Logger trcLogger = WIMLogger.getTraceLogger("com.ibm.ws.wim.util.PasswordEncryptionUtil");
    private static final int MAXIMUM_DBPASSWORD_LENGTH = 128;
    private static final int DES_KEY_STRING_LEN = 16;
    private static final int DES_KEY_SIZE = 8;
    private static final int TRIPLE_DES_KEY_SIZE = 24;
    private static final int CODE_LENGTH = 16;
    static CipherObjectPool CIPHER_POOL = null;
    private static final byte[] code = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static int salt_length = 12;

    public static byte[] formatPassword(byte[] byArray) {
        int n;
        byte[] byArray2 = new byte[128];
        int n2 = 32;
        for (n = 0; n < 128; ++n) {
            byArray2[n] = n2;
        }
        if (byArray != null) {
            for (n = 0; n < byArray.length; ++n) {
                byArray2[n] = byArray[n];
            }
        }
        return byArray2;
    }

    public static synchronized String hash(String string) {
        return PasswordEncryptionUtil.hash(string, "SHA");
    }

    public static synchronized String hash(byte[] byArray) {
        return PasswordEncryptionUtil.hash(byArray, "SHA");
    }

    public static synchronized String hash(String string, String string2) {
        Object object;
        block5: {
            byte[] byArray = null;
            try {
                object = MessageDigest.getInstance(string2);
                byArray = ((MessageDigest)object).digest(string.getBytes("UTF-8"));
            }
            catch (Exception exception) {
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "hash(String strPlainText, String MDAlgorithm)", "SHA1-CIPHERINIT: Exception caught while initializing the cipher object using algorithm " + string2);
                }
                return null;
            }
            object = null;
            try {
                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                object = bASE64Encoder.encodeBuffer(byArray);
            }
            catch (Exception exception) {
                if (!trcLogger.isLoggable(Level.INFO)) break block5;
                trcLogger.logp(Level.INFO, CLASSNAME, "hash(String strPlainText, String MDAlgorithm)", "Exception caught while base64 encoding.");
            }
        }
        return object;
    }

    public static synchronized String hash(byte[] byArray, String string) {
        Object object;
        block5: {
            byte[] byArray2 = null;
            try {
                object = MessageDigest.getInstance(string);
                byArray2 = ((MessageDigest)object).digest(byArray);
            }
            catch (Exception exception) {
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "hash(byte[] byteText, String MDAlgorithm)", "SHA1-CIPHERINIT: Exception caught while initializing the cipher object using algorithm " + string);
                }
                return null;
            }
            object = null;
            try {
                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                object = bASE64Encoder.encodeBuffer(byArray2);
            }
            catch (Exception exception) {
                if (!trcLogger.isLoggable(Level.INFO)) break block5;
                trcLogger.logp(Level.INFO, CLASSNAME, "hash(byte[] byteText, String MDAlgorithm)", "Exception caught while base64 encoding.");
            }
        }
        return object;
    }

    static void memcpy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[i + n] = byArray2[i + n2];
        }
    }

    static void memset(byte[] byArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)n;
        }
    }

    static int nc_decode_key(byte[] byArray, byte[] byArray2) {
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            int n2;
            for (n2 = 0; code[n2] != byArray[i] && n2 < 16; ++n2) {
            }
            if (n2 >= 16) {
                return 0;
            }
            byArray2[n] = (byte)(n2 << 4);
            ++i;
            for (n2 = 0; code[n2] != byArray[i] && n2 < 16; ++n2) {
            }
            if (n2 >= 16) {
                return 0;
            }
            int n3 = n++;
            byArray2[n3] = (byte)(byArray2[n3] | (byte)n2);
        }
        return 1;
    }

    static void gen1(byte[] byArray) {
        byArray[0] = code[8];
        byArray[1] = code[13];
        byArray[2] = code[7];
        byArray[3] = code[2];
        byArray[4] = code[15];
        byArray[5] = code[6];
        byArray[6] = code[1];
        byArray[7] = code[11];
        byArray[8] = code[0];
        byArray[9] = code[3];
        byArray[10] = code[9];
        byArray[11] = code[15];
        byArray[12] = code[1];
        byArray[13] = code[10];
        byArray[14] = code[10];
        byArray[15] = code[12];
    }

    static void gen2(byte[] byArray) {
        byArray[0] = code[3];
        byArray[1] = code[11];
        byArray[2] = code[10];
        byArray[3] = code[3];
        byArray[4] = code[15];
        byArray[5] = code[1];
        byArray[6] = code[9];
        byArray[7] = code[5];
        byArray[8] = code[1];
        byArray[9] = code[13];
        byArray[10] = code[2];
        byArray[11] = code[11];
        byArray[12] = code[5];
        byArray[13] = code[13];
        byArray[14] = code[15];
        byArray[15] = code[3];
    }

    static void gen3(byte[] byArray) {
        byArray[0] = code[11];
        byArray[1] = code[1];
        byArray[2] = code[4];
        byArray[3] = code[8];
        byArray[4] = code[6];
        byArray[5] = code[15];
        byArray[6] = code[2];
        byArray[7] = code[11];
        byArray[8] = code[0];
        byArray[9] = code[13];
        byArray[10] = code[2];
        byArray[11] = code[11];
        byArray[12] = code[15];
        byArray[13] = code[10];
        byArray[14] = code[12];
        byArray[15] = code[0];
    }

    private static byte[] createKey(byte[] byArray) {
        byte[] byArray2 = new byte[24];
        PasswordEncryptionUtil.nc_decode_key(byArray, byArray2);
        byte[] byArray3 = new byte[16];
        PasswordEncryptionUtil.gen2(byArray3);
        byte[] byArray4 = new byte[16];
        PasswordEncryptionUtil.nc_decode_key(byArray3, byArray4);
        PasswordEncryptionUtil.memcpy(byArray2, 8, byArray4, 0, 8);
        PasswordEncryptionUtil.memset(byArray3, 0, 8);
        byte[] byArray5 = new byte[16];
        PasswordEncryptionUtil.gen3(byArray5);
        byte[] byArray6 = new byte[16];
        PasswordEncryptionUtil.nc_decode_key(byArray5, byArray6);
        PasswordEncryptionUtil.memcpy(byArray2, 16, byArray6, 0, 8);
        PasswordEncryptionUtil.memset(byArray5, 0, 8);
        return byArray2;
    }

    public static String encrypt(String string, String string2) throws WIMSystemException {
        int n;
        String string3;
        byte[] byArray;
        byte[] byArray2;
        block12: {
            Cipher cipher = null;
            IvParameterSpec ivParameterSpec = null;
            byArray2 = null;
            byArray = null;
            byte[] byArray3 = new byte[]{-2, -36, -70, 33, -112, 67, -121, 101};
            byte[] byArray4 = new byte[16];
            if (string2 != null) {
                byArray4 = PasswordUtil.getByteArrayPassword(string2);
            } else {
                PasswordEncryptionUtil.gen1(byArray4);
            }
            byArray2 = PasswordUtil.getByteArrayPassword(string);
            SecretKey secretKey = null;
            try {
                byte[] byArray5 = PasswordEncryptionUtil.createKey(byArray4);
                DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray5);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
                secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
                cipher = (Cipher)CIPHER_POOL.checkout();
                ivParameterSpec = new IvParameterSpec(byArray3);
            }
            catch (Exception exception) {
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "encrypt( String text, String user_key )", "%3DES-F-CIPHERINIT; Exception caught while initializing the cipher object.");
                }
                return null;
            }
            try {
                cipher.init(1, (Key)secretKey, ivParameterSpec);
                byArray = new byte[cipher.getOutputSize(byArray2.length)];
                int n2 = cipher.update(byArray2, 0, byArray2.length, byArray, 0);
                int n3 = cipher.doFinal(byArray, n2);
                CIPHER_POOL.checkin(cipher);
                int n4 = n2 + n3;
            }
            catch (Exception exception) {
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "encrypt( String text, String user_key )", "%3DES-F-NCRYPT; Exception caught while encrypting.");
                }
                return null;
            }
            string3 = null;
            try {
                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                string3 = bASE64Encoder.encodeBuffer(byArray);
            }
            catch (Exception exception) {
                if (!trcLogger.isLoggable(Level.INFO)) break block12;
                trcLogger.logp(Level.INFO, CLASSNAME, "encrypt( String text, String user_key )", "Exception caught while base64 encoding.");
            }
        }
        for (n = 0; n < byArray2.length; ++n) {
            byArray2[n] = 0;
        }
        for (n = 0; n < byArray.length; ++n) {
            byArray[n] = 0;
        }
        return string3.trim();
    }

    public static String decrypt(String string, String string2) throws WIMSystemException {
        String string3;
        byte[] byArray;
        block15: {
            int n;
            Object object;
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4;
            IvParameterSpec ivParameterSpec;
            Cipher cipher;
            block14: {
                cipher = null;
                ivParameterSpec = null;
                byArray4 = null;
                byArray = null;
                byArray3 = new byte[]{-2, -36, -70, 33, -112, 67, -121, 101};
                byArray2 = new byte[16];
                if (string2 != null) {
                    byArray2 = PasswordUtil.getByteArrayPassword(string2);
                } else {
                    PasswordEncryptionUtil.gen1(byArray2);
                }
                try {
                    object = new BASE64Decoder();
                    byArray4 = object.decodeBuffer(string);
                }
                catch (Exception exception) {
                    if (!trcLogger.isLoggable(Level.INFO)) break block14;
                    trcLogger.logp(Level.INFO, CLASSNAME, "decrypt( String text, String user_key )", "Exception caught while base64 decoding.");
                }
            }
            object = null;
            try {
                byte[] byArray5 = PasswordEncryptionUtil.createKey(byArray2);
                DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray5);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
                object = secretKeyFactory.generateSecret(dESedeKeySpec);
                cipher = (Cipher)CIPHER_POOL.checkout();
                ivParameterSpec = new IvParameterSpec(byArray3);
            }
            catch (Exception exception) {
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "decrypt( String text, String user_key )", "%3DES-F-CIPHERINIT; Exception caught while initializing the cipher object.");
                }
                return null;
            }
            try {
                byArray = new byte[byArray4.length];
                cipher.init(2, (Key)object, ivParameterSpec);
                n = cipher.update(byArray4, 0, byArray4.length, byArray, 0);
                int n2 = cipher.doFinal(byArray, n);
                CIPHER_POOL.checkin(cipher);
                int n3 = n + n2;
            }
            catch (Exception exception) {
                if (trcLogger.isLoggable(Level.INFO)) {
                    trcLogger.logp(Level.INFO, CLASSNAME, "decrypt( String text, String user_key )", "%3DES-F-DCRYPT; Exception caught while decrypting");
                }
                return null;
            }
            for (n = 0; n < byArray4.length; ++n) {
                byArray4[n] = 0;
            }
            string3 = null;
            try {
                string3 = new String(byArray, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if (!trcLogger.isLoggable(Level.INFO)) break block15;
                trcLogger.logp(Level.INFO, CLASSNAME, "decrypt( String text, String user_key )", "Unable to convert string to UTF-8 format");
            }
        }
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        return string3.trim();
    }

    public static void setSaltLength(int n) {
        salt_length = n;
    }

    public static String generateSalt() {
        return PasswordEncryptionUtil.generateSalt(salt_length);
    }

    public static String generateSalt(int n) {
        String string = "abcdefghijklmnoprstuvxyz1234567890";
        int n2 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        Random random = new Random();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 = random.nextInt() % n2;
            if (n3 < 0) {
                n3 = -n3;
            }
            stringBuffer.append(string.charAt(n3));
        }
        return stringBuffer.toString();
    }

    public static byte[] getSaltedTextBytes(String string, byte[] byArray) throws WIMSystemException {
        int n;
        byte[] byArray2 = PasswordUtil.getByteArrayPassword(string);
        int n2 = byArray2.length;
        int n3 = byArray.length;
        byte[] byArray3 = new byte[n2 + n3];
        for (n = 0; n < n2; ++n) {
            byArray3[n] = byArray2[n];
        }
        for (n = 0; n < n3; ++n) {
            byArray3[n2 + n] = byArray[n];
        }
        return byArray3;
    }

    static {
        int n = 120000;
        try {
            n = new Integer(System.getProperty("wcpool.timeout"));
            if (n < 10) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            n = 120000;
        }
        CIPHER_POOL = new CipherObjectPool("com.ibm.commerce.util.wrapper.nc_cryptx", n);
    }
}

