/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.util;

import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.websphere.wim.ras.WIMTraceHelper;
import com.ibm.ws.wim.util.WIMSortCompare;
import commonj.sdo.DataObject;
import java.text.Collator;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SortHandler {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = SortHandler.class.getName();
    private static final Logger trcLogger = WIMLogger.getTraceLogger(CLASSNAME);
    private DataObject sortControl = null;

    public SortHandler() {
    }

    public SortHandler(DataObject dataObject) {
        this.sortControl = dataObject;
    }

    public int compareEntitysWithRespectToProperties(DataObject dataObject, DataObject dataObject2) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "compareEntitysWithRespectToProperties( DataObject, DataObject)", WIMTraceHelper.printObjectArray(new Object[]{dataObject, dataObject2}));
        }
        List list = this.sortControl.getList("sortKeys");
        int n = 0;
        for (int i = 0; i < list.size() && n == 0; ++i) {
            DataObject dataObject3 = (DataObject)list.get(i);
            String string = dataObject3.getString("propertyName");
            boolean bl = dataObject3.getBoolean("ascendingOrder");
            Object object = this.getPropertyValue(dataObject, string, bl);
            Object object2 = this.getPropertyValue(dataObject2, string, bl);
            n = this.compareProperties(object, object2);
            if (bl) continue;
            n = 0 - n;
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "compareEntitysWithRespectToProperties( DataObject, DataObject)", "return code = " + n);
        }
        return n;
    }

    public void setSortControl(DataObject dataObject) {
        this.sortControl = dataObject;
    }

    public DataObject getSortControl() {
        return this.sortControl;
    }

    public List sortEntities(List list) {
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "List sortEntities(List)", WIMTraceHelper.printObjectArray(new Object[]{list}));
        }
        if (list != null && list.size() > 0) {
            Object[] objectArray = list.toArray();
            WIMSortCompare wIMSortCompare = new WIMSortCompare(this.sortControl);
            Arrays.sort(objectArray, wIMSortCompare);
            list.clear();
            for (int i = 0; i < objectArray.length; ++i) {
                list.add(objectArray[i]);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "List sortEntities(List)", WIMTraceHelper.printObjectArray(new Object[]{list}));
        }
        return list;
    }

    private Object getPropertyValue(DataObject dataObject, String string, boolean bl) {
        List list;
        Object object = null;
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.entering(CLASSNAME, "Object getPropertyValue(DataObject, String, boolean)", WIMTraceHelper.printObjectArray(new Object[]{dataObject, string, bl}));
        }
        Object object2 = null;
        try {
            object2 = dataObject.get(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = null;
        }
        if (object2 != null && !(object2 instanceof List)) {
            object = object2;
        } else if (object2 != null && (list = (List)object2).size() > 0) {
            object = list.get(0);
            for (int i = 1; i < list.size(); ++i) {
                int n = this.compareProperties(object, list.get(i));
                if (n <= 0 || !bl) continue;
                object = list.get(i);
            }
        }
        if (trcLogger.isLoggable(Level.FINER)) {
            trcLogger.exiting(CLASSNAME, "Object getPropertyValue(DataObject, String, boolean)", WIMTraceHelper.printObjectArray(new Object[]{object}));
        }
        return object;
    }

    private int compareProperties(Object object, Object object2) {
        Collator collator = null;
        int n = 0;
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.entering(CLASSNAME, "compareProperties(Object, Object)", WIMTraceHelper.printObjectArray(new Object[]{object, object2}));
        }
        if (this.sortControl != null) {
            int n2;
            String string = this.sortControl.getString("locale");
            Locale locale = Locale.getDefault();
            if (string != null) {
                n2 = string.indexOf("-");
                if (n2 != -1) {
                    String string2 = string.substring(0, n2);
                    String string3 = string.substring(n2 + 1);
                    locale = new Locale(string2, string3);
                } else {
                    locale = new Locale(string);
                }
            }
            if (locale != null) {
                collator = Collator.getInstance(locale);
                collator.setStrength(3);
            }
            n2 = 0;
            n = object == null && object2 == null ? 0 : (object == null ? -1 : (object2 == null ? 1 : (object instanceof String ? collator.compare(object, object2) : (object instanceof Integer ? ((Integer)object).compareTo((Integer)object2) : (object instanceof Long ? ((Long)object).compareTo((Long)object2) : (object instanceof Double ? ((Double)object).compareTo((Double)object2) : collator.compare(object.toString(), object2.toString())))))));
        }
        if (trcLogger.isLoggable(Level.FINEST)) {
            trcLogger.exiting(CLASSNAME, "compareProperties(Object, Object)", "return code = " + n);
        }
        return n;
    }
}

