/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.util;

import com.ibm.websphere.wim.exception.InvalidPropertyValueException;
import com.ibm.websphere.wim.exception.InvalidUniqueNameException;
import com.ibm.websphere.wim.exception.MissingMandatoryPropertyException;
import com.ibm.websphere.wim.exception.WIMException;
import com.ibm.websphere.wim.ras.WIMMessageHelper;
import com.ibm.ws.wim.SchemaManager;
import com.ibm.ws.wim.adapter.ldap.LdapHelper;
import com.sun.jndi.ldap.LdapName;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.naming.InvalidNameException;

public class UniqueNameHelper {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    private static final String CLASSNAME = UniqueNameHelper.class.getName();
    public static final String ENTITY_DN_SEPARATOR = ",";

    public static String isDN(String string) {
        if (string == null) {
            return null;
        }
        LdapName ldapName = null;
        try {
            ldapName = new LdapName(string);
            return ldapName.getPrefix(ldapName.size()).toString();
        }
        catch (InvalidNameException invalidNameException) {
            return null;
        }
    }

    public static String formatUniqueName(String string) throws InvalidUniqueNameException {
        String string2 = UniqueNameHelper.getValidUniqueName(string);
        if (string2 == null) {
            throw new InvalidUniqueNameException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "formatUniqueName(String)");
        }
        return string2;
    }

    public static String getParentDN(String string) throws InvalidUniqueNameException {
        if (string == null) {
            return string;
        }
        String string2 = null;
        try {
            LdapName ldapName = new LdapName(string);
            if (ldapName.size() == 0) {
                return null;
            }
            string2 = ldapName.getPrefix(ldapName.size() - 1).toString();
        }
        catch (InvalidNameException invalidNameException) {
            throw new InvalidUniqueNameException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getRDN(String)");
        }
        return string2;
    }

    public static String getRDN(String string) throws InvalidUniqueNameException {
        if (string == null) {
            return string;
        }
        String string2 = null;
        try {
            LdapName ldapName = new LdapName(string);
            if (ldapName.size() == 0) {
                return string;
            }
            string2 = ldapName.get(ldapName.size() - 1);
        }
        catch (InvalidNameException invalidNameException) {
            throw new InvalidUniqueNameException("INVALID_UNIQUE_NAME_SYNTAX", WIMMessageHelper.generateMsgParms(string), CLASSNAME, "getRDN(String)");
        }
        return string2;
    }

    public static String getRDNProperty(String string) throws InvalidUniqueNameException {
        String string2 = null;
        String string3 = UniqueNameHelper.getRDN(string);
        int n = string3.indexOf(61);
        if (n != -1) {
            string2 = string3.substring(0, n);
        }
        return string2;
    }

    public static String[] getRDNComponents(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = null;
        int n = string.indexOf(43);
        if (n == -1) {
            stringArray = new String[]{string};
            return stringArray;
        }
        if (n == 0) {
            stringArray = new String[]{string.substring(1)};
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object var4_4 = null;
        int n2 = 0;
        while (n > -1) {
            if (string.charAt(n - 1) != '\\') {
                arrayList.add(string.substring(n2, n));
                n2 = n + 1;
            }
            n = string.indexOf(43, n + 1);
        }
        arrayList.add(string.substring(n2));
        stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    public static String[] getRDNAttrTypesByRDNComponents(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = null;
        int n = stringArray.length;
        stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = stringArray[i].indexOf(61);
            if (n2 <= -1) continue;
            stringArray2[i] = stringArray[i].substring(0, n2);
        }
        return stringArray2;
    }

    public static String[] getRDNAttrTypesForComparison(String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = stringArray[i].toLowerCase();
        }
        return stringArray2;
    }

    public static String getValidUniqueName(String string) {
        return LdapHelper.getValidDN(string);
    }

    public static String[] getRDNs(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[0]);
    }

    public static String constructUniqueName(List list, String[] stringArray, String string) throws InvalidUniqueNameException {
        if (list == null) {
            return null;
        }
        int n = list.size();
        if (n != stringArray.length || n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null || stringArray[i].length() == 0) continue;
            if (i != 0 && stringBuffer.length() != 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append((String)list.get(i) + "=" + LdapName.escapeAttributeValue(stringArray[i]));
        }
        String string2 = null;
        string2 = string.length() == 0 ? stringBuffer.toString() : stringBuffer.toString() + ENTITY_DN_SEPARATOR + string;
        return UniqueNameHelper.formatUniqueName(string2);
    }

    public static String constructUniqueName(String[] stringArray, String[] stringArray2, String string) throws InvalidUniqueNameException {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n != stringArray2.length || n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            if (stringArray2[i] == null || stringArray2[i].length() == 0) continue;
            if (i != 0 && stringBuffer.length() != 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append(stringArray[i] + "=" + LdapName.escapeAttributeValue(stringArray2[i]));
        }
        String string2 = null;
        string2 = string.length() == 0 ? stringBuffer.toString() : stringBuffer.toString() + ENTITY_DN_SEPARATOR + string;
        return UniqueNameHelper.formatUniqueName(string2);
    }

    public static String constructUniqueName(List list, DataObject dataObject, String string) throws WIMException {
        return UniqueNameHelper.constructUniqueName(list, dataObject, string, true);
    }

    public static String constructUniqueName(List list, DataObject dataObject, String string, boolean bl) throws WIMException {
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < list.size(); ++i) {
            String string4;
            String[] stringArray = UniqueNameHelper.getRDNs((String)list.get(i));
            int n = stringArray.length;
            String[] stringArray2 = new String[n];
            boolean bl3 = true;
            for (int j = 0; j < n && bl3; ++j) {
                string4 = stringArray[j];
                String string5 = dataObject.getString(string4);
                if (string5 == null) {
                    bl3 = false;
                    string3 = string4;
                    continue;
                }
                if (string5.trim().length() == 0) {
                    SchemaManager schemaManager = SchemaManager.singleton();
                    String string6 = schemaManager.getQualifiedTypeName(dataObject.getType());
                    throw new InvalidPropertyValueException("CAN_NOT_CONSTRUCT_UNIQUE_NAME", WIMMessageHelper.generateMsgParms(string4, string6), CLASSNAME, "constructUniqueName(List,DataObject,String,boolean)");
                }
                stringArray2[j] = string5;
            }
            if (!bl3) continue;
            if (!bl2) {
                string2 = UniqueNameHelper.constructUniqueName(stringArray, stringArray2, string);
                bl2 = true;
                continue;
            }
            if (!bl) continue;
            SchemaManager schemaManager = SchemaManager.singleton();
            string4 = schemaManager.getQualifiedTypeName(dataObject.getType());
            throw new InvalidUniqueNameException("CAN_NOT_CONSTRUCT_UNIQUE_NAME", WIMMessageHelper.generateMsgParms(list.toString(), string4), CLASSNAME, "constructUniqueName(List,DataObject,String,boolean)");
        }
        if (string3 != null && !bl2 && bl) {
            throw new MissingMandatoryPropertyException("MISSING_MANDATORY_PROPERTY", WIMMessageHelper.generateMsgParms(string3), CLASSNAME, "constructUniqueName(List,DataObject,String,boolean)");
        }
        return string2;
    }

    public static boolean isUniqueNameUnderSearchBases(String string, List list) {
        if (list == null || list.size() == 0) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            String string2 = (String)list.get(i);
            if (!string.trim().toLowerCase().endsWith(string2.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static String replaceRDNProperty(String string, String string2) {
        int n = string.indexOf("=");
        if (n > 0) {
            string = string2 + string.substring(n);
        }
        return string;
    }
}

