/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wim.util;

import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.wim.ras.WIMLogger;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.io.FileInputStream;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class WasVariableResolver {
    static final String COPYRIGHT_NOTICE = "(c) Copyright International Business Machines Corporation 2005";
    public static final String CLASSNAME = "com.ibm.ws.wim.util.WasVariableResolver";
    private static final Logger trcLogger = WIMLogger.getTraceLogger("com.ibm.ws.wim.util.WasVariableResolver");
    private boolean debug = false;
    ConfigService configService;
    AdminService adminService;
    Session session;
    ObjectName[] variables;
    Properties otherVariables;
    String nodeName = null;
    String serverName = null;
    String cellName = null;

    public WasVariableResolver() throws Exception {
        String string = System.getProperty("com.ibm.ws.wim");
        if (string != null) {
            this.debug = Boolean.valueOf(string);
        }
        this.printDebug("<init>");
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    WasVariableResolver.this.adminService = AdminServiceFactory.getAdminService();
                    WasVariableResolver.this.configService = ConfigServiceFactory.getConfigService();
                    if (WasVariableResolver.this.configService != null) {
                        WasVariableResolver.this.session = new Session();
                        ObjectName[] objectNameArray = null;
                        WasVariableResolver.this.printDebug("AdminService=" + WasVariableResolver.this.adminService);
                        if (WasVariableResolver.this.adminService != null) {
                            objectNameArray = WasVariableResolver.this.configService.resolve(WasVariableResolver.this.session, "Cell=" + WasVariableResolver.this.adminService.getCellName());
                            WasVariableResolver.this.nodeName = WasVariableResolver.this.adminService.getNodeName();
                            WasVariableResolver.this.serverName = WasVariableResolver.this.adminService.getProcessName();
                        }
                        ObjectName objectName = ConfigServiceHelper.createObjectName(null, "VariableSubstitutionEntry");
                        WasVariableResolver.this.printDebug("Pattern=" + objectName);
                        WasVariableResolver.this.variables = objectNameArray != null ? WasVariableResolver.this.configService.queryConfigObjects(WasVariableResolver.this.session, objectNameArray[0], objectName, null) : WasVariableResolver.this.configService.queryConfigObjects(WasVariableResolver.this.session, null, objectName, null);
                        WasVariableResolver.this.printDebug("Retrieved variables=" + WasVariableResolver.this.variables.toString());
                        String string = System.getProperty("was.variable.map");
                        if (string != null) {
                            FileInputStream fileInputStream = new FileInputStream(string);
                            WasVariableResolver.this.otherVariables = new Properties();
                            WasVariableResolver.this.otherVariables.load(fileInputStream);
                        }
                    }
                    return WasVariableResolver.this.configService;
                }
            };
            ContextManagerFactory.getInstance().runAsSystem(privilegedExceptionAction);
        }
        catch (Exception exception) {
            this.printDebug("<init> failed");
            exception.printStackTrace();
        }
        this.printDebug("<init> successful");
    }

    public String getVariableValue(String string) throws Exception {
        return this.getVariableValue(string, null);
    }

    private String getVariableValue(String string, Set hashSet) throws Exception {
        CharSequence charSequence;
        Object object;
        Object object2;
        int n;
        int n2;
        if (this.configService == null) {
            return null;
        }
        String string2 = null;
        if (hashSet == null) {
            hashSet = new HashSet<String>();
        }
        if (hashSet.contains(string)) {
            return null;
        }
        if (this.otherVariables != null) {
            string2 = this.otherVariables.getProperty(string);
        }
        if (string2 == null) {
            ObjectName objectName = null;
            n2 = 0;
            for (n = 0; n < this.variables.length; ++n) {
                if (!this.configService.getAttribute(this.session, this.variables[n], "symbolicName").equals(string)) continue;
                object2 = ConfigServiceHelper.getObjectLocation(this.variables[n]);
                if (this.cellName == null) {
                    this.cellName = ((Properties)object2).getProperty("cell");
                }
                if ((object = ((Properties)object2).getProperty("node")) != null && this.nodeName != null && !((String)object).equals(this.nodeName) || (charSequence = ((Properties)object2).getProperty("server")) != null && this.serverName != null && !((String)charSequence).equals(this.serverName)) continue;
                if (charSequence != null) {
                    objectName = this.variables[n];
                    break;
                }
                if (n2 >= 2) continue;
                if (object != null) {
                    n2 = 2;
                    objectName = this.variables[n];
                }
                if (n2 >= 1) continue;
                n2 = 1;
                objectName = this.variables[n];
            }
            if (objectName != null) {
                string2 = (String)this.configService.getAttribute(this.session, objectName, "value");
            }
        }
        if (string2 != null) {
            int n3 = 0;
            hashSet.add(string);
            while ((n2 = string2.indexOf("${", n3)) >= 0 && (n = string2.indexOf("}", n2 + 2)) >= n2) {
                object2 = this.getVariableValue(string2.substring(n2 + 2, n), hashSet);
                if (object2 != null) {
                    object = string2.toCharArray();
                    charSequence = new StringBuffer();
                    if (n2 > 0) {
                        ((StringBuffer)charSequence).append((char[])object, 0, n2);
                    }
                    ((StringBuffer)charSequence).append((String)object2);
                    if (n < ((Object)object).length - 1) {
                        ((StringBuffer)charSequence).append((char[])object, n + 1, ((Object)object).length - 1 - n);
                    }
                    string2 = ((StringBuffer)charSequence).toString();
                    n3 = n2;
                    continue;
                }
                n3 = n;
            }
            hashSet.remove(string);
        }
        return string2;
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getServerName() {
        return this.serverName;
    }

    private void printDebug(String string) {
        if (this.debug) {
            trcLogger.log(Level.FINER, "com.ibm.ws.wim.util.WasVariableResolver:" + string);
        }
    }
}

